#!/usr/bin/perl -w

#############################################################
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#############################################################

#
# Who.pm
# 
# Who is connected
#

package VMware::VMServerd::Who;

use strict;
use Carp;
use VMware::DOMAccess;
use VMware::Control::VM;

my $DEBUG = 0;

sub convertToXML {
    my $out = shift;
    my $numEntries = shift;
    my @entries = @_;

    print STDERR "Who $numEntries ", @entries,"\n" if ($DEBUG);

    if (!defined($numEntries) || $numEntries <= 0 || !defined(@entries) ||
        (($#entries + 1) % $numEntries)) {
        croak("Did not get a full table");
    }

    my @headers = splice(@entries, 0, $numEntries);

    print STDERR "Who raw headers: ",@headers,"\n" if ($DEBUG);

    @headers = map { lc((split())[0]) } @headers;

    print STDERR "Who XML headers: ",@headers,"\n" if ($DEBUG);

    while($#entries > -1) {
        my @row = splice(@entries, 0, $numEntries);

        my $doc = VMware::DOMAccess->new("connection");

        for my $header (@headers) {
            my $item = shift(@row);
            if ($header eq "type") {
                $doc->setAttribute("connection", $header, $item);
            } else {
                if (length($item)) {
                    $doc->setValue("connection.$header", $item);
                }
            }
        }

        #XXX Hack to blank out "local" in MUI connections (bug 7289)
        if ($doc->getAttribute("connection", "type") eq "control" &&
            $doc->getValue("connection.ip") eq "local") {
            $doc->removeElement("connection.ip");
            print STDERR "Resetting local to nothing.\n" if ($DEBUG);
        }

        print STDERR $doc->prettyPrint(),"\n" if ($DEBUG);

        $out->addSubTree("", $doc);
	$doc->dispose();
    }

    return 1;
}

sub VM_Who_Handler {
    my $in = shift;
    my $out = shift;

    my $cfg = $in->getValue(".cfg");

    my $vm = VMware::VMServerd::findVM($cfg);

    if(!defined($vm)) {
        return undef;
    }

    my @args = $vm->Who();

    if (!defined(@args) || !defined($args[0])) {
        return undef;
    }

    return convertToXML($out, @args);
}

VMware::VMServerd::addOperation( OPNAME => 'VM_Who',
				 PERLFUNC => 'VMware::VMServerd::Who::VM_Who_Handler',
				 POLICY => 'authuser' );

1;


