#
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#

package VMware::VmPerl::ConnectParams;

use strict;
use Carp;

require DynaLoader;

use vars qw($VERSION @ISA);

BEGIN{$VERSION = '1.01'};

@ISA = qw(DynaLoader);

use VMware::VmPerl $VERSION;

# Preloaded methods go here.

sub new {
    my ($hostname, $port, $username, $password) = (undef, 0, undef, undef);
    
    $hostname = shift if $#_ >= 0;
    $port = shift if $#_ >= 0;
    $username = shift if $#_ >= 0;
    $password = shift if $#_ >= 0;

    if (!defined($port)) {
        $port = 0;
    }
            
    return New($hostname, $port, $username, $password);
}

sub get_hostname {
   my $connectparams = shift;
   return $connectparams->GetHostname();
}
sub set_hostname {
   my $connectparams = shift;
   my $hostname = shift;
   return $connectparams->SetHostname($hostname);
}

sub get_username {
   my $connectparams = shift;
   return $connectparams->GetUsername();
}
sub set_username {
   my $connectparams = shift;
   my $user = shift;
   return $connectparams->SetUsername($user);
}

sub get_password {
   my $connectparams = shift;
   return $connectparams->GetPassword();
}
sub set_password {
   my $connectparams = shift;
   my $password = shift;
   return $connectparams->SetPassword($password);
}

sub get_port {
   my $connectparams = shift;
   return $connectparams->GetPort();
}
sub set_port {
   my $connectparams = shift;
   my $port = shift;
   return $connectparams->SetPort($port);
}


__END__

=head1 NAME

VMware::VmPerl::ConnectParams - Provide connection information to server and VMs.

=head1 SYNOPSIS

TBA

=head1 DESCRIPTION

=head2 VMware::VmPerl::ConnectParams::new($hostname, $port, $username, $password)

Connects to the given hostname and network port and authenticates with
the supplied username and password.  If $hostname is not given or
undef, the authentication is performed for the local machine.  In this
case, the username and password are optional: if they are not supplied
the current user is authenticated to VMware.  (Otherwise, username and
password may still be supplied to authenticate as a different user.)

=head2 $connectparams->get_hostname()

=head2 $connectparams->set_hostname($hostname)

Gets/Sets the name of a server. Its default value is "localhost", indicating the local system.

=head2 $connectparams->get_port()

=head2 $connectparams->set_port($port)

Gets/Sets the TCP port to use when connecting to the server. Its default value is 0, indicating the default port number should be used.

=head2 $connectparams->get_username()

=head2 $connectparams->set_username($username)

Gets/Sets the name of a user on the server.

=head2 $connectparams->get_password()

=head2 $connectparams->set_password($password)

Gets/Sets the user's password on the server.

=head1 AUTHORS

Jeff Hu, Vui-Chiap Lam, Bich Le

=head1 COPYRIGHT

    (c) 2002 VMware Incorporated.  All rights reserved.

=head1 VERSION

Version 1.01	   29 Mar 2002

C<% pod2html --header --title="VMware::VmPerl::ConnectParams" E<lt> ConnectParams.pm E<gt> ConnectParams.html>

=head1 SEE ALSO

perl(1).

=cut






