/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef _CPUID_INFO_H
#define _CPUID_INFO_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMKERNEL
#include "includeCheck.h"


typedef struct CPUIDRegs {
   uint32 eax, ebx, ecx, edx;
} CPUIDRegs;

/*
 * Results of calling cpuid(eaxArg) on all logical processors. 
 */
typedef struct CPUIDResult {
   uint32 numLogicalCPUs;
   uint32 eaxArg;
   CPUIDRegs regs[0];
} CPUIDResult;

enum {
   CPUID_LEVEL_0 = 0,
   CPUID_LEVEL_1,
   CPUID_LEVEL_80,
   CPUID_LEVEL_81,
   CPUID_LEVEL_88,
   CPUID_NUM_LEVELS
};

enum {
   CPUID_REG_EAX = 0,
   CPUID_REG_EBX,
   CPUID_REG_ECX,
   CPUID_REG_EDX,
   CPUID_NUM_REGS
};

typedef uint32 CPUIDSimple[CPUID_NUM_LEVELS][CPUID_NUM_REGS];

typedef struct CPUID0 {
   int numEntries;
   char name[16];      // 4 extra bytes to null terminate
} CPUID0;

typedef struct CPUID1 {
   uint32 version;
   uint32 ebx;
   uint32 ecxFeatures;
   uint32 edxFeatures;
} CPUID1;

typedef struct CPUID80 {
   uint32 numEntries;
   uint32 ebx;
   uint32 ecx;
   uint32 edx;
} CPUID80;

typedef struct CPUID81 {
   uint32 eax;
   uint32 ebx;
   uint32 ecxFeatures;
   uint32 edxFeatures;
} CPUID81;

typedef struct CPUID88 {
   uint32 eax;
   uint32 ebx;
   uint32 ecx;
   uint32 edx;
} CPUID88;

typedef struct CPUIDSummary {
   CPUID0  id0;
   CPUID1  id1;
   CPUID80 id80;
   CPUID81 id81;
   CPUID88 id88;
} CPUIDSummary;

static INLINE void CPUIDSummaryToSimple(CPUIDSimple simple, CPUIDSummary *summary)
{
   *(CPUIDRegs *)simple[CPUID_LEVEL_0]  = *(CPUIDRegs *)&summary->id0;
   *(CPUIDRegs *)simple[CPUID_LEVEL_1]  = *(CPUIDRegs *)&summary->id1;
   *(CPUIDRegs *)simple[CPUID_LEVEL_80] = *(CPUIDRegs *)&summary->id80;
   *(CPUIDRegs *)simple[CPUID_LEVEL_81] = *(CPUIDRegs *)&summary->id81;
   *(CPUIDRegs *)simple[CPUID_LEVEL_88] = *(CPUIDRegs *)&summary->id88;
}

static INLINE void CPUIDSimpleToSummary(CPUIDSummary *summary, CPUIDSimple simple)
{
   *(CPUIDRegs *)&summary->id0  = *(CPUIDRegs *)simple[CPUID_LEVEL_0];
   summary->id0.name[12] = 0;
   *(CPUIDRegs *)&summary->id1  = *(CPUIDRegs *)simple[CPUID_LEVEL_1];
   *(CPUIDRegs *)&summary->id80 = *(CPUIDRegs *)simple[CPUID_LEVEL_80];
   *(CPUIDRegs *)&summary->id81 = *(CPUIDRegs *)simple[CPUID_LEVEL_81];
   *(CPUIDRegs *)&summary->id88 = *(CPUIDRegs *)simple[CPUID_LEVEL_88];
}

#endif
