/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef __VMMONINT_H__
#define __VMMONINT_H__

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"


/*
 * Hide all kernel compatibility stuff in these macros and functions.
 */


#ifdef KERNEL_2_4_0
#   define compat_fop_set_owner(_pFop) do { \
   (_pFop)->owner = THIS_MODULE;            \
} while (0)
#   define compat_mod_inc_refcount
#   define compat_mod_dec_refcount
#else
#   define compat_fop_set_owner(_pFop)
#   define compat_mod_inc_refcount do { \
   MOD_INC_USE_COUNT;                   \
} while (0)
#   define compat_mod_dec_refcount do { \
   MOD_DEC_USE_COUNT;                   \
} while (0)
#endif

#if defined(CONFIG_SMP) && LINUX_VERSION_CODE >= KERNEL_VERSION(2, 2, 8)
#define compat_smp_call_function smp_call_function
#else
#define compat_smp_call_function(_a0,_a1,_a2,_a3) 0
#endif


/*
 * Although this is not really related to kernel-compatibility, I put this
 * helper macro here for now for a lack of better place --hpreg
 *
 * The exit(2) path does, in this order:
 * . set current->files to NULL
 * . close all fds, which potentially calls LinuxDriver_Close()
 *
 * fget() requires current->files != NULL, so we must explicitely check --hpreg
 */
#define vmware_fget(_fd) (current->files ? fget(_fd) : NULL)


extern void LinuxDriverIPIHandler(void*);
extern void LinuxDriverWakeUp(Bool selective);

#endif /* __VMMONINT_H__ */
