#!/usr/bin/perl -w
#
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#
# saveguestip.pl
#
# This script demonstrates the use of the VMware guest service to set
# a configuration variable from within a running virtual machine's guest
# operating system.  It stores the guest operating system's IP address.
# The host can retrieve the IP address with a corresponding script.
#
# usage:
#   saveguestip.pl
#
# NOTE:
# This script should be run from within a running virtual machine's guest
# operating system.  The corresponding script get_guest_ip.pl can be run
# from the host operating system.

if (@ARGV != 0) {
   print "Usage: $0\n";
   exit(1);
}

my($err);

# Get the IP for the Guest
my($ip) = (undef);
$ip = &get_ip();

if(!defined($ip)) {
   die "$0: Could not get guest ip\n";
}
else {
   print "$0: guest ip is $ip\n";
}

# Sets the ip address configuration variable.
$err = &set_ip_variable();
if($err != 0) {
   die "$0: Could not set guest ip\n";
}

# Captures IP address from the OS.
sub get_ip {
   my ($myip, @iparr) = (undef, []);

   # For Windows Guest OS.
   if ($^O eq "MSWin32") { 
      $_ = `ipconfig`;
      @iparr = /IP Address.*?(\d+\.\d+\.\d+\.\d+)/ig;
    
      $myip = $iparr[0];
   }
   # For Linux Guest OS.
   # Please ensure that ifconfig is in your path.  The root user has it by default.
   else { 
      $_ = `ifconfig`;
      @iparr = /inet addr:(\d+\.\d+\.\d+\.\d+)/ig;
    
      $myip = $iparr[0];
   }

   return $myip;
}

# Stores the IP address in the guestinfo name space.
sub set_ip_variable {
   if ($^O eq "MSWin32") {
      # Please ensure that VMwareService is in your path.
      # VMwareService needs double quotes around the command.
      my $cmd = "VMwareService -cmd " . '"' . "info-set guestinfo.ip $ip" . '"';
      system($cmd);
   }
   else {
      # Please ensure that vmware-guestd is found in the path used below
      system("/etc/vmware/vmware-guestd --cmd 'info-set guestinfo.ip $ip'");
   }
   return $?;
}






