#!/usr/bin/perl -w 
#
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#
# suspend.pl
#
# This script suspends to disk the virtual machine specified by config on
# the server defined by hostname.
#
# usage: 
#   suspend.pl hostname user password config

BEGIN {
   if ($^O eq "MSWin32") {
      @INC = (
         # Set the path to your VmPerl Scripting directory if different
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005',
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005\MSWin32-x86');
   }
}

use VMware::VmPerl;
use VMware::VmPerl::VM;
use VMware::VmPerl::ConnectParams;
use strict;

if (@ARGV < 1) {
   print "Usage $0: <path_to_config_file> [<server> [<user> <password>]]\n";
   exit(1);
}

my ($cfg_path, $server_name, $user, $passwd) = @ARGV;
# Use the default port of 902.  Change this if your port is different.
my $port = 902;

# Connect to the local host on the default port as yourself.
my $connect_params = VMware::VmPerl::ConnectParams::new($server_name,$port,$user,$passwd);

# Create a new VMware::VmPerl::VM object to interact with a virtual machine.
my $vm = VMware::VmPerl::VM::new();

# Establish a persistent connection with virtual machine.
if (!$vm->connect($connect_params, $cfg_path)) {
   my ($errorNumber, $errorString) = $vm->get_last_error();
   # Destroys the virtual machine object, thus disconnecting from the virtual machine.
   undef $vm;
   die  "Cannot connect to vm: Error $errorNumber: $errorString\n";
}

# Gets the Power status of the virtual machine to determine if it is running.
my $curState = $vm->get_execution_state();
if ($curState != VM_EXECUTION_STATE_ON) {
   print "Can only suspend a powered on Virtual Machine.\n";
} else {
# Suspends the running vm.
   if (!$vm->suspend()) {
      my ($errorNumber, $errorString) = $vm->get_last_error();
      print "Couldn't suspend: Error $errorNumber: $errorString\n";
   } 
}

# Destroys the virtual machine object, thus disconnecting from the virtual machine.
undef $vm;

