#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to 
# your agreement to the terms of an applicable VMware license.
#
#
use ExtUtils::MakeMaker;
use File::Spec;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

# To make: type "perl Makefile.PL; make" in this directory.
# To check if things worked correctly, try running "make test"

#
# Build the module table
#
my %modules = ();
open(MODULES, "ModuleList");
while (<MODULES>) {
   my $modPath = $_;
   chomp($modPath);
# if you compile on Windows, ModuleList can get a \r on the end, which
# annoys Linux
   $modPath =~ s/\r$//g;
   my @modPath = split('/', $modPath);
   shift @modPath; # remove the lib/ prefix
   my $modDest = join('/', @modPath);
   $modules{$modPath} = '$(INST_LIBDIR)/'.'Vix/'.$modDest;
}
close(MODULES);

#
# Make sure the bootstrapping module gets included too.
#
$modules{'VixBinding.pm'} = '$(INST_LIBDIR)/VixBinding.pm';

my %args = (
    'NAME'		      => 'VMware::VixBinding',
    'VERSION_FROM'	=> 'VixBinding.pm', # finds $VERSION
    'PREREQ_PM'		=> {}, # e.g., Module::Name => 1.1
    'LIBS'		      => [''], # e.g., '-lm'
    'DEFINE'		   => '-Dbool=char -DHAS_BOOL', # e.g., '-DHAVE_SOMETHING'
    'PM'             => \%modules,
    'INC'            => '-I.',  # Header files are in tarball
            );

# Set up the library for the VIX API
if ($^O =~ /MSWin32/) {
   $args{'MYEXTLIB'} = "vixAllProducts.lib";
   $args{'LIBS'} = "ws2_32.lib wbemuuid.lib";
} elsif ($^O =~ /darwin/) {
   # libvix.dylib contains all VIX functions
   $args{'MYEXTLIB'} = "libvix.dylib";
} else { # Linux
   $args{'MYEXTLIB'} = "libvixAllProducts.so";
}

WriteMakefile(%args);

sub MY::postamble {
   if ($^O =~ /MSWin32/) {
      # Pull in the Vix DLLs, plus other dependencies (SSL)
   return <<'DLL_COPY';

DLL_COPY
   }
}

