#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to 
# your agreement to the terms of an applicable VMware license.
#

package VMware::Vix::API::VM;

#use 5.00503;
use strict;
use Carp;

use VMware::VixBinding;
require Exporter;
require DynaLoader;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
@ISA = qw(Exporter DynaLoader);

%EXPORT_TAGS = ( 'all' => [ qw(
   Open
   Delete
   PowerOn
   PowerOff
   Reset
   Suspend

   GetNumRootSnapshots
   GetRootSnapshot
   RemoveSnapshot
   RevertToSnapshot
   CreateSnapshot
   GetCurrentSnapshot
   GetNamedSnapshot

   WaitForToolsInGuest
   UpgradeVirtualHardware
   InstallTools

   LoginInGuest
   LogoutFromGuest
   RunProgramInGuest
   ListProcessesInGuest
   KillProcessInGuest
   RunScriptInGuest
   OpenUrlInGuest
   CreateTempFileInGuest

   CopyFileFromHostToGuest
   CopyFileFromGuestToHost
   DeleteFileInGuest
   FileExistsInGuest
   RenameFileInGuest
   CreateDirectoryInGuest
   DeleteDirectoryInGuest
   DirectoryExistsInGuest
   ListDirectoryInGuest

   GetNumSharedFolders
   GetSharedFolderState
   SetSharedFolderState
   AddSharedFolder
   RemoveSharedFolder
   EnableSharedFolders

   ReadVariable
   WriteVariable

   GetFileInfoInGuest

   BeginRecording
   EndRecording
   BeginReplay
   EndReplay
   Pause
   Unpause

   CaptureScreenImage

   Clone
) ] );

@EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
@EXPORT = qw();

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
