#!/usr/bin/perl
#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to 
# your agreement to the terms of an applicable VMware license.
#


#
# This test opens the host and lists all running VMs.
#
# XXX be sure to modify the connection parameters and VMpath values
#
# for testing w/o installation
use lib qw{ blib/lib blib/auto blib/arch blib/arch/auto/VMware blib/arch/auto };

use strict;
use VMware::Vix::Simple;

# all constants are exported
use VMware::Vix::API::Constants;

my $hostname = "";
my $hostport = 0;
my $username = "";
my $password = "";
my $connType;


# adjust as needed
my $useWorkstation = 1;

if ($useWorkstation) {
# for VMware workstation, set the connection
   $connType = VIX_SERVICEPROVIDER_VMWARE_WORKSTATION; 

} else {
# for VMware server, set the connection type, hostname as full URL
# and username/password
   $connType = VIX_SERVICEPROVIDER_VMWARE_VI_SERVER; 
   $hostname = "https://localhost:8333/sdk";
   $username = "myuser";
   $password = "mypass";
}

my $err;
my $hostHandle;
my @vms;

($err, $hostHandle) = HostConnect(VIX_API_VERSION, 
                                  $connType,
                                  $hostname, $hostport, $username, $password,
                                  0, VIX_INVALID_HANDLE);

die "Connect failed, $err ", GetErrorText($err), "\n" if $err != VIX_OK;

@vms = FindRunningVMs($hostHandle, 100);
$err = shift @vms;
die "Error $err finding running VMs ", GetErrorText($err),"\n" if $err != VIX_OK;

print "VMs: @vms\n";

HostDisconnect($hostHandle);

