#!/usr/bin/perl
#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to 
# your agreement to the terms of an applicable VMware license.
#


#
# This test opens the host, opens a vm, powers it on, then powers
# it off.  
#
# XXX be sure to modify the connection parameters and VMpath values
#
# for testing w/o installation
use lib qw{ blib/lib blib/auto blib/arch blib/arch/auto/VMware blib/arch/auto };

use strict;
use VMware::Vix::Simple;

# all constants are exported
use VMware::Vix::API::Constants;

my $hostname = "";
my $hostport = 0;
my $username = "";
my $password = "";
my $vmxPathName;
my $connType;
my $powerOptions;


# adjust these as needed
my $useWorkstation = 1;

if ($useWorkstation) {
# for VMware workstation, set the connection type and power option
   $connType = VIX_SERVICEPROVIDER_VMWARE_WORKSTATION; 
   $powerOptions = VIX_VMPOWEROP_LAUNCH_GUI;
   $vmxPathName = "/work/vms/teams/team2/MS-DOS/MS-DOS.vmx";

} else {
# for VMware server, set the connection type, hostname as full URL
# and username/password
   $connType = VIX_SERVICEPROVIDER_VMWARE_VI_SERVER; 
   $powerOptions = VIX_VMPOWEROP_NORMAL;
   $hostname = "https://localhost:8333/sdk";
   $username = "myuser";
   $password = "mypass";
# VM path needs to use [datastore] style
   $vmxPathName = "[storage] MS-DOS/MS-DOS.vmx";
}

my $err;
my $hostHandle = VIX_INVALID_HANDLE;
my $vmHandle;

($err, $hostHandle) = HostConnect(VIX_API_VERSION, 
                                  $connType,
                                  $hostname,
                                  $hostport,
                                  $username,
                                  $password,
                                  0,
                                  VIX_INVALID_HANDLE);
die "Connect failed, $err ", GetErrorText($err), "\n" if $err != VIX_OK;

($err, $vmHandle) = VMOpen($hostHandle, $vmxPathName);
die "open of $vmxPathName failed, $err ", GetErrorText($err), "\n" if $err != VIX_OK;

$err = VMPowerOn($vmHandle, $powerOptions, VIX_INVALID_HANDLE);
die "PowerOn of $vmxPathName failed, $err ", GetErrorText($err), "\n" if $err != VIX_OK;

$err = VMPowerOff($vmHandle, 0);
die "PowerOff of $vmxPathName failed, $err ", GetErrorText($err), "\n" if $err != VIX_OK;

ReleaseHandle($vmHandle);
HostDisconnect($hostHandle);
