/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vix;

import com.vmware.vix.EventListener;
import com.vmware.vix.Vix;
import com.vmware.vix.VixConstants;

public class VixHandle {
    private int handle = 0;

    public void finalize() {
        if (this.handle != 0) {
            Vix.Vix_ReleaseHandle(this);
            this.handle = 0;
        }
    }

    public VixHandle() {
    }

    VixHandle(int n) {
        this();
        this.handle = n;
    }

    public static VixHandle createTemporary(int n) {
        VixHandle vixHandle = new VixHandle();
        long l = Vix.Vix_CreateTemporaryObject(n, vixHandle);
        if (l == (long)VixConstants.VIX_OK) {
            return vixHandle;
        }
        return null;
    }

    public static VixHandle createJob() {
        return VixHandle.createTemporary(VixConstants.VIX_HANDLETYPE_JOB);
    }

    public boolean equals(Object object) {
        return object instanceof VixHandle && this.handle == ((VixHandle)object).handle;
    }

    public String toString() {
        return super.toString() + " (handle value: " + this.getHandleValue() + ")";
    }

    public void addEventListener(EventListener eventListener, int n) {
        this.checkIsValid();
        if (eventListener != null) {
            Vix.Vix_SubscribeToEvents(this, n, eventListener);
        }
    }

    public void addCallbackListener(EventListener eventListener) {
        this.addEventListener(eventListener, VixConstants.VIX_EVENTTYPE_CALLBACK_SIGNALLED);
    }

    public void removeEventListener(EventListener eventListener, int n) {
        this.checkIsValid();
        Vix.Vix_CancelEventSubscription(this, n, eventListener);
    }

    public void removeCallbackListener(EventListener eventListener) {
        this.removeEventListener(eventListener, VixConstants.VIX_EVENTTYPE_CALLBACK_SIGNALLED);
    }

    public int getPropertyInt(int n) {
        this.checkIsValid();
        return Vix.Vix_GetPropertyInteger(this, n);
    }

    public String getPropertyString(int n) {
        this.checkIsValid();
        return Vix.Vix_GetPropertyString(this, n);
    }

    public boolean getPropertyBoolean(int n) {
        this.checkIsValid();
        return Vix.Vix_GetPropertyBool(this, n);
    }

    public VixHandle getPropertyHandle(int n) {
        this.checkIsValid();
        return new VixHandle(Vix.Vix_GetPropertyInteger(this, n));
    }

    public long getPropertyLong(int n) {
        this.checkIsValid();
        return Vix.Vix_GetPropertyInt64(this, n);
    }

    public long waitDone() {
        this.checkIsValid();
        return Vix.VixJob_Wait(this, 0);
    }

    public boolean isValid() {
        return this.getHandleValue() != 0 && Vix.Vix_IsHandleValid(this);
    }

    private void checkIsValid() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException("Handle not initialized.");
        }
    }

    private void setHandleValue(int n) {
        this.finalize();
        this.handle = n;
    }

    private int getHandleValue() {
        return this.handle;
    }
}

