/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.JavaProcessData;
import com.vmware.bfg.JavaProcessSelectionDialog;
import com.vmware.bfg.ProcessData;
import com.vmware.bfg.VMwareConfigDelegate;
import com.vmware.bfg.VMwareConfigTab;
import com.vmware.bfg.VMwarePlugin;
import com.vmware.bfg.widgets.ContentProvider;
import com.vmware.bfg.widgets.DataLabelProvider;
import com.vmware.bfg.widgets.DataList;
import com.vmware.bfg.widgets.EasyTable;
import com.vmware.vix.Vix;
import com.vmware.vix.VixHandle;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;

public class AttachConfigDelegate
extends VMwareConfigDelegate {
    private JavaProcessData targetProc;
    private CoreException ce;

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(MessageFormat.format("Attaching to {0}", iLaunchConfiguration.getName()), 6);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        try {
            this.initializeVix(iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            String string2 = iLaunchConfiguration.getAttribute(VMwareConfigTab.ATTR_VM_LOCATION, "");
            this.loadVM(iLaunchConfiguration, iProgressMonitor, string2);
            this.checkCancelled(iProgressMonitor);
            this.startupVM(iLaunchConfiguration, iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            this.waitForGuestToolsStartup(iLaunchConfiguration, iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            this.guestLogin(iLaunchConfiguration, iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            int n = this.getPortNumFromUser(iProgressMonitor, iLaunchConfiguration);
            this.checkCancelled(iProgressMonitor);
            this.connectToRunningJVM(iLaunchConfiguration, iLaunch, iProgressMonitor, n);
            this.checkCancelled(iProgressMonitor);
            iProgressMonitor.done();
        }
        catch (CoreException coreException) {
            if (!coreException.getStatus().equals(Status.CANCEL_STATUS)) {
                VMwarePlugin.log(coreException);
            }
            this.getLaunchManager().removeLaunch(iLaunch);
        }
    }

    private int getPortNumFromUser(IProgressMonitor iProgressMonitor, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string;
        InetAddress inetAddress = this.getGuestAddress();
        this.jobHandle = Vix.VixVM_ListProcessesInGuest((VixHandle)this.vmHandle, (int)0, null);
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Unable to retrieve process listing");
        int n = Vix.VixJob_GetNumProperties((VixHandle)this.jobHandle, (int)Vix.VIX_PROPERTY_JOB_RESULT_ITEM_NAME);
        final ArrayList<JavaProcessData> arrayList = new ArrayList<JavaProcessData>(n);
        final String string2 = this.getMainTypeName(iLaunchConfiguration);
        for (int i = 0; i < n; ++i) {
            JavaProcessData javaProcessData;
            string = Vix.VixJob_GetNthPropertyString((VixHandle)this.jobHandle, (int)i, (int)Vix.VIX_PROPERTY_JOB_RESULT_ITEM_NAME);
            if (!string.contains("java")) continue;
            long l = Vix.VixJob_GetNthPropertyInt64((VixHandle)this.jobHandle, (int)i, (int)Vix.VIX_PROPERTY_JOB_RESULT_PROCESS_ID);
            String string3 = Vix.VixJob_GetNthPropertyString((VixHandle)this.jobHandle, (int)i, (int)Vix.VIX_PROPERTY_JOB_RESULT_PROCESS_COMMAND);
            if (!string3.contains(string2) || !string3.contains("-Xrunjdwp") && !string3.contains("-agentlib:jdwp") || attachedPorts.contains(new InetSocketAddress(inetAddress, (javaProcessData = new JavaProcessData(string2, string, l, 0L, string3)).getPortNumber()))) continue;
            arrayList.add(javaProcessData);
        }
        if (arrayList.size() < 1) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Cannot attach to this Java application. Either it is not running in the selected virtual machine or the debugger is already attached to it.", null));
        }
        if (arrayList.size() == 1) {
            return ((ProcessData)arrayList.get(0)).getPortNumber();
        }
        final Shell shell = VMwarePlugin.getShell();
        if (shell == null) {
            this.abort("No Shell available in Launch", null, 0);
        }
        this.targetProc = null;
        string = shell.getDisplay();
        iProgressMonitor.subTask("Waiting for user to make a selection from the list of available Java processes.");
        string.syncExec(new Runnable(){

            public void run() {
                HashSet<EasyTable.IData> hashSet = new HashSet<EasyTable.IData>(arrayList);
                DataList dataList = new DataList(hashSet);
                EasyTable.IDataAttrib[] iDataAttribArray = new ProcessData.ProcAttrib[]{ProcessData.ProcAttrib.PID, ProcessData.ProcAttrib.Port, ProcessData.ProcAttrib.Arguments};
                JavaProcessSelectionDialog javaProcessSelectionDialog = new JavaProcessSelectionDialog(shell, "Select Process", "To which instance of " + string2 + " would you like to attach the debugger?");
                javaProcessSelectionDialog.setContentProvider(new ContentProvider());
                javaProcessSelectionDialog.setLabelProvider((ILabelProvider)new DataLabelProvider(iDataAttribArray));
                javaProcessSelectionDialog.setColumnHeaders(iDataAttribArray);
                javaProcessSelectionDialog.setInput(dataList);
                javaProcessSelectionDialog.setInitialElementSelections(null);
                if (javaProcessSelectionDialog.open() == 0) {
                    Object[] objectArray = javaProcessSelectionDialog.getResult();
                    if (objectArray.length > 0) {
                        AttachConfigDelegate.this.targetProc = (JavaProcessData)objectArray[0];
                    } else {
                        AttachConfigDelegate.this.ce = new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Please select a process from the list before hitting OK.", null));
                    }
                } else {
                    AttachConfigDelegate.this.ce = new CoreException(Status.CANCEL_STATUS);
                }
            }
        });
        if (this.targetProc == null) {
            throw this.ce;
        }
        iProgressMonitor.worked(1);
        return this.targetProc.getPortNumber();
    }
}

