/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.Counter;
import com.vmware.bfg.SharedFolder;
import com.vmware.bfg.VMwareConfigDelegate;
import com.vmware.bfg.VMwareConfigTab;
import com.vmware.bfg.VMwareExecTab;
import com.vmware.bfg.VMwarePlugin;
import com.vmware.vix.EventListener;
import com.vmware.vix.Vix;
import com.vmware.vix.VixConstants;
import com.vmware.vix.VixHandle;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class ExecConfigDelegate
extends VMwareConfigDelegate
implements ILaunchConfigurationDelegate {
    private static final String ERR_CANT_ACCESS_SNAPSHOT = "Unable to revert to snapshot: no current snapshot exists";
    private static final String ERR_ADDING_SHARED_FOLDER = "Error while trying to share folder {0}";
    private static final String WINDOWS = "Windows";
    private static final String GNU = "Linux";
    private static final String[] LinuxJVMs = new String[]{"/usr/bin/java", "/usr/lib/java/jre/bin/java", "/opt/ibm/java2-i386-50/jre/bin/java", "/usr/lib/j2sdk1.5-sun/bin/java", "/usr/lib/j2se/1.5/jre/bin/java", "/usr/lib/j2se/1.4/jre/bin/java", "/usr/lib/j2sdk1.5-ibm/jre/bin/java", "/usr/lib/j2sdk1.4-ibm/jre/bin/java", "/usr/lib/j2sdk1.5-sun/jre/bin/java", "/usr/lib/j2sdk1.4-sun/jre/bin/java"};
    private static final String[] WindowsJVMs = new String[]{"C:\\Windows\\System32\\java.exe", "C:\\WinNT\\System32\\java.exe"};
    private static final String[] XTermLocations = new String[]{"/usr/bin/xterm", "/usr/X11R6/bin/xterm"};
    private static final ConcurrentMap<String, ConcurrentMap<SharedFolder, Counter>> activeShares = new ConcurrentHashMap<String, ConcurrentMap<SharedFolder, Counter>>();
    private static final int MIN_PORTNUM = 49152;
    private static final int MAX_PORTNUM = 65535;
    private String osFamily;
    private Map<String, String> sharedFolderMap;
    private Map<InetAddress, Integer> portBank = new HashMap<InetAddress, Integer>();
    private String cmdShell;
    private String sharedProjectFolderName;

    protected void startupVM(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        long l = 0L;
        if (iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_REVERT, false)) {
            iProgressMonitor.subTask("Reverting to last snapshot...");
            VixHandle vixHandle = new VixHandle();
            l = Vix.VixVM_GetCurrentSnapshot((VixHandle)this.vmHandle, (VixHandle)vixHandle);
            if (l != (long)VixConstants.VIX_OK) {
                throw new CoreException((IStatus)ExecConfigDelegate.makeVixErrorStatus(l, ERR_CANT_ACCESS_SNAPSHOT));
            }
            this.jobHandle = Vix.VixVM_RevertToSnapshot((VixHandle)this.vmHandle, (VixHandle)vixHandle, (int)Vix.VIX_VMPOWEROP_LAUNCH_GUI, null, null);
            this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Revert to snapshot failed");
            this.jobHandle = null;
        } else {
            iProgressMonitor.worked(1);
        }
        if (!iProgressMonitor.isCanceled()) {
            super.startupVM(iLaunchConfiguration, iProgressMonitor);
        }
    }

    private void setupVMEnvironment(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        Object object;
        iProgressMonitor.subTask("Sharing folders required to debug project...");
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
        this.sharedFolderMap = iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_SHARED_FOLDERS, (Map)null);
        String string2 = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        this.sharedProjectFolderName = ".project-" + string2;
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
        if (this.sharedFolderMap == null) {
            this.sharedFolderMap = new HashMap<String, String>(1);
        }
        this.sharedFolderMap.put(this.sharedProjectFolderName, iProject.getLocation().toOSString());
        subProgressMonitor.beginTask("Mapping shared folders inside virtual machine...", this.sharedFolderMap.size());
        activeShares.putIfAbsent(string, new ConcurrentHashMap());
        ConcurrentMap concurrentMap = (ConcurrentMap)activeShares.get(string);
        for (Map.Entry<String, String> object2 : this.sharedFolderMap.entrySet()) {
            object = new SharedFolder(object2.getKey(), object2.getValue());
            concurrentMap.putIfAbsent(object, new Counter());
            Semaphore semaphore = (Semaphore)concurrentMap.get(object);
            semaphore.release();
            if (semaphore.availablePermits() < 1) {
                this.jobHandle = Vix.VixVM_AddSharedFolder((VixHandle)this.vmHandle, (String)object2.getKey(), (String)object2.getValue(), (int)0, null);
                String string3 = MessageFormat.format(ERR_ADDING_SHARED_FOLDER, object2.getKey());
                long l = this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200);
                if (l != (long)VixConstants.VIX_OK && l != (long)VixConstants.VIX_E_ALREADY_EXISTS) {
                    throw new CoreException((IStatus)ExecConfigDelegate.makeVixErrorStatus(l, string3));
                }
            }
            iProgressMonitor.worked(1);
        }
        subProgressMonitor.done();
        this.osFamily = Vix.Vix_GetPropertyString((VixHandle)this.vmHandle, (int)Vix.VIX_PROPERTY_GUEST_OS_VERSION);
        if (this.osFamily == null) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unable to determine guest operating system type. Please ensure that VMware Tools is installed and up-to-date on this virtual machine. ", null));
        }
        int n = this.osFamily.indexOf(32);
        if (n != -1) {
            this.osFamily = this.osFamily.substring(0, n);
        }
        this.cmdShell = this.getCmdShell(iProgressMonitor);
        if (iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_ENABLE_PRELAUNCH_SCRIPT, false)) {
            String string4 = iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_PRELAUNCH_SCRIPT, "");
            if (!string4.equals("")) {
                iProgressMonitor.subTask("Running prelaunch script...");
                object = new CompletionListener();
                this.jobHandle = Vix.VixVM_RunScriptInGuest((VixHandle)this.vmHandle, (String)this.cmdShell, (String)string4, (int)0, null, (EventListener)object);
                this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Error while running prelaunch script.");
            }
        } else {
            iProgressMonitor.worked(1);
        }
    }

    private String getCmdShell(IProgressMonitor iProgressMonitor) throws CoreException {
        String string = null;
        if (this.osFamily.equals(WINDOWS)) {
            return "";
        }
        if (this.osFamily.equals(GNU)) {
            string = "/bin/sh";
            if (!this.doesFileExistOnGuest(iProgressMonitor, string)) {
                throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "The shell \"/bin/sh\" does not exist on the guest operating system.", null));
            }
        } else {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unsupported guest operating system for running scripts: " + this.osFamily, null));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void runJVMOnGuest(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor, String string, int n) throws CoreException {
        void var7_10;
        String string22;
        String string3 = null;
        String[] stringArray = new String[]{};
        if (!iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_USE_DEFAULT, true)) {
            string3 = iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_JRE_LOCATION, "");
            if (!this.doesFileExistOnGuest(iProgressMonitor, string3)) {
                throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "No Java virtual machine found on guest operating system at location specified in JVM tab of launch configuration editor: " + string3, null));
            }
        } else if (this.osFamily.equals(WINDOWS)) {
            stringArray = WindowsJVMs;
        } else if (this.osFamily.equals(GNU)) {
            stringArray = LinuxJVMs;
        } else {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unsupported guest operating system. Only Linux  and Windows guests are currently supported.", null));
        }
        for (String string22 : stringArray) {
            if (!this.doesFileExistOnGuest(iProgressMonitor, string22)) continue;
            string3 = string22;
            break;
        }
        if (string3 == null) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "No JVM found on guest operating system. Please specify the Java runtime install location in the JVM tab.", null));
        }
        if (this.osFamily.equals(WINDOWS)) {
            String string4 = "\\\\.host\\Shared Folders\\";
        } else if (this.osFamily.equals(GNU)) {
            String string5 = "/mnt/hgfs/";
        } else {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unsupported guest operating system. Shared Folder support is required on the guest.", null));
        }
        String string6 = (String)var7_10 + this.sharedProjectFolderName;
        String[] stringArray2 = this.getClasspath(iLaunchConfiguration);
        IJavaProject iJavaProject = this.getJavaProject(iLaunchConfiguration);
        string22 = iJavaProject.getOutputLocation().makeRelative().toString();
        iProgressMonitor.subTask("Verifying access to shared project folder on guest operating system...");
        this.jobHandle = Vix.VixVM_ListDirectoryInGuest((VixHandle)this.vmHandle, (String)string6, (int)0, null);
        String string7 = MessageFormat.format("Unable to access the contents of shared project directory \"{0}\" on guest operating system.", string6);
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, string7);
        String string8 = "";
        int n2 = string22.indexOf(47);
        if (n2 > 0) {
            string8 = string22.substring(n2);
        }
        String string9 = " -cp \"" + string6 + string8 + "\" ";
        String string10 = this.getMainTypeName(iLaunchConfiguration);
        String string11 = this.getProgramArguments(iLaunchConfiguration);
        String string12 = "-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + Integer.toString(n) + string9 + string10 + " " + string11;
        String string13 = null;
        if (iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_ENABLE_POST_TERM_SCRIPT, false)) {
            string13 = iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_POST_TERM_SCRIPT, "");
        }
        int n3 = 3;
        try {
            if (iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_HAS_TERM_OPT, false)) {
                n3 = iLaunchConfiguration.getAttribute(VMwareExecTab.ATTR_TERM_OPT, n3);
            }
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        TermListener termListener = new TermListener(string, string13, n3);
        if (this.osFamily.equals(GNU)) {
            boolean bl = false;
            for (String string14 : XTermLocations) {
                if (!this.doesFileExistOnGuest(iProgressMonitor, string14)) continue;
                string12 = "-e " + string3 + " " + string12;
                string3 = string14;
                bl = true;
                break;
            }
            if (!bl) {
                string12 = "-c \"export DISPLAY=:0.0 && " + string3 + " " + string12 + "\"";
                string3 = "/bin/sh";
            }
        }
        this.jobHandle = Vix.VixVM_RunProgramInGuest((VixHandle)this.vmHandle, (String)string3, (String)string12, (int)Vix.VIX_RUNPROGRAM_ACTIVATE_WINDOW, null, (EventListener)termListener);
        iProgressMonitor.worked(1);
    }

    private boolean doesFileExistOnGuest(IProgressMonitor iProgressMonitor, String string) throws CoreException {
        this.jobHandle = Vix.VixVM_FileExistsInGuest((VixHandle)this.vmHandle, (String)string, null);
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Unable to check for existence of specified file on guest operating system: " + string);
        boolean bl = Vix.Vix_GetPropertyBool((VixHandle)this.jobHandle, (int)Vix.VIX_PROPERTY_JOB_RESULT_GUEST_OBJECT_EXISTS);
        return bl;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(MessageFormat.format("Launching code in virtual machine...", iLaunchConfiguration.getName()), 9);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        try {
            this.initializeVix(iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            String string2 = iLaunchConfiguration.getAttribute(VMwareConfigTab.ATTR_VM_LOCATION, "");
            this.loadVM(iLaunchConfiguration, iProgressMonitor, string2);
            this.checkCancelled(iProgressMonitor);
            this.startupVM(iLaunchConfiguration, iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            Vix.VixVM_AttachUI((VixHandle)this.vmHandle);
            this.waitForGuestToolsStartup(iLaunchConfiguration, iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            this.jobHandle = Vix.VixVM_EnableSharedFolders((VixHandle)this.vmHandle, (boolean)true, (int)0, null);
            this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Failed to enable Shared Folders in guest operating system.");
            this.guestLogin(iLaunchConfiguration, iProgressMonitor);
            this.checkCancelled(iProgressMonitor);
            iProgressMonitor.subTask("Looking for an unused port. Please disable any firewall\nthat may be running on the guest operating system.");
            int n = this.getNewPortNum(this.getGuestAddress());
            this.checkCancelled(iProgressMonitor);
            this.setupVMEnvironment(iLaunchConfiguration, iProgressMonitor, string2);
            this.checkCancelled(iProgressMonitor);
            this.runJVMOnGuest(iLaunchConfiguration, iProgressMonitor, string2, n);
            this.checkCancelled(iProgressMonitor);
            this.connectToRunningJVM(iLaunchConfiguration, iLaunch, iProgressMonitor, n);
            this.checkCancelled(iProgressMonitor);
            iProgressMonitor.done();
        }
        catch (CoreException coreException) {
            if (!coreException.getStatus().equals(Status.CANCEL_STATUS)) {
                VMwarePlugin.log(coreException);
            }
            this.getLaunchManager().removeLaunch(iLaunch);
        }
    }

    private int getNewPortNum(InetAddress inetAddress) throws CoreException {
        int n;
        Integer n2 = this.portBank.get(inetAddress);
        int n3 = n = n2 == null ? 49152 : n2 + 1;
        while (n < 65535) {
            try {
                Socket socket = new Socket(inetAddress, n);
                ++n;
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        if (n == 65535) {
            n = 49152;
        }
        this.portBank.put(inetAddress, n);
        return n;
    }

    private class CompletionListener
    extends EventListener {
        protected boolean isDone = false;

        private CompletionListener() {
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void eventReceived(VixHandle vixHandle, int n, VixHandle vixHandle2) {
            if (this.isDone) assert (false);
            if (n == Vix.VIX_EVENTTYPE_JOB_COMPLETED) {
                this.isDone = true;
            }
        }
    }

    private class TermListener
    extends EventListener {
        private String vmxPath;
        private TermStage stage;
        private String script;
        private int termState;
        private int shareNum;
        private boolean killProjShare;

        public TermListener(String string, String string2, int n) {
            this.vmxPath = string;
            this.script = string2;
            this.termState = n;
            this.stage = TermStage.START;
            VMwarePlugin.getDefault().rememberCallback(this);
        }

        public void eventReceived(VixHandle vixHandle, int n, VixHandle vixHandle2) {
            if (n == Vix.VIX_EVENTTYPE_JOB_COMPLETED) {
                switch (this.stage) {
                    case START: {
                        if (this.script != null && this.script.length() > 0) {
                            vixHandle = Vix.VixVM_RunScriptInGuest((VixHandle)ExecConfigDelegate.this.vmHandle, (String)ExecConfigDelegate.this.cmdShell, (String)this.script, (int)0, null, (EventListener)this);
                            this.stage = TermStage.RUN_SCRIPT;
                            break;
                        }
                    }
                    case RUN_SCRIPT: {
                        this.shareNum = 0;
                        for (Map.Entry entry : ExecConfigDelegate.this.sharedFolderMap.entrySet()) {
                            SharedFolder sharedFolder = new SharedFolder((String)entry.getKey(), (String)entry.getValue());
                            Counter counter = (Counter)((ConcurrentMap)activeShares.get(this.vmxPath)).get(sharedFolder);
                            if (counter.tryAcquire()) continue;
                            Vix.VixVM_RemoveSharedFolder((VixHandle)ExecConfigDelegate.this.vmHandle, (String)((String)entry.getKey()), (int)0, (EventListener)this);
                            counter.reducePermits(1);
                            ++this.shareNum;
                            if (!ExecConfigDelegate.this.sharedProjectFolderName.equals(entry.getKey())) continue;
                            this.killProjShare = true;
                        }
                        this.stage = TermStage.REMOVE_SHARES;
                    }
                    case REMOVE_SHARES: {
                        if (this.shareNum > 0) {
                            --this.shareNum;
                            break;
                        }
                        if (this.killProjShare) {
                            ExecConfigDelegate.this.sharedFolderMap.remove(ExecConfigDelegate.this.sharedProjectFolderName);
                        }
                        switch (this.termState) {
                            case 0: {
                                VixHandle vixHandle3 = new VixHandle();
                                long l = Vix.VixVM_GetCurrentSnapshot((VixHandle)ExecConfigDelegate.this.vmHandle, (VixHandle)vixHandle3);
                                if (l != (long)VixConstants.VIX_OK) {
                                    VMwarePlugin.getDefault().log(ExecConfigDelegate.ERR_CANT_ACCESS_SNAPSHOT);
                                    break;
                                }
                                Vix.VixVM_RevertToSnapshot((VixHandle)ExecConfigDelegate.this.vmHandle, (VixHandle)vixHandle3, (int)0, null, (EventListener)this);
                                break;
                            }
                            case 1: {
                                Vix.VixVM_PowerOff((VixHandle)ExecConfigDelegate.this.vmHandle, (int)0, (EventListener)this);
                                break;
                            }
                            case 2: {
                                Vix.VixVM_Suspend((VixHandle)ExecConfigDelegate.this.vmHandle, (int)0, (EventListener)this);
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                VMwarePlugin.getDefault().log("Invalid state change requested.");
                            }
                        }
                        this.stage = TermStage.CHANGE_POWER_STATE;
                        break;
                    }
                    case CHANGE_POWER_STATE: {
                        this.stage = TermStage.END;
                        VMwarePlugin.getDefault().forgetCallback(this);
                        break;
                    }
                    default: {
                        String string = "Unacceptable stage in post-termination process.";
                        System.err.println(string);
                        VMwarePlugin.getDefault().log(string);
                        break;
                    }
                }
            } else if (n != Vix.VIX_EVENTTYPE_JOB_PROGRESS) {
                VMwarePlugin.getDefault().log("Unexpected callback event " + n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TermStage {
        START,
        RUN_SCRIPT,
        REMOVE_SHARES,
        CHANGE_POWER_STATE,
        END;

    }
}

