/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.widgets.EasyTable;
import org.eclipse.core.runtime.CoreException;

public abstract class ProcessData
implements EasyTable.IData {
    private String name;
    private long pid;
    private long age;
    protected String arglist;

    public ProcessData(String string, long l, long l2, String string2) {
        this.name = string;
        this.pid = l;
        this.age = l2;
        this.arglist = this.extractArgs(string2);
    }

    protected String extractArgs(String string) {
        return string.substring(string.indexOf(32, string.indexOf(this.name))).trim();
    }

    public String getArgs() {
        return this.arglist;
    }

    public long getAge() {
        return this.age;
    }

    public String getName() {
        return this.name;
    }

    public long getPID() {
        return this.pid;
    }

    public abstract int getPortNumber() throws CoreException;

    public String getAttribText(EasyTable.IDataAttrib iDataAttrib) {
        switch ((ProcAttrib)iDataAttrib) {
            case Name: {
                return this.getName();
            }
            case PID: {
                return String.valueOf(this.getPID());
            }
            case Age: {
                return String.valueOf(this.getAge());
            }
            case Arguments: {
                return this.getArgs();
            }
            case Port: {
                try {
                    return Integer.toString(this.getPortNumber());
                }
                catch (CoreException coreException) {
                    return "invalid port";
                }
            }
        }
        throw new RuntimeException("Invalid process attribute.");
    }

    public int compareTo(EasyTable.IData iData, EasyTable.IDataAttrib iDataAttrib) {
        ProcessData processData = (ProcessData)iData;
        if (iDataAttrib == null) {
            iDataAttrib = ProcAttrib.Name;
        }
        switch ((ProcAttrib)iDataAttrib) {
            case Name: {
                return this.getName().compareTo(processData.getName());
            }
            case PID: {
                return (int)(this.getPID() - processData.getPID());
            }
            case Age: {
                return (int)(this.getAge() - processData.getAge());
            }
            case Arguments: {
                return this.getArgs().compareTo(processData.getArgs());
            }
            case Port: {
                try {
                    return this.getPortNumber() - processData.getPortNumber();
                }
                catch (CoreException coreException) {
                    return 0;
                }
            }
        }
        throw new RuntimeException("Invalid process attribute.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ProcAttrib implements EasyTable.IDataAttrib
    {
        Name,
        PID,
        Age,
        Arguments,
        Port;

    }
}

