/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.DisconnectListener;
import com.vmware.bfg.VMwarePlugin;
import com.vmware.vix.EventListener;
import com.vmware.vix.Vix;
import com.vmware.vix.VixConstants;
import com.vmware.vix.VixHandle;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;

abstract class VMwareConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected static Collection<InetSocketAddress> attachedPorts = new HashSet<InetSocketAddress>();
    protected VixHandle hostHandle = null;
    protected VixHandle vmHandle = null;
    protected VixHandle jobHandle = null;

    VMwareConfigDelegate() {
    }

    void waitDoneOrCancelled(IProgressMonitor iProgressMonitor, VixHandle vixHandle, int n, String string) throws CoreException {
        long l = this.waitDoneOrCancelled(iProgressMonitor, vixHandle, n);
        if (l != (long)VixConstants.VIX_OK) {
            throw new CoreException((IStatus)VMwareConfigDelegate.makeVixErrorStatus(l, string));
        }
        iProgressMonitor.worked(1);
    }

    protected long waitDoneOrCancelled(IProgressMonitor iProgressMonitor, VixHandle vixHandle, int n) {
        long l;
        while (!iProgressMonitor.isCanceled()) {
            boolean[] blArray = new boolean[]{false};
            Vix.VixJob_CheckCompletion((VixHandle)vixHandle, (boolean[])blArray);
            if (blArray[0]) break;
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                l = VixConstants.VIX_E_CANCELLED;
            }
        }
        if (iProgressMonitor.isCanceled()) {
            l = VixConstants.VIX_E_CANCELLED;
        } else {
            vixHandle.waitDone();
            l = Vix.VixJob_GetError((VixHandle)vixHandle);
        }
        return l;
    }

    public ILaunch getLaunch(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        return new Launch(iLaunchConfiguration, string, null);
    }

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        return super.buildForLaunch(iLaunchConfiguration, string, iProgressMonitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        return super.finalLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        return super.preLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
    }

    static Status makeErrorStatus(long l, String string) {
        return new Status(4, VMwarePlugin.getUniqueIdentifier(), (int)l, string, null);
    }

    static Status makeVixErrorStatus(long l, String string) {
        if (l != (long)VixConstants.VIX_OK) {
            String string2 = Vix.Vix_GetErrorText((long)l, null);
            if (!string2.equals("")) {
                string = string + ": " + string2;
            }
            if (!string.endsWith(".")) {
                string = string + ".";
            }
        }
        return VMwareConfigDelegate.makeErrorStatus(l, string);
    }

    protected void initializeVix(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask("Preparing to communicate with virtual machine...");
        this.jobHandle = Vix.VixHost_Connect((int)Vix.VIX_API_VERSION, (int)Vix.VIX_SERVICEPROVIDER_VMWARE_WORKSTATION, null, (int)0, null, null, (int)0, null, null);
        if (this.jobHandle == null) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unable to initialize Foundry.", null));
        }
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Unable to initialize VMware runtime for this machine");
        this.hostHandle = this.jobHandle.getPropertyHandle(Vix.VIX_PROPERTY_JOB_RESULT_HANDLE);
    }

    protected void loadVM(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        if (string.equals("")) {
            throw new CoreException((IStatus)VMwareConfigDelegate.makeErrorStatus(0L, "No virtual machine specified"));
        }
        assert (this.hostHandle != null);
        iProgressMonitor.subTask("Opening virtual machine...");
        File file = new File(string);
        if (!file.exists()) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "No virtual machine was found at " + string, null));
        }
        this.jobHandle = Vix.VixVM_Open((VixHandle)this.hostHandle, (String)string, null);
        String string2 = MessageFormat.format("Unable to open virtual machine \"{0}\"", string);
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, string2);
        this.vmHandle = this.jobHandle.getPropertyHandle(Vix.VIX_PROPERTY_JOB_RESULT_HANDLE);
        if (this.vmHandle == null) {
            string2 = MessageFormat.format("Unable to open virtual machine \"{0}\": Unknown error", string);
            throw new CoreException((IStatus)VMwareConfigDelegate.makeErrorStatus(0L, string2));
        }
    }

    protected void waitForGuestToolsStartup(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask("Waiting for the virtual machine to finish booting...");
        int n = 300;
        this.jobHandle = Vix.VixVM_WaitForToolsInGuest((VixHandle)this.vmHandle, (int)n, null);
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "VMware Tools did not start");
    }

    protected void guestLogin(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask("Waiting for user to login on guest console in Workstation...");
        this.jobHandle = Vix.VixVM_LoginInGuest((VixHandle)this.vmHandle, (String)Vix.VIX_CONSOLE_USER_NAME, null, (int)0, null);
        assert (this.jobHandle.isValid());
        this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200, "Authentication failed");
    }

    protected void connectToRunningJVM(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor, int n) throws CoreException {
        Object object;
        iProgressMonitor.subTask("Identifying target process on guest...");
        String string = this.getVMConnectorId(iLaunchConfiguration);
        IVMConnector iVMConnector = null;
        iVMConnector = string == null ? JavaRuntime.getDefaultVMConnector() : JavaRuntime.getVMConnector((String)string);
        if (iVMConnector == null) {
            this.abort("Connector not specified", null, 119);
        }
        Map map = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, new HashMap());
        int n2 = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        map.put("timeout", "" + n2);
        InetAddress inetAddress = this.getGuestAddress();
        try {
            inetAddress.isReachable(2000);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unable to reach virtual machine: " + inetAddress.getHostName(), (Throwable)iOException));
        }
        map.put("hostname", inetAddress.getHostName());
        map.put("port", Integer.toString(n));
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.subTask("Creating source locator...");
        this.setDefaultSourceLocator(iLaunch, iLaunchConfiguration);
        iProgressMonitor.worked(1);
        try {
            while (!iProgressMonitor.isCanceled()) {
                try {
                    iVMConnector.connect(map, iProgressMonitor, iLaunch);
                    break;
                }
                catch (CoreException coreException) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(System.err);
        }
        if (iProgressMonitor.isCanceled()) {
            for (IDebugTarget iDebugTarget : object = iLaunch.getDebugTargets()) {
                if (!iDebugTarget.canDisconnect()) continue;
                iDebugTarget.disconnect();
            }
            return;
        }
        object = new DisconnectListener(inetAddress, n);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)object);
    }

    protected InetAddress getGuestAddress() throws CoreException {
        assert (this.vmHandle != null && this.vmHandle.isValid());
        VixHandle vixHandle = Vix.VixVM_ReadVariable((VixHandle)this.vmHandle, (int)Vix.VIX_VM_GUEST_VARIABLE, (String)"ip", (int)0, null);
        vixHandle.waitDone();
        String string = Vix.VixJob_GetNthPropertyString((VixHandle)vixHandle, (int)0, (int)Vix.VIX_PROPERTY_JOB_RESULT_VM_VARIABLE_STRING);
        if (string.length() == 0) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Unable to get IP address from guest. Ensure that it has a properly configured TCP/IP connection to the host.", null));
        }
        if (string.equals("0.0.0.0")) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Guest has only loopback IP address. Ensure that it has a properly configured TCP/IP connection to the host.", null));
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new CoreException((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Invalid guest IP address: " + string, (Throwable)unknownHostException));
        }
    }

    protected void checkCancelled(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected void startupVM(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask("Powering on virtual machine...");
        this.jobHandle = Vix.VixVM_PowerOn((VixHandle)this.vmHandle, (int)VixConstants.VIX_VMPOWEROP_LAUNCH_GUI, null, null);
        long l = this.waitDoneOrCancelled(iProgressMonitor, this.jobHandle, 200);
        if (l != (long)VixConstants.VIX_OK && l != (long)Vix.VIX_PROPERTY_VM_IS_RUNNING) {
            throw new CoreException((IStatus)VMwareConfigDelegate.makeVixErrorStatus(l, "Power on failed"));
        }
        iProgressMonitor.worked(1);
    }

    protected class VixListener
    extends EventListener {
        protected boolean isDone = false;

        protected VixListener() {
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void eventReceived(VixHandle vixHandle, int n, VixHandle vixHandle2) {
            if (n == Vix.VIX_EVENTTYPE_JOB_COMPLETED) {
                this.isDone = true;
            }
        }
    }
}

