/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.VMwarePlugin;
import com.vmware.bfg.VirtualMachineChooserButton;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class VMwareConfigTab
extends AbstractLaunchConfigurationTab {
    public static final int VM_SPACING = 10;
    protected static final String VM_CFG_NULL_ERR = "Launch config is null";
    protected static final String VM_LOCATION_UNSET_ERR = "Virtual machine location not specified";
    protected static final String VM_UNREADABLE_ERR = "Cannot open virtual machine at specified location";
    static final String ATTR_VM_LOCATION = DebugPlugin.getUniqueIdentifier() + ".vmLocation";
    static final String VM_LABEL = "Virtual Machine:";
    private static final String VMWARE = "VMware";
    protected VirtualMachineChooserButton vmSelector;
    protected FieldListener wListener = new FieldListener();
    protected FormToolkit toolkit;
    protected ScrolledForm form;

    public void createControl(Composite composite) {
        this.toolkit = new FormToolkit(composite.getDisplay());
        this.toolkit.setBackground(composite.getBackground());
        this.form = this.toolkit.createScrolledForm(composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        formLayout.marginHeight = 10;
        this.form.getBody().setLayout((Layout)formLayout);
        this.setControl((Control)this.form);
        Label label = this.toolkit.createLabel(this.form.getBody(), VM_LABEL);
        FormData formData = new FormData();
        label.setLayoutData((Object)formData);
        this.vmSelector = new VirtualMachineChooserButton(this.form.getBody(), 4);
        this.toolkit.adapt((Composite)this.vmSelector);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)label, 10);
        this.vmSelector.setLayoutData(formData2);
        formData.top = new FormAttachment((Control)this.vmSelector, 0, 0x1000000);
        formData2.right = new FormAttachment(100);
        this.vmSelector.addSelectionListener(this.wListener);
        VMwarePlugin.setShell(composite.getShell());
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute(ATTR_VM_LOCATION, "");
            if (string != "") {
                this.vmSelector.setData(string);
            }
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_VM_LOCATION, this.vmSelector.getFileName());
        this.vmSelector.persist();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_VM_LOCATION, "");
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, true);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        if (iLaunchConfiguration == null) {
            this.setErrorMessage(VM_CFG_NULL_ERR);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        String string = this.vmSelector.getFileName();
        if (string == null || string.equals("")) {
            this.setErrorMessage(VM_LOCATION_UNSET_ERR);
            return false;
        }
        File file = new File(this.vmSelector.getFileName());
        if (!file.canRead()) {
            this.setErrorMessage(VM_UNREADABLE_ERR);
            return false;
        }
        return true;
    }

    public String getName() {
        return VMWARE;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    protected class FieldListener
    implements ModifyListener,
    SelectionListener {
        protected FieldListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            VMwareConfigTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            VMwareConfigTab.this.updateLaunchConfigurationDialog();
        }
    }
}

