/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.SharedFolder;
import com.vmware.bfg.VMwareConfigTab;
import com.vmware.bfg.VMwarePlugin;
import com.vmware.bfg.widgets.CachingCombo;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class VMwareExecTab
extends VMwareConfigTab {
    public static final String EMPTY_STRING = "";
    public static final int VM_SPACING = 10;
    static final int TERM_OPTION_REVERT_TO_SNAPSHOT = 0;
    static final int TERM_OPTION_POWER_OFF = 1;
    static final int TERM_OPTION_SUSPEND = 2;
    static final int TERM_OPTION_DO_NOTHING = 3;
    static final String ATTR_USE_DEFAULT = DebugPlugin.getUniqueIdentifier() + ".useDefaultJRE";
    static final String ATTR_JRE_LOCATION = DebugPlugin.getUniqueIdentifier() + ".runtimeLocation";
    static final String ATTR_SHARED_FOLDERS = DebugPlugin.getUniqueIdentifier() + ".sharedFolders";
    static final String ATTR_REVERT = DebugPlugin.getUniqueIdentifier() + ".revert";
    static final String ATTR_ENABLE_PRELAUNCH_SCRIPT = DebugPlugin.getUniqueIdentifier() + ".enableInitScript";
    static final String ATTR_PRELAUNCH_SCRIPT = DebugPlugin.getUniqueIdentifier() + ".initScript";
    static final String ATTR_ENABLE_POST_TERM_SCRIPT = DebugPlugin.getUniqueIdentifier() + ".enableCleanupScript";
    static final String ATTR_POST_TERM_SCRIPT = DebugPlugin.getUniqueIdentifier() + ".cleanupScript";
    static final String ATTR_HAS_TERM_OPT = DebugPlugin.getUniqueIdentifier() + ".hasTermOpt";
    static final String ATTR_TERM_OPT = DebugPlugin.getUniqueIdentifier() + ".termOpt";
    private static final String JVM_LOCATIONS = "jvmLocations";
    private static final String TABNAME = "VMware";
    private static final String TITLE = "JVM on Guest Operating System";
    private static final String DEFAULT_JRE_LABEL = "Aut&o-select";
    private static final String SPECIFIC_JRE_LABEL = "Alternate &JVM Path:";
    private static final String SPECIFIC_JRE_UNSET_MSG = "Alternate &JVM Path: not specified";
    private static final String P_LOCATION = "location";
    private static final String P_NAME = "name";
    private static String[] shareTableColumnProperties = new String[]{"name", "location"};
    private static final String PRELAUNCH_SNAPSHOT_REVERSION_TOOLTIP = "Restore this virtual machine to a known state before each launch of the application";
    private static final String PRELAUNCH_SCRIPT_TOOLTIP = "Shell commands to execute inside the virtual machine before the application launches";
    private static final String PRELAUNCH_LABEL = "Before Launch";
    private static final String PRELAUNCH_SNAPSHOT_REVERT_PREDICATE_LABEL = "Set virtual machine state to &most recent snapshot";
    private static final String SCRIPT_PREDICATE_LABEL_1 = "R&un script:";
    private static final String POST_TERM_LABEL = "After Termination";
    private static final String SCRIPT_PREDICATE_LABEL_2 = "Run scrip&t:";
    private static final String POST_TERM_SCRIPT_TOOLTIP = "Shell commands to execute inside the virtual machine after the application has terminated";
    private static final String POST_TERM_STATE_CHANGE_PREDICATE_LABEL = "&Set virtual machine state ";
    private static final String POST_TERM_STATE_CHANGE_TOOLTIP = "Change the state of this virtual machine after the application has terminated";
    private static final String[] vmTerminateOptions = new String[]{"to most recent snapshot", "to powered-off", "to suspended"};
    private static final String COPY_SETTINGS_BTN = "Copy settings from another launch configuration";
    private static final String ADD = "&Add...";
    private static final String REMOVE = "&Remove";
    private static final String EDIT = "&Edit...";
    private static final String EDIT_SHARE_TITLE = "Edit share";
    private static final String LOCATION_LABEL = "Host Path";
    private static final String NAME_LABEL = "Name";
    private static final String[] shareTableColumnHeaders = new String[]{"Name", "Host Path"};
    private static final String NEW_SHARE_TITLE = "New shared folder";
    private static final String REPLACE_SHARE_TITLE = "Overwrite existing share?";
    private static final String SHARE_REPLACE_PREDICATE = "A share already exists with this name.  Replace the existing share?";
    private static final String SHARED_FOLDERS_LABEL = "{0} Shared Folders";
    private static final String SHARED_FOLDER_LABEL = "{0} Shared Folder";
    private static final String SHARE_TABLE_TOOLTIP = "List of folders that will be shared between this host and the virtual machine's guest operating system";
    private static final String ADD_BTN_TOOLTIP = "Add a new shared folder";
    private static final String EDIT_BTN_TOOLTIP = "Edit the name or host path of the selected shared folder";
    private static final String REMOVE_BTN_TOOLTIP = "Stop sharing the selected folder";
    protected Button shareAddButton;
    protected Button shareEditButton;
    protected Button shareRemoveButton;
    protected TableViewer shareTable;
    protected ColumnLayoutData[] shareTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(3), new ColumnWeightData(7)};
    private FormData jvmSelectionLabelFD;
    private Label jvmSelectionLabel;
    private FormData jvmSelectorFD;
    private ExpandableComposite sharedFoldersEC;
    private FormData prelaunchLabelFD;
    private Label prelaunchLabel;
    private Button copySettings;
    private FormData copySettingsFD;
    private FormData termSelectorFD;
    private FormData termStateToggleFD;
    private FormData teardownScriptToggleFD;
    private FormData teardownHeaderFD;
    private FormData teardownScriptFD;
    private Button prelaunchSnapshotReversionToggle;
    private Button postTermVMstateChangeToggle;
    private Button prelaunchAutomationToggle;
    private Button postTermAutomationToggle;
    private Text prelaunchScript;
    private Text postTermScript;
    private Combo vmEndStateSelector;
    private Composite sharedFolders;
    private FormData sharedFoldersFD;
    private Button defaultButton;
    private Button specificButton;
    private Combo runtimeLocationEntryBase;
    private CachingCombo runtimeLocationEntry;
    private IPreferenceStore prefs;

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.updateSharedFoldersLabel();
    }

    protected boolean addShare(SharedFolder sharedFolder) {
        TableItem[] tableItemArray;
        String string = sharedFolder.getShareName();
        for (TableItem tableItem : tableItemArray = this.shareTable.getTable().getItems()) {
            SharedFolder sharedFolder2 = (SharedFolder)tableItem.getData();
            if (!sharedFolder2.getShareName().equals(string)) continue;
            boolean bl = MessageDialog.openQuestion((Shell)this.getShell(), (String)REPLACE_SHARE_TITLE, (String)MessageFormat.format(SHARE_REPLACE_PREDICATE, string));
            if (!bl) {
                return false;
            }
            this.shareTable.remove((Object)sharedFolder2);
            break;
        }
        this.shareTable.add((Object)sharedFolder);
        return true;
    }

    public void createControl(Composite composite) {
        TableColumn tableColumn;
        FontData fontData2;
        FormData formData;
        super.createControl(composite);
        for (FontData fontData2 : formData = composite.getFont().getFontData()) {
            fontData2.setStyle(1);
        }
        this.jvmSelectionLabel = this.toolkit.createLabel(this.form.getBody(), TITLE);
        this.jvmSelectionLabel.setFont(new Font((Device)composite.getDisplay(), (FontData[])formData));
        this.jvmSelectionLabelFD = new FormData();
        this.jvmSelectionLabelFD.top = new FormAttachment((Control)this.vmSelector, 10);
        this.jvmSelectionLabel.setLayoutData((Object)this.jvmSelectionLabelFD);
        this.defaultButton = this.toolkit.createButton(this.form.getBody(), DEFAULT_JRE_LABEL, 16);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.jvmSelectionLabel, 10);
        this.defaultButton.setLayoutData((Object)formData2);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (VMwareExecTab.this.defaultButton.getSelection()) {
                    VMwareExecTab.this.runtimeLocationEntryBase.setEnabled(false);
                }
            }
        });
        this.defaultButton.addSelectionListener((SelectionListener)this.wListener);
        this.specificButton = this.toolkit.createButton(this.form.getBody(), SPECIFIC_JRE_LABEL, 16);
        formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.defaultButton, 10);
        this.specificButton.setLayoutData((Object)formData2);
        this.specificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (VMwareExecTab.this.specificButton.getSelection()) {
                    VMwareExecTab.this.runtimeLocationEntryBase.setEnabled(true);
                }
            }
        });
        this.specificButton.addSelectionListener((SelectionListener)this.wListener);
        this.prefs = VMwarePlugin.getDefault().getPreferenceStore();
        String string = this.prefs.getString(JVM_LOCATIONS);
        this.runtimeLocationEntryBase = new Combo(this.form.getBody(), 4);
        this.toolkit.adapt((Composite)this.runtimeLocationEntryBase);
        this.runtimeLocationEntry = new CachingCombo(this.runtimeLocationEntryBase, string);
        this.jvmSelectorFD = new FormData();
        this.jvmSelectorFD.left = new FormAttachment((Control)this.specificButton, 10);
        this.jvmSelectorFD.top = new FormAttachment((Control)this.specificButton, 0, 0x1000000);
        this.jvmSelectorFD.right = new FormAttachment(100);
        this.runtimeLocationEntryBase.setLayoutData((Object)this.jvmSelectorFD);
        this.runtimeLocationEntryBase.addModifyListener((ModifyListener)this.wListener);
        this.sharedFoldersEC = this.toolkit.createExpandableComposite(this.form.getBody(), 2);
        this.sharedFoldersFD = new FormData();
        this.sharedFoldersFD.top = new FormAttachment((Control)this.specificButton, 10);
        this.sharedFoldersFD.left = new FormAttachment(0);
        this.sharedFoldersFD.right = new FormAttachment(100);
        this.sharedFoldersEC.setLayoutData((Object)this.sharedFoldersFD);
        this.sharedFolders = this.toolkit.createComposite((Composite)this.sharedFoldersEC);
        FormLayout formLayout = new FormLayout();
        this.sharedFolders.setLayout((Layout)formLayout);
        this.shareTable = new TableViewer(this.sharedFolders, 68354);
        fontData2 = this.shareTable.getTable();
        this.toolkit.adapt((Composite)fontData2);
        TableLayout tableLayout = new TableLayout();
        fontData2.setLayout((Layout)tableLayout);
        fontData2.setHeaderVisible(true);
        fontData2.setFont(composite.getFont());
        fontData2.setToolTipText(SHARE_TABLE_TOOLTIP);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(0);
        this.shareTable.getControl().setLayoutData((Object)formData3);
        this.shareTable.setContentProvider((IContentProvider)new SharedFoldersContentProvider());
        this.shareTable.setLabelProvider((IBaseLabelProvider)new SharedFoldersLabelProvider());
        this.shareTable.setColumnProperties(shareTableColumnProperties);
        ISelectionChangedListener iSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                VMwareExecTab.this.handleTableSelectionChanged(selectionChangedEvent);
            }
        };
        this.shareTable.addSelectionChangedListener(iSelectionChangedListener);
        IDoubleClickListener iDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!VMwareExecTab.this.shareTable.getSelection().isEmpty()) {
                    VMwareExecTab.this.handleShareEditButtonSelected();
                }
            }
        };
        this.shareTable.addDoubleClickListener(iDoubleClickListener);
        for (int i = 0; i < shareTableColumnHeaders.length; ++i) {
            tableLayout.addColumnData(this.shareTableColumnLayouts[i]);
            tableColumn = new TableColumn((Table)fontData2, 0, i);
            tableColumn.setWidth(320);
            tableColumn.setResizable(this.shareTableColumnLayouts[i].resizable);
            tableColumn.setText(shareTableColumnHeaders[i]);
        }
        fontData2.pack();
        Composite composite2 = new Composite(this.sharedFolders, 0);
        tableColumn = new FormData();
        tableColumn.right = new FormAttachment(100);
        composite2.setLayoutData((Object)tableColumn);
        FormLayout formLayout2 = new FormLayout();
        formLayout2.marginHeight = 0;
        formLayout2.marginWidth = 0;
        composite2.setLayout((Layout)formLayout2);
        composite2.setFont(composite.getFont());
        formData3.right = new FormAttachment((Control)composite2);
        this.shareAddButton = this.toolkit.createButton(composite2, ADD, 8);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VMwareExecTab.this.handleShareAddButtonSelected();
            }
        };
        this.shareAddButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.shareAddButton.setToolTipText(ADD_BTN_TOOLTIP);
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment(0);
        formData4.right = new FormAttachment(100);
        this.shareAddButton.setLayoutData((Object)formData4);
        this.shareEditButton = this.toolkit.createButton(composite2, EDIT, 8);
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VMwareExecTab.this.handleShareEditButtonSelected();
            }
        };
        this.shareEditButton.addSelectionListener((SelectionListener)selectionAdapter2);
        this.shareEditButton.setEnabled(false);
        this.shareEditButton.setToolTipText(EDIT_BTN_TOOLTIP);
        formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.shareAddButton);
        formData4.left = new FormAttachment(0);
        formData4.right = new FormAttachment(100);
        this.shareEditButton.setLayoutData((Object)formData4);
        this.shareRemoveButton = this.toolkit.createButton(composite2, REMOVE, 8);
        SelectionAdapter selectionAdapter3 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VMwareExecTab.this.handleShareRemoveButtonSelected();
            }
        };
        this.shareRemoveButton.addSelectionListener((SelectionListener)selectionAdapter3);
        this.shareRemoveButton.setEnabled(false);
        this.shareRemoveButton.setToolTipText(REMOVE_BTN_TOOLTIP);
        formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.shareEditButton);
        formData4.left = new FormAttachment(0);
        formData4.right = new FormAttachment(100);
        this.shareRemoveButton.setLayoutData((Object)formData4);
        this.sharedFoldersEC.setClient((Control)this.sharedFolders);
        this.sharedFoldersEC.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                VMwareExecTab.this.form.reflow(true);
            }
        });
        this.prelaunchLabel = this.toolkit.createLabel(this.form.getBody(), PRELAUNCH_LABEL);
        this.prelaunchLabel.setFont(new Font((Device)composite.getDisplay(), (FontData[])formData));
        this.prelaunchLabelFD = new FormData();
        this.prelaunchLabelFD.top = new FormAttachment((Control)this.sharedFoldersEC, 10);
        this.prelaunchLabel.setLayoutData((Object)this.prelaunchLabelFD);
        this.prelaunchSnapshotReversionToggle = this.toolkit.createButton(this.form.getBody(), PRELAUNCH_SNAPSHOT_REVERT_PREDICATE_LABEL, 32);
        formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.prelaunchLabel, 10);
        this.prelaunchSnapshotReversionToggle.setLayoutData((Object)formData2);
        this.prelaunchSnapshotReversionToggle.addSelectionListener((SelectionListener)this.wListener);
        this.prelaunchSnapshotReversionToggle.setToolTipText(PRELAUNCH_SNAPSHOT_REVERSION_TOOLTIP);
        this.prelaunchAutomationToggle = this.toolkit.createButton(this.form.getBody(), SCRIPT_PREDICATE_LABEL_1, 32);
        formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.prelaunchSnapshotReversionToggle, 10);
        this.prelaunchAutomationToggle.setLayoutData((Object)formData2);
        this.prelaunchAutomationToggle.addSelectionListener((SelectionListener)this.wListener);
        this.prelaunchScript = this.toolkit.createText(this.form.getBody(), EMPTY_STRING, 2562);
        formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.prelaunchSnapshotReversionToggle, 10);
        formData2.left = new FormAttachment((Control)this.prelaunchAutomationToggle, 10);
        formData2.right = new FormAttachment(100);
        this.prelaunchScript.setLayoutData((Object)formData2);
        this.prelaunchScript.setFont(composite.getFont());
        this.prelaunchScript.addModifyListener((ModifyListener)this.wListener);
        this.prelaunchScript.setToolTipText(PRELAUNCH_SCRIPT_TOOLTIP);
        Label label = this.toolkit.createLabel(this.form.getBody(), POST_TERM_LABEL);
        label.setFont(new Font((Device)composite.getDisplay(), (FontData[])formData));
        this.teardownHeaderFD = new FormData();
        this.teardownHeaderFD.top = new FormAttachment((Control)this.prelaunchScript, 10);
        label.setLayoutData((Object)this.teardownHeaderFD);
        this.postTermAutomationToggle = this.toolkit.createButton(this.form.getBody(), SCRIPT_PREDICATE_LABEL_2, 32);
        this.teardownScriptToggleFD = new FormData();
        this.teardownScriptToggleFD.top = new FormAttachment((Control)label, 10);
        this.postTermAutomationToggle.setLayoutData((Object)this.teardownScriptToggleFD);
        this.postTermAutomationToggle.addSelectionListener((SelectionListener)this.wListener);
        this.postTermScript = this.toolkit.createText(this.form.getBody(), EMPTY_STRING, 2562);
        this.teardownScriptFD = new FormData();
        this.teardownScriptFD.top = new FormAttachment((Control)label, 10);
        this.teardownScriptFD.left = new FormAttachment((Control)this.postTermAutomationToggle, 10);
        this.teardownScriptFD.right = new FormAttachment(100);
        this.postTermScript.setLayoutData((Object)this.teardownScriptFD);
        this.postTermScript.setFont(composite.getFont());
        this.postTermScript.addModifyListener((ModifyListener)this.wListener);
        this.postTermScript.setToolTipText(POST_TERM_SCRIPT_TOOLTIP);
        this.postTermVMstateChangeToggle = this.toolkit.createButton(this.form.getBody(), POST_TERM_STATE_CHANGE_PREDICATE_LABEL, 32);
        this.termStateToggleFD = new FormData();
        this.termStateToggleFD.top = new FormAttachment((Control)this.postTermScript, 10);
        this.postTermVMstateChangeToggle.setLayoutData((Object)this.termStateToggleFD);
        SelectionAdapter selectionAdapter4 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VMwareExecTab.this.updateLaunchConfigurationDialog();
                VMwareExecTab.this.vmEndStateSelector.setEnabled(VMwareExecTab.this.postTermVMstateChangeToggle.getSelection());
            }
        };
        this.postTermVMstateChangeToggle.addSelectionListener((SelectionListener)selectionAdapter4);
        this.postTermVMstateChangeToggle.setToolTipText(POST_TERM_STATE_CHANGE_TOOLTIP);
        this.vmEndStateSelector = new Combo(this.form.getBody(), 2056);
        this.toolkit.adapt((Composite)this.vmEndStateSelector);
        this.vmEndStateSelector.setItems(vmTerminateOptions);
        this.vmEndStateSelector.setText(vmTerminateOptions[0]);
        this.termSelectorFD = new FormData();
        this.termSelectorFD.left = new FormAttachment((Control)this.postTermVMstateChangeToggle);
        this.termSelectorFD.top = new FormAttachment((Control)this.postTermVMstateChangeToggle, 0, 0x1000000);
        this.vmEndStateSelector.setLayoutData((Object)this.termSelectorFD);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                VMwareExecTab.this.vmEndStateSelector.setSelection(new Point(0, 0));
            }
        };
        this.vmEndStateSelector.addFocusListener((FocusListener)focusAdapter);
        this.vmEndStateSelector.setSelection(new Point(0, 0));
        this.vmEndStateSelector.addModifyListener((ModifyListener)this.wListener);
        this.copySettings = this.toolkit.createButton(this.form.getBody(), COPY_SETTINGS_BTN, 8);
        this.copySettingsFD = new FormData();
        this.copySettingsFD.left = new FormAttachment(0);
        this.copySettingsFD.right = new FormAttachment(100);
        this.copySettingsFD.bottom = new FormAttachment(100);
        this.copySettings.setLayoutData((Object)this.copySettingsFD);
        SelectionAdapter selectionAdapter5 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                System.out.println("Copy Setting btn pushed");
            }
        };
        this.copySettings.addSelectionListener((SelectionListener)selectionAdapter5);
        this.copySettings.setVisible(false);
        int n = this.shareTable.getTable().getItemCount();
        this.sharedFoldersEC.setText(n + SHARED_FOLDERS_LABEL);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void dispose() {
    }

    public String getName() {
        return TABNAME;
    }

    protected void handleShareAddButtonSelected() {
        MultipleInputDialog multipleInputDialog = new MultipleInputDialog(this.getShell(), NEW_SHARE_TITLE);
        multipleInputDialog.addTextField(NAME_LABEL, null, false);
        multipleInputDialog.addBrowseField(LOCATION_LABEL, null, false);
        if (multipleInputDialog.open() != 0) {
            return;
        }
        String string = multipleInputDialog.getStringValue(LOCATION_LABEL);
        String string2 = multipleInputDialog.getStringValue(NAME_LABEL);
        if (string != null && string2 != null && string.length() > 0 && string2.length() > 0 && this.addShare(new SharedFolder(string2.trim(), string.trim()))) {
            this.updateLaunchConfigurationDialog();
        }
        this.updateSharedFoldersLabel();
    }

    private void handleShareEditButtonSelected() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.shareTable.getSelection();
        SharedFolder sharedFolder = (SharedFolder)iStructuredSelection.getFirstElement();
        if (sharedFolder == null) {
            return;
        }
        IPath iPath = sharedFolder.getLocation();
        String string = sharedFolder.getShareName();
        MultipleInputDialog multipleInputDialog = new MultipleInputDialog(this.getShell(), EDIT_SHARE_TITLE);
        multipleInputDialog.addTextField(NAME_LABEL, string, true);
        multipleInputDialog.addBrowseField(LOCATION_LABEL, iPath.toOSString(), false);
        if (multipleInputDialog.open() != 0) {
            return;
        }
        Path path = new Path(multipleInputDialog.getStringValue(LOCATION_LABEL));
        String string2 = multipleInputDialog.getStringValue(NAME_LABEL);
        if (!string.equals(string2)) {
            if (this.addShare(new SharedFolder(string2, (IPath)path))) {
                this.shareTable.remove((Object)sharedFolder);
                this.updateLaunchConfigurationDialog();
            }
        } else {
            sharedFolder.setLocation((IPath)path);
            this.shareTable.update((Object)sharedFolder, null);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleShareRemoveButtonSelected() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.shareTable.getSelection();
        this.shareTable.getControl().setRedraw(false);
        for (SharedFolder sharedFolder : iStructuredSelection) {
            this.shareTable.remove((Object)sharedFolder);
        }
        this.shareTable.getControl().setRedraw(true);
        this.updateSharedFoldersLabel();
        this.updateLaunchConfigurationDialog();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        int n = ((IStructuredSelection)selectionChangedEvent.getSelection()).size();
        this.shareEditButton.setEnabled(n == 1);
        this.shareRemoveButton.setEnabled(n > 0);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        super.initializeFrom(iLaunchConfiguration);
        boolean bl = true;
        try {
            bl = iLaunchConfiguration.getAttribute(ATTR_USE_DEFAULT, true);
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        this.defaultButton.setSelection(bl);
        this.runtimeLocationEntryBase.setEnabled(!bl);
        this.specificButton.setSelection(!bl);
        String string = EMPTY_STRING;
        try {
            string = iLaunchConfiguration.getAttribute(ATTR_JRE_LOCATION, EMPTY_STRING);
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        try {
            String string2 = iLaunchConfiguration.getAttribute(VMwareConfigTab.ATTR_VM_LOCATION, EMPTY_STRING);
            this.runtimeLocationEntry.update(string, string2);
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
            this.runtimeLocationEntryBase.setText(string);
        }
        try {
            this.prelaunchSnapshotReversionToggle.setSelection(iLaunchConfiguration.getAttribute(ATTR_REVERT, false));
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        boolean bl2 = false;
        try {
            bl2 = iLaunchConfiguration.getAttribute(ATTR_ENABLE_PRELAUNCH_SCRIPT, false);
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        this.prelaunchAutomationToggle.setSelection(bl2);
        try {
            this.prelaunchScript.setText(iLaunchConfiguration.getAttribute(ATTR_PRELAUNCH_SCRIPT, EMPTY_STRING));
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        try {
            this.postTermAutomationToggle.setSelection(iLaunchConfiguration.getAttribute(ATTR_ENABLE_POST_TERM_SCRIPT, false));
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        try {
            this.postTermScript.setText(iLaunchConfiguration.getAttribute(ATTR_POST_TERM_SCRIPT, EMPTY_STRING));
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        try {
            this.postTermVMstateChangeToggle.setSelection(iLaunchConfiguration.getAttribute(ATTR_HAS_TERM_OPT, false));
            this.vmEndStateSelector.setEnabled(this.postTermVMstateChangeToggle.getSelection());
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        int n = 3;
        try {
            n = iLaunchConfiguration.getAttribute(ATTR_TERM_OPT, n);
        }
        catch (CoreException coreException) {
            VMwarePlugin.log(coreException);
        }
        this.vmEndStateSelector.select(n);
        this.updateShares(iLaunchConfiguration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.performApply(iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_USE_DEFAULT, this.defaultButton.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_JRE_LOCATION, this.runtimeLocationEntryBase.getText());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_REVERT, this.prelaunchSnapshotReversionToggle.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_ENABLE_PRELAUNCH_SCRIPT, this.prelaunchAutomationToggle.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_PRELAUNCH_SCRIPT, this.prelaunchScript.getText());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_ENABLE_POST_TERM_SCRIPT, this.postTermAutomationToggle.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_POST_TERM_SCRIPT, this.postTermScript.getText());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_HAS_TERM_OPT, this.postTermVMstateChangeToggle.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_TERM_OPT, this.vmEndStateSelector.getSelectionIndex());
        TableItem[] tableItemArray = this.shareTable.getTable().getItems();
        HashMap<String, String> hashMap = new HashMap<String, String>(tableItemArray.length);
        for (TableItem tableItem : tableItemArray) {
            SharedFolder sharedFolder = (SharedFolder)tableItem.getData();
            hashMap.put(sharedFolder.getShareName(), sharedFolder.getLocation().toOSString());
        }
        if (hashMap.size() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute(ATTR_SHARED_FOLDERS, (Map)null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute(ATTR_SHARED_FOLDERS, hashMap);
            this.updateShares((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.setDefaults(iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_REVERT, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_ENABLE_PRELAUNCH_SCRIPT, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_PRELAUNCH_SCRIPT, "\n\n\n");
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_ENABLE_POST_TERM_SCRIPT, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_POST_TERM_SCRIPT, "\n\n\n");
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_HAS_TERM_OPT, false);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_TERM_OPT, 2);
        iLaunchConfigurationWorkingCopy.setAttribute(ATTR_USE_DEFAULT, true);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        if (!super.isValid(iLaunchConfiguration)) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.specificButton.getSelection() && this.runtimeLocationEntryBase.getText().equals(EMPTY_STRING)) {
            this.setErrorMessage(SPECIFIC_JRE_UNSET_MSG);
            return false;
        }
        return true;
    }

    protected void updateShares(ILaunchConfiguration iLaunchConfiguration) {
        this.shareTable.setInput((Object)iLaunchConfiguration);
        this.updateSharedFoldersLabel();
    }

    private void updateSharedFoldersLabel() {
        int n = this.shareTable.getTable().getItemCount();
        String string = MessageFormat.format(n == 1 ? SHARED_FOLDER_LABEL : SHARED_FOLDERS_LABEL, n);
        this.sharedFoldersEC.setText(string);
    }

    void persistCachedPluginData(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        assert (this.prefs != null);
        String string = this.runtimeLocationEntry.toString();
        this.prefs.setValue(JVM_LOCATIONS, string);
    }

    public class SharedFoldersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            if (object != null) {
                SharedFolder sharedFolder = (SharedFolder)object;
                switch (n) {
                    case 0: {
                        string = sharedFolder.getShareName();
                        break;
                    }
                    case 1: {
                        string = sharedFolder.getLocation().toOSString();
                    }
                }
            }
            return string;
        }
    }

    protected class SharedFoldersContentProvider
    implements IStructuredContentProvider {
        protected SharedFoldersContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Map map;
            Object[] objectArray = new SharedFolder[]{};
            ILaunchConfiguration iLaunchConfiguration = (ILaunchConfiguration)object;
            try {
                map = iLaunchConfiguration.getAttribute(ATTR_SHARED_FOLDERS, new HashMap());
            }
            catch (CoreException coreException) {
                VMwarePlugin.getDefault().getLog().log((IStatus)new Status(4, VMwarePlugin.getUniqueIdentifier(), 0, "Error reading configuration", (Throwable)coreException));
                return objectArray;
            }
            assert (map != null);
            if (map != null && !map.isEmpty()) {
                objectArray = new SharedFolder[map.size()];
                Iterator iterator = map.entrySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    objectArray[n] = new SharedFolder((String)entry.getKey(), (String)entry.getValue());
                    ++n;
                }
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                ViewerSorter viewerSorter = new ViewerSorter(){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        if (object == null) {
                            return -1;
                        }
                        if (object2 == null) {
                            return 1;
                        }
                        return ((SharedFolder)object).getShareName().compareToIgnoreCase(((SharedFolder)object2).getShareName());
                    }
                };
                tableViewer.setSorter(viewerSorter);
            }
        }
    }
}

