/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.vix.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class VMwarePlugin
extends AbstractUIPlugin {
    private static final String VIRTUALIZED_DEBUGGING = "virtualized_debugging";
    private static final String IMAGE_ICONS_APPICON_PNG = "icons/appIcon.png";
    private static VMwarePlugin plugin;
    private static Shell shell;
    private Set<EventListener> activeCallbacks;

    public VMwarePlugin() {
        plugin = this;
        this.activeCallbacks = new HashSet<EventListener>();
    }

    void rememberCallback(EventListener eventListener) {
        this.activeCallbacks.add(eventListener);
    }

    void forgetCallback(EventListener eventListener) {
        this.activeCallbacks.remove(eventListener);
    }

    public static Shell getShell() {
        if (VMwarePlugin.getActiveWorkbenchShell() != null) {
            return VMwarePlugin.getActiveWorkbenchShell();
        }
        if (shell != null) {
            if (!shell.isDisposed()) {
                return shell;
            }
            shell = null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = VMwarePlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return iWorkbenchWindowArray[0].getShell();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static VMwarePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return VMwarePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)VIRTUALIZED_DEBUGGING, (String)string);
    }

    public static ImageDescriptor getAppIconSmall() {
        return VMwarePlugin.getImageDescriptor(IMAGE_ICONS_APPICON_PNG);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return VMwarePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = VMwarePlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = VMwarePlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static void errorDialog(String string, IStatus iStatus) {
        Shell shell = VMwarePlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"A bad thing happened :-(", (String)string, (IStatus)iStatus);
        }
    }

    public static void log(JavaModelException javaModelException) {
    }

    public static void log(CoreException coreException) {
        VMwarePlugin.getDefault().log(coreException.getLocalizedMessage(), (Exception)((Object)coreException));
    }

    public void log(String string) {
        this.log(string, null);
    }

    public void log(String string, Exception exception) {
        this.getLog().log((IStatus)new Status(1, VMwarePlugin.getUniqueIdentifier(), 4, string, (Throwable)exception));
    }

    public static void setShell(Shell shell) {
        VMwarePlugin.shell = shell;
    }
}

