/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg;

import com.vmware.bfg.VMwareConfigDelegate;
import com.vmware.bfg.VMwarePlugin;
import com.vmware.bfg.VmxItem;
import com.vmware.bfg.widgets.FileChooserButton;
import com.vmware.vix.EventListener;
import com.vmware.vix.Vix;
import com.vmware.vix.VixConstants;
import com.vmware.vix.VixHandle;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineChooserButton
extends FileChooserButton {
    public static final String ERR_FOUNDRY_INIT_FAILED = "Unable to initialize VMware runtime for this machine";
    static final String VM_CHOOSER_BTN_TEXT = "Click to select.";
    static final String CURRENTLY_RUNNING = "currently running";
    static final String[] vmExts = new String[]{"*.vmx", "*.VMX"};

    public VirtualMachineChooserButton(Composite composite, int n) {
        super(composite, VM_CHOOSER_BTN_TEXT, VMwarePlugin.getDefault(), vmExts, n);
        ArrayList<FileChooserButton.FileItem> arrayList = new ArrayList<FileChooserButton.FileItem>();
        Iterable<String> iterable = this.getRunningVMs();
        for (String string : iterable) {
            try {
                arrayList.add(this.makeFileItem(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                VMwarePlugin.getDefault().log(fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
            }
        }
        this.addItemGroup(CURRENTLY_RUNNING, arrayList);
    }

    private Iterable<String> getRunningVMs() {
        long l = 0L;
        ArrayList<String> arrayList = new ArrayList<String>();
        VixHandle vixHandle = null;
        VixHandle vixHandle2 = null;
        SynchronousEventListener synchronousEventListener = new SynchronousEventListener(arrayList);
        try {
            vixHandle = Vix.VixHost_Connect((int)Vix.VIX_API_VERSION, (int)Vix.VIX_SERVICEPROVIDER_DEFAULT, null, (int)0, null, null, (int)0, null, null);
            l = vixHandle.waitDone();
            if (l != (long)VixConstants.VIX_OK) {
                throw new CoreException((IStatus)VMwareConfigDelegate.makeVixErrorStatus(l, ERR_FOUNDRY_INIT_FAILED));
            }
            vixHandle2 = vixHandle.getPropertyHandle(Vix.VIX_PROPERTY_JOB_RESULT_HANDLE);
            vixHandle = Vix.VixHost_FindItems((VixHandle)vixHandle2, (int)Vix.VIX_FIND_RUNNING_VMS, null, (int)-1, (EventListener)synchronousEventListener);
            vixHandle.waitDone();
            boolean[] blArray = new boolean[]{false};
            if (!synchronousEventListener.isDone()) {
                Thread.sleep(1000L);
                while (!blArray[0]) {
                    Thread.sleep(200L);
                    Vix.VixJob_CheckCompletion((VixHandle)vixHandle, (boolean[])blArray);
                }
            }
            vixHandle = null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return arrayList;
    }

    @Override
    protected FileChooserButton.FileItem makeFileItem(String string) throws FileNotFoundException {
        return new VmxItem(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SynchronousEventListener
    extends EventListener {
        List<String> vmLocations;
        boolean isDone = false;

        public boolean isDone() {
            return this.isDone;
        }

        public SynchronousEventListener(List<String> list) {
            this.vmLocations = list;
        }

        public void eventReceived(VixHandle vixHandle, int n, VixHandle vixHandle2) {
            if (this.isDone) assert (false);
            if (n == Vix.VIX_EVENTTYPE_FIND_ITEM) {
                String string = Vix.Vix_GetPropertyString((VixHandle)vixHandle2, (int)Vix.VIX_PROPERTY_FOUND_ITEM_LOCATION);
                if (string != null) {
                    this.vmLocations.add(string);
                }
            } else if (n == Vix.VIX_EVENTTYPE_JOB_COMPLETED) {
                this.isDone = true;
            }
        }
    }
}

