/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg.widgets;

import com.vmware.bfg.widgets.ContentProvider;
import com.vmware.bfg.widgets.DataLabelProvider;
import com.vmware.bfg.widgets.DataList;
import com.vmware.bfg.widgets.DataSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EasyTable
extends Composite {
    private Table table = null;
    private TableViewer tableViewer = null;

    public EasyTable(Composite composite, int n, IDataAttrib[] iDataAttribArray, DataList dataList) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(gridData);
        this.tableViewer = new TableViewer((Composite)this);
        this.table = this.tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        gridData = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setSorter((ViewerSorter)new DataSorter(null));
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DataLabelProvider(iDataAttribArray));
        String[] stringArray = new String[iDataAttribArray.length];
        for (int i = 0; i < iDataAttribArray.length; ++i) {
            this.createColumn(iDataAttribArray[i], i);
            stringArray[i] = iDataAttribArray[i].toString();
        }
        this.tableViewer.setColumnProperties(stringArray);
        this.tableViewer.setInput((Object)dataList);
    }

    private void createColumn(IDataAttrib iDataAttrib, int n) {
        TableColumn tableColumn = new TableColumn(this.table, 16384, n);
        tableColumn.setText(iDataAttrib.toString());
        tableColumn.setWidth(78);
        DataSorter dataSorter = new DataSorter(iDataAttrib);
        tableColumn.addSelectionListener((SelectionListener)new DataSelectionAdapter(dataSorter));
    }

    public class DataSelectionAdapter
    extends SelectionAdapter
    implements SelectionListener {
        private DataSorter ds;

        DataSelectionAdapter(DataSorter dataSorter) {
            this.ds = dataSorter;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            EasyTable.this.tableViewer.setSorter((ViewerSorter)this.ds);
        }
    }

    public static interface IData {
        public String getAttribText(IDataAttrib var1);

        public int compareTo(IData var1, IDataAttrib var2);
    }

    public static interface IDataAttrib {
    }

    public static interface IDataListViewer {
    }
}

