/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.bfg.widgets;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileChooserButton
extends Composite {
    public static final String PATH_DELIMITER = "\n";
    static final String MRU_VM_LOCATIONS = "vmLocations";
    static final int MRU_QUANTITY = 6;
    static final String MRU = "recently used";
    static final String[] defaultValidExts = new String[]{"*", "*.*"};
    private static final String DEFAULT_TEXT = "Please select a file...";
    private SortedMap<String, List<FileItem>> items = new TreeMap<String, List<FileItem>>();
    private Button btn = null;
    private Listener selectionListener;
    private AbstractUIPlugin plugin;
    private String[] validExts = null;
    protected IPreferenceStore prefs;
    protected String filename = null;

    public static List<String> splitPathList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_DELIMITER);
        int n = stringTokenizer.countTokens();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    protected abstract FileItem makeFileItem(String var1) throws FileNotFoundException;

    public void addSelectionListener(SelectionListener selectionListener) {
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)selectionListener));
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(13, (SWTEventListener)selectionListener);
    }

    public FileChooserButton(Composite composite, int n) {
        this(composite, DEFAULT_TEXT, null, defaultValidExts, n);
    }

    public FileChooserButton(Composite composite, String string, AbstractUIPlugin abstractUIPlugin, String[] stringArray, int n) {
        super(composite, n);
        this.validExts = stringArray;
        this.selectionListener = new Listener(){

            public void handleEvent(Event event) {
                MenuItem menuItem = (MenuItem)event.widget;
                FileChooserButton.this.filename = menuItem.getText();
                try {
                    FileItem fileItem = FileChooserButton.this.makeFileItem(FileChooserButton.this.filename);
                    List<FileItem> list = FileChooserButton.this.getItemGroup(FileChooserButton.MRU);
                    list.remove(fileItem);
                    list.add(fileItem);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                FileChooserButton.this.btn.setText(menuItem.getText());
                FileChooserButton.this.notifyListeners(13, new Event());
            }
        };
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        this.setLayout((Layout)fillLayout);
        ArrayList<FileItem> arrayList = new ArrayList<FileItem>();
        if (abstractUIPlugin != null) {
            this.prefs = abstractUIPlugin.getPreferenceStore();
            List<String> list = FileChooserButton.splitPathList(this.prefs.getString(MRU_VM_LOCATIONS));
            for (String string2 : list) {
                try {
                    FileItem fileItem = this.makeFileItem(string2);
                    arrayList.add(fileItem);
                }
                catch (Exception exception) {}
            }
        }
        this.addItemGroup(MRU, arrayList);
        this.btn = new Button((Composite)this, 8);
        this.btn.setAlignment(16384);
        this.btn.setText(string);
        this.btn.setVisible(true);
        this.btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                assert (false);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Menu menu = new Menu((Decorations)FileChooserButton.this.getShell(), 8);
                menu.setLocation(FileChooserButton.this.toDisplay(new Point(0, 0)));
                HashSet<String> hashSet = new HashSet<String>();
                for (String string : FileChooserButton.this.items.keySet()) {
                    FileItem[] fileItemArray = FileChooserButton.this.getItemGroup(string).toArray(new FileItem[0]);
                    for (int i = fileItemArray.length - 1; i >= 0; --i) {
                        if (hashSet.contains(fileItemArray[i].toString())) continue;
                        MenuItem menuItem = new MenuItem(menu, 8);
                        hashSet.add(fileItemArray[i].toString());
                        menuItem.setText(fileItemArray[i].toString());
                        menuItem.addListener(13, FileChooserButton.this.selectionListener);
                    }
                    new MenuItem(menu, 2);
                }
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText("Browse...");
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        FileDialog fileDialog = new FileDialog(FileChooserButton.this.getShell());
                        fileDialog.setFilterExtensions(FileChooserButton.this.validExts);
                        fileDialog.setText("Open file");
                        String string = fileDialog.open();
                        if (string != null) {
                            FileChooserButton.this.filename = string;
                            try {
                                FileItem fileItem = FileChooserButton.this.makeFileItem(FileChooserButton.this.filename);
                                List<FileItem> list = FileChooserButton.this.getItemGroup(FileChooserButton.MRU);
                                if (list.contains(fileItem)) {
                                    list.remove(fileItem);
                                }
                                list.add(fileItem);
                                while (list.size() > 6) {
                                    list.remove(0);
                                }
                                FileChooserButton.this.btn.setText(fileItem.toString());
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                        }
                        FileChooserButton.this.notifyListeners(13, new Event());
                    }
                });
                menu.setVisible(true);
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (!FileChooserButton.this.getDisplay().readAndDispatch()) continue;
                    FileChooserButton.this.getDisplay().sleep();
                }
                menu.dispose();
            }
        });
    }

    public void addItemGroup(String string, List<FileItem> list) {
        this.checkWidget();
        this.items.put(string, list);
    }

    public List<FileItem> getItemGroup(String string) {
        return (List)this.items.get(string);
    }

    public void setData(String string) {
        this.filename = string;
        this.btn.setText(string);
    }

    public String getFileName() {
        return this.filename;
    }

    public void persist() {
        assert (this.prefs != null);
        List<FileItem> list = this.getItemGroup(MRU);
        StringBuffer stringBuffer = new StringBuffer();
        for (FileItem fileItem : list) {
            stringBuffer.append(fileItem);
            stringBuffer.append(PATH_DELIMITER);
        }
        this.prefs.setValue(MRU_VM_LOCATIONS, stringBuffer.toString());
    }

    public static interface FileItem {
    }
}

