// Copyright (c) 2002-2005 Quadralay Corporation.  All rights reserved.
//

function  HTMLHelpUtility_NotifyClickedPopup()
{
  // Not a member function, need to access via variable
  //
  WebWorksHTMLHelp.mbPopupClicked = true;
}

function  HTMLHelp_Object()
{
  this.mbPopupClicked  = false;
  this.mbOverPopupLink = false;
  this.mEvent          = null;
  this.mPopup          = new HTMLHelpPopup_Object("WebWorksHTMLHelp.mPopup",
                                                  "window",
                                                  HTMLHelpUtility_NotifyClickedPopup,
                                                  "HTMLHelpPopupDIV", "HTMLHelpPopupText",
                                                  10, 12, 20, 400);

  this.fNotifyClicked  = HTMLHelp_NotifyClicked;
  this.fMouseOverPopup = HTMLHelp_MouseOverPopup;
  this.fMouseOutPopup  = HTMLHelp_MouseOutPopup;
  this.fShowPopup      = HTMLHelp_ShowPopup;
  this.fPopupLoaded    = HTMLHelp_PopupLoaded;
  this.fHidePopup      = HTMLHelp_HidePopup;
  this.fPopupDivTag    = HTMLHelp_PopupDivTag;
}

function  HTMLHelp_NotifyClicked()
{
  if (this.mbPopupClicked)
  {
    this.mbPopupClicked = false;
  }
  else if ( ! this.mbOverPopupLink)
  {
    this.fHidePopup();
  }
}

function  HTMLHelp_MouseOverPopup(ParamEvent)
{
  this.mbOverPopupLink = true;

  this.mEvent = new Object();
  this.mEvent.x = ParamEvent.x;
  this.mEvent.y = ParamEvent.y;
}

function  HTMLHelp_MouseOutPopup()
{
  this.mbOverPopupLink = false;
}

function  HTMLHelp_ShowPopup(ParamLink)
{
  var  VarHTML;

  if (this.mEvent != null)
  {
    VarHTML = "<iframe id=\"WWHPopupIFrame\" width=\"" + this.mPopup.mWidth + "\" src=\"" + ParamLink + "\" onload=\"javascript:WebWorksHTMLHelp.fPopupLoaded()\"></iframe>";
    this.mbPopupClicked = false;
    this.mPopup.fShow(VarHTML, this.mEvent);
  }

  this.mEvent = null;
}

function  HTMLHelp_PopupLoaded()
{
  var  VarPopupDocument;
  var  VarIFrame;
  var  VarHeight;

  // Access popup document
  //
  VarPopupDocument = eval(this.mPopup.mWindowRef + ".document");

  // Access popup iframe
  //
  VarIFrame = VarPopupDocument.all['WWHPopupIFrame'];

  // Set height again before width set
  //
  VarHeight = VarIFrame.contentWindow.document.body.scrollHeight + 32 + 4;
  VarIFrame.height = VarHeight;

  // Set width
  //
  VarWidth = VarIFrame.contentWindow.document.body.scrollWidth + 32 + 4;
  if (VarWidth > this.mPopup.mWidth)
  {
    VarIFrame.width = VarWidth;
  }

  // Set height again after width set
  //
  VarHeight = VarIFrame.contentWindow.document.body.scrollHeight + 32 + 4;
  VarIFrame.height = VarHeight;
}

function  HTMLHelp_HidePopup()
{
  this.mPopup.fHide();
}

function  HTMLHelp_PopupDivTag()
{
  return this.mPopup.fDivTagText();
}
