#!/bin/bash

# 
# This script is copied into the guest with the 32 and 64 bit upgrader binaries.
# It selects one of the binaries based on the userland bitness of the guest and
# runs it.
#

BINDIR=`dirname $0`
UPGRADER64="$BINDIR/vmware-tools-upgrader-64"
UPGRADER32="$BINDIR/vmware-tools-upgrader-32"

# Close all the inherited FDs. See bug 138500 for details.
MAXFD=$(expr `ulimit -n` - 1)
for fd in `seq 3 $MAXFD`; do
   eval "exec $fd>&-"
done

# Check userland bitness.
if LANG=C file -- "$SHELL" | grep 64-bit >& /dev/null;
then
   UPGRADER=$UPGRADER64;
else
   UPGRADER=$UPGRADER32;
fi

# Run the upgrader.
chmod +x $UPGRADER
$UPGRADER >& $BINDIR/vmware-tools-upgrader.log

# Cleanup.
rm -f $UPGRADER64 $UPGRADER32 $0 

# Done.
exit 0

