/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciGroup.h --
 *
 *	VMCI Group API.
 */

#ifndef _VMCI_GROUP_H_
#define _VMCI_GROUP_H_

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

VMCIHandle VMCIGroup_Create(void);
void VMCIGroup_Destroy(VMCIHandle groupHandle);
int VMCIGroup_AddMember(VMCIHandle groupHandle, VMCIHandle memberHandle, 
                        Bool canAssign);
int VMCIGroup_RemoveMember(VMCIHandle groupHandle, VMCIHandle memberHandle);
Bool VMCIGroup_IsMember(VMCIHandle groupHandle, VMCIHandle memberHandle);

#endif // _VMCI_GROUP_H_
