#include <linux/fs.h>
#include <linux/types.h>  /* loff_t */
#include <linux/stddef.h> /* NULL */

/*
 * Around 2.6.18, filldir and statfs were changed to send 64-bit inode
 * numbers to user space. Red Hat backported this behavior into a 2.6.17
 * kernel.
 *
 * This test will fail on a kernel with such a patch.
 */
static int LinuxDriverFilldir(void *buf,
                              const char *name,
                              int namelen,
                              loff_t offset,
                              ino_t ino,
                              unsigned int d_type)
{
   return 0;
}

void test(void)
{
   vfs_readdir(NULL, LinuxDriverFilldir, NULL);
}
