#ifndef __COMPAT_STRING_H__
#   define __COMPAT_STRING_H__

#include <linux/string.h>

/*
 * kstrdup was born in 2.6.13. This implementation is almost identical to the
 * one found there.
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 13)
#define compat_kstrdup(s, gfp) kstrdup(s, gfp)
#else
#define compat_kstrdup(s, gfp)                                                \
({                                                                            \
   size_t len;                                                                \
   char *buf;                                                                 \
   len = strlen(s) + 1;                                                       \
   buf = kmalloc(len, gfp);                                                   \
   memcpy(buf, s, len);                                                       \
   buf;                                                                       \
})                                                                            
#endif

#endif /* __COMPAT_STRING_H__ */
