/* **********************************************************
 * Copyright (C) 2006 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmblock.h --
 *
 *   User-level interface to the vmblock device.
 */

#ifndef _VMBLOCK_H_
#define _VMBLOCK_H_

#ifdef sun
# include <sys/ioccom.h>
#endif

#define VMBLOCK_FS_NAME                "vmblock"

/* Commands for the control half of vmblock driver */
#if defined(linux)
# define VMBLOCK_ADD_FILEBLOCK          98
# define VMBLOCK_DEL_FILEBLOCK          99
# ifdef VMX86_DEVEL
#  define VMBLOCK_LIST_FILEBLOCKS       100
# endif
# define VMBLOCK_CONTROL_DIRNAME        VMBLOCK_FS_NAME
# define VMBLOCK_CONTROL_DEVNAME        "dev"
# define VMBLOCK_CONTROL_MOUNTPOINT     "mountPoint"

# define VMBLOCK_MOUNT_POINT            "/proc/fs/" VMBLOCK_CONTROL_DIRNAME   \
                                       "/" VMBLOCK_CONTROL_MOUNTPOINT
# define VMBLOCK_DEVICE                 "/proc/fs/" VMBLOCK_CONTROL_DIRNAME   \
                                       "/" VMBLOCK_CONTROL_DEVNAME
# define VMBLOCK_DEVICE_MODE            O_WRONLY
# define VMBLOCK_CONTROL(fd, op, path)  write(fd, path, op)

#elif defined(sun)
/*
 * Construct ioctl(2) commands for blocks.  _IO() is a helper macro to
 * construct unique command values more easily.  I chose 'v' because I didn't
 * see it being used elsewhere, and the command numbers begin at one.
 */
# define VMBLOCK_ADD_FILEBLOCK          _IO('v', 1)
# define VMBLOCK_DEL_FILEBLOCK          _IO('v', 2)
# ifdef VMX86_DEVEL
#  define VMBLOCK_LIST_FILEBLOCKS       _IO('v', 3)
# endif
# define VMBLOCK_MOUNT_POINT            "/var/run/" VMBLOCK_FS_NAME
# define VMBLOCK_DEVICE                 VMBLOCK_MOUNT_POINT
# define VMBLOCK_DEVICE_MODE            O_RDONLY
# define VMBLOCK_CONTROL(fd, op, path)  ioctl(fd, op, path)
#else
# error "Unknown platform for vmblock."
#endif

#endif /* _VMBLOCK_H_ */
