
#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to
# your agreement to the terms of an applicable VMware license.
#

package VMware::Vix::API::Constants;
require Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();
$VERSION = 1;

unless(0) {
    sub _VIX_H_ {1} push(@EXPORT, '_VIX_H_');
    if(defined(&__cplusplus)) {
    }
    sub VIX_API_VERSION {2} push(@EXPORT, 'VIX_API_VERSION');
    sub VIX_INVALID_HANDLE {0} push(@EXPORT, 'VIX_INVALID_HANDLE');
    sub VIX_HANDLETYPE_NONE {0} push(@EXPORT, 'VIX_HANDLETYPE_NONE');
    sub VIX_HANDLETYPE_HOST {2} push(@EXPORT, 'VIX_HANDLETYPE_HOST');
    sub VIX_HANDLETYPE_VM {3} push(@EXPORT, 'VIX_HANDLETYPE_VM');
    sub VIX_HANDLETYPE_NETWORK {5} push(@EXPORT, 'VIX_HANDLETYPE_NETWORK');
    sub VIX_HANDLETYPE_JOB {6} push(@EXPORT, 'VIX_HANDLETYPE_JOB');
    sub VIX_HANDLETYPE_SNAPSHOT {7} push(@EXPORT, 'VIX_HANDLETYPE_SNAPSHOT');
    sub VIX_HANDLETYPE_METADATA_CONTAINER {11} push(@EXPORT, 'VIX_HANDLETYPE_METADATA_CONTAINER');
    eval 'sub VIX_ERROR_CODE {
        local($err) = @_;
	    eval q((($err) & 0xffff));
    }' unless defined(&VIX_ERROR_CODE);
    eval 'sub VIX_SUCCEEDED {
        local($err) = @_;
	    eval q(( &VIX_OK == ($err)));
    }' unless defined(&VIX_SUCCEEDED);
    eval 'sub VIX_FAILED {
        local($err) = @_;
	    eval q(( &VIX_OK != ($err)));
    }' unless defined(&VIX_FAILED);
    sub VIX_OK {0} push(@EXPORT, 'VIX_OK');
    sub VIX_E_FAIL {1} push(@EXPORT, 'VIX_E_FAIL');
    sub VIX_E_OUT_OF_MEMORY {2} push(@EXPORT, 'VIX_E_OUT_OF_MEMORY');
    sub VIX_E_INVALID_ARG {3} push(@EXPORT, 'VIX_E_INVALID_ARG');
    sub VIX_E_FILE_NOT_FOUND {4} push(@EXPORT, 'VIX_E_FILE_NOT_FOUND');
    sub VIX_E_OBJECT_IS_BUSY {5} push(@EXPORT, 'VIX_E_OBJECT_IS_BUSY');
    sub VIX_E_NOT_SUPPORTED {6} push(@EXPORT, 'VIX_E_NOT_SUPPORTED');
    sub VIX_E_FILE_ERROR {7} push(@EXPORT, 'VIX_E_FILE_ERROR');
    sub VIX_E_DISK_FULL {8} push(@EXPORT, 'VIX_E_DISK_FULL');
    sub VIX_E_INCORRECT_FILE_TYPE {9} push(@EXPORT, 'VIX_E_INCORRECT_FILE_TYPE');
    sub VIX_E_CANCELLED {10} push(@EXPORT, 'VIX_E_CANCELLED');
    sub VIX_E_FILE_READ_ONLY {11} push(@EXPORT, 'VIX_E_FILE_READ_ONLY');
    sub VIX_E_FILE_ALREADY_EXISTS {12} push(@EXPORT, 'VIX_E_FILE_ALREADY_EXISTS');
    sub VIX_E_FILE_ACCESS_ERROR {13} push(@EXPORT, 'VIX_E_FILE_ACCESS_ERROR');
    sub VIX_E_REQUIRES_LARGE_FILES {14} push(@EXPORT, 'VIX_E_REQUIRES_LARGE_FILES');
    sub VIX_E_FILE_ALREADY_LOCKED {15} push(@EXPORT, 'VIX_E_FILE_ALREADY_LOCKED');
    sub VIX_E_NOT_SUPPORTED_ON_REMOTE_OBJECT {20} push(@EXPORT, 'VIX_E_NOT_SUPPORTED_ON_REMOTE_OBJECT');
    sub VIX_E_FILE_TOO_BIG {21} push(@EXPORT, 'VIX_E_FILE_TOO_BIG');
    sub VIX_E_FILE_NAME_INVALID {22} push(@EXPORT, 'VIX_E_FILE_NAME_INVALID');
    sub VIX_E_ALREADY_EXISTS {23} push(@EXPORT, 'VIX_E_ALREADY_EXISTS');
    sub VIX_E_INVALID_HANDLE {1000} push(@EXPORT, 'VIX_E_INVALID_HANDLE');
    sub VIX_E_NOT_SUPPORTED_ON_HANDLE_TYPE {1001} push(@EXPORT, 'VIX_E_NOT_SUPPORTED_ON_HANDLE_TYPE');
    sub VIX_E_TOO_MANY_HANDLES {1002} push(@EXPORT, 'VIX_E_TOO_MANY_HANDLES');
    sub VIX_E_NOT_FOUND {2000} push(@EXPORT, 'VIX_E_NOT_FOUND');
    sub VIX_E_TYPE_MISMATCH {2001} push(@EXPORT, 'VIX_E_TYPE_MISMATCH');
    sub VIX_E_INVALID_XML {2002} push(@EXPORT, 'VIX_E_INVALID_XML');
    sub VIX_E_TIMEOUT_WAITING_FOR_TOOLS {3000} push(@EXPORT, 'VIX_E_TIMEOUT_WAITING_FOR_TOOLS');
    sub VIX_E_UNRECOGNIZED_COMMAND {3001} push(@EXPORT, 'VIX_E_UNRECOGNIZED_COMMAND');
    sub VIX_E_OP_NOT_SUPPORTED_ON_GUEST {3003} push(@EXPORT, 'VIX_E_OP_NOT_SUPPORTED_ON_GUEST');
    sub VIX_E_PROGRAM_NOT_STARTED {3004} push(@EXPORT, 'VIX_E_PROGRAM_NOT_STARTED');
    sub VIX_E_CANNOT_START_READ_ONLY_VM {3005} push(@EXPORT, 'VIX_E_CANNOT_START_READ_ONLY_VM');
    sub VIX_E_VM_NOT_RUNNING {3006} push(@EXPORT, 'VIX_E_VM_NOT_RUNNING');
    sub VIX_E_VM_IS_RUNNING {3007} push(@EXPORT, 'VIX_E_VM_IS_RUNNING');
    sub VIX_E_CANNOT_CONNECT_TO_VM {3008} push(@EXPORT, 'VIX_E_CANNOT_CONNECT_TO_VM');
    sub VIX_E_POWEROP_SCRIPTS_NOT_AVAILABLE {3009} push(@EXPORT, 'VIX_E_POWEROP_SCRIPTS_NOT_AVAILABLE');
    sub VIX_E_NO_GUEST_OS_INSTALLED {3010} push(@EXPORT, 'VIX_E_NO_GUEST_OS_INSTALLED');
    sub VIX_E_VM_INSUFFICIENT_HOST_MEMORY {3011} push(@EXPORT, 'VIX_E_VM_INSUFFICIENT_HOST_MEMORY');
    sub VIX_E_SUSPEND_ERROR {3012} push(@EXPORT, 'VIX_E_SUSPEND_ERROR');
    sub VIX_E_VM_NOT_ENOUGH_CPUS {3013} push(@EXPORT, 'VIX_E_VM_NOT_ENOUGH_CPUS');
    sub VIX_E_HOST_USER_PERMISSIONS {3014} push(@EXPORT, 'VIX_E_HOST_USER_PERMISSIONS');
    sub VIX_E_GUEST_USER_PERMISSIONS {3015} push(@EXPORT, 'VIX_E_GUEST_USER_PERMISSIONS');
    sub VIX_E_TOOLS_NOT_RUNNING {3016} push(@EXPORT, 'VIX_E_TOOLS_NOT_RUNNING');
    sub VIX_E_GUEST_OPERATIONS_PROHIBITED {3017} push(@EXPORT, 'VIX_E_GUEST_OPERATIONS_PROHIBITED');
    sub VIX_E_ANON_GUEST_OPERATIONS_PROHIBITED {3018} push(@EXPORT, 'VIX_E_ANON_GUEST_OPERATIONS_PROHIBITED');
    sub VIX_E_ROOT_GUEST_OPERATIONS_PROHIBITED {3019} push(@EXPORT, 'VIX_E_ROOT_GUEST_OPERATIONS_PROHIBITED');
    sub VIX_E_MISSING_ANON_GUEST_ACCOUNT {3023} push(@EXPORT, 'VIX_E_MISSING_ANON_GUEST_ACCOUNT');
    sub VIX_E_CANNOT_AUTHENTICATE_WITH_GUEST {3024} push(@EXPORT, 'VIX_E_CANNOT_AUTHENTICATE_WITH_GUEST');
    sub VIX_E_UNRECOGNIZED_COMMAND_IN_GUEST {3025} push(@EXPORT, 'VIX_E_UNRECOGNIZED_COMMAND_IN_GUEST');
    sub VIX_E_CONSOLE_GUEST_OPERATIONS_PROHIBITED {3026} push(@EXPORT, 'VIX_E_CONSOLE_GUEST_OPERATIONS_PROHIBITED');
    sub VIX_E_MUST_BE_CONSOLE_USER {3027} push(@EXPORT, 'VIX_E_MUST_BE_CONSOLE_USER');
    sub VIX_E_VM_NOT_FOUND {4000} push(@EXPORT, 'VIX_E_VM_NOT_FOUND');
    sub VIX_E_NOT_SUPPORTED_FOR_VM_VERSION {4001} push(@EXPORT, 'VIX_E_NOT_SUPPORTED_FOR_VM_VERSION');
    sub VIX_E_CANNOT_READ_VM_CONFIG {4002} push(@EXPORT, 'VIX_E_CANNOT_READ_VM_CONFIG');
    sub VIX_E_TEMPLATE_VM {4003} push(@EXPORT, 'VIX_E_TEMPLATE_VM');
    sub VIX_E_VM_ALREADY_LOADED {4004} push(@EXPORT, 'VIX_E_VM_ALREADY_LOADED');
    sub VIX_E_VM_ALREADY_UP_TO_DATE {4006} push(@EXPORT, 'VIX_E_VM_ALREADY_UP_TO_DATE');
    sub VIX_E_UNRECOGNIZED_PROPERTY {6000} push(@EXPORT, 'VIX_E_UNRECOGNIZED_PROPERTY');
    sub VIX_E_INVALID_PROPERTY_VALUE {6001} push(@EXPORT, 'VIX_E_INVALID_PROPERTY_VALUE');
    sub VIX_E_READ_ONLY_PROPERTY {6002} push(@EXPORT, 'VIX_E_READ_ONLY_PROPERTY');
    sub VIX_E_MISSING_REQUIRED_PROPERTY {6003} push(@EXPORT, 'VIX_E_MISSING_REQUIRED_PROPERTY');
    sub VIX_E_BAD_VM_INDEX {8000} push(@EXPORT, 'VIX_E_BAD_VM_INDEX');
    sub VIX_E_SNAPSHOT_INVAL {13000} push(@EXPORT, 'VIX_E_SNAPSHOT_INVAL');
    sub VIX_E_SNAPSHOT_DUMPER {13001} push(@EXPORT, 'VIX_E_SNAPSHOT_DUMPER');
    sub VIX_E_SNAPSHOT_DISKLIB {13002} push(@EXPORT, 'VIX_E_SNAPSHOT_DISKLIB');
    sub VIX_E_SNAPSHOT_NOTFOUND {13003} push(@EXPORT, 'VIX_E_SNAPSHOT_NOTFOUND');
    sub VIX_E_SNAPSHOT_EXISTS {13004} push(@EXPORT, 'VIX_E_SNAPSHOT_EXISTS');
    sub VIX_E_SNAPSHOT_VERSION {13005} push(@EXPORT, 'VIX_E_SNAPSHOT_VERSION');
    sub VIX_E_SNAPSHOT_NOPERM {13006} push(@EXPORT, 'VIX_E_SNAPSHOT_NOPERM');
    sub VIX_E_SNAPSHOT_CONFIG {13007} push(@EXPORT, 'VIX_E_SNAPSHOT_CONFIG');
    sub VIX_E_SNAPSHOT_NOCHANGE {13008} push(@EXPORT, 'VIX_E_SNAPSHOT_NOCHANGE');
    sub VIX_E_SNAPSHOT_CHECKPOINT {13009} push(@EXPORT, 'VIX_E_SNAPSHOT_CHECKPOINT');
    sub VIX_E_SNAPSHOT_LOCKED {13010} push(@EXPORT, 'VIX_E_SNAPSHOT_LOCKED');
    sub VIX_E_SNAPSHOT_INCONSISTENT {13011} push(@EXPORT, 'VIX_E_SNAPSHOT_INCONSISTENT');
    sub VIX_E_SNAPSHOT_NAMETOOLONG {13012} push(@EXPORT, 'VIX_E_SNAPSHOT_NAMETOOLONG');
    sub VIX_E_SNAPSHOT_VIXFILE {13013} push(@EXPORT, 'VIX_E_SNAPSHOT_VIXFILE');
    sub VIX_E_SNAPSHOT_DISKLOCKED {13014} push(@EXPORT, 'VIX_E_SNAPSHOT_DISKLOCKED');
    sub VIX_E_SNAPSHOT_DUPLICATEDDISK {13015} push(@EXPORT, 'VIX_E_SNAPSHOT_DUPLICATEDDISK');
    sub VIX_E_SNAPSHOT_INDEPENDENTDISK {13016} push(@EXPORT, 'VIX_E_SNAPSHOT_INDEPENDENTDISK');
    sub VIX_E_SNAPSHOT_NONUNIQUE_NAME {13017} push(@EXPORT, 'VIX_E_SNAPSHOT_NONUNIQUE_NAME');
    sub VIX_E_NOT_A_FILE {20001} push(@EXPORT, 'VIX_E_NOT_A_FILE');
    sub VIX_E_NOT_A_DIRECTORY {20002} push(@EXPORT, 'VIX_E_NOT_A_DIRECTORY');
    sub VIX_E_NO_SUCH_PROCESS {20003} push(@EXPORT, 'VIX_E_NO_SUCH_PROCESS');
    sub VIX_E_FILE_NAME_TOO_LONG {20004} push(@EXPORT, 'VIX_E_FILE_NAME_TOO_LONG');
    sub VIX_PROPERTYTYPE_ANY {0} push(@EXPORT, 'VIX_PROPERTYTYPE_ANY');
    sub VIX_PROPERTYTYPE_INTEGER {1} push(@EXPORT, 'VIX_PROPERTYTYPE_INTEGER');
    sub VIX_PROPERTYTYPE_STRING {2} push(@EXPORT, 'VIX_PROPERTYTYPE_STRING');
    sub VIX_PROPERTYTYPE_BOOL {3} push(@EXPORT, 'VIX_PROPERTYTYPE_BOOL');
    sub VIX_PROPERTYTYPE_HANDLE {4} push(@EXPORT, 'VIX_PROPERTYTYPE_HANDLE');
    sub VIX_PROPERTYTYPE_INT64 {5} push(@EXPORT, 'VIX_PROPERTYTYPE_INT64');
    sub VIX_PROPERTYTYPE_BLOB {6} push(@EXPORT, 'VIX_PROPERTYTYPE_BLOB');
    sub VIX_PROPERTY_NONE {0} push(@EXPORT, 'VIX_PROPERTY_NONE');
    sub VIX_PROPERTY_META_DATA_CONTAINER {2} push(@EXPORT, 'VIX_PROPERTY_META_DATA_CONTAINER');
    sub VIX_PROPERTY_HOST_HOSTTYPE {50} push(@EXPORT, 'VIX_PROPERTY_HOST_HOSTTYPE');
    sub VIX_PROPERTY_HOST_API_VERSION {51} push(@EXPORT, 'VIX_PROPERTY_HOST_API_VERSION');
    sub VIX_PROPERTY_VM_NUM_VCPUS {101} push(@EXPORT, 'VIX_PROPERTY_VM_NUM_VCPUS');
    sub VIX_PROPERTY_VM_VMX_PATHNAME {103} push(@EXPORT, 'VIX_PROPERTY_VM_VMX_PATHNAME');
    sub VIX_PROPERTY_VM_VMTEAM_PATHNAME {105} push(@EXPORT, 'VIX_PROPERTY_VM_VMTEAM_PATHNAME');
    sub VIX_PROPERTY_VM_MEMORY_SIZE {106} push(@EXPORT, 'VIX_PROPERTY_VM_MEMORY_SIZE');
    sub VIX_PROPERTY_VM_READ_ONLY {107} push(@EXPORT, 'VIX_PROPERTY_VM_READ_ONLY');
    sub VIX_PROPERTY_VM_IN_VMTEAM {128} push(@EXPORT, 'VIX_PROPERTY_VM_IN_VMTEAM');
    sub VIX_PROPERTY_VM_POWER_STATE {129} push(@EXPORT, 'VIX_PROPERTY_VM_POWER_STATE');
    sub VIX_PROPERTY_VM_TOOLS_STATE {152} push(@EXPORT, 'VIX_PROPERTY_VM_TOOLS_STATE');
    sub VIX_PROPERTY_VM_IS_RUNNING {196} push(@EXPORT, 'VIX_PROPERTY_VM_IS_RUNNING');
    sub VIX_PROPERTY_VM_SUPPORTED_FEATURES {197} push(@EXPORT, 'VIX_PROPERTY_VM_SUPPORTED_FEATURES');
    sub VIX_PROPERTY_JOB_RESULT_ERROR_CODE {3000} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_ERROR_CODE');
    sub VIX_PROPERTY_JOB_RESULT_VM_IN_GROUP {3001} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_VM_IN_GROUP');
    sub VIX_PROPERTY_JOB_RESULT_USER_MESSAGE {3002} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_USER_MESSAGE');
    sub VIX_PROPERTY_JOB_RESULT_EXIT_CODE {3004} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_EXIT_CODE');
    sub VIX_PROPERTY_JOB_RESULT_COMMAND_OUTPUT {3005} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_COMMAND_OUTPUT');
    sub VIX_PROPERTY_JOB_RESULT_HANDLE {3010} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_HANDLE');
    sub VIX_PROPERTY_JOB_RESULT_GUEST_OBJECT_EXISTS {3011} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_GUEST_OBJECT_EXISTS');
    sub VIX_PROPERTY_JOB_RESULT_GUEST_PROGRAM_ELAPSED_TIME {3017} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_GUEST_PROGRAM_ELAPSED_TIME');
    sub VIX_PROPERTY_JOB_RESULT_GUEST_PROGRAM_EXIT_CODE {3018} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_GUEST_PROGRAM_EXIT_CODE');
    sub VIX_PROPERTY_JOB_RESULT_ITEM_NAME {3035} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_ITEM_NAME');
    sub VIX_PROPERTY_JOB_RESULT_FOUND_ITEM_DESCRIPTION {3036} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_FOUND_ITEM_DESCRIPTION');
    sub VIX_PROPERTY_JOB_RESULT_SHARED_FOLDER_COUNT {3046} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_SHARED_FOLDER_COUNT');
    sub VIX_PROPERTY_JOB_RESULT_SHARED_FOLDER_HOST {3048} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_SHARED_FOLDER_HOST');
    sub VIX_PROPERTY_JOB_RESULT_SHARED_FOLDER_FLAGS {3049} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_SHARED_FOLDER_FLAGS');
    sub VIX_PROPERTY_JOB_RESULT_PROCESS_ID {3051} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_PROCESS_ID');
    sub VIX_PROPERTY_JOB_RESULT_PROCESS_OWNER {3052} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_PROCESS_OWNER');
    sub VIX_PROPERTY_JOB_RESULT_PROCESS_COMMAND {3053} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_PROCESS_COMMAND');
    sub VIX_PROPERTY_JOB_RESULT_FILE_FLAGS {3054} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_FILE_FLAGS');
    sub VIX_PROPERTY_JOB_RESULT_PROCESS_START_TIME {3055} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_PROCESS_START_TIME');
    sub VIX_PROPERTY_JOB_RESULT_VM_VARIABLE_STRING {3056} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_VM_VARIABLE_STRING');
    sub VIX_PROPERTY_JOB_RESULT_PROCESS_BEING_DEBUGGED {3057} push(@EXPORT, 'VIX_PROPERTY_JOB_RESULT_PROCESS_BEING_DEBUGGED');
    sub VIX_PROPERTY_FOUND_ITEM_LOCATION {4010} push(@EXPORT, 'VIX_PROPERTY_FOUND_ITEM_LOCATION');
    sub VIX_PROPERTY_SNAPSHOT_DISPLAYNAME {4200} push(@EXPORT, 'VIX_PROPERTY_SNAPSHOT_DISPLAYNAME');
    sub VIX_PROPERTY_SNAPSHOT_DESCRIPTION {4201} push(@EXPORT, 'VIX_PROPERTY_SNAPSHOT_DESCRIPTION');
    sub VIX_PROPERTY_SNAPSHOT_POWERSTATE {4205} push(@EXPORT, 'VIX_PROPERTY_SNAPSHOT_POWERSTATE');
    sub VIX_EVENTTYPE_JOB_COMPLETED {2} push(@EXPORT, 'VIX_EVENTTYPE_JOB_COMPLETED');
    sub VIX_EVENTTYPE_JOB_PROGRESS {3} push(@EXPORT, 'VIX_EVENTTYPE_JOB_PROGRESS');
    sub VIX_EVENTTYPE_FIND_ITEM {8} push(@EXPORT, 'VIX_EVENTTYPE_FIND_ITEM');
    sub VIX_EVENTTYPE_CALLBACK_SIGNALLED {2} push(@EXPORT, 'VIX_EVENTTYPE_CALLBACK_SIGNALLED');
    sub VIX_FILE_ATTRIBUTES_DIRECTORY {0x0001} push(@EXPORT, 'VIX_FILE_ATTRIBUTES_DIRECTORY');
    sub VIX_FILE_ATTRIBUTES_SYMLINK {0x0002} push(@EXPORT, 'VIX_FILE_ATTRIBUTES_SYMLINK');
    sub VIX_HOSTOPTION_USE_EVENT_PUMP {0x0008} push(@EXPORT, 'VIX_HOSTOPTION_USE_EVENT_PUMP');
    sub VIX_SERVICEPROVIDER_DEFAULT {1} push(@EXPORT, 'VIX_SERVICEPROVIDER_DEFAULT');
    sub VIX_SERVICEPROVIDER_VMWARE_SERVER {2} push(@EXPORT, 'VIX_SERVICEPROVIDER_VMWARE_SERVER');
    sub VIX_SERVICEPROVIDER_VMWARE_WORKSTATION {3} push(@EXPORT, 'VIX_SERVICEPROVIDER_VMWARE_WORKSTATION');
    sub VIX_FIND_RUNNING_VMS {1} push(@EXPORT, 'VIX_FIND_RUNNING_VMS');
    sub VIX_FIND_REGISTERED_VMS {4} push(@EXPORT, 'VIX_FIND_REGISTERED_VMS');
    sub VIX_PUMPEVENTOPTION_NONE {0} push(@EXPORT, 'VIX_PUMPEVENTOPTION_NONE');
    sub VIX_VMPOWEROP_NORMAL {0} push(@EXPORT, 'VIX_VMPOWEROP_NORMAL');
    sub VIX_VMPOWEROP_SUPPRESS_SNAPSHOT_POWERON {0x0080} push(@EXPORT, 'VIX_VMPOWEROP_SUPPRESS_SNAPSHOT_POWERON');
    sub VIX_VMPOWEROP_LAUNCH_GUI {0x0200} push(@EXPORT, 'VIX_VMPOWEROP_LAUNCH_GUI');
    sub VIX_VMDELETE_DISK_FILES {0x0002} push(@EXPORT, 'VIX_VMDELETE_DISK_FILES');
    sub VIX_POWERSTATE_POWERING_OFF {0x0001} push(@EXPORT, 'VIX_POWERSTATE_POWERING_OFF');
    sub VIX_POWERSTATE_POWERED_OFF {0x0002} push(@EXPORT, 'VIX_POWERSTATE_POWERED_OFF');
    sub VIX_POWERSTATE_POWERING_ON {0x0004} push(@EXPORT, 'VIX_POWERSTATE_POWERING_ON');
    sub VIX_POWERSTATE_POWERED_ON {0x0008} push(@EXPORT, 'VIX_POWERSTATE_POWERED_ON');
    sub VIX_POWERSTATE_SUSPENDING {0x0010} push(@EXPORT, 'VIX_POWERSTATE_SUSPENDING');
    sub VIX_POWERSTATE_SUSPENDED {0x0020} push(@EXPORT, 'VIX_POWERSTATE_SUSPENDED');
    sub VIX_POWERSTATE_TOOLS_RUNNING {0x0040} push(@EXPORT, 'VIX_POWERSTATE_TOOLS_RUNNING');
    sub VIX_POWERSTATE_RESETTING {0x0080} push(@EXPORT, 'VIX_POWERSTATE_RESETTING');
    sub VIX_POWERSTATE_BLOCKED_ON_MSG {0x0100} push(@EXPORT, 'VIX_POWERSTATE_BLOCKED_ON_MSG');
    sub VIX_TOOLSSTATE_UNKNOWN {0x0001} push(@EXPORT, 'VIX_TOOLSSTATE_UNKNOWN');
    sub VIX_TOOLSSTATE_RUNNING {0x0002} push(@EXPORT, 'VIX_TOOLSSTATE_RUNNING');
    sub VIX_TOOLSSTATE_NOT_INSTALLED {0x0004} push(@EXPORT, 'VIX_TOOLSSTATE_NOT_INSTALLED');
    sub VIX_VM_SUPPORT_SHARED_FOLDERS {0x0001} push(@EXPORT, 'VIX_VM_SUPPORT_SHARED_FOLDERS');
    sub VIX_VM_SUPPORT_MULTIPLE_SNAPSHOTS {0x0002} push(@EXPORT, 'VIX_VM_SUPPORT_MULTIPLE_SNAPSHOTS');
    sub VIX_VM_SUPPORT_TOOLS_INSTALL {0x0004} push(@EXPORT, 'VIX_VM_SUPPORT_TOOLS_INSTALL');
    sub VIX_VM_SUPPORT_HARDWARE_UPGRADE {0x0008} push(@EXPORT, 'VIX_VM_SUPPORT_HARDWARE_UPGRADE');
    sub VIX_ANONYMOUS_USER_NAME {"__VMware_Vix_Guest_User_Anonymous__"} push(@EXPORT, 'VIX_ANONYMOUS_USER_NAME');
    sub VIX_ADMINISTRATOR_USER_NAME {"__VMware_Vix_Guest_User_Admin__"} push(@EXPORT, 'VIX_ADMINISTRATOR_USER_NAME');
    sub VIX_CONSOLE_USER_NAME {"__VMware_Vix_Guest_Console_User__"} push(@EXPORT, 'VIX_CONSOLE_USER_NAME');
    sub VIX_RUNPROGRAM_RETURN_IMMEDIATELY {0x0001} push(@EXPORT, 'VIX_RUNPROGRAM_RETURN_IMMEDIATELY');
    sub VIX_RUNPROGRAM_ACTIVATE_WINDOW {0x0002} push(@EXPORT, 'VIX_RUNPROGRAM_ACTIVATE_WINDOW');
    sub VIX_VM_GUEST_VARIABLE {1} push(@EXPORT, 'VIX_VM_GUEST_VARIABLE');
    sub VIX_VM_CONFIG_RUNTIME_ONLY {2} push(@EXPORT, 'VIX_VM_CONFIG_RUNTIME_ONLY');
    sub VIX_GUEST_ENVIRONMENT_VARIABLE {3} push(@EXPORT, 'VIX_GUEST_ENVIRONMENT_VARIABLE');
    sub VIX_SNAPSHOT_REMOVE_CHILDREN {0x0001} push(@EXPORT, 'VIX_SNAPSHOT_REMOVE_CHILDREN');
    sub VIX_SNAPSHOT_INCLUDE_MEMORY {0x0002} push(@EXPORT, 'VIX_SNAPSHOT_INCLUDE_MEMORY');
    sub VIX_SHAREDFOLDER_WRITE_ACCESS {0x04} push(@EXPORT, 'VIX_SHAREDFOLDER_WRITE_ACCESS');
    if(defined(&__cplusplus)) {
    }
}
1;
