# Filter to support Lagrangian analysis capabilities.  

Lagrangian analysis operates in two phases - phase one involes the extraction of flow field information. Phase two involves calculating new particle trajectories using the saved information. 

The lagrangian filter can be used to extract flow field information given a time-varying vector fields. The extracted information is in the form of particle trajectories.

The filter operates by first being set up with some information regarding step size, the interval at which information should be saved (write frequency), the number of seeds to be placed in the domain (specified as a reduction factor along each axis of the original dimensions).
The step size should be equivalent to the time between vector field data input. 
The write frequency corresponds to the number of cycles between saves. 

Filter execution is called for each cycle of the simulation data. Each filter execution call requires a velocity field to advect particles forward. 

The extracted particle trajectories - referred to as basis flows exist in the domain for the specified interval (write frequency). Particles are then reset along a uniform grid and new particle trajectories are calculated. 

An example of using the Lagrangian filter is at vtk-m/examples/lagrangian
The basis flows are saved into a folder named output which needs to be created in the directory in which the program is being executed.

The basis flows can be interpolated using barycentric coordinate interpolation or a form of linear interpolation to calculate new particle trajectories post hoc. 

An example of using basis flows generated by the Lagrangian filter is at vtk-m/examples/posthocinterpolation. The folder contains a script which specifies parameters which need to be provided to use the example.
