/* $Id: VBoxDispDbg.h $ */

/** @file
 * VBoxVideo Display D3D User mode dll
 */

/*
 * Copyright (C) 2011 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef ___VBoxDispDbg_h__
#define ___VBoxDispDbg_h__

#define VBOX_VIDEO_LOG_NAME "VBoxD3D"
#define VBOX_VIDEO_LOG_LOGGER vboxVDbgInternalLogLogger
#define VBOX_VIDEO_LOGREL_LOGGER vboxVDbgInternalLogRelLogger
#define VBOX_VIDEO_LOGFLOW_LOGGER vboxVDbgInternalLogFlowLogger
#define VBOX_VIDEO_LOG_FN_FMT "%s"

#include "../../common/VBoxVideoLog.h"

#ifdef DEBUG
/* debugging configuration flags */

/* generic debugging facilities & extra data checks */
# define VBOXWDDMDISP_DEBUG
# if defined(DEBUG_misha) || defined(DEBUG_leo)
/* for some reason when debugging with VirtualKD, user-mode DbgPrint's are discarded
 * the workaround so far is to pass the log info to the kernel driver and DbgPrint'ed from there,
 * which is enabled by this define */
//#  define VBOXWDDMDISP_DEBUG_PRINTDRV
/* use OutputDebugString */
#  define VBOXWDDMDISP_DEBUG_PRINT
/* adds vectored exception handler to be able to catch non-debug UM exceptions in kernel debugger */
//#  define VBOXWDDMDISP_DEBUG_VEHANDLER
/* disable shared resource creation with wine */
//#  define VBOXWDDMDISP_DEBUG_NOSHARED
# endif

/* debug config vars */
extern DWORD g_VBoxVDbgFDumpSetTexture;
extern DWORD g_VBoxVDbgFDumpDrawPrim;
extern DWORD g_VBoxVDbgFDumpTexBlt;
extern DWORD g_VBoxVDbgFDumpBlt;
extern DWORD g_VBoxVDbgFDumpRtSynch;
extern DWORD g_VBoxVDbgFDumpFlush;
extern DWORD g_VBoxVDbgFDumpShared;
extern DWORD g_VBoxVDbgFDumpLock;
extern DWORD g_VBoxVDbgFDumpUnlock;
extern DWORD g_VBoxVDbgFDumpPresentEnter;
extern DWORD g_VBoxVDbgFDumpPresentLeave;
extern DWORD g_VBoxVDbgFDumpScSync;

extern DWORD g_VBoxVDbgFBreakShared;
extern DWORD g_VBoxVDbgFBreakDdi;

extern DWORD g_VBoxVDbgFCheckSysMemSync;
extern DWORD g_VBoxVDbgFCheckBlt;
extern DWORD g_VBoxVDbgFCheckTexBlt;
extern DWORD g_VBoxVDbgFCheckScSync;

extern DWORD g_VBoxVDbgFSkipCheckTexBltDwmWndUpdate;

/* log enable flags */
extern DWORD g_VBoxVDbgFLogRel;
extern DWORD g_VBoxVDbgFLog;
extern DWORD g_VBoxVDbgFLogFlow;

extern DWORD g_VBoxVDbgFIsModuleNameInited;
extern char g_VBoxVDbgModuleName[];

extern LONG g_VBoxVDbgFIsDwm;

extern DWORD g_VBoxVDbgCfgMaxDirectRts;
extern DWORD g_VBoxVDbgCfgForceDummyDevCreate;

extern struct VBOXWDDMDISP_DEVICE *g_VBoxVDbgInternalDevice;
extern struct VBOXWDDMDISP_RESOURCE *g_VBoxVDbgInternalRc;

extern DWORD g_VBoxVDbgCfgCreateSwapchainOnDdiOnce;

#endif

#if 0
# ifdef Assert
#  undef Assert
#  define Assert(_a) do{}while(0)
# endif
# ifdef AssertBreakpoint
#  undef AssertBreakpoint
#  define AssertBreakpoint() do{}while(0)
# endif
# ifdef AssertFailed
#  undef AssertFailed
#  define AssertFailed() do{}while(0)
# endif
#endif

#ifdef VBOXWDDMDISP_DEBUG_VEHANDLER
void vboxVDbgVEHandlerRegister();
void vboxVDbgVEHandlerUnregister();
#endif

#if defined(LOG_TO_BACKDOOR_DRV) || defined(VBOXWDDMDISP_DEBUG_PRINTDRV)
# define DbgPrintDrv(_m) do { vboxDispLogDrvF _m; } while (0)
# define DbgPrintDrvRel(_m) do { vboxDispLogDrvF _m; } while (0)
# define DbgPrintDrvFlow(_m) do { vboxDispLogDrvF _m; } while (0)
#else
# define DbgPrintDrv(_m) do { } while (0)
# define DbgPrintDrvRel(_m) do { } while (0)
# define DbgPrintDrvFlow(_m) do { } while (0)
#endif

#ifdef VBOXWDDMDISP_DEBUG_PRINT
# define DbgPrintUsr(_m) do { vboxDispLogDbgPrintF _m; } while (0)
# define DbgPrintUsrRel(_m) do { vboxDispLogDbgPrintF _m; } while (0)
# define DbgPrintUsrFlow(_m) do { vboxDispLogDbgPrintF _m; } while (0)
#else
# define DbgPrintUsr(_m) do { } while (0)
# define DbgPrintUsrRel(_m) do { } while (0)
# define DbgPrintUsrFlow(_m) do { } while (0)
#endif

#ifdef VBOXWDDMDISP_DEBUG
#define vboxVDbgInternalLog(_p) if (g_VBoxVDbgFLog) { _p }
#define vboxVDbgInternalLogFlow(_p) if (g_VBoxVDbgFLogFlow) { _p }
#define vboxVDbgInternalLogRel(_p) if (g_VBoxVDbgFLogRel) { _p }
#else
#define vboxVDbgInternalLog(_p) do {} while (0)
#define vboxVDbgInternalLogFlow(_p) do {} while (0)
#define vboxVDbgInternalLogRel(_p) do { _p } while (0)
#endif

/* @todo: remove these from the code and from here */
#define vboxVDbgPrint(_m) LOG_EXACT(_m)
#define vboxVDbgPrintF(_m) LOGF_EXACT(_m)
#define vboxVDbgPrintR(_m)  LOGREL_EXACT(_m)

#define vboxVDbgInternalLogLogger(_m) do { \
        vboxVDbgInternalLog( \
            Log(_m); \
            DbgPrintUsr(_m); \
            DbgPrintDrv(_m); \
        ); \
    } while (0)

#define vboxVDbgInternalLogFlowLogger(_m)  do { \
        vboxVDbgInternalLogFlow( \
            LogFlow(_m); \
            DbgPrintUsrFlow(_m); \
            DbgPrintDrvFlow(_m); \
        ); \
    } while (0)

#define vboxVDbgInternalLogRelLogger(_m)  do { \
        vboxVDbgInternalLogRel( \
            LogRel(_m); \
            DbgPrintUsrRel(_m); \
            DbgPrintDrvRel(_m); \
        ); \
    } while (0)

#if defined(VBOXWDDMDISP_DEBUG) || defined(LOG_TO_BACKDOOR_DRV)

void vboxDispLogDrvF(char * szString, ...);
void vboxDispLogDrv(char * szString);
void vboxDispDumpD3DCAPS9Drv(D3DCAPS9 *pCaps);

# define vboxDispDumpD3DCAPS9(_pCaps) do { vboxDispDumpD3DCAPS9Drv(_pCaps); } while (0)
#else
# define vboxDispDumpD3DCAPS9(_pCaps) do { } while (0)
#endif

#ifdef VBOXWDDMDISP_DEBUG

void vboxDispLogDbgPrintF(char * szString, ...);

typedef struct VBOXWDDMDISP_ALLOCATION *PVBOXWDDMDISP_ALLOCATION;
typedef struct VBOXWDDMDISP_RESOURCE *PVBOXWDDMDISP_RESOURCE;

VOID vboxVDbgDoDumpSurfRectByAlloc(const char * pPrefix, PVBOXWDDMDISP_ALLOCATION pAlloc, const RECT *pRect, const char* pSuffix);
VOID vboxVDbgDoDumpAllocRect(const char * pPrefix, PVBOXWDDMDISP_ALLOCATION pAlloc, const RECT *pRect, const char* pSuffix);
VOID vboxVDbgDoDumpSurfRectByRc(const char * pPrefix, const PVBOXWDDMDISP_RESOURCE pRc, uint32_t iAlloc, const RECT *pRect, const char* pSuffix);
VOID vboxVDbgDoDumpSurfRect(const char * pPrefix, IDirect3DSurface9 *pSurf, const RECT *pRect, const char * pSuffix, bool bBreak);
VOID vboxVDbgDoDumpSurf(const char * pPrefix, IDirect3DSurface9 *pSurf, const char * pSuffix);
VOID vboxVDbgDoDumpRcRect(const char * pPrefix, IDirect3DResource9 *pRc, const RECT *pRect, const char * pSuffix);
VOID vboxVDbgDoDumpRcRectByRc(const char * pPrefix, const PVBOXWDDMDISP_RESOURCE pRc, const RECT *pRect, const char* pSuffix);
VOID vboxVDbgDoDumpRcRectByAlloc(const char * pPrefix, const PVBOXWDDMDISP_ALLOCATION pAlloc, IDirect3DResource9 *pD3DIf, const RECT *pRect, const char* pSuffix);
VOID vboxVDbgDoDumpTex(const char * pPrefix, IDirect3DBaseTexture9 *pTexBase, const char * pSuffix);
VOID vboxVDbgDoDumpRt(const char * pPrefix, struct VBOXWDDMDISP_DEVICE *pDevice, const char * pSuffix);
VOID vboxVDbgDoDumpBb(const char * pPrefix, IDirect3DSwapChain9 *pSwapchainIf, const char * pSuffix);
VOID vboxVDbgDoDumpFb(const char * pPrefix, IDirect3DSwapChain9 *pSwapchainIf, const char * pSuffix);

void vboxVDbgDoPrintRect(const char * pPrefix, const RECT *pRect, const char * pSuffix);
void vboxVDbgDoPrintAlloc(const char * pPrefix, const PVBOXWDDMDISP_RESOURCE pRc, uint32_t iAlloc, const char * pSuffix);

VOID vboxVDbgDoDumpLockSurfTex(const char * pPrefix, const D3DDDIARG_LOCK* pData, const char * pSuffix, bool fBreak);
VOID vboxVDbgDoDumpUnlockSurfTex(const char * pPrefix, const D3DDDIARG_UNLOCK* pData, const char * pSuffix, bool fBreak);

BOOL vboxVDbgDoCheckRectsMatch(const PVBOXWDDMDISP_RESOURCE pDstRc, uint32_t iDstAlloc,
                            const PVBOXWDDMDISP_RESOURCE pSrcRc, uint32_t iSrcAlloc,
                            const RECT *pDstRect,
                            const RECT *pSrcRect,
                            BOOL fBreakOnMismatch);

BOOL vboxVDbgDoCheckExe(const char * pszName);

VOID vboxVDbgDoPrintLopLastCmd(const char* pszDesc);

extern DWORD g_VBoxVDbgPid;
#define VBOXVDBG_IS_PID(_pid) ((_pid) == (g_VBoxVDbgPid ? g_VBoxVDbgPid : (g_VBoxVDbgPid = GetCurrentProcessId())))
#define VBOXVDBG_IS_DUMP_ALLOWED_PID(_pid) (((int)(_pid)) > 0 ? VBOXVDBG_IS_PID(_pid) : !VBOXVDBG_IS_PID(-((int)(_pid))))

#define VBOXVDBG_CHECK_EXE(_pszName) (vboxVDbgDoCheckExe(_pszName))
#define VBOXVDBG_IS_DWM() (!!(g_VBoxVDbgFIsDwm >=0 ? g_VBoxVDbgFIsDwm : (g_VBoxVDbgFIsDwm = VBOXVDBG_CHECK_EXE("dwm.exe"))))

#define VBOXVDBG_ASSERT_IS_DWM(_bDwm) do { \
        Assert((!VBOXVDBG_IS_DWM()) == (!(_bDwm))); \
    } while (0)

#define VBOXVDBG_IS_DUMP_ALLOWED(_type) ( \
        g_VBoxVDbgFDump##_type \
        && (g_VBoxVDbgFDump##_type == 1 \
                || VBOXVDBG_IS_DUMP_ALLOWED_PID(g_VBoxVDbgFDump##_type) \
           ) \
        )

#define VBOXVDBG_IS_BREAK_ALLOWED(_type) ( \
        g_VBoxVDbgFBreak##_type \
        && (g_VBoxVDbgFBreak##_type == 1 \
                || VBOXVDBG_IS_DUMP_ALLOWED_PID(g_VBoxVDbgFBreak##_type) \
           ) \
        )

#define VBOXVDBG_IS_CHECK_ALLOWED(_type) ( \
        g_VBoxVDbgFCheck##_type \
        && (g_VBoxVDbgFCheck##_type == 1 \
                || VBOXVDBG_IS_DUMP_ALLOWED_PID(g_VBoxVDbgFCheck##_type) \
           ) \
        )

#define VBOXVDBG_IS_DUMP_SHARED_ALLOWED(_pRc) (\
        (_pRc)->RcDesc.fFlags.SharedResource \
        && VBOXVDBG_IS_DUMP_ALLOWED(Shared) \
        )

#define VBOXVDBG_IS_BREAK_SHARED_ALLOWED(_pRc) (\
        (_pRc)->RcDesc.fFlags.SharedResource \
        && VBOXVDBG_IS_BREAK_ALLOWED(Shared) \
        )

#define VBOXVDBG_BREAK_SHARED(_pRc) do { \
        if (VBOXVDBG_IS_BREAK_SHARED_ALLOWED(_pRc)) { \
            vboxVDbgPrint(("Break on shared access: Rc(0x%p), SharedHandle(0x%p)\n", (_pRc), (_pRc)->aAllocations[0].hSharedHandle)); \
            AssertFailed(); \
        } \
    } while (0)

#define VBOXVDBG_BREAK_DDI() do { \
        if (VBOXVDBG_IS_BREAK_ALLOWED(Ddi)) { \
            AssertFailed(); \
        } \
    } while (0)

#define VBOXVDBG_LOOP_LAST() do { vboxVDbgLoop = 0; } while (0)

#define VBOXVDBG_LOOP(_op) do { \
        DWORD vboxVDbgLoop = 1; \
        do { \
            _op; \
        } while (vboxVDbgLoop); \
    } while (0)

#define VBOXVDBG_CHECK_SMSYNC(_pRc) do { \
        if (VBOXVDBG_IS_CHECK_ALLOWED(SysMemSync)) { \
            vboxWddmDbgRcSynchMemCheck((_pRc)); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_RECTS_INIT(_d) DWORD vboxVDbgDumpRects = _d;
#define VBOXVDBG_DUMP_RECTS_FORCE() vboxVDbgDumpRects = 1;
#define VBOXVDBG_DUMP_RECTS_FORCED() (!!vboxVDbgDumpRects)

#define VBOXVDBG_CHECK_RECTS(_opRests, _opDump, _pszOpName, _pDstRc, _iDstAlloc, _pSrcRc, _iSrcAlloc, _pDstRect, _pSrcRect) do { \
        VBOXVDBG_LOOP(\
                VBOXVDBG_DUMP_RECTS_INIT(0); \
                _opRests; \
                if (vboxVDbgDoCheckRectsMatch(_pDstRc, _iDstAlloc, _pSrcRc, _iSrcAlloc, _pDstRect, _pSrcRect, FALSE)) { \
                    VBOXVDBG_LOOP_LAST(); \
                } \
                else \
                { \
                    VBOXVDBG_DUMP_RECTS_FORCE(); \
                    vboxVDbgPrint(("vboxVDbgDoCheckRectsMatch failed! The " _pszOpName " will be re-done so it can be debugged\n")); \
                    vboxVDbgDoPrintLopLastCmd("Don't redo the" _pszOpName); \
                    Assert(0); \
                } \
                _opDump; \
         ); \
    } while (0)

#define VBOXVDBG_DEV_CHECK_SHARED(_pDevice, _pIsShared) do { \
        *(_pIsShared) = FALSE; \
        for (UINT i = 0; i < (_pDevice)->cRTs; ++i) { \
            PVBOXWDDMDISP_ALLOCATION pRtVar = (_pDevice)->apRTs[i]; \
            if (pRtVar->pRc->RcDesc.fFlags.SharedResource) { *(_pIsShared) = TRUE; break; } \
        } \
        if (!*(_pIsShared)) { \
            for (UINT i = 0, iSampler = 0; iSampler < (_pDevice)->cSamplerTextures; ++i) { \
                Assert(i < RT_ELEMENTS((_pDevice)->aSamplerTextures)); \
                if (!(_pDevice)->aSamplerTextures[i]) continue; \
                *(_pIsShared) = TRUE; break; \
                ++iSampler; \
            } \
        } \
    } while (0)

#define VBOXVDBG_IS_DUMP_SHARED_ALLOWED_DEV(_pDevice, _pIsAllowed) do { \
        VBOXVDBG_DEV_CHECK_SHARED(_pDevice, _pIsAllowed); \
        if (*(_pIsAllowed)) \
        { \
            *(_pIsAllowed) = VBOXVDBG_IS_DUMP_ALLOWED(Shared); \
        } \
    } while (0)

#define VBOXVDBG_IS_BREAK_SHARED_ALLOWED_DEV(_pDevice, _pIsAllowed) do { \
        VBOXVDBG_DEV_CHECK_SHARED(_pDevice, _pIsAllowed); \
        if (*(_pIsAllowed)) \
        { \
            *(_pIsAllowed) = VBOXVDBG_IS_BREAK_ALLOWED(Shared); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_DRAWPRIM_ENTER(_pDevice) do { \
        BOOL fDumpShaded = FALSE; \
        VBOXVDBG_IS_DUMP_SHARED_ALLOWED_DEV(_pDevice, &fDumpShaded); \
        if (fDumpShaded \
                || VBOXVDBG_IS_DUMP_ALLOWED(DrawPrim)) \
        { \
            vboxVDbgDoDumpRt("==>"__FUNCTION__": RenderTarget Dump\n", (_pDevice), "\n"); \
        }\
    } while (0)

#define VBOXVDBG_DUMP_DRAWPRIM_LEAVE(_pDevice) do { \
        BOOL fDumpShaded = FALSE; \
        VBOXVDBG_IS_DUMP_SHARED_ALLOWED_DEV(_pDevice, &fDumpShaded); \
        if (fDumpShaded \
                || VBOXVDBG_IS_DUMP_ALLOWED(DrawPrim)) \
        { \
            vboxVDbgDoDumpRt("<=="__FUNCTION__": RenderTarget Dump\n", (_pDevice), "\n"); \
        }\
    } while (0)

#define VBOXVDBG_BREAK_SHARED_DEV(_pDevice)  do { \
        BOOL fBreakShaded = FALSE; \
        VBOXVDBG_IS_BREAK_SHARED_ALLOWED_DEV(_pDevice, &fBreakShaded); \
        if (fBreakShaded) { \
            vboxVDbgPrint((__FUNCTION__"== Break on shared access\n")); \
            AssertFailed(); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_SETTEXTURE(_pRc) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(SetTexture) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED(_pRc) \
                ) \
        { \
            vboxVDbgDoDumpRcRectByRc("== "__FUNCTION__": ", _pRc, NULL, "\n"); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_TEXBLT_ENTER(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(TexBlt) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED(_pSrcRc) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED(_pDstRc) \
                ) \
        { \
            RECT _DstRect; \
            vboxWddmRectMoved(&_DstRect, (_pSrcRect), (_pDstPoint)->x, (_pDstPoint)->y); \
            vboxVDbgDoDumpRcRectByRc("==>"__FUNCTION__" Src: ", (_pSrcRc), (_pSrcRect), "\n"); \
            vboxVDbgDoDumpRcRectByRc("==>"__FUNCTION__" Dst: ", (_pDstRc), &_DstRect, "\n"); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_TEXBLT_LEAVE(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) do { \
        if (VBOXVDBG_DUMP_RECTS_FORCED() \
                || VBOXVDBG_IS_DUMP_ALLOWED(TexBlt) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED(_pSrcRc) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED(_pDstRc) \
                ) \
        { \
            RECT _DstRect; \
            vboxWddmRectMoved(&_DstRect, (_pSrcRect), (_pDstPoint)->x, (_pDstPoint)->y); \
            vboxVDbgDoDumpRcRectByRc("<=="__FUNCTION__" Src: ", (_pSrcRc), (_pSrcRect), "\n"); \
            vboxVDbgDoDumpRcRectByRc("<=="__FUNCTION__" Dst: ", (_pDstRc), &_DstRect, "\n"); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_STRETCH_RECT(_type, _str, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(_type) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED((_pSrcAlloc)->pRc) \
                || VBOXVDBG_IS_DUMP_SHARED_ALLOWED((_pDstAlloc)->pRc) \
                ) \
        { \
            if ((_pSrcSurf) == (_pDstSurf) \
                    && ( ((_pSrcRect) && (_pDstRect) && !memcmp((_pSrcRect), (_pDstRect), sizeof (_pDstRect))) \
                            || ((_pSrcRect) == (_pDstRect)) \
                            ) ) \
            { \
                vboxVDbgPrint((_str #_type ": skipping dump of the same rect for one surfcace\n")); \
            } \
            else \
            { \
                vboxVDbgDoDumpRcRectByAlloc(_str __FUNCTION__" Src: ", (_pSrcAlloc), (_pSrcSurf), (_pSrcRect), "\n"); \
                vboxVDbgDoDumpRcRectByAlloc(_str __FUNCTION__" Dst: ", (_pDstAlloc), (_pDstSurf), (_pDstRect), "\n"); \
            } \
        } \
    } while (0)

#define VBOXVDBG_DUMP_BLT_ENTER(_pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) \
    VBOXVDBG_DUMP_STRETCH_RECT(Blt, "==>", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect)

#define VBOXVDBG_DUMP_BLT_LEAVE(_pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) \
        VBOXVDBG_DUMP_STRETCH_RECT(Blt, "<==", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect)

#define VBOXVDBG_DUMP_SWAPCHAIN_SYNC_ENTER(_pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) \
        VBOXVDBG_DUMP_STRETCH_RECT(ScSync, "==>", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect)

#define VBOXVDBG_DUMP_SWAPCHAIN_SYNC_LEAVE(_pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) \
        VBOXVDBG_DUMP_STRETCH_RECT(ScSync, "<==", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect)

#define VBOXVDBG_IS_SKIP_DWM_WND_UPDATE(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) ( \
            g_VBoxVDbgFSkipCheckTexBltDwmWndUpdate \
            && ( \
                VBOXVDBG_IS_DWM() \
                && (_pSrcRc)->RcDesc.enmPool == D3DDDIPOOL_SYSTEMMEM \
                && (_pSrcRc)->RcDesc.enmFormat == D3DDDIFMT_A8R8G8B8 \
                && (_pSrcRc)->cAllocations == 1 \
                && (_pDstRc)->RcDesc.enmPool == D3DDDIPOOL_VIDEOMEMORY \
                && (_pDstRc)->RcDesc.enmFormat == D3DDDIFMT_A8R8G8B8 \
                && (_pDstRc)->RcDesc.fFlags.RenderTarget \
                && (_pDstRc)->RcDesc.fFlags.NotLockable \
                && (_pDstRc)->cAllocations == 1 \
                && (_pSrcRc)->aAllocations[0].SurfDesc.width == (_pDstRc)->aAllocations[0].SurfDesc.width \
                && (_pSrcRc)->aAllocations[0].SurfDesc.height == (_pDstRc)->aAllocations[0].SurfDesc.height \
            ) \
        )

#define VBOXVDBG_CHECK_TEXBLT(_opTexBlt, _pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) do { \
        if (VBOXVDBG_IS_CHECK_ALLOWED(TexBlt)) { \
            if (VBOXVDBG_IS_SKIP_DWM_WND_UPDATE(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint)) \
            { \
                vboxVDbgPrint(("TEXBLT: skipping check for dwm wnd update\n")); \
            } \
            else \
            { \
                RECT DstRect; \
                DstRect.left = (_pDstPoint)->x; \
                DstRect.right = (_pDstPoint)->x + (_pSrcRect)->right - (_pSrcRect)->left; \
                DstRect.top = (_pDstPoint)->y; \
                DstRect.bottom = (_pDstPoint)->y + (_pSrcRect)->bottom - (_pSrcRect)->top; \
                VBOXVDBG_CHECK_RECTS(\
                        VBOXVDBG_DUMP_TEXBLT_ENTER(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint); \
                        _opTexBlt ,\
                        VBOXVDBG_DUMP_TEXBLT_LEAVE(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint), \
                        "TexBlt", \
                        _pDstRc, 0, _pSrcRc, 0, &DstRect, _pSrcRect); \
                break; \
            } \
        } \
        VBOXVDBG_DUMP_RECTS_INIT(0); \
        VBOXVDBG_DUMP_TEXBLT_ENTER(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint); \
        _opTexBlt;\
        VBOXVDBG_DUMP_TEXBLT_LEAVE(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint); \
    } while (0)

#define VBOXVDBG_CHECK_STRETCH_RECT(_type, _op, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) do { \
        if (VBOXVDBG_IS_CHECK_ALLOWED(_type)) { \
            VBOXVDBG_CHECK_RECTS(\
                    VBOXVDBG_DUMP_STRETCH_RECT(_type, "==>", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect); \
                    _op ,\
                    VBOXVDBG_DUMP_STRETCH_RECT(_type, "<==", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect), \
                    #_type , \
                    _pDstAlloc->pRc, _pDstAlloc->iAlloc, _pSrcAlloc->pRc, _pSrcAlloc->iAlloc, _pDstRect, _pSrcRect); \
        } \
        else \
        { \
            VBOXVDBG_DUMP_RECTS_INIT(0); \
            VBOXVDBG_DUMP_STRETCH_RECT(_type, "==>", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect); \
            _op;\
            VBOXVDBG_DUMP_STRETCH_RECT(_type, "<==", _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect); \
        } \
    } while (0)

#define VBOXVDBG_CHECK_BLT(_opBlt, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) \
        VBOXVDBG_CHECK_STRETCH_RECT(Blt, _opBlt, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect)

#define VBOXVDBG_CHECK_SWAPCHAIN_SYNC(_op, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) \
        VBOXVDBG_CHECK_STRETCH_RECT(ScSync, _op, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect)

#define VBOXVDBG_DUMP_SYNC_RT(_pBbSurf) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(RtSynch)) \
        { \
            vboxVDbgDoDumpSurfRect("== "__FUNCTION__" Bb:\n", (_pBbSurf), NULL, "\n", true); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_PRESENT_ENTER(_pDevice, _pSwapchain) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(PresentEnter)) { \
            if (!(_pSwapchain)->fFlags.bRtReportingPresent) { \
                vboxVDbgDoDumpBb("==>"__FUNCTION__" Bb:\n", (_pSwapchain)->pSwapChainIf, "\n"); \
            } \
            else  { \
                PVBOXWDDMDISP_ALLOCATION pCurBb = vboxWddmSwapchainGetBb((_pSwapchain))->pAlloc; \
                IDirect3DSurface9 *pSurf; \
                HRESULT hr = vboxWddmSwapchainSurfGet(_pDevice, _pSwapchain, pCurBb, &pSurf); \
                Assert(hr == S_OK); \
                vboxVDbgDoDumpSurf("== "__FUNCTION__" Bb:\n", pSurf, "\n"); \
                pSurf->Release(); \
            } \
        } \
    } while (0)

#define VBOXVDBG_DUMP_PRESENT_LEAVE(_pDevice, _pSwapchain) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(PresentLeave)) { \
            if (!(_pSwapchain)->fFlags.bRtReportingPresent) { \
                vboxVDbgDoDumpFb("<=="__FUNCTION__" Fb:\n", (_pSwapchain)->pSwapChainIf, "\n"); \
            } \
            else  { \
                vboxVDbgPrint(("PRESENT_LEAVE: unsupported for Rt Reporting mode\n")); \
            } \
        } \
    } while (0)


#define VBOXVDBG_DUMP_FLUSH(_pDevice) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(Flush)) \
        { \
            vboxVDbgDoDumpRt("== "__FUNCTION__": RenderTarget Dump\n", (_pDevice), "\n"); \
        }\
    } while (0)

#define VBOXVDBG_DUMP_LOCK_ST(_pData) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(Lock) \
                || VBOXVDBG_IS_DUMP_ALLOWED(Unlock) \
                ) \
        { \
            vboxVDbgDoDumpLockSurfTex("== "__FUNCTION__": ", (_pData), "\n", VBOXVDBG_IS_DUMP_ALLOWED(Lock)); \
        } \
    } while (0)

#define VBOXVDBG_DUMP_UNLOCK_ST(_pData) do { \
        if (VBOXVDBG_IS_DUMP_ALLOWED(Unlock) \
                ) \
        { \
            vboxVDbgDoDumpUnlockSurfTex("== "__FUNCTION__": ", (_pData), "\n", true); \
        } \
    } while (0)


#define VBOXVDBG_CREATE_CHECK_SWAPCHAIN() do { \
            if (g_VBoxVDbgCfgCreateSwapchainOnDdiOnce && g_VBoxVDbgInternalRc) { \
                PVBOXWDDMDISP_SWAPCHAIN pSwapchain; \
                HRESULT hr = vboxWddmSwapchainCreateIfForRc(g_VBoxVDbgInternalDevice, g_VBoxVDbgInternalRc, &pSwapchain); \
                Assert(hr == S_OK); \
                g_VBoxVDbgInternalRc = NULL; \
                g_VBoxVDbgCfgCreateSwapchainOnDdiOnce = 0; \
            } \
        } while (0)

#else
#define VBOXVDBG_DUMP_DRAWPRIM_ENTER(_pDevice) do { } while (0)
#define VBOXVDBG_DUMP_DRAWPRIM_LEAVE(_pDevice) do { } while (0)
#define VBOXVDBG_DUMP_SETTEXTURE(_pRc) do { } while (0)
#define VBOXVDBG_DUMP_TEXBLT_ENTER(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) do { } while (0)
#define VBOXVDBG_DUMP_TEXBLT_LEAVE(_pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) do { } while (0)
#define VBOXVDBG_DUMP_BLT_ENTER(_pSrcRc, _pSrcSurf, _pSrcRect, _pDstRc, _pDstSurf, _pDstRect) do { } while (0)
#define VBOXVDBG_DUMP_BLT_LEAVE(_pSrcRc, _pSrcSurf, _pSrcRect, _pDstRc, _pDstSurf, _pDstRect) do { } while (0)
#define VBOXVDBG_DUMP_SYNC_RT(_pBbSurf) do { } while (0)
#define VBOXVDBG_DUMP_FLUSH(_pDevice) do { } while (0)
#define VBOXVDBG_DUMP_LOCK_ST(_pData) do { } while (0)
#define VBOXVDBG_DUMP_UNLOCK_ST(_pData) do { } while (0)
#define VBOXVDBG_DUMP_PRESENT_ENTER(_pDevice, _pSwapchain) do { } while (0)
#define VBOXVDBG_DUMP_PRESENT_LEAVE(_pDevice, _pSwapchain) do { } while (0)
#define VBOXVDBG_BREAK_SHARED(_pRc) do { } while (0)
#define VBOXVDBG_BREAK_SHARED_DEV(_pDevice) do { } while (0)
#define VBOXVDBG_BREAK_DDI() do { } while (0)
#define VBOXVDBG_CHECK_SMSYNC(_pRc) do { } while (0)
#define VBOXVDBG_CHECK_BLT(_opBlt, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) do { _opBlt; } while (0)
#define VBOXVDBG_CHECK_TEXBLT(_opTexBlt, _pSrcRc, _pSrcRect, _pDstRc, _pDstPoint) do { _opTexBlt; } while (0)
#define VBOXVDBG_ASSERT_IS_DWM(_bDwm) do { } while (0)
#define VBOXVDBG_CHECK_SWAPCHAIN_SYNC(_op, _pSrcAlloc, _pSrcSurf, _pSrcRect, _pDstAlloc, _pDstSurf, _pDstRect) do { _op; } while (0)
#define VBOXVDBG_CREATE_CHECK_SWAPCHAIN() do { } while (0)
#endif


#endif /* #ifndef ___VBoxDispDbg_h__ */
