/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.xerces.util;

import com.sun.xml.stream.xerces.xni.Augmentations;
import com.sun.xml.stream.xerces.xni.QName;
import com.sun.xml.stream.xerces.xni.XMLAttributes;
import java.util.ArrayList;
import java.util.HashMap;

public class STAXAttributesImpl
implements XMLAttributes {
    int attr_index = 0;
    int MAGIC_NUMBER = 2;
    protected boolean fNamespaces = true;
    protected ArrayList attrList = null;
    protected ArrayList dupList = null;
    private boolean init = false;
    protected HashMap attrMap = null;

    public STAXAttributesImpl() {
        this.attrList = new ArrayList(2);
        for (int i = 0; i < 2; ++i) {
            Attribute attr = new Attribute();
            attr.name = new QName();
            this.attrList.add(i, attr);
        }
    }

    public STAXAttributesImpl(int tableSize) {
        this.attrList = new ArrayList(tableSize);
        this.attrMap = new HashMap();
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
    }

    public int addAttribute(QName name, String type, String value) {
        Attribute attr = null;
        if (this.attr_index >= this.attrList.size()) {
            attr = new Attribute();
            attr.name = new QName();
            this.attrList.add(attr);
            attr.next = null;
        } else {
            attr = (Attribute)this.attrList.get(this.attr_index);
            attr.next = null;
        }
        attr.name.setValues(name);
        attr.type = type;
        attr.value = value;
        if (this.attr_index < 5) {
            Attribute tmp = null;
            for (int i = 0; i < this.attr_index; ++i) {
                tmp = (Attribute)this.attrList.get(i);
                if (tmp.name.rawname != name.rawname) continue;
                tmp.value = value;
                return i;
            }
        } else {
            Attribute tmp = null;
            if (!this.init) {
                if (this.attrMap == null) {
                    this.attrMap = new HashMap(2, 2.0f);
                }
                for (int i = 0; i < this.attr_index; ++i) {
                    tmp = (Attribute)this.attrList.get(i);
                    this.attrMap.put(tmp.name.rawname, tmp);
                }
                this.init = true;
            }
            if (this.attrMap.containsKey(name.rawname)) {
                return this.getLength();
            }
            this.attrMap.put(name.rawname, attr);
        }
        ++this.attr_index;
        return this.getLength() - 1;
    }

    public void removeAllAttributes() {
        this.attr_index = 0;
        if (this.attrMap != null) {
            this.attrMap.clear();
        }
        if (this.dupList != null) {
            this.dupList.clear();
        }
        this.init = false;
    }

    public void removeAttributeAt(int attrIndex) {
        Attribute attr = (Attribute)this.attrList.remove(attrIndex);
    }

    public void setName(int attrIndex, QName attrName) {
        ((Attribute)this.attrList.get((int)attrIndex)).name.setValues(attrName);
    }

    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(((Attribute)this.attrList.get((int)attrIndex)).name);
    }

    public void setType(int attrIndex, String attrType) {
        ((Attribute)this.attrList.get((int)attrIndex)).type = attrType;
    }

    public void setValue(int attrIndex, String attrValue) {
        if (attrIndex > this.attr_index) {
            return;
        }
        Attribute attribute = (Attribute)this.attrList.get(attrIndex);
        attribute.value = attrValue;
        attribute.nonNormalizedValue = attrValue;
    }

    public void setNonNormalizedValue(int attrIndex, String attrValue) {
        Attribute attribute = (Attribute)this.attrList.get(attrIndex);
        attribute.nonNormalizedValue = attrValue;
    }

    public String getNonNormalizedValue(int attrIndex) {
        Attribute attribute = (Attribute)this.attrList.get(attrIndex);
        return attribute.nonNormalizedValue;
    }

    public void setSpecified(int attrIndex, boolean specified) {
        ((Attribute)this.attrList.get((int)attrIndex)).specified = specified;
    }

    public boolean isSpecified(int attrIndex) {
        return ((Attribute)this.attrList.get((int)attrIndex)).specified;
    }

    public int getLength() {
        return this.attr_index;
    }

    public String getType(int index) {
        if (index < 0 || index >= this.attrList.size()) {
            return null;
        }
        return this.getReportableType(((Attribute)this.attrList.get((int)index)).type);
    }

    public String getType(String qname) {
        return null;
    }

    public String getValue(int index) {
        return ((Attribute)this.attrList.get((int)index)).value;
    }

    public String getValue(String qname) {
        return null;
    }

    public String getName(int index) {
        if (index < 0 || index >= this.attrList.size()) {
            return null;
        }
        return ((Attribute)this.attrList.get((int)index)).name.rawname;
    }

    public int getIndex(String qName) {
        for (int i = 0; i < this.attr_index; ++i) {
            Attribute attribute = (Attribute)this.attrList.get(i);
            if (attribute.name.rawname == null || !attribute.name.rawname.equals(qName)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String uri, String localPart) {
        for (int i = 0; i < this.attr_index; ++i) {
            Attribute attribute = (Attribute)this.attrList.get(i);
            if (attribute.name.localpart == null || !attribute.name.localpart.equals(localPart) || uri != attribute.name.uri && (uri == null || attribute.name.uri == null || !attribute.name.uri.equals(uri))) continue;
            return i;
        }
        return -1;
    }

    public String getLocalName(int index) {
        if (!this.fNamespaces) {
            return "";
        }
        return ((Attribute)this.attrList.get((int)index)).name.localpart;
    }

    public String getQName(int index) {
        return ((Attribute)this.attrList.get((int)index)).name.rawname;
    }

    public QName getQualifiedName(int index) {
        return ((Attribute)this.attrList.get((int)index)).name;
    }

    public String getType(String uri, String localName) {
        if (!this.fNamespaces) {
            return null;
        }
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getReportableType(((Attribute)this.attrList.get((int)index)).type) : null;
    }

    public String getPrefix(int index) {
        return ((Attribute)this.attrList.get((int)index)).name.prefix;
    }

    public String getURI(int index) {
        return ((Attribute)this.attrList.get((int)index)).name.uri;
    }

    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getValue(index) : null;
    }

    public Augmentations getAugmentations(String uri, String localName) {
        return null;
    }

    public Augmentations getAugmentations(String qName) {
        return null;
    }

    public Augmentations getAugmentations(int attributeIndex) {
        return null;
    }

    public void setAugmentations(int attrIndex, Augmentations augs) {
    }

    public void setURI(int attrIndex, String uri) {
        Attribute attribute = (Attribute)this.attrList.get(attrIndex);
        attribute.name.uri = uri;
    }

    public void setSchemaId(int attrIndex, boolean schemaId) {
    }

    public boolean getSchemaId(int index) {
        return false;
    }

    public boolean getSchemaId(String qname) {
        return false;
    }

    public boolean getSchemaId(String uri, String localName) {
        return false;
    }

    public void addAttributeNS(QName name, String type, String value) {
        Attribute attr = null;
        if (this.attr_index >= this.attrList.size()) {
            attr = new Attribute();
            attr.name = new QName();
            this.attrList.add(attr);
            attr.next = null;
        } else {
            attr = (Attribute)this.attrList.get(this.attr_index);
            attr.next = null;
        }
        attr.name.setValues(name);
        attr.type = type;
        attr.value = value;
        if (this.attr_index > this.MAGIC_NUMBER) {
            if (!this.init) {
                if (this.attrMap == null) {
                    this.attrMap = new HashMap(2, 2.0f);
                }
                for (int i = 0; i < this.attr_index; ++i) {
                    Attribute tmp = (Attribute)this.attrList.get(i);
                    this.attrMap.put(tmp.name.localpart, tmp);
                }
                this.init = true;
            }
            if (this.attrMap.containsKey(name.localpart)) {
                Attribute obj = (Attribute)this.attrMap.get(name.localpart);
                attr.next = obj.next;
                obj.next = attr;
                ++this.attr_index;
                if (!obj.dup) {
                    if (this.dupList == null) {
                        this.dupList = new ArrayList();
                    }
                    this.dupList.add(attr);
                    obj.dup = true;
                }
            } else {
                this.attrMap.put(name.localpart, attr);
                ++this.attr_index;
            }
        } else {
            ++this.attr_index;
        }
    }

    public QName checkDuplicatesNS() {
        if (this.attr_index <= this.MAGIC_NUMBER) {
            for (int i = 0; i < this.attr_index - 1; ++i) {
                Attribute att1 = (Attribute)this.attrList.get(i);
                for (int j = i + 1; j < this.attr_index; ++j) {
                    Attribute att2 = (Attribute)this.attrList.get(j);
                    if (att1.name.localpart != att2.name.localpart || att1.name.uri != att2.name.uri) continue;
                    return att2.name;
                }
            }
        } else {
            if (this.dupList == null) {
                return null;
            }
            for (int i = 0; i < this.dupList.size(); ++i) {
                Attribute att1 = (Attribute)this.dupList.get(i);
                Attribute att2 = att1.next;
                while (att2 != null) {
                    if (att1.name.localpart == att2.name.localpart && att1.name.uri == att2.name.uri) {
                        return att2.name;
                    }
                    att2 = att1.next;
                }
            }
        }
        return null;
    }

    protected String getReportableType(String type) {
        if (type.indexOf(40) == 0 && type.lastIndexOf(41) == type.length() - 1) {
            return "NMTOKEN";
        }
        return type;
    }

    protected Attribute getDuplicate(Attribute attr1, QName qname) {
        Attribute att1 = attr1;
        if (att1.name.prefix == qname.prefix && attr1.next == null) {
            return att1;
        }
        while (att1 != null) {
            if (att1.name.rawname == qname.rawname) {
                return att1;
            }
            att1 = att1.next;
        }
        return null;
    }

    class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public boolean schemaId;
        public boolean dup = false;
        Attribute next;

        Attribute() {
        }
    }
}

