

/**
 * Copyright (C) 2006-2008 Sun Microsystems, Inc.
 * 
 * Sun Microsystems, Inc. confidential
 * All rights reserved
 *
 * This file is autogenerated by glue-jaxws.xsl, DO NOT EDIT! 
 */

package com.sun.xml.ws.commons.virtualbox;

import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import com.sun.xml.ws.commons.virtualbox.IUnknown;

import org.virtualbox.service.InvalidObjectFaultMsg;
import org.virtualbox.service.RuntimeFaultMsg;
import org.virtualbox.service.VboxService;
import org.virtualbox.service.VboxPortType;

public class IMachine extends IUnknown {

    public static IMachine cast(IUnknown other) {
        return new IMachine(other.getRef(), other.getRemoteWSPort());
    }

    public IMachine(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IMachine::parent of type IVirtualBox
    public com.sun.xml.ws.commons.virtualbox.IVirtualBox getParent() {
        try {
            String retVal = port.iMachineGetParent(_this);
            return new IVirtualBox(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::accessible of type boolean
    public Boolean getAccessible() {
        try {
            Boolean retVal = port.iMachineGetAccessible(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // Skipping attribute IVirtualBoxErrorInfo for it is of suppressed type IVirtualBoxErrorInfo

    // read/write attribute IMachine::name of type wstring
    public String getName() {
        try {
            String retVal = port.iMachineGetName(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setName(String value) {
        try {
            port.iMachineSetName(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::description of type wstring
    public String getDescription() {
        try {
            String retVal = port.iMachineGetDescription(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setDescription(String value) {
        try {
            port.iMachineSetDescription(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::id of type uuid
    public UUID getId() {
        try {
            String retVal = port.iMachineGetId(_this);
            return UUID.fromString(retVal);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::OSTypeId of type wstring
    public String getOSTypeId() {
        try {
            String retVal = port.iMachineGetOSTypeId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setOSTypeId(String value) {
        try {
            port.iMachineSetOSTypeId(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::memorySize of type unsigned long
    public Long getMemorySize() {
        try {
            Long retVal = port.iMachineGetMemorySize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMemorySize(Long value) {
        try {
            port.iMachineSetMemorySize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::memoryBalloonSize of type unsigned long
    public Long getMemoryBalloonSize() {
        try {
            Long retVal = port.iMachineGetMemoryBalloonSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMemoryBalloonSize(Long value) {
        try {
            port.iMachineSetMemoryBalloonSize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::statisticsUpdateInterval of type unsigned long
    public Long getStatisticsUpdateInterval() {
        try {
            Long retVal = port.iMachineGetStatisticsUpdateInterval(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setStatisticsUpdateInterval(Long value) {
        try {
            port.iMachineSetStatisticsUpdateInterval(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::VRAMSize of type unsigned long
    public Long getVRAMSize() {
        try {
            Long retVal = port.iMachineGetVRAMSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setVRAMSize(Long value) {
        try {
            port.iMachineSetVRAMSize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::MonitorCount of type unsigned long
    public Long getMonitorCount() {
        try {
            Long retVal = port.iMachineGetMonitorCount(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMonitorCount(Long value) {
        try {
            port.iMachineSetMonitorCount(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::BIOSSettings of type IBIOSSettings
    public com.sun.xml.ws.commons.virtualbox.IBIOSSettings getBIOSSettings() {
        try {
            String retVal = port.iMachineGetBIOSSettings(_this);
            return new IBIOSSettings(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::HWVirtExEnabled of type TSBool
    public org.virtualbox.TSBool getHWVirtExEnabled() {
        try {
            org.virtualbox.TSBool retVal = port.iMachineGetHWVirtExEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setHWVirtExEnabled(org.virtualbox.TSBool value) {
        try {
            port.iMachineSetHWVirtExEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::HWVirtExNestedPagingEnabled of type boolean
    public Boolean getHWVirtExNestedPagingEnabled() {
        try {
            Boolean retVal = port.iMachineGetHWVirtExNestedPagingEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setHWVirtExNestedPagingEnabled(Boolean value) {
        try {
            port.iMachineSetHWVirtExNestedPagingEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::PAEEnabled of type boolean
    public Boolean getPAEEnabled() {
        try {
            Boolean retVal = port.iMachineGetPAEEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setPAEEnabled(Boolean value) {
        try {
            port.iMachineSetPAEEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::snapshotFolder of type wstring
    public String getSnapshotFolder() {
        try {
            String retVal = port.iMachineGetSnapshotFolder(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setSnapshotFolder(String value) {
        try {
            port.iMachineSetSnapshotFolder(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::VRDPServer of type IVRDPServer
    public com.sun.xml.ws.commons.virtualbox.IVRDPServer getVRDPServer() {
        try {
            String retVal = port.iMachineGetVRDPServer(_this);
            return new IVRDPServer(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::hardDiskAttachments of type IHardDiskAttachmentCollection
    public List<org.virtualbox.IHardDiskAttachment> getHardDiskAttachments() {
        try {
            return port.iMachineGetHardDiskAttachments(_this).getArray();
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::DVDDrive of type IDVDDrive
    public com.sun.xml.ws.commons.virtualbox.IDVDDrive getDVDDrive() {
        try {
            String retVal = port.iMachineGetDVDDrive(_this);
            return new IDVDDrive(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::FloppyDrive of type IFloppyDrive
    public com.sun.xml.ws.commons.virtualbox.IFloppyDrive getFloppyDrive() {
        try {
            String retVal = port.iMachineGetFloppyDrive(_this);
            return new IFloppyDrive(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::USBController of type IUSBController
    public com.sun.xml.ws.commons.virtualbox.IUSBController getUSBController() {
        try {
            String retVal = port.iMachineGetUSBController(_this);
            return new IUSBController(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::audioAdapter of type IAudioAdapter
    public com.sun.xml.ws.commons.virtualbox.IAudioAdapter getAudioAdapter() {
        try {
            String retVal = port.iMachineGetAudioAdapter(_this);
            return new IAudioAdapter(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::SATAController of type ISATAController
    public com.sun.xml.ws.commons.virtualbox.ISATAController getSATAController() {
        try {
            String retVal = port.iMachineGetSATAController(_this);
            return new ISATAController(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::settingsFilePath of type wstring
    public String getSettingsFilePath() {
        try {
            String retVal = port.iMachineGetSettingsFilePath(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::settingsFileVersion of type wstring
    public String getSettingsFileVersion() {
        try {
            String retVal = port.iMachineGetSettingsFileVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::settingsModified of type boolean
    public Boolean getSettingsModified() {
        try {
            Boolean retVal = port.iMachineGetSettingsModified(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sessionState of type SessionState
    public org.virtualbox.SessionState getSessionState() {
        try {
            org.virtualbox.SessionState retVal = port.iMachineGetSessionState(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sessionType of type wstring
    public String getSessionType() {
        try {
            String retVal = port.iMachineGetSessionType(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sessionPid of type unsigned long
    public Long getSessionPid() {
        try {
            Long retVal = port.iMachineGetSessionPid(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::state of type MachineState
    public org.virtualbox.MachineState getState() {
        try {
            org.virtualbox.MachineState retVal = port.iMachineGetState(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::lastStateChange of type long long
    public Long getLastStateChange() {
        try {
            Long retVal = port.iMachineGetLastStateChange(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::stateFilePath of type wstring
    public String getStateFilePath() {
        try {
            String retVal = port.iMachineGetStateFilePath(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::logFolder of type wstring
    public String getLogFolder() {
        try {
            String retVal = port.iMachineGetLogFolder(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::currentSnapshot of type ISnapshot
    public com.sun.xml.ws.commons.virtualbox.ISnapshot getCurrentSnapshot() {
        try {
            String retVal = port.iMachineGetCurrentSnapshot(_this);
            return new ISnapshot(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::snapshotCount of type unsigned long
    public Long getSnapshotCount() {
        try {
            Long retVal = port.iMachineGetSnapshotCount(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::currentStateModified of type boolean
    public Boolean getCurrentStateModified() {
        try {
            Boolean retVal = port.iMachineGetCurrentStateModified(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sharedFolders of type ISharedFolderCollection
    public List<org.virtualbox.ISharedFolder> getSharedFolders() {
        try {
            return port.iMachineGetSharedFolders(_this).getArray();
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::clipboardMode of type ClipboardMode
    public org.virtualbox.ClipboardMode getClipboardMode() {
        try {
            org.virtualbox.ClipboardMode retVal = port.iMachineGetClipboardMode(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setClipboardMode(org.virtualbox.ClipboardMode value) {
        try {
            port.iMachineSetClipboardMode(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setBootOrder(
            [in] unsigned long position,
            [in] DeviceType device)
     */
    public void setBootOrder(Long position, org.virtualbox.DeviceType device) {
        try {
            port.iMachineSetBootOrder(_this, position, device);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getBootOrder(
            [in] unsigned long order,
            [return] DeviceType device)
     */
    public org.virtualbox.DeviceType getBootOrder(Long order) {
        try {
            org.virtualbox.DeviceType retVal = port.iMachineGetBootOrder(_this, order);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::attachHardDisk(
            [in] uuid id,
            [in] StorageBus bus,
            [in] long channel,
            [in] long device)
     */
    public void attachHardDisk(UUID id, org.virtualbox.StorageBus bus, Integer channel, Integer device) {
        try {
            port.iMachineAttachHardDisk(_this, id.toString(), bus, channel, device);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getHardDisk(
            [in] StorageBus bus,
            [in] long channel,
            [in] long device,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox.IHardDisk getHardDisk(org.virtualbox.StorageBus bus, Integer channel, Integer device) {
        try {
            String retVal = port.iMachineGetHardDisk(_this, bus, channel, device);
            return new com.sun.xml.ws.commons.virtualbox.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::detachHardDisk(
            [in] StorageBus bus,
            [in] long channel,
            [in] long device)
     */
    public void detachHardDisk(org.virtualbox.StorageBus bus, Integer channel, Integer device) {
        try {
            port.iMachineDetachHardDisk(_this, bus, channel, device);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getNetworkAdapter(
            [in] unsigned long slot,
            [return] INetworkAdapter adapter)
     */
    public com.sun.xml.ws.commons.virtualbox.INetworkAdapter getNetworkAdapter(Long slot) {
        try {
            String retVal = port.iMachineGetNetworkAdapter(_this, slot);
            return new com.sun.xml.ws.commons.virtualbox.INetworkAdapter(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getSerialPort(
            [in] unsigned long slot,
            [return] ISerialPort port)
     */
    public com.sun.xml.ws.commons.virtualbox.ISerialPort getSerialPort(Long slot) {
        try {
            String retVal = port.iMachineGetSerialPort(_this, slot);
            return new com.sun.xml.ws.commons.virtualbox.ISerialPort(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getParallelPort(
            [in] unsigned long slot,
            [return] IParallelPort port)
     */
    public com.sun.xml.ws.commons.virtualbox.IParallelPort getParallelPort(Long slot) {
        try {
            String retVal = port.iMachineGetParallelPort(_this, slot);
            return new com.sun.xml.ws.commons.virtualbox.IParallelPort(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getNextExtraDataKey(
            [in] wstring key,
            [out] wstring nextKey,
            [out] wstring nextValue)
     */
    public void getNextExtraDataKey(String key, Holder<String> nextKey, Holder<String> nextValue) {
        try {
            port.iMachineGetNextExtraDataKey(_this, key, nextKey, nextValue);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getExtraData(
            [in] wstring key,
            [return] wstring value)
     */
    public String getExtraData(String key) {
        try {
            String retVal = port.iMachineGetExtraData(_this, key);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setExtraData(
            [in] wstring key,
            [in] wstring value)
     */
    public void setExtraData(String key, String value) {
        try {
            port.iMachineSetExtraData(_this, key, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::saveSettings()
     */
    public void saveSettings() {
        try {
            port.iMachineSaveSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::saveSettingsWithBackup(
            [return] wstring bakFileName)
     */
    public String saveSettingsWithBackup() {
        try {
            String retVal = port.iMachineSaveSettingsWithBackup(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::discardSettings()
     */
    public void discardSettings() {
        try {
            port.iMachineDiscardSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::deleteSettings()
     */
    public void deleteSettings() {
        try {
            port.iMachineDeleteSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getSnapshot(
            [in] uuid id,
            [return] ISnapshot snapshot)
     */
    public com.sun.xml.ws.commons.virtualbox.ISnapshot getSnapshot(UUID id) {
        try {
            String retVal = port.iMachineGetSnapshot(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.ISnapshot(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::findSnapshot(
            [in] wstring name,
            [return] ISnapshot snapshot)
     */
    public com.sun.xml.ws.commons.virtualbox.ISnapshot findSnapshot(String name) {
        try {
            String retVal = port.iMachineFindSnapshot(_this, name);
            return new com.sun.xml.ws.commons.virtualbox.ISnapshot(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setCurrentSnapshot(
            [in] uuid id)
     */
    public void setCurrentSnapshot(UUID id) {
        try {
            port.iMachineSetCurrentSnapshot(_this, id.toString());
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::createSharedFolder(
            [in] wstring name,
            [in] wstring hostPath,
            [in] boolean writable)
     */
    public void createSharedFolder(String name, String hostPath, Boolean writable) {
        try {
            port.iMachineCreateSharedFolder(_this, name, hostPath, writable);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::removeSharedFolder(
            [in] wstring name)
     */
    public void removeSharedFolder(String name) {
        try {
            port.iMachineRemoveSharedFolder(_this, name);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::canShowConsoleWindow(
            [return] boolean canShow)
     */
    public Boolean canShowConsoleWindow() {
        try {
            Boolean retVal = port.iMachineCanShowConsoleWindow(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::showConsoleWindow(
            [return] unsigned long long winId)
     */
    public BigInteger showConsoleWindow() {
        try {
            BigInteger retVal = port.iMachineShowConsoleWindow(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getGuestProperty(
            [in] wstring name,
            [out] wstring value,
            [out] unsigned long long timestamp,
            [out] wstring flags)
     */
    public void getGuestProperty(String name, Holder<String> value, Holder<BigInteger> timestamp, Holder<String> flags) {
        try {
            port.iMachineGetGuestProperty(_this, name, value, timestamp, flags);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getGuestPropertyValue(
            [in] wstring property,
            [return] wstring value)
     */
    public String getGuestPropertyValue(String property) {
        try {
            String retVal = port.iMachineGetGuestPropertyValue(_this, property);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getGuestPropertyTimestamp(
            [in] wstring property,
            [return] unsigned long long value)
     */
    public BigInteger getGuestPropertyTimestamp(String property) {
        try {
            BigInteger retVal = port.iMachineGetGuestPropertyTimestamp(_this, property);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setGuestProperty(
            [in] wstring property,
            [in] wstring value,
            [in] wstring flags)
     */
    public void setGuestProperty(String property, String value, String flags) {
        try {
            port.iMachineSetGuestProperty(_this, property, value, flags);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setGuestPropertyValue(
            [in] wstring property,
            [in] wstring value)
     */
    public void setGuestPropertyValue(String property, String value) {
        try {
            port.iMachineSetGuestPropertyValue(_this, property, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::enumerateGuestProperties(
            [in] wstring patterns,
            [out] wstring name[],
            [out] wstring value[],
            [out] unsigned long long timestamp[],
            [out] wstring flags[])
     */
    public void enumerateGuestProperties(String patterns, Holder<List<String>> name, Holder<List<String>> value, Holder<List<BigInteger>> timestamp, Holder<List<String>> flags) {
        try {
            port.iMachineEnumerateGuestProperties(_this, patterns, name, value, timestamp, flags);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
