package com.sun.xml.ws.commons.virtualbox;

import org.virtualbox.service.VboxPortType;
import org.virtualbox.service.InvalidObjectFaultMsg;
import org.virtualbox.service.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;

public class IUnknown 
{
   protected final String       _this;
   protected final VboxPortType port;
   
   public IUnknown(String _this, VboxPortType port)
   {
      this._this = _this;
      this.port = port;
   }
 
   public final String getRef() 
   {
      return _this;
   }

   public final VboxPortType getRemoteWSPort()
   {
      return port;
   }

   public void releaseRemote() throws WebServiceException
   {
      try {
          port.iManagedObjectRefRelease(_this);
      } catch (InvalidObjectFaultMsg e) {
          throw new WebServiceException(e);
      } catch (RuntimeFaultMsg e) {
          throw new WebServiceException(e);
      }
   }

   // may need to support some sort of QueryInterface, to make this class useable 
   // not only as common baseclass
}
