/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox;

import com.sun.xml.ws.commons.virtualbox.Helper;
import com.sun.xml.ws.commons.virtualbox.IUSBDeviceFilter;
import com.sun.xml.ws.commons.virtualbox.IUnknown;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.virtualbox.ArrayOfIUSBDeviceFilter;
import org.virtualbox.service.InvalidObjectFaultMsg;
import org.virtualbox.service.RuntimeFaultMsg;
import org.virtualbox.service.VboxPortType;

public class IUSBController
extends IUnknown {
    public static IUSBController cast(IUnknown iUnknown) {
        return new IUSBController(iUnknown.getRef(), iUnknown.getRemoteWSPort());
    }

    public IUSBController(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public Boolean getEnabled() {
        try {
            Boolean bl = this.port.iusbControllerGetEnabled(this._this);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setEnabled(Boolean bl) {
        try {
            this.port.iusbControllerSetEnabled(this._this, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Boolean getEnabledEhci() {
        try {
            Boolean bl = this.port.iusbControllerGetEnabledEhci(this._this);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setEnabledEhci(Boolean bl) {
        try {
            this.port.iusbControllerSetEnabledEhci(this._this, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Integer getUSBStandard() {
        try {
            int n = this.port.iusbControllerGetUSBStandard(this._this);
            return n;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IUSBDeviceFilter> getDeviceFilters() {
        try {
            ArrayOfIUSBDeviceFilter arrayOfIUSBDeviceFilter = this.port.iusbControllerGetDeviceFilters(this._this);
            return Helper.wrap(IUSBDeviceFilter.class, this.port, arrayOfIUSBDeviceFilter == null ? null : arrayOfIUSBDeviceFilter.getArray());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IUSBDeviceFilter createDeviceFilter(String string) {
        try {
            String string2 = this.port.iusbControllerCreateDeviceFilter(this._this, string);
            return new IUSBDeviceFilter(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void insertDeviceFilter(Long l, IUSBDeviceFilter iUSBDeviceFilter) {
        try {
            this.port.iusbControllerInsertDeviceFilter(this._this, l, iUSBDeviceFilter == null ? null : iUSBDeviceFilter.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IUSBDeviceFilter removeDeviceFilter(Long l) {
        try {
            String string = this.port.iusbControllerRemoveDeviceFilter(this._this, l);
            return new IUSBDeviceFilter(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }
}

