/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox;

import com.sun.xml.ws.commons.virtualbox.Helper;
import com.sun.xml.ws.commons.virtualbox.IDVDImage;
import com.sun.xml.ws.commons.virtualbox.IFloppyImage;
import com.sun.xml.ws.commons.virtualbox.IHardDisk;
import com.sun.xml.ws.commons.virtualbox.IHost;
import com.sun.xml.ws.commons.virtualbox.IMachine;
import com.sun.xml.ws.commons.virtualbox.IPerformanceCollector;
import com.sun.xml.ws.commons.virtualbox.IProgress;
import com.sun.xml.ws.commons.virtualbox.ISession;
import com.sun.xml.ws.commons.virtualbox.ISystemProperties;
import com.sun.xml.ws.commons.virtualbox.IUnknown;
import com.sun.xml.ws.commons.virtualbox.IVirtualDiskImage;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.virtualbox.ArrayOfIDVDImage;
import org.virtualbox.ArrayOfIFloppyImage;
import org.virtualbox.ArrayOfIHardDisk;
import org.virtualbox.ArrayOfIMachine;
import org.virtualbox.ArrayOfIProgress;
import org.virtualbox.HardDiskStorageType;
import org.virtualbox.IGuestOSType;
import org.virtualbox.ISharedFolder;
import org.virtualbox.ResourceUsage;
import org.virtualbox.service.InvalidObjectFaultMsg;
import org.virtualbox.service.RuntimeFaultMsg;
import org.virtualbox.service.VboxPortType;

public class IVirtualBox
extends IUnknown {
    public static IVirtualBox cast(IUnknown iUnknown) {
        return new IVirtualBox(iUnknown.getRef(), iUnknown.getRemoteWSPort());
    }

    public IVirtualBox(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public String getVersion() {
        try {
            String string = this.port.iVirtualBoxGetVersion(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Long getRevision() {
        try {
            Long l = this.port.iVirtualBoxGetRevision(this._this);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getPackageType() {
        try {
            String string = this.port.iVirtualBoxGetPackageType(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getHomeFolder() {
        try {
            String string = this.port.iVirtualBoxGetHomeFolder(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getSettingsFilePath() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFilePath(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getSettingsFileVersion() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFileVersion(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getSettingsFormatVersion() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFormatVersion(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHost getHost() {
        try {
            String string = this.port.iVirtualBoxGetHost(this._this);
            return new IHost(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public ISystemProperties getSystemProperties() {
        try {
            String string = this.port.iVirtualBoxGetSystemProperties(this._this);
            return new ISystemProperties(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IMachine> getMachines() {
        try {
            ArrayOfIMachine arrayOfIMachine = this.port.iVirtualBoxGetMachines(this._this);
            return Helper.wrap(IMachine.class, this.port, arrayOfIMachine == null ? null : arrayOfIMachine.getArray());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IMachine> getMachines2() {
        try {
            List<String> list = this.port.iVirtualBoxGetMachines2(this._this);
            return Helper.wrap(IMachine.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IHardDisk> getHardDisks() {
        try {
            ArrayOfIHardDisk arrayOfIHardDisk = this.port.iVirtualBoxGetHardDisks(this._this);
            return Helper.wrap(IHardDisk.class, this.port, arrayOfIHardDisk == null ? null : arrayOfIHardDisk.getArray());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IDVDImage> getDVDImages() {
        try {
            ArrayOfIDVDImage arrayOfIDVDImage = this.port.iVirtualBoxGetDVDImages(this._this);
            return Helper.wrap(IDVDImage.class, this.port, arrayOfIDVDImage == null ? null : arrayOfIDVDImage.getArray());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IFloppyImage> getFloppyImages() {
        try {
            ArrayOfIFloppyImage arrayOfIFloppyImage = this.port.iVirtualBoxGetFloppyImages(this._this);
            return Helper.wrap(IFloppyImage.class, this.port, arrayOfIFloppyImage == null ? null : arrayOfIFloppyImage.getArray());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IProgress> getProgressOperations() {
        try {
            ArrayOfIProgress arrayOfIProgress = this.port.iVirtualBoxGetProgressOperations(this._this);
            return Helper.wrap(IProgress.class, this.port, arrayOfIProgress == null ? null : arrayOfIProgress.getArray());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IGuestOSType> getGuestOSTypes() {
        try {
            return this.port.iVirtualBoxGetGuestOSTypes(this._this).getArray();
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<ISharedFolder> getSharedFolders() {
        try {
            return this.port.iVirtualBoxGetSharedFolders(this._this).getArray();
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IPerformanceCollector getPerformanceCollector() {
        try {
            String string = this.port.iVirtualBoxGetPerformanceCollector(this._this);
            return new IPerformanceCollector(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine createMachine(String string, String string2, UUID uUID) {
        try {
            String string3 = this.port.iVirtualBoxCreateMachine(this._this, string, string2, uUID.toString());
            return new IMachine(string3, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine createLegacyMachine(String string, String string2, UUID uUID) {
        try {
            String string3 = this.port.iVirtualBoxCreateLegacyMachine(this._this, string, string2, uUID.toString());
            return new IMachine(string3, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine openMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxOpenMachine(this._this, string);
            return new IMachine(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void registerMachine(IMachine iMachine) {
        try {
            this.port.iVirtualBoxRegisterMachine(this._this, iMachine == null ? null : iMachine.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine getMachine(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxGetMachine(this._this, uUID.toString());
            return new IMachine(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine findMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindMachine(this._this, string);
            return new IMachine(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine unregisterMachine(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxUnregisterMachine(this._this, uUID.toString());
            return new IMachine(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk createHardDisk(HardDiskStorageType hardDiskStorageType) {
        try {
            String string = this.port.iVirtualBoxCreateHardDisk(this._this, hardDiskStorageType);
            return new IHardDisk(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk openHardDisk(String string) {
        try {
            String string2 = this.port.iVirtualBoxOpenHardDisk(this._this, string);
            return new IHardDisk(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IVirtualDiskImage openVirtualDiskImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxOpenVirtualDiskImage(this._this, string);
            return new IVirtualDiskImage(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void registerHardDisk(IHardDisk iHardDisk) {
        try {
            this.port.iVirtualBoxRegisterHardDisk(this._this, iHardDisk == null ? null : iHardDisk.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk getHardDisk(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxGetHardDisk(this._this, uUID.toString());
            return new IHardDisk(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk findHardDisk(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindHardDisk(this._this, string);
            return new IHardDisk(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IVirtualDiskImage findVirtualDiskImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindVirtualDiskImage(this._this, string);
            return new IVirtualDiskImage(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk unregisterHardDisk(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxUnregisterHardDisk(this._this, uUID.toString());
            return new IHardDisk(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage openDVDImage(String string, UUID uUID) {
        try {
            String string2 = this.port.iVirtualBoxOpenDVDImage(this._this, string, uUID.toString());
            return new IDVDImage(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void registerDVDImage(IDVDImage iDVDImage) {
        try {
            this.port.iVirtualBoxRegisterDVDImage(this._this, iDVDImage == null ? null : iDVDImage.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage getDVDImage(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxGetDVDImage(this._this, uUID.toString());
            return new IDVDImage(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage findDVDImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindDVDImage(this._this, string);
            return new IDVDImage(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getDVDImageUsage(UUID uUID, ResourceUsage resourceUsage) {
        try {
            String string = this.port.iVirtualBoxGetDVDImageUsage(this._this, uUID.toString(), resourceUsage);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage unregisterDVDImage(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxUnregisterDVDImage(this._this, uUID.toString());
            return new IDVDImage(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage openFloppyImage(String string, UUID uUID) {
        try {
            String string2 = this.port.iVirtualBoxOpenFloppyImage(this._this, string, uUID.toString());
            return new IFloppyImage(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void registerFloppyImage(IFloppyImage iFloppyImage) {
        try {
            this.port.iVirtualBoxRegisterFloppyImage(this._this, iFloppyImage == null ? null : iFloppyImage.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage getFloppyImage(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxGetFloppyImage(this._this, uUID.toString());
            return new IFloppyImage(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage findFloppyImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindFloppyImage(this._this, string);
            return new IFloppyImage(string2, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getFloppyImageUsage(UUID uUID, ResourceUsage resourceUsage) {
        try {
            String string = this.port.iVirtualBoxGetFloppyImageUsage(this._this, uUID.toString(), resourceUsage);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage unregisterFloppyImage(UUID uUID) {
        try {
            String string = this.port.iVirtualBoxUnregisterFloppyImage(this._this, uUID.toString());
            return new IFloppyImage(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IGuestOSType getGuestOSType(String string) {
        try {
            IGuestOSType iGuestOSType = this.port.iVirtualBoxGetGuestOSType(this._this, string);
            return iGuestOSType;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void createSharedFolder(String string, String string2, Boolean bl) {
        try {
            this.port.iVirtualBoxCreateSharedFolder(this._this, string, string2, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void removeSharedFolder(String string) {
        try {
            this.port.iVirtualBoxRemoveSharedFolder(this._this, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void getNextExtraDataKey(String string, Holder<String> holder, Holder<String> holder2) {
        try {
            this.port.iVirtualBoxGetNextExtraDataKey(this._this, string, holder, holder2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getExtraData(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetExtraData(this._this, string);
            return string2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setExtraData(String string, String string2) {
        try {
            this.port.iVirtualBoxSetExtraData(this._this, string, string2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void openSession(ISession iSession, UUID uUID) {
        try {
            this.port.iVirtualBoxOpenSession(this._this, iSession == null ? null : iSession.getRef(), uUID.toString());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IProgress openRemoteSession(ISession iSession, UUID uUID, String string, String string2) {
        try {
            String string3 = this.port.iVirtualBoxOpenRemoteSession(this._this, iSession == null ? null : iSession.getRef(), uUID.toString(), string, string2);
            return new IProgress(string3, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void openExistingSession(ISession iSession, UUID uUID) {
        try {
            this.port.iVirtualBoxOpenExistingSession(this._this, iSession == null ? null : iSession.getRef(), uUID.toString());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void waitForPropertyChange(String string, Long l, Holder<String> holder, Holder<String> holder2) {
        try {
            this.port.iVirtualBoxWaitForPropertyChange(this._this, string, l, holder, holder2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void saveSettings() {
        try {
            this.port.iVirtualBoxSaveSettings(this._this);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String saveSettingsWithBackup() {
        try {
            String string = this.port.iVirtualBoxSaveSettingsWithBackup(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }
}

