/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox;

import com.sun.xml.ws.commons.virtualbox.IDVDImage;
import com.sun.xml.ws.commons.virtualbox.IHostDVDDrive;
import com.sun.xml.ws.commons.virtualbox.IUnknown;
import java.util.UUID;
import javax.xml.ws.WebServiceException;
import org.virtualbox.DriveState;
import org.virtualbox.service.InvalidObjectFaultMsg;
import org.virtualbox.service.RuntimeFaultMsg;
import org.virtualbox.service.VboxPortType;

public class IDVDDrive
extends IUnknown {
    public static IDVDDrive cast(IUnknown iUnknown) {
        return new IDVDDrive(iUnknown.getRef(), iUnknown.getRemoteWSPort());
    }

    public IDVDDrive(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public DriveState getState() {
        try {
            DriveState driveState = this.port.idvdDriveGetState(this._this);
            return driveState;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Boolean getPassthrough() {
        try {
            Boolean bl = this.port.idvdDriveGetPassthrough(this._this);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setPassthrough(Boolean bl) {
        try {
            this.port.idvdDriveSetPassthrough(this._this, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void mountImage(UUID uUID) {
        try {
            this.port.idvdDriveMountImage(this._this, uUID.toString());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void captureHostDrive(IHostDVDDrive iHostDVDDrive) {
        try {
            this.port.idvdDriveCaptureHostDrive(this._this, iHostDVDDrive == null ? null : iHostDVDDrive.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void unmount() {
        try {
            this.port.idvdDriveUnmount(this._this);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage getImage() {
        try {
            String string = this.port.idvdDriveGetImage(this._this);
            return new IDVDImage(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHostDVDDrive getHostDrive() {
        try {
            String string = this.port.idvdDriveGetHostDrive(this._this);
            return new IHostDVDDrive(string, this.port);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }
}

