

/**
 * Copyright (C) 2006-2008 Sun Microsystems, Inc.
 * 
 * Sun Microsystems, Inc. confidential
 * All rights reserved
 *
 * This file is autogenerated by glue-jaxws.xsl, DO NOT EDIT! 
 */

package com.sun.xml.ws.commons.virtualbox;

import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import com.sun.xml.ws.commons.virtualbox.IUnknown;

import org.virtualbox.service.InvalidObjectFaultMsg;
import org.virtualbox.service.RuntimeFaultMsg;
import org.virtualbox.service.VboxService;
import org.virtualbox.service.VboxPortType;

public class IVirtualBox extends IUnknown {

    public static IVirtualBox cast(IUnknown other) {
        return new IVirtualBox(other.getRef(), other.getRemoteWSPort());
    }

    public IVirtualBox(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IVirtualBox::version of type wstring
    public String getVersion() {
        try {
            String retVal = port.iVirtualBoxGetVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::revision of type unsigned long
    public Long getRevision() {
        try {
            Long retVal = port.iVirtualBoxGetRevision(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::packageType of type wstring
    public String getPackageType() {
        try {
            String retVal = port.iVirtualBoxGetPackageType(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::homeFolder of type wstring
    public String getHomeFolder() {
        try {
            String retVal = port.iVirtualBoxGetHomeFolder(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::settingsFilePath of type wstring
    public String getSettingsFilePath() {
        try {
            String retVal = port.iVirtualBoxGetSettingsFilePath(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::settingsFileVersion of type wstring
    public String getSettingsFileVersion() {
        try {
            String retVal = port.iVirtualBoxGetSettingsFileVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::settingsFormatVersion of type wstring
    public String getSettingsFormatVersion() {
        try {
            String retVal = port.iVirtualBoxGetSettingsFormatVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::host of type IHost
    public com.sun.xml.ws.commons.virtualbox.IHost getHost() {
        try {
            String retVal = port.iVirtualBoxGetHost(_this);
            return new IHost(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::systemProperties of type ISystemProperties
    public com.sun.xml.ws.commons.virtualbox.ISystemProperties getSystemProperties() {
        try {
            String retVal = port.iVirtualBoxGetSystemProperties(_this);
            return new ISystemProperties(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::machines of type IMachineCollection
    public List<com.sun.xml.ws.commons.virtualbox.IMachine> getMachines() {
        try {
            org.virtualbox.ArrayOfIMachine retVal = port.iVirtualBoxGetMachines(_this);
            return Helper.wrap(IMachine.class, port, ((retVal == null)?null:retVal.getArray()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::machines2 of type IMachine
    public List<com.sun.xml.ws.commons.virtualbox.IMachine> getMachines2() {
        try {
            List<String> retVal = port.iVirtualBoxGetMachines2(_this);
            return Helper.wrap(IMachine.class, port, retVal);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::hardDisks of type IHardDiskCollection
    public List<com.sun.xml.ws.commons.virtualbox.IHardDisk> getHardDisks() {
        try {
            org.virtualbox.ArrayOfIHardDisk retVal = port.iVirtualBoxGetHardDisks(_this);
            return Helper.wrap(IHardDisk.class, port, ((retVal == null)?null:retVal.getArray()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::DVDImages of type IDVDImageCollection
    public List<com.sun.xml.ws.commons.virtualbox.IDVDImage> getDVDImages() {
        try {
            org.virtualbox.ArrayOfIDVDImage retVal = port.iVirtualBoxGetDVDImages(_this);
            return Helper.wrap(IDVDImage.class, port, ((retVal == null)?null:retVal.getArray()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::FloppyImages of type IFloppyImageCollection
    public List<com.sun.xml.ws.commons.virtualbox.IFloppyImage> getFloppyImages() {
        try {
            org.virtualbox.ArrayOfIFloppyImage retVal = port.iVirtualBoxGetFloppyImages(_this);
            return Helper.wrap(IFloppyImage.class, port, ((retVal == null)?null:retVal.getArray()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::progressOperations of type IProgressCollection
    public List<com.sun.xml.ws.commons.virtualbox.IProgress> getProgressOperations() {
        try {
            org.virtualbox.ArrayOfIProgress retVal = port.iVirtualBoxGetProgressOperations(_this);
            return Helper.wrap(IProgress.class, port, ((retVal == null)?null:retVal.getArray()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::guestOSTypes of type IGuestOSTypeCollection
    public List<org.virtualbox.IGuestOSType> getGuestOSTypes() {
        try {
            return port.iVirtualBoxGetGuestOSTypes(_this).getArray();
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::sharedFolders of type ISharedFolderCollection
    public List<org.virtualbox.ISharedFolder> getSharedFolders() {
        try {
            return port.iVirtualBoxGetSharedFolders(_this).getArray();
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IVirtualBox::performanceCollector of type IPerformanceCollector
    public com.sun.xml.ws.commons.virtualbox.IPerformanceCollector getPerformanceCollector() {
        try {
            String retVal = port.iVirtualBoxGetPerformanceCollector(_this);
            return new IPerformanceCollector(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::createMachine(
            [in] wstring baseFolder,
            [in] wstring name,
            [in] uuid id,
            [return] IMachine machine)
     */
    public com.sun.xml.ws.commons.virtualbox.IMachine createMachine(String baseFolder, String name, UUID id) {
        try {
            String retVal = port.iVirtualBoxCreateMachine(_this, baseFolder, name, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IMachine(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::createLegacyMachine(
            [in] wstring settingsFile,
            [in] wstring name,
            [in] uuid id,
            [return] IMachine machine)
     */
    public com.sun.xml.ws.commons.virtualbox.IMachine createLegacyMachine(String settingsFile, String name, UUID id) {
        try {
            String retVal = port.iVirtualBoxCreateLegacyMachine(_this, settingsFile, name, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IMachine(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openMachine(
            [in] wstring settingsFile,
            [return] IMachine machine)
     */
    public com.sun.xml.ws.commons.virtualbox.IMachine openMachine(String settingsFile) {
        try {
            String retVal = port.iVirtualBoxOpenMachine(_this, settingsFile);
            return new com.sun.xml.ws.commons.virtualbox.IMachine(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::registerMachine(
            [in] IMachine machine)
     */
    public void registerMachine(com.sun.xml.ws.commons.virtualbox.IMachine machine) {
        try {
            port.iVirtualBoxRegisterMachine(_this, ((machine == null)?null:machine.getRef()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getMachine(
            [in] uuid id,
            [return] IMachine machine)
     */
    public com.sun.xml.ws.commons.virtualbox.IMachine getMachine(UUID id) {
        try {
            String retVal = port.iVirtualBoxGetMachine(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IMachine(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::findMachine(
            [in] wstring name,
            [return] IMachine machine)
     */
    public com.sun.xml.ws.commons.virtualbox.IMachine findMachine(String name) {
        try {
            String retVal = port.iVirtualBoxFindMachine(_this, name);
            return new com.sun.xml.ws.commons.virtualbox.IMachine(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::unregisterMachine(
            [in] uuid id,
            [return] IMachine machine)
     */
    public com.sun.xml.ws.commons.virtualbox.IMachine unregisterMachine(UUID id) {
        try {
            String retVal = port.iVirtualBoxUnregisterMachine(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IMachine(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::createHardDisk(
            [in] HardDiskStorageType storageType,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox.IHardDisk createHardDisk(org.virtualbox.HardDiskStorageType storageType) {
        try {
            String retVal = port.iVirtualBoxCreateHardDisk(_this, storageType);
            return new com.sun.xml.ws.commons.virtualbox.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openHardDisk(
            [in] wstring location,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox.IHardDisk openHardDisk(String location) {
        try {
            String retVal = port.iVirtualBoxOpenHardDisk(_this, location);
            return new com.sun.xml.ws.commons.virtualbox.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openVirtualDiskImage(
            [in] wstring filePath,
            [return] IVirtualDiskImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IVirtualDiskImage openVirtualDiskImage(String filePath) {
        try {
            String retVal = port.iVirtualBoxOpenVirtualDiskImage(_this, filePath);
            return new com.sun.xml.ws.commons.virtualbox.IVirtualDiskImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::registerHardDisk(
            [in] IHardDisk hardDisk)
     */
    public void registerHardDisk(com.sun.xml.ws.commons.virtualbox.IHardDisk hardDisk) {
        try {
            port.iVirtualBoxRegisterHardDisk(_this, ((hardDisk == null)?null:hardDisk.getRef()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getHardDisk(
            [in] uuid id,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox.IHardDisk getHardDisk(UUID id) {
        try {
            String retVal = port.iVirtualBoxGetHardDisk(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::findHardDisk(
            [in] wstring location,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox.IHardDisk findHardDisk(String location) {
        try {
            String retVal = port.iVirtualBoxFindHardDisk(_this, location);
            return new com.sun.xml.ws.commons.virtualbox.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::findVirtualDiskImage(
            [in] wstring filePath,
            [return] IVirtualDiskImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IVirtualDiskImage findVirtualDiskImage(String filePath) {
        try {
            String retVal = port.iVirtualBoxFindVirtualDiskImage(_this, filePath);
            return new com.sun.xml.ws.commons.virtualbox.IVirtualDiskImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::unregisterHardDisk(
            [in] uuid id,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox.IHardDisk unregisterHardDisk(UUID id) {
        try {
            String retVal = port.iVirtualBoxUnregisterHardDisk(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openDVDImage(
            [in] wstring filePath,
            [in] uuid id,
            [return] IDVDImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IDVDImage openDVDImage(String filePath, UUID id) {
        try {
            String retVal = port.iVirtualBoxOpenDVDImage(_this, filePath, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IDVDImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::registerDVDImage(
            [in] IDVDImage image)
     */
    public void registerDVDImage(com.sun.xml.ws.commons.virtualbox.IDVDImage image) {
        try {
            port.iVirtualBoxRegisterDVDImage(_this, ((image == null)?null:image.getRef()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getDVDImage(
            [in] uuid id,
            [return] IDVDImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IDVDImage getDVDImage(UUID id) {
        try {
            String retVal = port.iVirtualBoxGetDVDImage(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IDVDImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::findDVDImage(
            [in] wstring filePath,
            [return] IDVDImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IDVDImage findDVDImage(String filePath) {
        try {
            String retVal = port.iVirtualBoxFindDVDImage(_this, filePath);
            return new com.sun.xml.ws.commons.virtualbox.IDVDImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getDVDImageUsage(
            [in] uuid id,
            [in] ResourceUsage usage,
            [return] wstring machineIDs)
     */
    public String getDVDImageUsage(UUID id, org.virtualbox.ResourceUsage usage) {
        try {
            String retVal = port.iVirtualBoxGetDVDImageUsage(_this, id.toString(), usage);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::unregisterDVDImage(
            [in] uuid id,
            [return] IDVDImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IDVDImage unregisterDVDImage(UUID id) {
        try {
            String retVal = port.iVirtualBoxUnregisterDVDImage(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IDVDImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openFloppyImage(
            [in] wstring filePath,
            [in] uuid id,
            [return] IFloppyImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IFloppyImage openFloppyImage(String filePath, UUID id) {
        try {
            String retVal = port.iVirtualBoxOpenFloppyImage(_this, filePath, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IFloppyImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::registerFloppyImage(
            [in] IFloppyImage image)
     */
    public void registerFloppyImage(com.sun.xml.ws.commons.virtualbox.IFloppyImage image) {
        try {
            port.iVirtualBoxRegisterFloppyImage(_this, ((image == null)?null:image.getRef()));
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getFloppyImage(
            [in] uuid id,
            [return] IFloppyImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IFloppyImage getFloppyImage(UUID id) {
        try {
            String retVal = port.iVirtualBoxGetFloppyImage(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IFloppyImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::findFloppyImage(
            [in] wstring filePath,
            [return] IFloppyImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IFloppyImage findFloppyImage(String filePath) {
        try {
            String retVal = port.iVirtualBoxFindFloppyImage(_this, filePath);
            return new com.sun.xml.ws.commons.virtualbox.IFloppyImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getFloppyImageUsage(
            [in] uuid id,
            [in] ResourceUsage usage,
            [return] wstring machineIDs)
     */
    public String getFloppyImageUsage(UUID id, org.virtualbox.ResourceUsage usage) {
        try {
            String retVal = port.iVirtualBoxGetFloppyImageUsage(_this, id.toString(), usage);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::unregisterFloppyImage(
            [in] uuid id,
            [return] IFloppyImage image)
     */
    public com.sun.xml.ws.commons.virtualbox.IFloppyImage unregisterFloppyImage(UUID id) {
        try {
            String retVal = port.iVirtualBoxUnregisterFloppyImage(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox.IFloppyImage(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getGuestOSType(
            [in] wstring id,
            [return] IGuestOSType type)
     */
    public org.virtualbox.IGuestOSType getGuestOSType(String id) {
        try {
            org.virtualbox.IGuestOSType retVal = port.iVirtualBoxGetGuestOSType(_this, id);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::createSharedFolder(
            [in] wstring name,
            [in] wstring hostPath,
            [in] boolean writable)
     */
    public void createSharedFolder(String name, String hostPath, Boolean writable) {
        try {
            port.iVirtualBoxCreateSharedFolder(_this, name, hostPath, writable);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::removeSharedFolder(
            [in] wstring name)
     */
    public void removeSharedFolder(String name) {
        try {
            port.iVirtualBoxRemoveSharedFolder(_this, name);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getNextExtraDataKey(
            [in] wstring key,
            [out] wstring nextKey,
            [out] wstring nextValue)
     */
    public void getNextExtraDataKey(String key, Holder<String> nextKey, Holder<String> nextValue) {
        try {
            port.iVirtualBoxGetNextExtraDataKey(_this, key, nextKey, nextValue);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::getExtraData(
            [in] wstring key,
            [return] wstring value)
     */
    public String getExtraData(String key) {
        try {
            String retVal = port.iVirtualBoxGetExtraData(_this, key);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::setExtraData(
            [in] wstring key,
            [in] wstring value)
     */
    public void setExtraData(String key, String value) {
        try {
            port.iVirtualBoxSetExtraData(_this, key, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openSession(
            [in] ISession session,
            [in] uuid machineId)
     */
    public void openSession(com.sun.xml.ws.commons.virtualbox.ISession session, UUID machineId) {
        try {
            port.iVirtualBoxOpenSession(_this, ((session == null)?null:session.getRef()), machineId.toString());
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openRemoteSession(
            [in] ISession session,
            [in] uuid machineId,
            [in] wstring type,
            [in] wstring environment,
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox.IProgress openRemoteSession(com.sun.xml.ws.commons.virtualbox.ISession session, UUID machineId, String type, String environment) {
        try {
            String retVal = port.iVirtualBoxOpenRemoteSession(_this, ((session == null)?null:session.getRef()), machineId.toString(), type, environment);
            return new com.sun.xml.ws.commons.virtualbox.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::openExistingSession(
            [in] ISession session,
            [in] uuid machineId)
     */
    public void openExistingSession(com.sun.xml.ws.commons.virtualbox.ISession session, UUID machineId) {
        try {
            port.iVirtualBoxOpenExistingSession(_this, ((session == null)?null:session.getRef()), machineId.toString());
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::waitForPropertyChange(
            [in] wstring what,
            [in] unsigned long timeout,
            [out] wstring changed,
            [out] wstring values)
     */
    public void waitForPropertyChange(String what, Long timeout, Holder<String> changed, Holder<String> values) {
        try {
            port.iVirtualBoxWaitForPropertyChange(_this, what, timeout, changed, values);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::saveSettings()
     */
    public void saveSettings() {
        try {
            port.iVirtualBoxSaveSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualBox::saveSettingsWithBackup(
            [return] wstring bakFileName)
     */
    public String saveSettingsWithBackup() {
        try {
            String retVal = port.iVirtualBoxSaveSettingsWithBackup(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
