# Copyright (C) 2008 Sun Microsystems, Inc.
#
# Sun Microsystems, Inc. confidential
# All rights reserved
#
# This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
#
from VirtualBox_services import *

g_port = vboxServiceLocator().getvboxPortType()

class ManagedManager:
  def __init__(self):
     self.map = {}

  def register(self,handle):
     if handle == None:
        return
     c = self.map.get(handle,0)
     c = c + 1
     self.map[handle]=c

  def unregister(self,handle):
     if handle == None:
        return
     c = self.map.get(handle,-1)
     if c == -1:
        raise Error, 'wrong refcount'
     c = c - 1
     if c == 0:
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass
        finally:
            self.map[handle] = -1
     else:
        self.map[handle] = c

g_manMgr = ManagedManager()

class String:
  def __init__(self, handle = None, isarray = False):
      self.handle = handle
      self.isarray = isarray
 
  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return String(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

  def __str__(self):
      return self.handle

  def __eq__(self,other):
      if self.isarray:
         return isinstance(other,String) and self.handle == other.handle
      if isinstance(other,String):
         return self.handle == other.handle
      if isinstance(other,basestring):
         return self.handle == other
      return False

  def __ne__(self,other):
      if self.isarray:
         return not isinstance(other,String) or self.handle == other.handle     
      if isinstance(other,String):
         return self.handle != other.handle
      if isinstance(other,basestring):
         return self.handle != other
      return True


class UUID:
  def __init__(self, handle = None, isarray = False):
      self.handle = handle
      self.isarray = isarray
 
  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return UUID(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

  def __str__(self):
      return self.handle

  def __eq__(self,other):
      if self.isarray:
         return isinstance(other,UUID) and self.handle == other.handle
      if isinstance(other,UUID):
         return self.handle == other.handle
      if isinstance(other,basestring):
         return self.handle == other
      return False

  def __ne__(self,other):
      if self.isarray:
         return not isinstance(other,UUID) or self.handle == other.handle     
      if isinstance(other,UUID):
         return self.handle != other.handle
      if isinstance(other,basestring):
         return self.handle != other
      return True

class Boolean:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return "true" if self.handle else "false"

  def __eq__(self,other):
      if isinstance(other,Bool):
         return self.handle == other.value
      if isinstance(other,bool):
         return self.handle == other
      return False

  def __ne__(self,other):
      if isinstance(other,Bool):
         return self.handle != other.handle
      if isinstance(other,bool):
         return self.handle != other
      return True

class UnsignedInt:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return UnsignedInt(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

    
class Int:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
       self.isarray = isarray

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return Int(self.handle[index])
      raise TypeError, "iteration over non-sequence"       
 
  def __str__(self):
       return str(self.handle)
  
  def __int__(self):
       return int(self.handle)

class UnsignedShort:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Short:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)
  
  def __int__(self):
       return int(self.handle)

class UnsignedLong:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Long:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Double:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Float:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)


class IUnknown:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)


class IVirtualBox:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualBox(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualBox._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVirtualBox._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createMachine(self, _arg_baseFolder, _arg_name, _arg_id):
       req=IVirtualBox_createMachineRequestMsg()
       req._this=self.handle
       
       req._baseFolder=_arg_baseFolder
       req._name=_arg_name
       req._id=_arg_id
       val=g_port.IVirtualBox_createMachine(req)
             
       return IMachine(val._returnval)

 
   def createLegacyMachine(self, _arg_settingsFile, _arg_name, _arg_id):
       req=IVirtualBox_createLegacyMachineRequestMsg()
       req._this=self.handle
       
       req._settingsFile=_arg_settingsFile
       req._name=_arg_name
       req._id=_arg_id
       val=g_port.IVirtualBox_createLegacyMachine(req)
             
       return IMachine(val._returnval)

 
   def openMachine(self, _arg_settingsFile):
       req=IVirtualBox_openMachineRequestMsg()
       req._this=self.handle
       
       req._settingsFile=_arg_settingsFile
       val=g_port.IVirtualBox_openMachine(req)
             
       return IMachine(val._returnval)

 
   def registerMachine(self, _arg_machine):
       req=IVirtualBox_registerMachineRequestMsg()
       req._this=self.handle
       
       req._machine=_arg_machine
       val=g_port.IVirtualBox_registerMachine(req)
             
       return 

 
   def getMachine(self, _arg_id):
       req=IVirtualBox_getMachineRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getMachine(req)
             
       return IMachine(val._returnval)

 
   def findMachine(self, _arg_name):
       req=IVirtualBox_findMachineRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IVirtualBox_findMachine(req)
             
       return IMachine(val._returnval)

 
   def unregisterMachine(self, _arg_id):
       req=IVirtualBox_unregisterMachineRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_unregisterMachine(req)
             
       return IMachine(val._returnval)

 
   def createHardDisk(self, _arg_storageType):
       req=IVirtualBox_createHardDiskRequestMsg()
       req._this=self.handle
       
       req._storageType=_arg_storageType
       val=g_port.IVirtualBox_createHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def openHardDisk(self, _arg_location):
       req=IVirtualBox_openHardDiskRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       val=g_port.IVirtualBox_openHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def openVirtualDiskImage(self, _arg_filePath):
       req=IVirtualBox_openVirtualDiskImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       val=g_port.IVirtualBox_openVirtualDiskImage(req)
             
       return IVirtualDiskImage(val._returnval)

 
   def registerHardDisk(self, _arg_hardDisk):
       req=IVirtualBox_registerHardDiskRequestMsg()
       req._this=self.handle
       
       req._hardDisk=_arg_hardDisk
       val=g_port.IVirtualBox_registerHardDisk(req)
             
       return 

 
   def getHardDisk(self, _arg_id):
       req=IVirtualBox_getHardDiskRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def findHardDisk(self, _arg_location):
       req=IVirtualBox_findHardDiskRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       val=g_port.IVirtualBox_findHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def findVirtualDiskImage(self, _arg_filePath):
       req=IVirtualBox_findVirtualDiskImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       val=g_port.IVirtualBox_findVirtualDiskImage(req)
             
       return IVirtualDiskImage(val._returnval)

 
   def unregisterHardDisk(self, _arg_id):
       req=IVirtualBox_unregisterHardDiskRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_unregisterHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def openDVDImage(self, _arg_filePath, _arg_id):
       req=IVirtualBox_openDVDImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       req._id=_arg_id
       val=g_port.IVirtualBox_openDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def registerDVDImage(self, _arg_image):
       req=IVirtualBox_registerDVDImageRequestMsg()
       req._this=self.handle
       
       req._image=_arg_image
       val=g_port.IVirtualBox_registerDVDImage(req)
             
       return 

 
   def getDVDImage(self, _arg_id):
       req=IVirtualBox_getDVDImageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def findDVDImage(self, _arg_filePath):
       req=IVirtualBox_findDVDImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       val=g_port.IVirtualBox_findDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def getDVDImageUsage(self, _arg_id, _arg_usage):
       req=IVirtualBox_getDVDImageUsageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._usage=_arg_usage
       val=g_port.IVirtualBox_getDVDImageUsage(req)
             
       return String(val._returnval)

 
   def unregisterDVDImage(self, _arg_id):
       req=IVirtualBox_unregisterDVDImageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_unregisterDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def openFloppyImage(self, _arg_filePath, _arg_id):
       req=IVirtualBox_openFloppyImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       req._id=_arg_id
       val=g_port.IVirtualBox_openFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def registerFloppyImage(self, _arg_image):
       req=IVirtualBox_registerFloppyImageRequestMsg()
       req._this=self.handle
       
       req._image=_arg_image
       val=g_port.IVirtualBox_registerFloppyImage(req)
             
       return 

 
   def getFloppyImage(self, _arg_id):
       req=IVirtualBox_getFloppyImageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def findFloppyImage(self, _arg_filePath):
       req=IVirtualBox_findFloppyImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       val=g_port.IVirtualBox_findFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def getFloppyImageUsage(self, _arg_id, _arg_usage):
       req=IVirtualBox_getFloppyImageUsageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._usage=_arg_usage
       val=g_port.IVirtualBox_getFloppyImageUsage(req)
             
       return String(val._returnval)

 
   def unregisterFloppyImage(self, _arg_id):
       req=IVirtualBox_unregisterFloppyImageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_unregisterFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def getGuestOSType(self, _arg_id):
       req=IVirtualBox_getGuestOSTypeRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getGuestOSType(req)
             
       return IGuestOSType(val._returnval)

 
   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable):
       req=IVirtualBox_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       val=g_port.IVirtualBox_createSharedFolder(req)
             
       return 

 
   def removeSharedFolder(self, _arg_name):
       req=IVirtualBox_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IVirtualBox_removeSharedFolder(req)
             
       return 

 
   def getNextExtraDataKey(self, _arg_key):
       req=IVirtualBox_getNextExtraDataKeyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IVirtualBox_getNextExtraDataKey(req)
             
       return String(val._nextKey), String(val._nextValue)

 
   def getExtraData(self, _arg_key):
       req=IVirtualBox_getExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IVirtualBox_getExtraData(req)
             
       return String(val._returnval)

 
   def setExtraData(self, _arg_key, _arg_value):
       req=IVirtualBox_setExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=g_port.IVirtualBox_setExtraData(req)
             
       return 

 
   def openSession(self, _arg_session, _arg_machineId):
       req=IVirtualBox_openSessionRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._machineId=_arg_machineId
       val=g_port.IVirtualBox_openSession(req)
             
       return 

 
   def openRemoteSession(self, _arg_session, _arg_machineId, _arg_type, _arg_environment):
       req=IVirtualBox_openRemoteSessionRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._machineId=_arg_machineId
       req._type=_arg_type
       req._environment=_arg_environment
       val=g_port.IVirtualBox_openRemoteSession(req)
             
       return IProgress(val._returnval)

 
   def openExistingSession(self, _arg_session, _arg_machineId):
       req=IVirtualBox_openExistingSessionRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._machineId=_arg_machineId
       val=g_port.IVirtualBox_openExistingSession(req)
             
       return 

 
   def registerCallback(self, _arg_callback):
       req=IVirtualBox_registerCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IVirtualBox_registerCallback(req)
             
       return 

 
   def unregisterCallback(self, _arg_callback):
       req=IVirtualBox_unregisterCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IVirtualBox_unregisterCallback(req)
             
       return 

 
   def waitForPropertyChange(self, _arg_what, _arg_timeout):
       req=IVirtualBox_waitForPropertyChangeRequestMsg()
       req._this=self.handle
       
       req._what=_arg_what
       req._timeout=_arg_timeout
       val=g_port.IVirtualBox_waitForPropertyChange(req)
             
       return String(val._changed), String(val._values)

 
   def saveSettings(self):
       req=IVirtualBox_saveSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualBox_saveSettings(req)
             
       return 

 
   def saveSettingsWithBackup(self):
       req=IVirtualBox_saveSettingsWithBackupRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualBox_saveSettingsWithBackup(req)
             
       return String(val._returnval)


   def getVersion(self):
       req=IVirtualBox_getVersionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getVersion(req)
       return  String(val._returnval)
   def getRevision(self):
       req=IVirtualBox_getRevisionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getRevision(req)
       return  UnsignedInt(val._returnval)
   def getPackageType(self):
       req=IVirtualBox_getPackageTypeRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getPackageType(req)
       return  String(val._returnval)
   def getHomeFolder(self):
       req=IVirtualBox_getHomeFolderRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getHomeFolder(req)
       return  String(val._returnval)
   def getSettingsFilePath(self):
       req=IVirtualBox_getSettingsFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSettingsFilePath(req)
       return  String(val._returnval)
   def getSettingsFileVersion(self):
       req=IVirtualBox_getSettingsFileVersionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSettingsFileVersion(req)
       return  String(val._returnval)
   def getSettingsFormatVersion(self):
       req=IVirtualBox_getSettingsFormatVersionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSettingsFormatVersion(req)
       return  String(val._returnval)
   def getHost(self):
       req=IVirtualBox_getHostRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getHost(req)
       return  IHost(val._returnval)
   def getSystemProperties(self):
       req=IVirtualBox_getSystemPropertiesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSystemProperties(req)
       return  ISystemProperties(val._returnval)
   def getMachines(self):
       req=IVirtualBox_getMachinesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getMachines(req)
       return  IMachineCollection(val._returnval)
   def getMachines2(self):
       req=IVirtualBox_getMachines2RequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getMachines2(req)
       return  IMachine(val._returnval, True)
   def getHardDisks(self):
       req=IVirtualBox_getHardDisksRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getHardDisks(req)
       return  IHardDiskCollection(val._returnval)
   def getDVDImages(self):
       req=IVirtualBox_getDVDImagesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getDVDImages(req)
       return  IDVDImageCollection(val._returnval)
   def getFloppyImages(self):
       req=IVirtualBox_getFloppyImagesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getFloppyImages(req)
       return  IFloppyImageCollection(val._returnval)
   def getProgressOperations(self):
       req=IVirtualBox_getProgressOperationsRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getProgressOperations(req)
       return  IProgressCollection(val._returnval)
   def getGuestOSTypes(self):
       req=IVirtualBox_getGuestOSTypesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getGuestOSTypes(req)
       return  IGuestOSTypeCollection(val._returnval)
   def getSharedFolders(self):
       req=IVirtualBox_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSharedFolders(req)
       return  ISharedFolderCollection(val._returnval)
   def getPerformanceCollector(self):
       req=IVirtualBox_getPerformanceCollectorRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getPerformanceCollector(req)
       return  IPerformanceCollector(val._returnval)


   _Attrs_={         'version':[getVersion,None],
         'revision':[getRevision,None],
         'packageType':[getPackageType,None],
         'homeFolder':[getHomeFolder,None],
         'settingsFilePath':[getSettingsFilePath,None],
         'settingsFileVersion':[getSettingsFileVersion,None],
         'settingsFormatVersion':[getSettingsFormatVersion,None],
         'host':[getHost,None],
         'systemProperties':[getSystemProperties,None],
         'machines':[getMachines,None],
         'machines2':[getMachines2,None],
         'hardDisks':[getHardDisks,None],
         'DVDImages':[getDVDImages,None],
         'FloppyImages':[getFloppyImages,None],
         'progressOperations':[getProgressOperations,None],
         'guestOSTypes':[getGuestOSTypes,None],
         'sharedFolders':[getSharedFolders,None],
         'performanceCollector':[getPerformanceCollector,None]}
class IBIOSSettings:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IBIOSSettings(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IBIOSSettings._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IBIOSSettings._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getLogoFadeIn(self):
       req=IBIOSSettings_getLogoFadeInRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoFadeIn(req)
       return  Boolean(val._returnval)
   def setLogoFadeIn(self, value):
       req=IBIOSSettings_setLogoFadeInRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoFadeIn = value
       else:
            req._logoFadeIn = value.handle
       g_port.IBIOSSettings_setLogoFadeIn(req)      

   def getLogoFadeOut(self):
       req=IBIOSSettings_getLogoFadeOutRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoFadeOut(req)
       return  Boolean(val._returnval)
   def setLogoFadeOut(self, value):
       req=IBIOSSettings_setLogoFadeOutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoFadeOut = value
       else:
            req._logoFadeOut = value.handle
       g_port.IBIOSSettings_setLogoFadeOut(req)      

   def getLogoDisplayTime(self):
       req=IBIOSSettings_getLogoDisplayTimeRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoDisplayTime(req)
       return  UnsignedInt(val._returnval)
   def setLogoDisplayTime(self, value):
       req=IBIOSSettings_setLogoDisplayTimeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoDisplayTime = value
       else:
            req._logoDisplayTime = value.handle
       g_port.IBIOSSettings_setLogoDisplayTime(req)      

   def getLogoImagePath(self):
       req=IBIOSSettings_getLogoImagePathRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoImagePath(req)
       return  String(val._returnval)
   def setLogoImagePath(self, value):
       req=IBIOSSettings_setLogoImagePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoImagePath = value
       else:
            req._logoImagePath = value.handle
       g_port.IBIOSSettings_setLogoImagePath(req)      

   def getBootMenuMode(self):
       req=IBIOSSettings_getBootMenuModeRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getBootMenuMode(req)
       return  BIOSBootMenuMode(val._returnval)
   def setBootMenuMode(self, value):
       req=IBIOSSettings_setBootMenuModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._bootMenuMode = value
       else:
            req._bootMenuMode = value.handle
       g_port.IBIOSSettings_setBootMenuMode(req)      

   def getACPIEnabled(self):
       req=IBIOSSettings_getACPIEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getACPIEnabled(req)
       return  Boolean(val._returnval)
   def setACPIEnabled(self, value):
       req=IBIOSSettings_setACPIEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._ACPIEnabled = value
       else:
            req._ACPIEnabled = value.handle
       g_port.IBIOSSettings_setACPIEnabled(req)      

   def getIOAPICEnabled(self):
       req=IBIOSSettings_getIOAPICEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getIOAPICEnabled(req)
       return  Boolean(val._returnval)
   def setIOAPICEnabled(self, value):
       req=IBIOSSettings_setIOAPICEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IOAPICEnabled = value
       else:
            req._IOAPICEnabled = value.handle
       g_port.IBIOSSettings_setIOAPICEnabled(req)      

   def getTimeOffset(self):
       req=IBIOSSettings_getTimeOffsetRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getTimeOffset(req)
       return  Long(val._returnval)
   def setTimeOffset(self, value):
       req=IBIOSSettings_setTimeOffsetRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._timeOffset = value
       else:
            req._timeOffset = value.handle
       g_port.IBIOSSettings_setTimeOffset(req)      

   def getPXEDebugEnabled(self):
       req=IBIOSSettings_getPXEDebugEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getPXEDebugEnabled(req)
       return  Boolean(val._returnval)
   def setPXEDebugEnabled(self, value):
       req=IBIOSSettings_setPXEDebugEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._PXEDebugEnabled = value
       else:
            req._PXEDebugEnabled = value.handle
       g_port.IBIOSSettings_setPXEDebugEnabled(req)      

   def getIDEControllerType(self):
       req=IBIOSSettings_getIDEControllerTypeRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getIDEControllerType(req)
       return  IDEControllerType(val._returnval)
   def setIDEControllerType(self, value):
       req=IBIOSSettings_setIDEControllerTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IDEControllerType = value
       else:
            req._IDEControllerType = value.handle
       g_port.IBIOSSettings_setIDEControllerType(req)      



   _Attrs_={         'logoFadeIn':[getLogoFadeIn,setLogoFadeIn,
        ],
         'logoFadeOut':[getLogoFadeOut,setLogoFadeOut,
        ],
         'logoDisplayTime':[getLogoDisplayTime,setLogoDisplayTime,
        ],
         'logoImagePath':[getLogoImagePath,setLogoImagePath,
        ],
         'bootMenuMode':[getBootMenuMode,setBootMenuMode,
        ],
         'ACPIEnabled':[getACPIEnabled,setACPIEnabled,
        ],
         'IOAPICEnabled':[getIOAPICEnabled,setIOAPICEnabled,
        ],
         'timeOffset':[getTimeOffset,setTimeOffset,
        ],
         'PXEDebugEnabled':[getPXEDebugEnabled,setPXEDebugEnabled,
        ],
         'IDEControllerType':[getIDEControllerType,setIDEControllerType,
        ]}
class IMachine:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IMachine(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachine._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IMachine._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def setBootOrder(self, _arg_position, _arg_device):
       req=IMachine_setBootOrderRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._device=_arg_device
       val=g_port.IMachine_setBootOrder(req)
             
       return 

 
   def getBootOrder(self, _arg_order):
       req=IMachine_getBootOrderRequestMsg()
       req._this=self.handle
       
       req._order=_arg_order
       val=g_port.IMachine_getBootOrder(req)
             
       return DeviceType(val._returnval)

 
   def attachHardDisk(self, _arg_id, _arg_bus, _arg_channel, _arg_device):
       req=IMachine_attachHardDiskRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._bus=_arg_bus
       req._channel=_arg_channel
       req._device=_arg_device
       val=g_port.IMachine_attachHardDisk(req)
             
       return 

 
   def getHardDisk(self, _arg_bus, _arg_channel, _arg_device):
       req=IMachine_getHardDiskRequestMsg()
       req._this=self.handle
       
       req._bus=_arg_bus
       req._channel=_arg_channel
       req._device=_arg_device
       val=g_port.IMachine_getHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def detachHardDisk(self, _arg_bus, _arg_channel, _arg_device):
       req=IMachine_detachHardDiskRequestMsg()
       req._this=self.handle
       
       req._bus=_arg_bus
       req._channel=_arg_channel
       req._device=_arg_device
       val=g_port.IMachine_detachHardDisk(req)
             
       return 

 
   def getNetworkAdapter(self, _arg_slot):
       req=IMachine_getNetworkAdapterRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=g_port.IMachine_getNetworkAdapter(req)
             
       return INetworkAdapter(val._returnval)

 
   def getSerialPort(self, _arg_slot):
       req=IMachine_getSerialPortRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=g_port.IMachine_getSerialPort(req)
             
       return ISerialPort(val._returnval)

 
   def getParallelPort(self, _arg_slot):
       req=IMachine_getParallelPortRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=g_port.IMachine_getParallelPort(req)
             
       return IParallelPort(val._returnval)

 
   def getNextExtraDataKey(self, _arg_key):
       req=IMachine_getNextExtraDataKeyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IMachine_getNextExtraDataKey(req)
             
       return String(val._nextKey), String(val._nextValue)

 
   def getExtraData(self, _arg_key):
       req=IMachine_getExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IMachine_getExtraData(req)
             
       return String(val._returnval)

 
   def setExtraData(self, _arg_key, _arg_value):
       req=IMachine_setExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=g_port.IMachine_setExtraData(req)
             
       return 

 
   def saveSettings(self):
       req=IMachine_saveSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_saveSettings(req)
             
       return 

 
   def saveSettingsWithBackup(self):
       req=IMachine_saveSettingsWithBackupRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_saveSettingsWithBackup(req)
             
       return String(val._returnval)

 
   def discardSettings(self):
       req=IMachine_discardSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_discardSettings(req)
             
       return 

 
   def deleteSettings(self):
       req=IMachine_deleteSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_deleteSettings(req)
             
       return 

 
   def getSnapshot(self, _arg_id):
       req=IMachine_getSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IMachine_getSnapshot(req)
             
       return ISnapshot(val._returnval)

 
   def findSnapshot(self, _arg_name):
       req=IMachine_findSnapshotRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_findSnapshot(req)
             
       return ISnapshot(val._returnval)

 
   def setCurrentSnapshot(self, _arg_id):
       req=IMachine_setCurrentSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IMachine_setCurrentSnapshot(req)
             
       return 

 
   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable):
       req=IMachine_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       val=g_port.IMachine_createSharedFolder(req)
             
       return 

 
   def removeSharedFolder(self, _arg_name):
       req=IMachine_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_removeSharedFolder(req)
             
       return 

 
   def canShowConsoleWindow(self):
       req=IMachine_canShowConsoleWindowRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_canShowConsoleWindow(req)
             
       return Boolean(val._returnval)

 
   def showConsoleWindow(self):
       req=IMachine_showConsoleWindowRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_showConsoleWindow(req)
             
       return UnsignedLong(val._returnval)

 
   def getGuestProperty(self, _arg_name):
       req=IMachine_getGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_getGuestProperty(req)
             
       return String(val._value), UnsignedLong(val._timestamp), String(val._flags)

 
   def getGuestPropertyValue(self, _arg_property):
       req=IMachine_getGuestPropertyValueRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=g_port.IMachine_getGuestPropertyValue(req)
             
       return String(val._returnval)

 
   def getGuestPropertyTimestamp(self, _arg_property):
       req=IMachine_getGuestPropertyTimestampRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=g_port.IMachine_getGuestPropertyTimestamp(req)
             
       return UnsignedLong(val._returnval)

 
   def setGuestProperty(self, _arg_property, _arg_value, _arg_flags):
       req=IMachine_setGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       req._flags=_arg_flags
       val=g_port.IMachine_setGuestProperty(req)
             
       return 

 
   def setGuestPropertyValue(self, _arg_property, _arg_value):
       req=IMachine_setGuestPropertyValueRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       val=g_port.IMachine_setGuestPropertyValue(req)
             
       return 

 
   def enumerateGuestProperties(self, _arg_patterns):
       req=IMachine_enumerateGuestPropertiesRequestMsg()
       req._this=self.handle
       
       req._patterns=_arg_patterns
       val=g_port.IMachine_enumerateGuestProperties(req)
             
       return String(val._name, True), String(val._value, True), UnsignedLong(val._timestamp, True), String(val._flags, True)


   def getParent(self):
       req=IMachine_getParentRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getParent(req)
       return  IVirtualBox(val._returnval)
   def getAccessible(self):
       req=IMachine_getAccessibleRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getAccessible(req)
       return  Boolean(val._returnval)
   def getName(self):
       req=IMachine_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getName(req)
       return  String(val._returnval)
   def setName(self, value):
       req=IMachine_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._name = value
       else:
            req._name = value.handle
       g_port.IMachine_setName(req)      

   def getDescription(self):
       req=IMachine_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getDescription(req)
       return  String(val._returnval)
   def setDescription(self, value):
       req=IMachine_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._description = value
       else:
            req._description = value.handle
       g_port.IMachine_setDescription(req)      

   def getId(self):
       req=IMachine_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getId(req)
       return  UUID(val._returnval)
   def getOSTypeId(self):
       req=IMachine_getOSTypeIdRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getOSTypeId(req)
       return  String(val._returnval)
   def setOSTypeId(self, value):
       req=IMachine_setOSTypeIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._OSTypeId = value
       else:
            req._OSTypeId = value.handle
       g_port.IMachine_setOSTypeId(req)      

   def getMemorySize(self):
       req=IMachine_getMemorySizeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getMemorySize(req)
       return  UnsignedInt(val._returnval)
   def setMemorySize(self, value):
       req=IMachine_setMemorySizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._memorySize = value
       else:
            req._memorySize = value.handle
       g_port.IMachine_setMemorySize(req)      

   def getMemoryBalloonSize(self):
       req=IMachine_getMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getMemoryBalloonSize(req)
       return  UnsignedInt(val._returnval)
   def setMemoryBalloonSize(self, value):
       req=IMachine_setMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._memoryBalloonSize = value
       else:
            req._memoryBalloonSize = value.handle
       g_port.IMachine_setMemoryBalloonSize(req)      

   def getStatisticsUpdateInterval(self):
       req=IMachine_getStatisticsUpdateIntervalRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getStatisticsUpdateInterval(req)
       return  UnsignedInt(val._returnval)
   def setStatisticsUpdateInterval(self, value):
       req=IMachine_setStatisticsUpdateIntervalRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._statisticsUpdateInterval = value
       else:
            req._statisticsUpdateInterval = value.handle
       g_port.IMachine_setStatisticsUpdateInterval(req)      

   def getVRAMSize(self):
       req=IMachine_getVRAMSizeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getVRAMSize(req)
       return  UnsignedInt(val._returnval)
   def setVRAMSize(self, value):
       req=IMachine_setVRAMSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._VRAMSize = value
       else:
            req._VRAMSize = value.handle
       g_port.IMachine_setVRAMSize(req)      

   def getMonitorCount(self):
       req=IMachine_getMonitorCountRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getMonitorCount(req)
       return  UnsignedInt(val._returnval)
   def setMonitorCount(self, value):
       req=IMachine_setMonitorCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._MonitorCount = value
       else:
            req._MonitorCount = value.handle
       g_port.IMachine_setMonitorCount(req)      

   def getBIOSSettings(self):
       req=IMachine_getBIOSSettingsRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getBIOSSettings(req)
       return  IBIOSSettings(val._returnval)
   def getHWVirtExEnabled(self):
       req=IMachine_getHWVirtExEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHWVirtExEnabled(req)
       return  TSBool(val._returnval)
   def setHWVirtExEnabled(self, value):
       req=IMachine_setHWVirtExEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExEnabled = value
       else:
            req._HWVirtExEnabled = value.handle
       g_port.IMachine_setHWVirtExEnabled(req)      

   def getHWVirtExNestedPagingEnabled(self):
       req=IMachine_getHWVirtExNestedPagingEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHWVirtExNestedPagingEnabled(req)
       return  Boolean(val._returnval)
   def setHWVirtExNestedPagingEnabled(self, value):
       req=IMachine_setHWVirtExNestedPagingEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExNestedPagingEnabled = value
       else:
            req._HWVirtExNestedPagingEnabled = value.handle
       g_port.IMachine_setHWVirtExNestedPagingEnabled(req)      

   def getPAEEnabled(self):
       req=IMachine_getPAEEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getPAEEnabled(req)
       return  Boolean(val._returnval)
   def setPAEEnabled(self, value):
       req=IMachine_setPAEEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._PAEEnabled = value
       else:
            req._PAEEnabled = value.handle
       g_port.IMachine_setPAEEnabled(req)      

   def getSnapshotFolder(self):
       req=IMachine_getSnapshotFolderRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSnapshotFolder(req)
       return  String(val._returnval)
   def setSnapshotFolder(self, value):
       req=IMachine_setSnapshotFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._snapshotFolder = value
       else:
            req._snapshotFolder = value.handle
       g_port.IMachine_setSnapshotFolder(req)      

   def getVRDPServer(self):
       req=IMachine_getVRDPServerRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getVRDPServer(req)
       return  IVRDPServer(val._returnval)
   def getHardDiskAttachments(self):
       req=IMachine_getHardDiskAttachmentsRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHardDiskAttachments(req)
       return  IHardDiskAttachmentCollection(val._returnval)
   def getDVDDrive(self):
       req=IMachine_getDVDDriveRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getDVDDrive(req)
       return  IDVDDrive(val._returnval)
   def getFloppyDrive(self):
       req=IMachine_getFloppyDriveRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getFloppyDrive(req)
       return  IFloppyDrive(val._returnval)
   def getUSBController(self):
       req=IMachine_getUSBControllerRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getUSBController(req)
       return  IUSBController(val._returnval)
   def getAudioAdapter(self):
       req=IMachine_getAudioAdapterRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getAudioAdapter(req)
       return  IAudioAdapter(val._returnval)
   def getSATAController(self):
       req=IMachine_getSATAControllerRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSATAController(req)
       return  ISATAController(val._returnval)
   def getSettingsFilePath(self):
       req=IMachine_getSettingsFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSettingsFilePath(req)
       return  String(val._returnval)
   def getSettingsFileVersion(self):
       req=IMachine_getSettingsFileVersionRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSettingsFileVersion(req)
       return  String(val._returnval)
   def getSettingsModified(self):
       req=IMachine_getSettingsModifiedRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSettingsModified(req)
       return  Boolean(val._returnval)
   def getSessionState(self):
       req=IMachine_getSessionStateRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSessionState(req)
       return  SessionState(val._returnval)
   def getSessionType(self):
       req=IMachine_getSessionTypeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSessionType(req)
       return  String(val._returnval)
   def getSessionPid(self):
       req=IMachine_getSessionPidRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSessionPid(req)
       return  UnsignedInt(val._returnval)
   def getState(self):
       req=IMachine_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getState(req)
       return  MachineState(val._returnval)
   def getLastStateChange(self):
       req=IMachine_getLastStateChangeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getLastStateChange(req)
       return  Long(val._returnval)
   def getStateFilePath(self):
       req=IMachine_getStateFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getStateFilePath(req)
       return  String(val._returnval)
   def getLogFolder(self):
       req=IMachine_getLogFolderRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getLogFolder(req)
       return  String(val._returnval)
   def getCurrentSnapshot(self):
       req=IMachine_getCurrentSnapshotRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getCurrentSnapshot(req)
       return  ISnapshot(val._returnval)
   def getSnapshotCount(self):
       req=IMachine_getSnapshotCountRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSnapshotCount(req)
       return  UnsignedInt(val._returnval)
   def getCurrentStateModified(self):
       req=IMachine_getCurrentStateModifiedRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getCurrentStateModified(req)
       return  Boolean(val._returnval)
   def getSharedFolders(self):
       req=IMachine_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSharedFolders(req)
       return  ISharedFolderCollection(val._returnval)
   def getClipboardMode(self):
       req=IMachine_getClipboardModeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getClipboardMode(req)
       return  ClipboardMode(val._returnval)
   def setClipboardMode(self, value):
       req=IMachine_setClipboardModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._clipboardMode = value
       else:
            req._clipboardMode = value.handle
       g_port.IMachine_setClipboardMode(req)      



   _Attrs_={         'parent':[getParent,None],
         'accessible':[getAccessible,None],
         'name':[getName,setName,
        ],
         'description':[getDescription,setDescription,
        ],
         'id':[getId,None],
         'OSTypeId':[getOSTypeId,setOSTypeId,
        ],
         'memorySize':[getMemorySize,setMemorySize,
        ],
         'memoryBalloonSize':[getMemoryBalloonSize,setMemoryBalloonSize,
        ],
         'statisticsUpdateInterval':[getStatisticsUpdateInterval,setStatisticsUpdateInterval,
        ],
         'VRAMSize':[getVRAMSize,setVRAMSize,
        ],
         'MonitorCount':[getMonitorCount,setMonitorCount,
        ],
         'BIOSSettings':[getBIOSSettings,None],
         'HWVirtExEnabled':[getHWVirtExEnabled,setHWVirtExEnabled,
        ],
         'HWVirtExNestedPagingEnabled':[getHWVirtExNestedPagingEnabled,setHWVirtExNestedPagingEnabled,
        ],
         'PAEEnabled':[getPAEEnabled,setPAEEnabled,
        ],
         'snapshotFolder':[getSnapshotFolder,setSnapshotFolder,
        ],
         'VRDPServer':[getVRDPServer,None],
         'hardDiskAttachments':[getHardDiskAttachments,None],
         'DVDDrive':[getDVDDrive,None],
         'FloppyDrive':[getFloppyDrive,None],
         'USBController':[getUSBController,None],
         'audioAdapter':[getAudioAdapter,None],
         'SATAController':[getSATAController,None],
         'settingsFilePath':[getSettingsFilePath,None],
         'settingsFileVersion':[getSettingsFileVersion,None],
         'settingsModified':[getSettingsModified,None],
         'sessionState':[getSessionState,None],
         'sessionType':[getSessionType,None],
         'sessionPid':[getSessionPid,None],
         'state':[getState,None],
         'lastStateChange':[getLastStateChange,None],
         'stateFilePath':[getStateFilePath,None],
         'logFolder':[getLogFolder,None],
         'currentSnapshot':[getCurrentSnapshot,None],
         'snapshotCount':[getSnapshotCount,None],
         'currentStateModified':[getCurrentStateModified,None],
         'sharedFolders':[getSharedFolders,None],
         'clipboardMode':[getClipboardMode,setClipboardMode,
        ]}
class IConsole:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IConsole(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IConsole._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IConsole._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def powerUp(self):
       req=IConsole_powerUpRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerUp(req)
             
       return IProgress(val._returnval)

 
   def powerDown(self):
       req=IConsole_powerDownRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerDown(req)
             
       return 

 
   def powerDownAsync(self):
       req=IConsole_powerDownAsyncRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerDownAsync(req)
             
       return IProgress(val._returnval)

 
   def reset(self):
       req=IConsole_resetRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_reset(req)
             
       return 

 
   def pause(self):
       req=IConsole_pauseRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_pause(req)
             
       return 

 
   def resume(self):
       req=IConsole_resumeRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_resume(req)
             
       return 

 
   def powerButton(self):
       req=IConsole_powerButtonRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerButton(req)
             
       return 

 
   def sleepButton(self):
       req=IConsole_sleepButtonRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_sleepButton(req)
             
       return 

 
   def getPowerButtonHandled(self):
       req=IConsole_getPowerButtonHandledRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_getPowerButtonHandled(req)
             
       return Boolean(val._returnval)

 
   def saveState(self):
       req=IConsole_saveStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_saveState(req)
             
       return IProgress(val._returnval)

 
   def adoptSavedState(self, _arg_savedStateFile):
       req=IConsole_adoptSavedStateRequestMsg()
       req._this=self.handle
       
       req._savedStateFile=_arg_savedStateFile
       val=g_port.IConsole_adoptSavedState(req)
             
       return 

 
   def discardSavedState(self):
       req=IConsole_discardSavedStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_discardSavedState(req)
             
       return 

 
   def getDeviceActivity(self, _arg_type):
       req=IConsole_getDeviceActivityRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=g_port.IConsole_getDeviceActivity(req)
             
       return DeviceActivity(val._returnval)

 
   def attachUSBDevice(self, _arg_id):
       req=IConsole_attachUSBDeviceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_attachUSBDevice(req)
             
       return 

 
   def detachUSBDevice(self, _arg_id):
       req=IConsole_detachUSBDeviceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_detachUSBDevice(req)
             
       return IUSBDevice(val._returnval)

 
   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable):
       req=IConsole_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       val=g_port.IConsole_createSharedFolder(req)
             
       return 

 
   def removeSharedFolder(self, _arg_name):
       req=IConsole_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IConsole_removeSharedFolder(req)
             
       return 

 
   def takeSnapshot(self, _arg_name, _arg_description):
       req=IConsole_takeSnapshotRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._description=_arg_description
       val=g_port.IConsole_takeSnapshot(req)
             
       return IProgress(val._returnval)

 
   def discardSnapshot(self, _arg_id):
       req=IConsole_discardSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_discardSnapshot(req)
             
       return IProgress(val._returnval)

 
   def discardCurrentState(self):
       req=IConsole_discardCurrentStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_discardCurrentState(req)
             
       return IProgress(val._returnval)

 
   def discardCurrentSnapshotAndState(self):
       req=IConsole_discardCurrentSnapshotAndStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_discardCurrentSnapshotAndState(req)
             
       return IProgress(val._returnval)

 
   def registerCallback(self, _arg_callback):
       req=IConsole_registerCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IConsole_registerCallback(req)
             
       return 

 
   def unregisterCallback(self, _arg_callback):
       req=IConsole_unregisterCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IConsole_unregisterCallback(req)
             
       return 


   def getMachine(self):
       req=IConsole_getMachineRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getMachine(req)
       return  IMachine(val._returnval)
   def getState(self):
       req=IConsole_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getState(req)
       return  MachineState(val._returnval)
   def getKeyboard(self):
       req=IConsole_getKeyboardRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getKeyboard(req)
       return  IKeyboard(val._returnval)
   def getMouse(self):
       req=IConsole_getMouseRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getMouse(req)
       return  IMouse(val._returnval)
   def getUSBDevices(self):
       req=IConsole_getUSBDevicesRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getUSBDevices(req)
       return  IUSBDeviceCollection(val._returnval)
   def getRemoteUSBDevices(self):
       req=IConsole_getRemoteUSBDevicesRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getRemoteUSBDevices(req)
       return  IHostUSBDeviceCollection(val._returnval)
   def getSharedFolders(self):
       req=IConsole_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getSharedFolders(req)
       return  ISharedFolderCollection(val._returnval)
   def getRemoteDisplayInfo(self):
       req=IConsole_getRemoteDisplayInfoRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getRemoteDisplayInfo(req)
       return  IRemoteDisplayInfo(val._returnval)


   _Attrs_={         'machine':[getMachine,None],
         'state':[getState,None],
         'keyboard':[getKeyboard,None],
         'mouse':[getMouse,None],
         'USBDevices':[getUSBDevices,None],
         'remoteUSBDevices':[getRemoteUSBDevices,None],
         'sharedFolders':[getSharedFolders,None],
         'remoteDisplayInfo':[getRemoteDisplayInfo,None]}
class IHostDVDDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostDVDDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IHostDVDDrive_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostDVDDrive_getName(req)
       return  String(val._returnval)
   def getDescription(self):
       req=IHostDVDDrive_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IHostDVDDrive_getDescription(req)
       return  String(val._returnval)
   def getUdi(self):
       req=IHostDVDDrive_getUdiRequestMsg()
       req._this=self.handle
       val=g_port.IHostDVDDrive_getUdi(req)
       return  String(val._returnval)


   _Attrs_={         'name':[getName,None],
         'description':[getDescription,None],
         'udi':[getUdi,None]}
class IHostFloppyDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostFloppyDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IHostFloppyDrive_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostFloppyDrive_getName(req)
       return  String(val._returnval)
   def getDescription(self):
       req=IHostFloppyDrive_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IHostFloppyDrive_getDescription(req)
       return  String(val._returnval)
   def getUdi(self):
       req=IHostFloppyDrive_getUdiRequestMsg()
       req._this=self.handle
       val=g_port.IHostFloppyDrive_getUdi(req)
       return  String(val._returnval)


   _Attrs_={         'name':[getName,None],
         'description':[getDescription,None],
         'udi':[getUdi,None]}
class IHostNetworkInterface:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostNetworkInterface(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostNetworkInterface._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostNetworkInterface._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IHostNetworkInterface_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getName(req)
       return  String(val._returnval)
   def getId(self):
       req=IHostNetworkInterface_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getId(req)
       return  UUID(val._returnval)


   _Attrs_={         'name':[getName,None],
         'id':[getId,None]}
class IHost:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHost(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHost._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHost._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getProcessorSpeed(self, _arg_cpuId):
       req=IHost_getProcessorSpeedRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=g_port.IHost_getProcessorSpeed(req)
             
       return UnsignedInt(val._returnval)

 
   def getProcessorDescription(self, _arg_cpuId):
       req=IHost_getProcessorDescriptionRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=g_port.IHost_getProcessorDescription(req)
             
       return String(val._returnval)

 
   def createUSBDeviceFilter(self, _arg_name):
       req=IHost_createUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHost_createUSBDeviceFilter(req)
             
       return IHostUSBDeviceFilter(val._returnval)

 
   def insertUSBDeviceFilter(self, _arg_position, _arg_filter):
       req=IHost_insertUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._filter=_arg_filter
       val=g_port.IHost_insertUSBDeviceFilter(req)
             
       return 

 
   def removeUSBDeviceFilter(self, _arg_position):
       req=IHost_removeUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=g_port.IHost_removeUSBDeviceFilter(req)
             
       return IHostUSBDeviceFilter(val._returnval)


   def getDVDDrives(self):
       req=IHost_getDVDDrivesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getDVDDrives(req)
       return  IHostDVDDriveCollection(val._returnval)
   def getFloppyDrives(self):
       req=IHost_getFloppyDrivesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getFloppyDrives(req)
       return  IHostFloppyDriveCollection(val._returnval)
   def getUSBDevices(self):
       req=IHost_getUSBDevicesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getUSBDevices(req)
       return  IHostUSBDeviceCollection(val._returnval)
   def getUSBDeviceFilters(self):
       req=IHost_getUSBDeviceFiltersRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getUSBDeviceFilters(req)
       return  IHostUSBDeviceFilterCollection(val._returnval)
   def getNetworkInterfaces(self):
       req=IHost_getNetworkInterfacesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getNetworkInterfaces(req)
       return  IHostNetworkInterfaceCollection(val._returnval)
   def getProcessorCount(self):
       req=IHost_getProcessorCountRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getProcessorCount(req)
       return  UnsignedInt(val._returnval)
   def getProcessorOnlineCount(self):
       req=IHost_getProcessorOnlineCountRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getProcessorOnlineCount(req)
       return  UnsignedInt(val._returnval)
   def getMemorySize(self):
       req=IHost_getMemorySizeRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getMemorySize(req)
       return  UnsignedInt(val._returnval)
   def getMemoryAvailable(self):
       req=IHost_getMemoryAvailableRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getMemoryAvailable(req)
       return  UnsignedInt(val._returnval)
   def getOperatingSystem(self):
       req=IHost_getOperatingSystemRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getOperatingSystem(req)
       return  String(val._returnval)
   def getOSVersion(self):
       req=IHost_getOSVersionRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getOSVersion(req)
       return  String(val._returnval)
   def getUTCTime(self):
       req=IHost_getUTCTimeRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getUTCTime(req)
       return  Long(val._returnval)


   _Attrs_={         'DVDDrives':[getDVDDrives,None],
         'floppyDrives':[getFloppyDrives,None],
         'USBDevices':[getUSBDevices,None],
         'USBDeviceFilters':[getUSBDeviceFilters,None],
         'networkInterfaces':[getNetworkInterfaces,None],
         'processorCount':[getProcessorCount,None],
         'processorOnlineCount':[getProcessorOnlineCount,None],
         'memorySize':[getMemorySize,None],
         'memoryAvailable':[getMemoryAvailable,None],
         'operatingSystem':[getOperatingSystem,None],
         'OSVersion':[getOSVersion,None],
         'UTCTime':[getUTCTime,None]}
class ISystemProperties:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISystemProperties(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISystemProperties._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISystemProperties._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMinGuestRAM(self):
       req=ISystemProperties_getMinGuestRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMinGuestRAM(req)
       return  UnsignedInt(val._returnval)
   def getMaxGuestRAM(self):
       req=ISystemProperties_getMaxGuestRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxGuestRAM(req)
       return  UnsignedInt(val._returnval)
   def getMinGuestVRAM(self):
       req=ISystemProperties_getMinGuestVRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMinGuestVRAM(req)
       return  UnsignedInt(val._returnval)
   def getMaxGuestVRAM(self):
       req=ISystemProperties_getMaxGuestVRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxGuestVRAM(req)
       return  UnsignedInt(val._returnval)
   def getMaxVDISize(self):
       req=ISystemProperties_getMaxVDISizeRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxVDISize(req)
       return  UnsignedLong(val._returnval)
   def getNetworkAdapterCount(self):
       req=ISystemProperties_getNetworkAdapterCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getNetworkAdapterCount(req)
       return  UnsignedInt(val._returnval)
   def getSerialPortCount(self):
       req=ISystemProperties_getSerialPortCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getSerialPortCount(req)
       return  UnsignedInt(val._returnval)
   def getParallelPortCount(self):
       req=ISystemProperties_getParallelPortCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getParallelPortCount(req)
       return  UnsignedInt(val._returnval)
   def getMaxBootPosition(self):
       req=ISystemProperties_getMaxBootPositionRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxBootPosition(req)
       return  UnsignedInt(val._returnval)
   def getDefaultVDIFolder(self):
       req=ISystemProperties_getDefaultVDIFolderRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getDefaultVDIFolder(req)
       return  String(val._returnval)
   def setDefaultVDIFolder(self, value):
       req=ISystemProperties_setDefaultVDIFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._defaultVDIFolder = value
       else:
            req._defaultVDIFolder = value.handle
       g_port.ISystemProperties_setDefaultVDIFolder(req)      

   def getDefaultMachineFolder(self):
       req=ISystemProperties_getDefaultMachineFolderRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getDefaultMachineFolder(req)
       return  String(val._returnval)
   def setDefaultMachineFolder(self, value):
       req=ISystemProperties_setDefaultMachineFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._defaultMachineFolder = value
       else:
            req._defaultMachineFolder = value.handle
       g_port.ISystemProperties_setDefaultMachineFolder(req)      

   def getRemoteDisplayAuthLibrary(self):
       req=ISystemProperties_getRemoteDisplayAuthLibraryRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getRemoteDisplayAuthLibrary(req)
       return  String(val._returnval)
   def setRemoteDisplayAuthLibrary(self, value):
       req=ISystemProperties_setRemoteDisplayAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._remoteDisplayAuthLibrary = value
       else:
            req._remoteDisplayAuthLibrary = value.handle
       g_port.ISystemProperties_setRemoteDisplayAuthLibrary(req)      

   def getWebServiceAuthLibrary(self):
       req=ISystemProperties_getWebServiceAuthLibraryRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getWebServiceAuthLibrary(req)
       return  String(val._returnval)
   def setWebServiceAuthLibrary(self, value):
       req=ISystemProperties_setWebServiceAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._webServiceAuthLibrary = value
       else:
            req._webServiceAuthLibrary = value.handle
       g_port.ISystemProperties_setWebServiceAuthLibrary(req)      

   def getHWVirtExEnabled(self):
       req=ISystemProperties_getHWVirtExEnabledRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getHWVirtExEnabled(req)
       return  Boolean(val._returnval)
   def setHWVirtExEnabled(self, value):
       req=ISystemProperties_setHWVirtExEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExEnabled = value
       else:
            req._HWVirtExEnabled = value.handle
       g_port.ISystemProperties_setHWVirtExEnabled(req)      

   def getLogHistoryCount(self):
       req=ISystemProperties_getLogHistoryCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getLogHistoryCount(req)
       return  UnsignedInt(val._returnval)
   def setLogHistoryCount(self, value):
       req=ISystemProperties_setLogHistoryCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._LogHistoryCount = value
       else:
            req._LogHistoryCount = value.handle
       g_port.ISystemProperties_setLogHistoryCount(req)      



   _Attrs_={         'minGuestRAM':[getMinGuestRAM,None],
         'maxGuestRAM':[getMaxGuestRAM,None],
         'minGuestVRAM':[getMinGuestVRAM,None],
         'maxGuestVRAM':[getMaxGuestVRAM,None],
         'maxVDISize':[getMaxVDISize,None],
         'networkAdapterCount':[getNetworkAdapterCount,None],
         'serialPortCount':[getSerialPortCount,None],
         'parallelPortCount':[getParallelPortCount,None],
         'maxBootPosition':[getMaxBootPosition,None],
         'defaultVDIFolder':[getDefaultVDIFolder,setDefaultVDIFolder,
        ],
         'defaultMachineFolder':[getDefaultMachineFolder,setDefaultMachineFolder,
        ],
         'remoteDisplayAuthLibrary':[getRemoteDisplayAuthLibrary,setRemoteDisplayAuthLibrary,
        ],
         'webServiceAuthLibrary':[getWebServiceAuthLibrary,setWebServiceAuthLibrary,
        ],
         'HWVirtExEnabled':[getHWVirtExEnabled,setHWVirtExEnabled,
        ],
         'LogHistoryCount':[getLogHistoryCount,setLogHistoryCount,
        ]}
class IProgress:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IProgress(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IProgress._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IProgress._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def waitForCompletion(self, _arg_timeout):
       req=IProgress_waitForCompletionRequestMsg()
       req._this=self.handle
       
       req._timeout=_arg_timeout
       val=g_port.IProgress_waitForCompletion(req)
             
       return 

 
   def waitForOperationCompletion(self, _arg_operation, _arg_timeout):
       req=IProgress_waitForOperationCompletionRequestMsg()
       req._this=self.handle
       
       req._operation=_arg_operation
       req._timeout=_arg_timeout
       val=g_port.IProgress_waitForOperationCompletion(req)
             
       return 

 
   def cancel(self):
       req=IProgress_cancelRequestMsg()
       req._this=self.handle
       
       val=g_port.IProgress_cancel(req)
             
       return 


   def getId(self):
       req=IProgress_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getId(req)
       return  UUID(val._returnval)
   def getDescription(self):
       req=IProgress_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getDescription(req)
       return  String(val._returnval)
   def getCancelable(self):
       req=IProgress_getCancelableRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getCancelable(req)
       return  Boolean(val._returnval)
   def getPercent(self):
       req=IProgress_getPercentRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getPercent(req)
       return  Int(val._returnval)
   def getCompleted(self):
       req=IProgress_getCompletedRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getCompleted(req)
       return  Boolean(val._returnval)
   def getCanceled(self):
       req=IProgress_getCanceledRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getCanceled(req)
       return  Boolean(val._returnval)
   def getResultCode(self):
       req=IProgress_getResultCodeRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getResultCode(req)
       return  UnsignedInt(val._returnval)
   def getOperationCount(self):
       req=IProgress_getOperationCountRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperationCount(req)
       return  UnsignedInt(val._returnval)
   def getOperation(self):
       req=IProgress_getOperationRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperation(req)
       return  UnsignedInt(val._returnval)
   def getOperationDescription(self):
       req=IProgress_getOperationDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperationDescription(req)
       return  String(val._returnval)
   def getOperationPercent(self):
       req=IProgress_getOperationPercentRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperationPercent(req)
       return  Int(val._returnval)


   _Attrs_={         'id':[getId,None],
         'description':[getDescription,None],
         'cancelable':[getCancelable,None],
         'percent':[getPercent,None],
         'completed':[getCompleted,None],
         'canceled':[getCanceled,None],
         'resultCode':[getResultCode,None],
         'operationCount':[getOperationCount,None],
         'operation':[getOperation,None],
         'operationDescription':[getOperationDescription,None],
         'operationPercent':[getOperationPercent,None]}
class ISnapshot:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshot(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshot._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISnapshot._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=ISnapshot_getIdRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getId(req)
       return  UUID(val._returnval)
   def getName(self):
       req=ISnapshot_getNameRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getName(req)
       return  String(val._returnval)
   def setName(self, value):
       req=ISnapshot_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._name = value
       else:
            req._name = value.handle
       g_port.ISnapshot_setName(req)      

   def getDescription(self):
       req=ISnapshot_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getDescription(req)
       return  String(val._returnval)
   def setDescription(self, value):
       req=ISnapshot_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._description = value
       else:
            req._description = value.handle
       g_port.ISnapshot_setDescription(req)      

   def getTimeStamp(self):
       req=ISnapshot_getTimeStampRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getTimeStamp(req)
       return  Long(val._returnval)
   def getOnline(self):
       req=ISnapshot_getOnlineRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getOnline(req)
       return  Boolean(val._returnval)
   def getMachine(self):
       req=ISnapshot_getMachineRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getMachine(req)
       return  IMachine(val._returnval)
   def getParent(self):
       req=ISnapshot_getParentRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getParent(req)
       return  ISnapshot(val._returnval)
   def getChildren(self):
       req=ISnapshot_getChildrenRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getChildren(req)
       return  ISnapshotCollection(val._returnval)


   _Attrs_={         'id':[getId,None],
         'name':[getName,setName,
        ],
         'description':[getDescription,setDescription,
        ],
         'timeStamp':[getTimeStamp,None],
         'online':[getOnline,None],
         'machine':[getMachine,None],
         'parent':[getParent,None],
         'children':[getChildren,None]}
class IHardDisk:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHardDisk(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def cloneToImage(self, _arg_filePath):
       req=IHardDisk_cloneToImageRequestMsg()
       req._this=self.handle
       
       req._filePath=_arg_filePath
       val=g_port.IHardDisk_cloneToImage(req)
             
       return IProgress(val._returnval), IVirtualDiskImage(val._image)


   def getId(self):
       req=IHardDisk_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getId(req)
       return  UUID(val._returnval)
   def getDescription(self):
       req=IHardDisk_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getDescription(req)
       return  String(val._returnval)
   def setDescription(self, value):
       req=IHardDisk_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._description = value
       else:
            req._description = value.handle
       g_port.IHardDisk_setDescription(req)      

   def getStorageType(self):
       req=IHardDisk_getStorageTypeRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getStorageType(req)
       return  HardDiskStorageType(val._returnval)
   def getLocation(self):
       req=IHardDisk_getLocationRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getLocation(req)
       return  String(val._returnval)
   def getType(self):
       req=IHardDisk_getTypeRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getType(req)
       return  HardDiskType(val._returnval)
   def setType(self, value):
       req=IHardDisk_setTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._type = value
       else:
            req._type = value.handle
       g_port.IHardDisk_setType(req)      

   def getParent(self):
       req=IHardDisk_getParentRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getParent(req)
       return  IHardDisk(val._returnval)
   def getChildren(self):
       req=IHardDisk_getChildrenRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getChildren(req)
       return  IHardDiskCollection(val._returnval)
   def getRoot(self):
       req=IHardDisk_getRootRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getRoot(req)
       return  IHardDisk(val._returnval)
   def getAccessible(self):
       req=IHardDisk_getAccessibleRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getAccessible(req)
       return  Boolean(val._returnval)
   def getAllAccessible(self):
       req=IHardDisk_getAllAccessibleRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getAllAccessible(req)
       return  Boolean(val._returnval)
   def getLastAccessError(self):
       req=IHardDisk_getLastAccessErrorRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getLastAccessError(req)
       return  String(val._returnval)
   def getSize(self):
       req=IHardDisk_getSizeRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getSize(req)
       return  UnsignedLong(val._returnval)
   def getActualSize(self):
       req=IHardDisk_getActualSizeRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getActualSize(req)
       return  UnsignedLong(val._returnval)
   def getMachineId(self):
       req=IHardDisk_getMachineIdRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getMachineId(req)
       return  UUID(val._returnval)
   def getSnapshotId(self):
       req=IHardDisk_getSnapshotIdRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getSnapshotId(req)
       return  UUID(val._returnval)


   _Attrs_={         'id':[getId,None],
         'description':[getDescription,setDescription,
        ],
         'storageType':[getStorageType,None],
         'location':[getLocation,None],
         'type':[getType,setType,
        ],
         'parent':[getParent,None],
         'children':[getChildren,None],
         'root':[getRoot,None],
         'accessible':[getAccessible,None],
         'allAccessible':[getAllAccessible,None],
         'lastAccessError':[getLastAccessError,None],
         'size':[getSize,None],
         'actualSize':[getActualSize,None],
         'machineId':[getMachineId,None],
         'snapshotId':[getSnapshotId,None]}
class IVirtualDiskImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualDiskImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualDiskImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVirtualDiskImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createDynamicImage(self, _arg_size):
       req=IVirtualDiskImage_createDynamicImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.IVirtualDiskImage_createDynamicImage(req)
             
       return IProgress(val._returnval)

 
   def createFixedImage(self, _arg_size):
       req=IVirtualDiskImage_createFixedImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.IVirtualDiskImage_createFixedImage(req)
             
       return IProgress(val._returnval)

 
   def deleteImage(self):
       req=IVirtualDiskImage_deleteImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualDiskImage_deleteImage(req)
             
       return 


   def getFilePath(self):
       req=IVirtualDiskImage_getFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualDiskImage_getFilePath(req)
       return  String(val._returnval)
   def setFilePath(self, value):
       req=IVirtualDiskImage_setFilePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._filePath = value
       else:
            req._filePath = value.handle
       g_port.IVirtualDiskImage_setFilePath(req)      

   def getCreated(self):
       req=IVirtualDiskImage_getCreatedRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualDiskImage_getCreated(req)
       return  Boolean(val._returnval)


   _Attrs_={         'filePath':[getFilePath,setFilePath,
        ],
         'created':[getCreated,None]}
class IISCSIHardDisk:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IISCSIHardDisk(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IISCSIHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IISCSIHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getServer(self):
       req=IISCSIHardDisk_getServerRequestMsg()
       req._this=self.handle
       val=g_port.IISCSIHardDisk_getServer(req)
       return  String(val._returnval)
   def setServer(self, value):
       req=IISCSIHardDisk_setServerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._server = value
       else:
            req._server = value.handle
       g_port.IISCSIHardDisk_setServer(req)      

   def getPort(self):
       req=IISCSIHardDisk_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IISCSIHardDisk_getPort(req)
       return  UnsignedShort(val._returnval)
   def setPort(self, value):
       req=IISCSIHardDisk_setPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._port = value
       else:
            req._port = value.handle
       g_port.IISCSIHardDisk_setPort(req)      

   def getTarget(self):
       req=IISCSIHardDisk_getTargetRequestMsg()
       req._this=self.handle
       val=g_port.IISCSIHardDisk_getTarget(req)
       return  String(val._returnval)
   def setTarget(self, value):
       req=IISCSIHardDisk_setTargetRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._target = value
       else:
            req._target = value.handle
       g_port.IISCSIHardDisk_setTarget(req)      

   def getLun(self):
       req=IISCSIHardDisk_getLunRequestMsg()
       req._this=self.handle
       val=g_port.IISCSIHardDisk_getLun(req)
       return  UnsignedLong(val._returnval)
   def setLun(self, value):
       req=IISCSIHardDisk_setLunRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._lun = value
       else:
            req._lun = value.handle
       g_port.IISCSIHardDisk_setLun(req)      

   def getUserName(self):
       req=IISCSIHardDisk_getUserNameRequestMsg()
       req._this=self.handle
       val=g_port.IISCSIHardDisk_getUserName(req)
       return  String(val._returnval)
   def setUserName(self, value):
       req=IISCSIHardDisk_setUserNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._userName = value
       else:
            req._userName = value.handle
       g_port.IISCSIHardDisk_setUserName(req)      

   def getPassword(self):
       req=IISCSIHardDisk_getPasswordRequestMsg()
       req._this=self.handle
       val=g_port.IISCSIHardDisk_getPassword(req)
       return  String(val._returnval)
   def setPassword(self, value):
       req=IISCSIHardDisk_setPasswordRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._password = value
       else:
            req._password = value.handle
       g_port.IISCSIHardDisk_setPassword(req)      



   _Attrs_={         'server':[getServer,setServer,
        ],
         'port':[getPort,setPort,
        ],
         'target':[getTarget,setTarget,
        ],
         'lun':[getLun,setLun,
        ],
         'userName':[getUserName,setUserName,
        ],
         'password':[getPassword,setPassword,
        ]}
class IVMDKImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVMDKImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVMDKImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVMDKImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createDynamicImage(self, _arg_size):
       req=IVMDKImage_createDynamicImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.IVMDKImage_createDynamicImage(req)
             
       return IProgress(val._returnval)

 
   def createFixedImage(self, _arg_size):
       req=IVMDKImage_createFixedImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.IVMDKImage_createFixedImage(req)
             
       return IProgress(val._returnval)

 
   def deleteImage(self):
       req=IVMDKImage_deleteImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IVMDKImage_deleteImage(req)
             
       return 


   def getFilePath(self):
       req=IVMDKImage_getFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IVMDKImage_getFilePath(req)
       return  String(val._returnval)
   def setFilePath(self, value):
       req=IVMDKImage_setFilePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._filePath = value
       else:
            req._filePath = value.handle
       g_port.IVMDKImage_setFilePath(req)      

   def getCreated(self):
       req=IVMDKImage_getCreatedRequestMsg()
       req._this=self.handle
       val=g_port.IVMDKImage_getCreated(req)
       return  Boolean(val._returnval)


   _Attrs_={         'filePath':[getFilePath,setFilePath,
        ],
         'created':[getCreated,None]}
class ICustomHardDisk:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ICustomHardDisk(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ICustomHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ICustomHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createDynamicImage(self, _arg_size):
       req=ICustomHardDisk_createDynamicImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.ICustomHardDisk_createDynamicImage(req)
             
       return IProgress(val._returnval)

 
   def createFixedImage(self, _arg_size):
       req=ICustomHardDisk_createFixedImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.ICustomHardDisk_createFixedImage(req)
             
       return IProgress(val._returnval)

 
   def deleteImage(self):
       req=ICustomHardDisk_deleteImageRequestMsg()
       req._this=self.handle
       
       val=g_port.ICustomHardDisk_deleteImage(req)
             
       return 


   def getLocation(self):
       req=ICustomHardDisk_getLocationRequestMsg()
       req._this=self.handle
       val=g_port.ICustomHardDisk_getLocation(req)
       return  String(val._returnval)
   def setLocation(self, value):
       req=ICustomHardDisk_setLocationRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._location = value
       else:
            req._location = value.handle
       g_port.ICustomHardDisk_setLocation(req)      

   def getFormat(self):
       req=ICustomHardDisk_getFormatRequestMsg()
       req._this=self.handle
       val=g_port.ICustomHardDisk_getFormat(req)
       return  String(val._returnval)
   def getCreated(self):
       req=ICustomHardDisk_getCreatedRequestMsg()
       req._this=self.handle
       val=g_port.ICustomHardDisk_getCreated(req)
       return  Boolean(val._returnval)


   _Attrs_={         'location':[getLocation,setLocation,
        ],
         'format':[getFormat,None],
         'created':[getCreated,None]}
class IVHDImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVHDImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVHDImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVHDImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createDynamicImage(self, _arg_size):
       req=IVHDImage_createDynamicImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.IVHDImage_createDynamicImage(req)
             
       return IProgress(val._returnval)

 
   def createFixedImage(self, _arg_size):
       req=IVHDImage_createFixedImageRequestMsg()
       req._this=self.handle
       
       req._size=_arg_size
       val=g_port.IVHDImage_createFixedImage(req)
             
       return IProgress(val._returnval)

 
   def deleteImage(self):
       req=IVHDImage_deleteImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IVHDImage_deleteImage(req)
             
       return 


   def getFilePath(self):
       req=IVHDImage_getFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IVHDImage_getFilePath(req)
       return  String(val._returnval)
   def setFilePath(self, value):
       req=IVHDImage_setFilePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._filePath = value
       else:
            req._filePath = value.handle
       g_port.IVHDImage_setFilePath(req)      

   def getCreated(self):
       req=IVHDImage_getCreatedRequestMsg()
       req._this=self.handle
       val=g_port.IVHDImage_getCreated(req)
       return  Boolean(val._returnval)


   _Attrs_={         'filePath':[getFilePath,setFilePath,
        ],
         'created':[getCreated,None]}
class IDVDImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IDVDImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDVDImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IDVDImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=IDVDImage_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IDVDImage_getId(req)
       return  UUID(val._returnval)
   def getFilePath(self):
       req=IDVDImage_getFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IDVDImage_getFilePath(req)
       return  String(val._returnval)
   def getAccessible(self):
       req=IDVDImage_getAccessibleRequestMsg()
       req._this=self.handle
       val=g_port.IDVDImage_getAccessible(req)
       return  Boolean(val._returnval)
   def getSize(self):
       req=IDVDImage_getSizeRequestMsg()
       req._this=self.handle
       val=g_port.IDVDImage_getSize(req)
       return  UnsignedLong(val._returnval)


   _Attrs_={         'id':[getId,None],
         'filePath':[getFilePath,None],
         'accessible':[getAccessible,None],
         'size':[getSize,None]}
class IDVDDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IDVDDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def mountImage(self, _arg_imageId):
       req=IDVDDrive_mountImageRequestMsg()
       req._this=self.handle
       
       req._imageId=_arg_imageId
       val=g_port.IDVDDrive_mountImage(req)
             
       return 

 
   def captureHostDrive(self, _arg_drive):
       req=IDVDDrive_captureHostDriveRequestMsg()
       req._this=self.handle
       
       req._drive=_arg_drive
       val=g_port.IDVDDrive_captureHostDrive(req)
             
       return 

 
   def unmount(self):
       req=IDVDDrive_unmountRequestMsg()
       req._this=self.handle
       
       val=g_port.IDVDDrive_unmount(req)
             
       return 

 
   def getImage(self):
       req=IDVDDrive_getImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IDVDDrive_getImage(req)
             
       return IDVDImage(val._returnval)

 
   def getHostDrive(self):
       req=IDVDDrive_getHostDriveRequestMsg()
       req._this=self.handle
       
       val=g_port.IDVDDrive_getHostDrive(req)
             
       return IHostDVDDrive(val._returnval)


   def getState(self):
       req=IDVDDrive_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IDVDDrive_getState(req)
       return  DriveState(val._returnval)
   def getPassthrough(self):
       req=IDVDDrive_getPassthroughRequestMsg()
       req._this=self.handle
       val=g_port.IDVDDrive_getPassthrough(req)
       return  Boolean(val._returnval)
   def setPassthrough(self, value):
       req=IDVDDrive_setPassthroughRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._passthrough = value
       else:
            req._passthrough = value.handle
       g_port.IDVDDrive_setPassthrough(req)      



   _Attrs_={         'state':[getState,None],
         'passthrough':[getPassthrough,setPassthrough,
        ]}
class IFloppyImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IFloppyImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFloppyImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IFloppyImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=IFloppyImage_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyImage_getId(req)
       return  UUID(val._returnval)
   def getFilePath(self):
       req=IFloppyImage_getFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyImage_getFilePath(req)
       return  String(val._returnval)
   def getAccessible(self):
       req=IFloppyImage_getAccessibleRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyImage_getAccessible(req)
       return  Boolean(val._returnval)
   def getSize(self):
       req=IFloppyImage_getSizeRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyImage_getSize(req)
       return  UnsignedInt(val._returnval)


   _Attrs_={         'id':[getId,None],
         'filePath':[getFilePath,None],
         'accessible':[getAccessible,None],
         'size':[getSize,None]}
class IFloppyDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IFloppyDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def mountImage(self, _arg_imageId):
       req=IFloppyDrive_mountImageRequestMsg()
       req._this=self.handle
       
       req._imageId=_arg_imageId
       val=g_port.IFloppyDrive_mountImage(req)
             
       return 

 
   def captureHostDrive(self, _arg_drive):
       req=IFloppyDrive_captureHostDriveRequestMsg()
       req._this=self.handle
       
       req._drive=_arg_drive
       val=g_port.IFloppyDrive_captureHostDrive(req)
             
       return 

 
   def unmount(self):
       req=IFloppyDrive_unmountRequestMsg()
       req._this=self.handle
       
       val=g_port.IFloppyDrive_unmount(req)
             
       return 

 
   def getImage(self):
       req=IFloppyDrive_getImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IFloppyDrive_getImage(req)
             
       return IFloppyImage(val._returnval)

 
   def getHostDrive(self):
       req=IFloppyDrive_getHostDriveRequestMsg()
       req._this=self.handle
       
       val=g_port.IFloppyDrive_getHostDrive(req)
             
       return IHostFloppyDrive(val._returnval)


   def getEnabled(self):
       req=IFloppyDrive_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyDrive_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IFloppyDrive_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IFloppyDrive_setEnabled(req)      

   def getState(self):
       req=IFloppyDrive_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyDrive_getState(req)
       return  DriveState(val._returnval)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'state':[getState,None]}
class IKeyboard:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IKeyboard(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IKeyboard._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IKeyboard._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def putScancode(self, _arg_scancode):
       req=IKeyboard_putScancodeRequestMsg()
       req._this=self.handle
       
       req._scancode=_arg_scancode
       val=g_port.IKeyboard_putScancode(req)
             
       return 

 
   def putScancodes(self, _arg_scancodes):
       req=IKeyboard_putScancodesRequestMsg()
       req._this=self.handle
       
       req._scancodes=_arg_scancodes
       val=g_port.IKeyboard_putScancodes(req)
             
       return UnsignedInt(val._returnval)

 
   def putCAD(self):
       req=IKeyboard_putCADRequestMsg()
       req._this=self.handle
       
       val=g_port.IKeyboard_putCAD(req)
             
       return 




   _Attrs_={}
class IMouse:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IMouse(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMouse._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IMouse._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def putMouseEvent(self, _arg_dx, _arg_dy, _arg_dz, _arg_buttonState):
       req=IMouse_putMouseEventRequestMsg()
       req._this=self.handle
       
       req._dx=_arg_dx
       req._dy=_arg_dy
       req._dz=_arg_dz
       req._buttonState=_arg_buttonState
       val=g_port.IMouse_putMouseEvent(req)
             
       return 

 
   def putMouseEventAbsolute(self, _arg_x, _arg_y, _arg_dz, _arg_buttonState):
       req=IMouse_putMouseEventAbsoluteRequestMsg()
       req._this=self.handle
       
       req._x=_arg_x
       req._y=_arg_y
       req._dz=_arg_dz
       req._buttonState=_arg_buttonState
       val=g_port.IMouse_putMouseEventAbsolute(req)
             
       return 


   def getAbsoluteSupported(self):
       req=IMouse_getAbsoluteSupportedRequestMsg()
       req._this=self.handle
       val=g_port.IMouse_getAbsoluteSupported(req)
       return  Boolean(val._returnval)


   _Attrs_={         'absoluteSupported':[getAbsoluteSupported,None]}
class INetworkAdapter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return INetworkAdapter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INetworkAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = INetworkAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def attachToNAT(self):
       req=INetworkAdapter_attachToNATRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToNAT(req)
             
       return 

 
   def attachToHostInterface(self):
       req=INetworkAdapter_attachToHostInterfaceRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToHostInterface(req)
             
       return 

 
   def attachToInternalNetwork(self):
       req=INetworkAdapter_attachToInternalNetworkRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToInternalNetwork(req)
             
       return 

 
   def detach(self):
       req=INetworkAdapter_detachRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_detach(req)
             
       return 


   def getAdapterType(self):
       req=INetworkAdapter_getAdapterTypeRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getAdapterType(req)
       return  NetworkAdapterType(val._returnval)
   def setAdapterType(self, value):
       req=INetworkAdapter_setAdapterTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._adapterType = value
       else:
            req._adapterType = value.handle
       g_port.INetworkAdapter_setAdapterType(req)      

   def getSlot(self):
       req=INetworkAdapter_getSlotRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getSlot(req)
       return  UnsignedInt(val._returnval)
   def getEnabled(self):
       req=INetworkAdapter_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=INetworkAdapter_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.INetworkAdapter_setEnabled(req)      

   def getMACAddress(self):
       req=INetworkAdapter_getMACAddressRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getMACAddress(req)
       return  String(val._returnval)
   def setMACAddress(self, value):
       req=INetworkAdapter_setMACAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._MACAddress = value
       else:
            req._MACAddress = value.handle
       g_port.INetworkAdapter_setMACAddress(req)      

   def getAttachmentType(self):
       req=INetworkAdapter_getAttachmentTypeRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getAttachmentType(req)
       return  NetworkAttachmentType(val._returnval)
   def getHostInterface(self):
       req=INetworkAdapter_getHostInterfaceRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getHostInterface(req)
       return  String(val._returnval)
   def setHostInterface(self, value):
       req=INetworkAdapter_setHostInterfaceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._hostInterface = value
       else:
            req._hostInterface = value.handle
       g_port.INetworkAdapter_setHostInterface(req)      

   def getInternalNetwork(self):
       req=INetworkAdapter_getInternalNetworkRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getInternalNetwork(req)
       return  String(val._returnval)
   def setInternalNetwork(self, value):
       req=INetworkAdapter_setInternalNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._internalNetwork = value
       else:
            req._internalNetwork = value.handle
       g_port.INetworkAdapter_setInternalNetwork(req)      

   def getNATNetwork(self):
       req=INetworkAdapter_getNATNetworkRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getNATNetwork(req)
       return  String(val._returnval)
   def setNATNetwork(self, value):
       req=INetworkAdapter_setNATNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._NATNetwork = value
       else:
            req._NATNetwork = value.handle
       g_port.INetworkAdapter_setNATNetwork(req)      

   def getCableConnected(self):
       req=INetworkAdapter_getCableConnectedRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getCableConnected(req)
       return  Boolean(val._returnval)
   def setCableConnected(self, value):
       req=INetworkAdapter_setCableConnectedRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._cableConnected = value
       else:
            req._cableConnected = value.handle
       g_port.INetworkAdapter_setCableConnected(req)      

   def getLineSpeed(self):
       req=INetworkAdapter_getLineSpeedRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getLineSpeed(req)
       return  UnsignedInt(val._returnval)
   def setLineSpeed(self, value):
       req=INetworkAdapter_setLineSpeedRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._lineSpeed = value
       else:
            req._lineSpeed = value.handle
       g_port.INetworkAdapter_setLineSpeed(req)      

   def getTraceEnabled(self):
       req=INetworkAdapter_getTraceEnabledRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getTraceEnabled(req)
       return  Boolean(val._returnval)
   def setTraceEnabled(self, value):
       req=INetworkAdapter_setTraceEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._traceEnabled = value
       else:
            req._traceEnabled = value.handle
       g_port.INetworkAdapter_setTraceEnabled(req)      

   def getTraceFile(self):
       req=INetworkAdapter_getTraceFileRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getTraceFile(req)
       return  String(val._returnval)
   def setTraceFile(self, value):
       req=INetworkAdapter_setTraceFileRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._traceFile = value
       else:
            req._traceFile = value.handle
       g_port.INetworkAdapter_setTraceFile(req)      



   _Attrs_={         'adapterType':[getAdapterType,setAdapterType,
        ],
         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'MACAddress':[getMACAddress,setMACAddress,
        ],
         'attachmentType':[getAttachmentType,None],
         'hostInterface':[getHostInterface,setHostInterface,
        ],
         'internalNetwork':[getInternalNetwork,setInternalNetwork,
        ],
         'NATNetwork':[getNATNetwork,setNATNetwork,
        ],
         'cableConnected':[getCableConnected,setCableConnected,
        ],
         'lineSpeed':[getLineSpeed,setLineSpeed,
        ],
         'traceEnabled':[getTraceEnabled,setTraceEnabled,
        ],
         'traceFile':[getTraceFile,setTraceFile,
        ]}
class ISerialPort:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISerialPort(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISerialPort._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISerialPort._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=ISerialPort_getSlotRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getSlot(req)
       return  UnsignedInt(val._returnval)
   def getEnabled(self):
       req=ISerialPort_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=ISerialPort_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.ISerialPort_setEnabled(req)      

   def getIOBase(self):
       req=ISerialPort_getIOBaseRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getIOBase(req)
       return  UnsignedInt(val._returnval)
   def setIOBase(self, value):
       req=ISerialPort_setIOBaseRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IOBase = value
       else:
            req._IOBase = value.handle
       g_port.ISerialPort_setIOBase(req)      

   def getIRQ(self):
       req=ISerialPort_getIRQRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getIRQ(req)
       return  UnsignedInt(val._returnval)
   def setIRQ(self, value):
       req=ISerialPort_setIRQRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IRQ = value
       else:
            req._IRQ = value.handle
       g_port.ISerialPort_setIRQ(req)      

   def getHostMode(self):
       req=ISerialPort_getHostModeRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getHostMode(req)
       return  PortMode(val._returnval)
   def setHostMode(self, value):
       req=ISerialPort_setHostModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._hostMode = value
       else:
            req._hostMode = value.handle
       g_port.ISerialPort_setHostMode(req)      

   def getServer(self):
       req=ISerialPort_getServerRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getServer(req)
       return  Boolean(val._returnval)
   def setServer(self, value):
       req=ISerialPort_setServerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._server = value
       else:
            req._server = value.handle
       g_port.ISerialPort_setServer(req)      

   def getPath(self):
       req=ISerialPort_getPathRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getPath(req)
       return  String(val._returnval)
   def setPath(self, value):
       req=ISerialPort_setPathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._path = value
       else:
            req._path = value.handle
       g_port.ISerialPort_setPath(req)      



   _Attrs_={         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IOBase':[getIOBase,setIOBase,
        ],
         'IRQ':[getIRQ,setIRQ,
        ],
         'hostMode':[getHostMode,setHostMode,
        ],
         'server':[getServer,setServer,
        ],
         'path':[getPath,setPath,
        ]}
class IParallelPort:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IParallelPort(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IParallelPort._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IParallelPort._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=IParallelPort_getSlotRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getSlot(req)
       return  UnsignedInt(val._returnval)
   def getEnabled(self):
       req=IParallelPort_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IParallelPort_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IParallelPort_setEnabled(req)      

   def getIOBase(self):
       req=IParallelPort_getIOBaseRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getIOBase(req)
       return  UnsignedInt(val._returnval)
   def setIOBase(self, value):
       req=IParallelPort_setIOBaseRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IOBase = value
       else:
            req._IOBase = value.handle
       g_port.IParallelPort_setIOBase(req)      

   def getIRQ(self):
       req=IParallelPort_getIRQRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getIRQ(req)
       return  UnsignedInt(val._returnval)
   def setIRQ(self, value):
       req=IParallelPort_setIRQRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IRQ = value
       else:
            req._IRQ = value.handle
       g_port.IParallelPort_setIRQ(req)      

   def getPath(self):
       req=IParallelPort_getPathRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getPath(req)
       return  String(val._returnval)
   def setPath(self, value):
       req=IParallelPort_setPathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._path = value
       else:
            req._path = value.handle
       g_port.IParallelPort_setPath(req)      



   _Attrs_={         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IOBase':[getIOBase,setIOBase,
        ],
         'IRQ':[getIRQ,setIRQ,
        ],
         'path':[getPath,setPath,
        ]}
class IUSBController:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IUSBController(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBController._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IUSBController._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createDeviceFilter(self, _arg_name):
       req=IUSBController_createDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IUSBController_createDeviceFilter(req)
             
       return IUSBDeviceFilter(val._returnval)

 
   def insertDeviceFilter(self, _arg_position, _arg_filter):
       req=IUSBController_insertDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._filter=_arg_filter
       val=g_port.IUSBController_insertDeviceFilter(req)
             
       return 

 
   def removeDeviceFilter(self, _arg_position):
       req=IUSBController_removeDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=g_port.IUSBController_removeDeviceFilter(req)
             
       return IUSBDeviceFilter(val._returnval)


   def getEnabled(self):
       req=IUSBController_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IUSBController_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IUSBController_setEnabled(req)      

   def getEnabledEhci(self):
       req=IUSBController_getEnabledEhciRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getEnabledEhci(req)
       return  Boolean(val._returnval)
   def setEnabledEhci(self, value):
       req=IUSBController_setEnabledEhciRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabledEhci = value
       else:
            req._enabledEhci = value.handle
       g_port.IUSBController_setEnabledEhci(req)      

   def getUSBStandard(self):
       req=IUSBController_getUSBStandardRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getUSBStandard(req)
       return  UnsignedShort(val._returnval)
   def getDeviceFilters(self):
       req=IUSBController_getDeviceFiltersRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getDeviceFilters(req)
       return  IUSBDeviceFilterCollection(val._returnval)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'enabledEhci':[getEnabledEhci,setEnabledEhci,
        ],
         'USBStandard':[getUSBStandard,None],
         'deviceFilters':[getDeviceFilters,None]}
class IUSBDevice:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDevice(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=IUSBDevice_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getId(req)
       return  UUID(val._returnval)
   def getVendorId(self):
       req=IUSBDevice_getVendorIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getVendorId(req)
       return  UnsignedShort(val._returnval)
   def getProductId(self):
       req=IUSBDevice_getProductIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getProductId(req)
       return  UnsignedShort(val._returnval)
   def getRevision(self):
       req=IUSBDevice_getRevisionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getRevision(req)
       return  UnsignedShort(val._returnval)
   def getManufacturer(self):
       req=IUSBDevice_getManufacturerRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getManufacturer(req)
       return  String(val._returnval)
   def getProduct(self):
       req=IUSBDevice_getProductRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getProduct(req)
       return  String(val._returnval)
   def getSerialNumber(self):
       req=IUSBDevice_getSerialNumberRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getSerialNumber(req)
       return  String(val._returnval)
   def getAddress(self):
       req=IUSBDevice_getAddressRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getAddress(req)
       return  String(val._returnval)
   def getPort(self):
       req=IUSBDevice_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getPort(req)
       return  UnsignedShort(val._returnval)
   def getVersion(self):
       req=IUSBDevice_getVersionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getVersion(req)
       return  UnsignedShort(val._returnval)
   def getPortVersion(self):
       req=IUSBDevice_getPortVersionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getPortVersion(req)
       return  UnsignedShort(val._returnval)
   def getRemote(self):
       req=IUSBDevice_getRemoteRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getRemote(req)
       return  Boolean(val._returnval)


   _Attrs_={         'id':[getId,None],
         'vendorId':[getVendorId,None],
         'productId':[getProductId,None],
         'revision':[getRevision,None],
         'manufacturer':[getManufacturer,None],
         'product':[getProduct,None],
         'serialNumber':[getSerialNumber,None],
         'address':[getAddress,None],
         'port':[getPort,None],
         'version':[getVersion,None],
         'portVersion':[getPortVersion,None],
         'remote':[getRemote,None]}
class IUSBDeviceFilter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDeviceFilter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IUSBDeviceFilter_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getName(req)
       return  String(val._returnval)
   def setName(self, value):
       req=IUSBDeviceFilter_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._name = value
       else:
            req._name = value.handle
       g_port.IUSBDeviceFilter_setName(req)      

   def getActive(self):
       req=IUSBDeviceFilter_getActiveRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getActive(req)
       return  Boolean(val._returnval)
   def setActive(self, value):
       req=IUSBDeviceFilter_setActiveRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._active = value
       else:
            req._active = value.handle
       g_port.IUSBDeviceFilter_setActive(req)      

   def getVendorId(self):
       req=IUSBDeviceFilter_getVendorIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getVendorId(req)
       return  String(val._returnval)
   def setVendorId(self, value):
       req=IUSBDeviceFilter_setVendorIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._vendorId = value
       else:
            req._vendorId = value.handle
       g_port.IUSBDeviceFilter_setVendorId(req)      

   def getProductId(self):
       req=IUSBDeviceFilter_getProductIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getProductId(req)
       return  String(val._returnval)
   def setProductId(self, value):
       req=IUSBDeviceFilter_setProductIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._productId = value
       else:
            req._productId = value.handle
       g_port.IUSBDeviceFilter_setProductId(req)      

   def getRevision(self):
       req=IUSBDeviceFilter_getRevisionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getRevision(req)
       return  String(val._returnval)
   def setRevision(self, value):
       req=IUSBDeviceFilter_setRevisionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._revision = value
       else:
            req._revision = value.handle
       g_port.IUSBDeviceFilter_setRevision(req)      

   def getManufacturer(self):
       req=IUSBDeviceFilter_getManufacturerRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getManufacturer(req)
       return  String(val._returnval)
   def setManufacturer(self, value):
       req=IUSBDeviceFilter_setManufacturerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._manufacturer = value
       else:
            req._manufacturer = value.handle
       g_port.IUSBDeviceFilter_setManufacturer(req)      

   def getProduct(self):
       req=IUSBDeviceFilter_getProductRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getProduct(req)
       return  String(val._returnval)
   def setProduct(self, value):
       req=IUSBDeviceFilter_setProductRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._product = value
       else:
            req._product = value.handle
       g_port.IUSBDeviceFilter_setProduct(req)      

   def getSerialNumber(self):
       req=IUSBDeviceFilter_getSerialNumberRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getSerialNumber(req)
       return  String(val._returnval)
   def setSerialNumber(self, value):
       req=IUSBDeviceFilter_setSerialNumberRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._serialNumber = value
       else:
            req._serialNumber = value.handle
       g_port.IUSBDeviceFilter_setSerialNumber(req)      

   def getPort(self):
       req=IUSBDeviceFilter_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getPort(req)
       return  String(val._returnval)
   def setPort(self, value):
       req=IUSBDeviceFilter_setPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._port = value
       else:
            req._port = value.handle
       g_port.IUSBDeviceFilter_setPort(req)      

   def getRemote(self):
       req=IUSBDeviceFilter_getRemoteRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getRemote(req)
       return  String(val._returnval)
   def setRemote(self, value):
       req=IUSBDeviceFilter_setRemoteRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._remote = value
       else:
            req._remote = value.handle
       g_port.IUSBDeviceFilter_setRemote(req)      

   def getMaskedInterfaces(self):
       req=IUSBDeviceFilter_getMaskedInterfacesRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getMaskedInterfaces(req)
       return  UnsignedInt(val._returnval)
   def setMaskedInterfaces(self, value):
       req=IUSBDeviceFilter_setMaskedInterfacesRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._maskedInterfaces = value
       else:
            req._maskedInterfaces = value.handle
       g_port.IUSBDeviceFilter_setMaskedInterfaces(req)      



   _Attrs_={         'name':[getName,setName,
        ],
         'active':[getActive,setActive,
        ],
         'vendorId':[getVendorId,setVendorId,
        ],
         'productId':[getProductId,setProductId,
        ],
         'revision':[getRevision,setRevision,
        ],
         'manufacturer':[getManufacturer,setManufacturer,
        ],
         'product':[getProduct,setProduct,
        ],
         'serialNumber':[getSerialNumber,setSerialNumber,
        ],
         'port':[getPort,setPort,
        ],
         'remote':[getRemote,setRemote,
        ],
         'maskedInterfaces':[getMaskedInterfaces,setMaskedInterfaces,
        ]}
class IHostUSBDevice:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostUSBDevice(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getState(self):
       req=IHostUSBDevice_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IHostUSBDevice_getState(req)
       return  USBDeviceState(val._returnval)


   _Attrs_={         'state':[getState,None]}
class IHostUSBDeviceFilter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostUSBDeviceFilter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getAction(self):
       req=IHostUSBDeviceFilter_getActionRequestMsg()
       req._this=self.handle
       val=g_port.IHostUSBDeviceFilter_getAction(req)
       return  USBDeviceFilterAction(val._returnval)
   def setAction(self, value):
       req=IHostUSBDeviceFilter_setActionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._action = value
       else:
            req._action = value.handle
       g_port.IHostUSBDeviceFilter_setAction(req)      



   _Attrs_={         'action':[getAction,setAction,
        ]}
class IAudioAdapter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IAudioAdapter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IAudioAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IAudioAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getEnabled(self):
       req=IAudioAdapter_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IAudioAdapter_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IAudioAdapter_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IAudioAdapter_setEnabled(req)      

   def getAudioController(self):
       req=IAudioAdapter_getAudioControllerRequestMsg()
       req._this=self.handle
       val=g_port.IAudioAdapter_getAudioController(req)
       return  AudioControllerType(val._returnval)
   def setAudioController(self, value):
       req=IAudioAdapter_setAudioControllerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._audioController = value
       else:
            req._audioController = value.handle
       g_port.IAudioAdapter_setAudioController(req)      

   def getAudioDriver(self):
       req=IAudioAdapter_getAudioDriverRequestMsg()
       req._this=self.handle
       val=g_port.IAudioAdapter_getAudioDriver(req)
       return  AudioDriverType(val._returnval)
   def setAudioDriver(self, value):
       req=IAudioAdapter_setAudioDriverRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._audioDriver = value
       else:
            req._audioDriver = value.handle
       g_port.IAudioAdapter_setAudioDriver(req)      



   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'audioController':[getAudioController,setAudioController,
        ],
         'audioDriver':[getAudioDriver,setAudioDriver,
        ]}
class IVRDPServer:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVRDPServer(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVRDPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVRDPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getEnabled(self):
       req=IVRDPServer_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IVRDPServer_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IVRDPServer_setEnabled(req)      

   def getPort(self):
       req=IVRDPServer_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getPort(req)
       return  UnsignedInt(val._returnval)
   def setPort(self, value):
       req=IVRDPServer_setPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._port = value
       else:
            req._port = value.handle
       g_port.IVRDPServer_setPort(req)      

   def getNetAddress(self):
       req=IVRDPServer_getNetAddressRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getNetAddress(req)
       return  String(val._returnval)
   def setNetAddress(self, value):
       req=IVRDPServer_setNetAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._netAddress = value
       else:
            req._netAddress = value.handle
       g_port.IVRDPServer_setNetAddress(req)      

   def getAuthType(self):
       req=IVRDPServer_getAuthTypeRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getAuthType(req)
       return  VRDPAuthType(val._returnval)
   def setAuthType(self, value):
       req=IVRDPServer_setAuthTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._authType = value
       else:
            req._authType = value.handle
       g_port.IVRDPServer_setAuthType(req)      

   def getAuthTimeout(self):
       req=IVRDPServer_getAuthTimeoutRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getAuthTimeout(req)
       return  UnsignedInt(val._returnval)
   def setAuthTimeout(self, value):
       req=IVRDPServer_setAuthTimeoutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._authTimeout = value
       else:
            req._authTimeout = value.handle
       g_port.IVRDPServer_setAuthTimeout(req)      

   def getAllowMultiConnection(self):
       req=IVRDPServer_getAllowMultiConnectionRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getAllowMultiConnection(req)
       return  Boolean(val._returnval)
   def setAllowMultiConnection(self, value):
       req=IVRDPServer_setAllowMultiConnectionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._allowMultiConnection = value
       else:
            req._allowMultiConnection = value.handle
       g_port.IVRDPServer_setAllowMultiConnection(req)      

   def getReuseSingleConnection(self):
       req=IVRDPServer_getReuseSingleConnectionRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getReuseSingleConnection(req)
       return  Boolean(val._returnval)
   def setReuseSingleConnection(self, value):
       req=IVRDPServer_setReuseSingleConnectionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._reuseSingleConnection = value
       else:
            req._reuseSingleConnection = value.handle
       g_port.IVRDPServer_setReuseSingleConnection(req)      



   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'port':[getPort,setPort,
        ],
         'netAddress':[getNetAddress,setNetAddress,
        ],
         'authType':[getAuthType,setAuthType,
        ],
         'authTimeout':[getAuthTimeout,setAuthTimeout,
        ],
         'allowMultiConnection':[getAllowMultiConnection,setAllowMultiConnection,
        ],
         'reuseSingleConnection':[getReuseSingleConnection,setReuseSingleConnection,
        ]}
class ISession:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISession(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISession._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISession._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def close(self):
       req=ISession_closeRequestMsg()
       req._this=self.handle
       
       val=g_port.ISession_close(req)
             
       return 


   def getState(self):
       req=ISession_getStateRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getState(req)
       return  SessionState(val._returnval)
   def getType(self):
       req=ISession_getTypeRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getType(req)
       return  SessionType(val._returnval)
   def getMachine(self):
       req=ISession_getMachineRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getMachine(req)
       return  IMachine(val._returnval)
   def getConsole(self):
       req=ISession_getConsoleRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getConsole(req)
       return  IConsole(val._returnval)


   _Attrs_={         'state':[getState,None],
         'type':[getType,None],
         'machine':[getMachine,None],
         'console':[getConsole,None]}
class ISATAController:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISATAController(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISATAController._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISATAController._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def GetIDEEmulationPort(self, _arg_devicePosition):
       req=ISATAController_GetIDEEmulationPortRequestMsg()
       req._this=self.handle
       
       req._devicePosition=_arg_devicePosition
       val=g_port.ISATAController_GetIDEEmulationPort(req)
             
       return Int(val._returnval)

 
   def SetIDEEmulationPort(self, _arg_devicePosition, _arg_portNumber):
       req=ISATAController_SetIDEEmulationPortRequestMsg()
       req._this=self.handle
       
       req._devicePosition=_arg_devicePosition
       req._portNumber=_arg_portNumber
       val=g_port.ISATAController_SetIDEEmulationPort(req)
             
       return 


   def getEnabled(self):
       req=ISATAController_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.ISATAController_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=ISATAController_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.ISATAController_setEnabled(req)      

   def getPortCount(self):
       req=ISATAController_getPortCountRequestMsg()
       req._this=self.handle
       val=g_port.ISATAController_getPortCount(req)
       return  UnsignedInt(val._returnval)
   def setPortCount(self, value):
       req=ISATAController_setPortCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._portCount = value
       else:
            req._portCount = value.handle
       g_port.ISATAController_setPortCount(req)      



   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'portCount':[getPortCount,setPortCount,
        ]}
class IManagedObjectRef:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IManagedObjectRef(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IManagedObjectRef._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IManagedObjectRef._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getInterfaceName(self):
       req=IManagedObjectRef_getInterfaceNameRequestMsg()
       req._this=self.handle
       
       val=g_port.IManagedObjectRef_getInterfaceName(req)
             
       return String(val._returnval)

 
   def release(self):
       req=IManagedObjectRef_releaseRequestMsg()
       req._this=self.handle
       
       val=g_port.IManagedObjectRef_release(req)
             
       return 




   _Attrs_={}
class IWebsessionManager:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IWebsessionManager(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IWebsessionManager._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IWebsessionManager._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def logon(self, _arg_username, _arg_password):
       req=IWebsessionManager_logonRequestMsg()
       req._this=self.handle
       
       req._username=_arg_username
       req._password=_arg_password
       val=g_port.IWebsessionManager_logon(req)
             
       return IVirtualBox(val._returnval)

 
   def getSessionObject(self, _arg_refIVirtualBox):
       req=IWebsessionManager_getSessionObjectRequestMsg()
       req._this=self.handle
       
       req._refIVirtualBox=_arg_refIVirtualBox
       val=g_port.IWebsessionManager_getSessionObject(req)
             
       return ISession(val._returnval)

 
   def logoff(self, _arg_refIVirtualBox):
       req=IWebsessionManager_logoffRequestMsg()
       req._this=self.handle
       
       req._refIVirtualBox=_arg_refIVirtualBox
       val=g_port.IWebsessionManager_logoff(req)
             
       return 




   _Attrs_={}
class IPerformanceMetric:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IPerformanceMetric(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPerformanceMetric._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IPerformanceMetric._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMetricName(self):
       req=IPerformanceMetric_getMetricNameRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getMetricName(req)
       return  String(val._returnval)
   def getDescription(self):
       req=IPerformanceMetric_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getDescription(req)
       return  String(val._returnval)
   def getPeriod(self):
       req=IPerformanceMetric_getPeriodRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getPeriod(req)
       return  UnsignedInt(val._returnval)
   def getCount(self):
       req=IPerformanceMetric_getCountRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getCount(req)
       return  UnsignedInt(val._returnval)
   def getUnit(self):
       req=IPerformanceMetric_getUnitRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getUnit(req)
       return  String(val._returnval)
   def getMinimumValue(self):
       req=IPerformanceMetric_getMinimumValueRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getMinimumValue(req)
       return  Int(val._returnval)
   def getMaximumValue(self):
       req=IPerformanceMetric_getMaximumValueRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getMaximumValue(req)
       return  Int(val._returnval)


   _Attrs_={         'metricName':[getMetricName,None],
         'description':[getDescription,None],
         'period':[getPeriod,None],
         'count':[getCount,None],
         'unit':[getUnit,None],
         'minimumValue':[getMinimumValue,None],
         'maximumValue':[getMaximumValue,None]}
class IPerformanceCollector:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IPerformanceCollector(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPerformanceCollector._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IPerformanceCollector._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_getMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_getMetrics(req)
             
       return IPerformanceMetric(val._returnval, True)

 
   def setupMetrics(self, _arg_metricNames, _arg_objects, _arg_period, _arg_count):
       req=IPerformanceCollector_setupMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       req._period=_arg_period
       req._count=_arg_count
       val=g_port.IPerformanceCollector_setupMetrics(req)
             
       return 

 
   def enableMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_enableMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_enableMetrics(req)
             
       return 

 
   def disableMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_disableMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_disableMetrics(req)
             
       return 

 
   def queryMetricsData(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_queryMetricsDataRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_queryMetricsData(req)
             
       return Int(val._returnval, True), String(val._returnMetricNames, True), IUnknown(val._returnObjects, True), UnsignedInt(val._returnDataIndices, True), UnsignedInt(val._returnDataLengths, True)


   def getMetricNames(self):
       req=IPerformanceCollector_getMetricNamesRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceCollector_getMetricNames(req)
       return  String(val._returnval, True)


   _Attrs_={         'metricNames':[getMetricNames,None]}
class IRemoteDisplayInfo:
    def __init__(self, handle):
       self.active = handle._active
       self.numberOfClients = handle._numberOfClients
       self.beginTime = handle._beginTime
       self.endTime = handle._endTime
       self.bytesSent = handle._bytesSent
       self.bytesSentTotal = handle._bytesSentTotal
       self.bytesReceived = handle._bytesReceived
       self.bytesReceivedTotal = handle._bytesReceivedTotal
       self.user = handle._user
       self.domain = handle._domain
       self.clientName = handle._clientName
       self.clientIP = handle._clientIP
       self.clientVersion = handle._clientVersion
       self.encryptionStyle = handle._encryptionStyle
    def getActive(self):
       return self.active
 
    def setActive(self):
       raise Error, 'setters not supported'
    
    def getNumberOfClients(self):
       return self.numberOfClients
 
    def setNumberOfClients(self):
       raise Error, 'setters not supported'
    
    def getBeginTime(self):
       return self.beginTime
 
    def setBeginTime(self):
       raise Error, 'setters not supported'
    
    def getEndTime(self):
       return self.endTime
 
    def setEndTime(self):
       raise Error, 'setters not supported'
    
    def getBytesSent(self):
       return self.bytesSent
 
    def setBytesSent(self):
       raise Error, 'setters not supported'
    
    def getBytesSentTotal(self):
       return self.bytesSentTotal
 
    def setBytesSentTotal(self):
       raise Error, 'setters not supported'
    
    def getBytesReceived(self):
       return self.bytesReceived
 
    def setBytesReceived(self):
       raise Error, 'setters not supported'
    
    def getBytesReceivedTotal(self):
       return self.bytesReceivedTotal
 
    def setBytesReceivedTotal(self):
       raise Error, 'setters not supported'
    
    def getUser(self):
       return self.user
 
    def setUser(self):
       raise Error, 'setters not supported'
    
    def getDomain(self):
       return self.domain
 
    def setDomain(self):
       raise Error, 'setters not supported'
    
    def getClientName(self):
       return self.clientName
 
    def setClientName(self):
       raise Error, 'setters not supported'
    
    def getClientIP(self):
       return self.clientIP
 
    def setClientIP(self):
       raise Error, 'setters not supported'
    
    def getClientVersion(self):
       return self.clientVersion
 
    def setClientVersion(self):
       raise Error, 'setters not supported'
    
    def getEncryptionStyle(self):
       return self.encryptionStyle
 
    def setEncryptionStyle(self):
       raise Error, 'setters not supported'
    
class IGuestOSType:
    def __init__(self, handle):
       self.id = handle._id
       self.description = handle._description
       self.recommendedRAM = handle._recommendedRAM
       self.recommendedVRAM = handle._recommendedVRAM
       self.recommendedHDD = handle._recommendedHDD
    def getId(self):
       return self.id
 
    def setId(self):
       raise Error, 'setters not supported'
    
    def getDescription(self):
       return self.description
 
    def setDescription(self):
       raise Error, 'setters not supported'
    
    def getRecommendedRAM(self):
       return self.recommendedRAM
 
    def setRecommendedRAM(self):
       raise Error, 'setters not supported'
    
    def getRecommendedVRAM(self):
       return self.recommendedVRAM
 
    def setRecommendedVRAM(self):
       raise Error, 'setters not supported'
    
    def getRecommendedHDD(self):
       return self.recommendedHDD
 
    def setRecommendedHDD(self):
       raise Error, 'setters not supported'
    
class IHardDiskAttachment:
    def __init__(self, handle):
       self.hardDisk = handle._hardDisk
       self.bus = handle._bus
       self.channel = handle._channel
       self.device = handle._device
    def getHardDisk(self):
       return self.hardDisk
 
    def setHardDisk(self):
       raise Error, 'setters not supported'
    
    def getBus(self):
       return self.bus
 
    def setBus(self):
       raise Error, 'setters not supported'
    
    def getChannel(self):
       return self.channel
 
    def setChannel(self):
       raise Error, 'setters not supported'
    
    def getDevice(self):
       return self.device
 
    def setDevice(self):
       raise Error, 'setters not supported'
    
class ISharedFolder:
    def __init__(self, handle):
       self.name = handle._name
       self.hostPath = handle._hostPath
       self.accessible = handle._accessible
       self.writable = handle._writable
    def getName(self):
       return self.name
 
    def setName(self):
       raise Error, 'setters not supported'
    
    def getHostPath(self):
       return self.hostPath
 
    def setHostPath(self):
       raise Error, 'setters not supported'
    
    def getAccessible(self):
       return self.accessible
 
    def setAccessible(self):
       raise Error, 'setters not supported'
    
    def getWritable(self):
       return self.writable
 
    def setWritable(self):
       raise Error, 'setters not supported'
    
class IMachineCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IMachine(self.array._array[index])
       

class IHostDVDDriveCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHostDVDDrive(self.array._array[index])
       

class IHostFloppyDriveCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHostFloppyDrive(self.array._array[index])
       

class IHostNetworkInterfaceCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHostNetworkInterface(self.array._array[index])
       

class IGuestOSTypeCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IGuestOSType(self.array._array[index])
       

class IProgressCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IProgress(self.array._array[index])
       

class ISnapshotCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return ISnapshot(self.array._array[index])
       

class IHardDiskAttachmentCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHardDiskAttachment(self.array._array[index])
       

class IHardDiskCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHardDisk(self.array._array[index])
       

class IDVDImageCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IDVDImage(self.array._array[index])
       

class IFloppyImageCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IFloppyImage(self.array._array[index])
       

class IUSBDeviceCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IUSBDevice(self.array._array[index])
       

class IUSBDeviceFilterCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IUSBDeviceFilter(self.array._array[index])
       

class IHostUSBDeviceCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHostUSBDevice(self.array._array[index])
       

class IHostUSBDeviceFilterCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return IHostUSBDeviceFilter(self.array._array[index])
       

class ISharedFolderCollection:
   def __init__(self, array):
       self.array = array

   def __next(self):
       return self.array.__next()

   def __size(self):
       return self.array._array.__size()

   def __len__(self):
       return self.array._array.__len__()

   def __getitem__(self, index):
       return ISharedFolder(self.array._array[index])
       

class TSBool:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=TSBool._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,TSBool):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,TSBool):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return TSBool._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'False',1:'True',2:'Default'}
   _ValueMap={
              'False':0,
              'True':1,
              'Default':2}

   False=0
   True=1
   Default=2

class MachineState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=MachineState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MachineState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,MachineState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return MachineState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'PoweredOff',2:'Saved',3:'Aborted',4:'Running',5:'Paused',6:'Stuck',7:'Starting',8:'Stopping',9:'Saving',10:'Restoring',11:'Discarding'}
   _ValueMap={
              'Null':0,
              'PoweredOff':1,
              'Saved':2,
              'Aborted':3,
              'Running':4,
              'Paused':5,
              'Stuck':6,
              'Starting':7,
              'Stopping':8,
              'Saving':9,
              'Restoring':10,
              'Discarding':11}

   Null=0
   PoweredOff=1
   Saved=2
   Aborted=3
   Running=4
   Paused=5
   Stuck=6
   Starting=7
   Stopping=8
   Saving=9
   Restoring=10
   Discarding=11

class SessionState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=SessionState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SessionState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,SessionState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return SessionState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Closed',2:'Open',3:'Spawning',4:'Closing'}
   _ValueMap={
              'Null':0,
              'Closed':1,
              'Open':2,
              'Spawning':3,
              'Closing':4}

   Null=0
   Closed=1
   Open=2
   Spawning=3
   Closing=4

class SessionType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=SessionType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SessionType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,SessionType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return SessionType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Direct',2:'Remote',3:'Existing'}
   _ValueMap={
              'Null':0,
              'Direct':1,
              'Remote':2,
              'Existing':3}

   Null=0
   Direct=1
   Remote=2
   Existing=3

class DeviceType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DeviceType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DeviceType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DeviceType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DeviceType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Floppy',2:'DVD',3:'HardDisk',4:'Network',5:'USB',6:'SharedFolder'}
   _ValueMap={
              'Null':0,
              'Floppy':1,
              'DVD':2,
              'HardDisk':3,
              'Network':4,
              'USB':5,
              'SharedFolder':6}

   Null=0
   Floppy=1
   DVD=2
   HardDisk=3
   Network=4
   USB=5
   SharedFolder=6

class DeviceActivity:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DeviceActivity._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DeviceActivity):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DeviceActivity):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DeviceActivity._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Idle',2:'Reading',3:'Writing'}
   _ValueMap={
              'Null':0,
              'Idle':1,
              'Reading':2,
              'Writing':3}

   Null=0
   Idle=1
   Reading=2
   Writing=3

class ResourceUsage:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=ResourceUsage._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ResourceUsage):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,ResourceUsage):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return ResourceUsage._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Permanent',2:'Temporary',3:'All'}
   _ValueMap={
              'Null':0,
              'Permanent':1,
              'Temporary':2,
              'All':3}

   Null=0
   Permanent=1
   Temporary=2
   All=3

class StorageBus:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=StorageBus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,StorageBus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,StorageBus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return StorageBus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'IDE',2:'SATA'}
   _ValueMap={
              'Null':0,
              'IDE':1,
              'SATA':2}

   Null=0
   IDE=1
   SATA=2

class ClipboardMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=ClipboardMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ClipboardMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,ClipboardMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return ClipboardMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'HostToGuest',2:'GuestToHost',3:'Bidirectional'}
   _ValueMap={
              'Disabled':0,
              'HostToGuest':1,
              'GuestToHost':2,
              'Bidirectional':3}

   Disabled=0
   HostToGuest=1
   GuestToHost=2
   Bidirectional=3

class Scope:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=Scope._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,Scope):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,Scope):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return Scope._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Global',1:'Machine',2:'Session'}
   _ValueMap={
              'Global':0,
              'Machine':1,
              'Session':2}

   Global=0
   Machine=1
   Session=2

class GuestStatisticType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=GuestStatisticType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestStatisticType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestStatisticType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return GuestStatisticType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'CPULoad_Idle',1:'CPULoad_Kernel',2:'CPULoad_User',3:'Threads',4:'Processes',5:'Handles',6:'MemoryLoad',7:'PhysMemTotal',8:'PhysMemAvailable',9:'PhysMemBalloon',10:'MemCommitTotal',11:'MemKernelTotal',12:'MemKernelPaged',13:'MemKernelNonpaged',14:'MemSystemCache',15:'PageFileSize',16:'SampleNumber',17:'MaxVal'}
   _ValueMap={
              'CPULoad_Idle':0,
              'CPULoad_Kernel':1,
              'CPULoad_User':2,
              'Threads':3,
              'Processes':4,
              'Handles':5,
              'MemoryLoad':6,
              'PhysMemTotal':7,
              'PhysMemAvailable':8,
              'PhysMemBalloon':9,
              'MemCommitTotal':10,
              'MemKernelTotal':11,
              'MemKernelPaged':12,
              'MemKernelNonpaged':13,
              'MemSystemCache':14,
              'PageFileSize':15,
              'SampleNumber':16,
              'MaxVal':17}

   CPULoad_Idle=0
   CPULoad_Kernel=1
   CPULoad_User=2
   Threads=3
   Processes=4
   Handles=5
   MemoryLoad=6
   PhysMemTotal=7
   PhysMemAvailable=8
   PhysMemBalloon=9
   MemCommitTotal=10
   MemKernelTotal=11
   MemKernelPaged=12
   MemKernelNonpaged=13
   MemSystemCache=14
   PageFileSize=15
   SampleNumber=16
   MaxVal=17

class BIOSBootMenuMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=BIOSBootMenuMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,BIOSBootMenuMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,BIOSBootMenuMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return BIOSBootMenuMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'MenuOnly',2:'MessageAndMenu'}
   _ValueMap={
              'Disabled':0,
              'MenuOnly':1,
              'MessageAndMenu':2}

   Disabled=0
   MenuOnly=1
   MessageAndMenu=2

class IDEControllerType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=IDEControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,IDEControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,IDEControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return IDEControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'PIIX3',2:'PIIX4'}
   _ValueMap={
              'Null':0,
              'PIIX3':1,
              'PIIX4':2}

   Null=0
   PIIX3=1
   PIIX4=2

class DriveState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DriveState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DriveState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DriveState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DriveState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'NotMounted',2:'ImageMounted',3:'HostDriveCaptured'}
   _ValueMap={
              'Null':0,
              'NotMounted':1,
              'ImageMounted':2,
              'HostDriveCaptured':3}

   Null=0
   NotMounted=1
   ImageMounted=2
   HostDriveCaptured=3

class HardDiskStorageType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HardDiskStorageType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HardDiskStorageType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HardDiskStorageType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HardDiskStorageType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'VirtualDiskImage',1:'ISCSIHardDisk',2:'VMDKImage',3:'CustomHardDisk',4:'VHDImage'}
   _ValueMap={
              'VirtualDiskImage':0,
              'ISCSIHardDisk':1,
              'VMDKImage':2,
              'CustomHardDisk':3,
              'VHDImage':4}

   VirtualDiskImage=0
   ISCSIHardDisk=1
   VMDKImage=2
   CustomHardDisk=3
   VHDImage=4

class HardDiskType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HardDiskType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HardDiskType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HardDiskType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HardDiskType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Normal',1:'Immutable',2:'Writethrough'}
   _ValueMap={
              'Normal':0,
              'Immutable':1,
              'Writethrough':2}

   Normal=0
   Immutable=1
   Writethrough=2

class MouseButtonState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=MouseButtonState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MouseButtonState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,MouseButtonState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return MouseButtonState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'LeftButton',0x02:'RightButton',0x04:'MiddleButton',0x08:'WheelUp',0x10:'WheelDown',0x1F:'MouseStateMask'}
   _ValueMap={
              'LeftButton':0x01,
              'RightButton':0x02,
              'MiddleButton':0x04,
              'WheelUp':0x08,
              'WheelDown':0x10,
              'MouseStateMask':0x1F}

   LeftButton=0x01
   RightButton=0x02
   MiddleButton=0x04
   WheelUp=0x08
   WheelDown=0x10
   MouseStateMask=0x1F

class FramebufferAccelerationOperation:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=FramebufferAccelerationOperation._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FramebufferAccelerationOperation):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,FramebufferAccelerationOperation):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return FramebufferAccelerationOperation._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'SolidFillAcceleration',2:'ScreenCopyAcceleration'}
   _ValueMap={
              'SolidFillAcceleration':1,
              'ScreenCopyAcceleration':2}

   SolidFillAcceleration=1
   ScreenCopyAcceleration=2

class FramebufferPixelFormat:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=FramebufferPixelFormat._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FramebufferPixelFormat):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,FramebufferPixelFormat):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return FramebufferPixelFormat._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0xFFFFFFFF:'Opaque',0x32424752:'FOURCC_RGB'}
   _ValueMap={
              'Opaque':0xFFFFFFFF,
              'FOURCC_RGB':0x32424752}

   Opaque=0xFFFFFFFF
   FOURCC_RGB=0x32424752

class NetworkAttachmentType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=NetworkAttachmentType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAttachmentType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAttachmentType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return NetworkAttachmentType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'NAT',2:'HostInterface',3:'Internal'}
   _ValueMap={
              'Null':0,
              'NAT':1,
              'HostInterface':2,
              'Internal':3}

   Null=0
   NAT=1
   HostInterface=2
   Internal=3

class NetworkAdapterType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=NetworkAdapterType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAdapterType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAdapterType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return NetworkAdapterType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Am79C970A',2:'Am79C973',3:'I82540EM',4:'I82543GC'}
   _ValueMap={
              'Null':0,
              'Am79C970A':1,
              'Am79C973':2,
              'I82540EM':3,
              'I82543GC':4}

   Null=0
   Am79C970A=1
   Am79C973=2
   I82540EM=3
   I82543GC=4

class PortMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=PortMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,PortMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,PortMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return PortMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disconnected',1:'HostPipe',2:'HostDevice'}
   _ValueMap={
              'Disconnected':0,
              'HostPipe':1,
              'HostDevice':2}

   Disconnected=0
   HostPipe=1
   HostDevice=2

class USBDeviceState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=USBDeviceState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBDeviceState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBDeviceState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return USBDeviceState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'NotSupported',1:'Unavailable',2:'Busy',3:'Available',4:'Held',5:'Captured'}
   _ValueMap={
              'NotSupported':0,
              'Unavailable':1,
              'Busy':2,
              'Available':3,
              'Held':4,
              'Captured':5}

   NotSupported=0
   Unavailable=1
   Busy=2
   Available=3
   Held=4
   Captured=5

class USBDeviceFilterAction:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=USBDeviceFilterAction._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBDeviceFilterAction):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBDeviceFilterAction):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return USBDeviceFilterAction._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Ignore',2:'Hold'}
   _ValueMap={
              'Null':0,
              'Ignore':1,
              'Hold':2}

   Null=0
   Ignore=1
   Hold=2

class AudioDriverType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=AudioDriverType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioDriverType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioDriverType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return AudioDriverType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'WinMM',2:'OSS',3:'ALSA',4:'DirectSound',5:'CoreAudio',6:'MMPM',7:'Pulse',8:'SolAudio'}
   _ValueMap={
              'Null':0,
              'WinMM':1,
              'OSS':2,
              'ALSA':3,
              'DirectSound':4,
              'CoreAudio':5,
              'MMPM':6,
              'Pulse':7,
              'SolAudio':8}

   Null=0
   WinMM=1
   OSS=2
   ALSA=3
   DirectSound=4
   CoreAudio=5
   MMPM=6
   Pulse=7
   SolAudio=8

class AudioControllerType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=AudioControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return AudioControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'AC97',1:'SB16'}
   _ValueMap={
              'AC97':0,
              'SB16':1}

   AC97=0
   SB16=1

class VRDPAuthType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=VRDPAuthType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VRDPAuthType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,VRDPAuthType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return VRDPAuthType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'External',2:'Guest'}
   _ValueMap={
              'Null':0,
              'External':1,
              'Guest':2}

   Null=0
   External=1
   Guest=2


class VirtualBoxReflectionInfo:
   def __init__(self):
      self.map = {}
  
   def add(self,name,ref):
      self.map[name] = ref

   def __getattr__(self,name):
      ref = self.map.get(name,None)
      if ref == None:
          return self.__dict__[name]
      return ref

g_reflectionInfo = VirtualBoxReflectionInfo()
g_reflectionInfo.add("TSBool",TSBool)
g_reflectionInfo.add("MachineState",MachineState)
g_reflectionInfo.add("SessionState",SessionState)
g_reflectionInfo.add("SessionType",SessionType)
g_reflectionInfo.add("DeviceType",DeviceType)
g_reflectionInfo.add("DeviceActivity",DeviceActivity)
g_reflectionInfo.add("ResourceUsage",ResourceUsage)
g_reflectionInfo.add("StorageBus",StorageBus)
g_reflectionInfo.add("ClipboardMode",ClipboardMode)
g_reflectionInfo.add("Scope",Scope)
g_reflectionInfo.add("GuestStatisticType",GuestStatisticType)
g_reflectionInfo.add("BIOSBootMenuMode",BIOSBootMenuMode)
g_reflectionInfo.add("IDEControllerType",IDEControllerType)
g_reflectionInfo.add("DriveState",DriveState)
g_reflectionInfo.add("HardDiskStorageType",HardDiskStorageType)
g_reflectionInfo.add("HardDiskType",HardDiskType)
g_reflectionInfo.add("MouseButtonState",MouseButtonState)
g_reflectionInfo.add("FramebufferAccelerationOperation",FramebufferAccelerationOperation)
g_reflectionInfo.add("FramebufferPixelFormat",FramebufferPixelFormat)
g_reflectionInfo.add("NetworkAttachmentType",NetworkAttachmentType)
g_reflectionInfo.add("NetworkAdapterType",NetworkAdapterType)
g_reflectionInfo.add("PortMode",PortMode)
g_reflectionInfo.add("USBDeviceState",USBDeviceState)
g_reflectionInfo.add("USBDeviceFilterAction",USBDeviceFilterAction)
g_reflectionInfo.add("AudioDriverType",AudioDriverType)
g_reflectionInfo.add("AudioControllerType",AudioControllerType)
g_reflectionInfo.add("VRDPAuthType",VRDPAuthType)
