
/**
 * Copyright (C) 2008-2009 Sun Microsystems, Inc.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Sun LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Sun elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
 * Clara, CA 95054 USA or visit http://www.sun.com if you need
 * additional information or have any questions.
 *
 * IHardDisk.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/webservice/glue-jaxws.xsl
 */


package com.sun.xml.ws.commons.virtualbox_2_2;

import org.virtualbox_2_2.VboxPortType;
import org.virtualbox_2_2.VboxService;
import org.virtualbox_2_2.InvalidObjectFaultMsg;
import org.virtualbox_2_2.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
public class IHardDisk extends IUnknown {

    public static IHardDisk cast(IUnknown other) {
        return new IHardDisk(other.getRef(), other.getRemoteWSPort());
    }

    public IHardDisk(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IHardDisk::format of type wstring
    public String getFormat() {
        try {
            String retVal = port.iHardDiskGetFormat(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IHardDisk::type of type HardDiskType
    public org.virtualbox_2_2.HardDiskType getType() {
        try {
            org.virtualbox_2_2.HardDiskType retVal = port.iHardDiskGetType(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setType(org.virtualbox_2_2.HardDiskType value) {
        try {
            port.iHardDiskSetType(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IHardDisk::parent of type IHardDisk
    public com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk getParent() {
        try {
            String retVal = port.iHardDiskGetParent(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IHardDisk::children of type IHardDisk
    public List<com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk> getChildren() {
        try {
            List<String> retVal = port.iHardDiskGetChildren(_this);
            return Helper.wrap(com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk.class, port, retVal);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IHardDisk::root of type IHardDisk
    public com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk getRoot() {
        try {
            String retVal = port.iHardDiskGetRoot(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IHardDisk::readOnly of type boolean
    public Boolean getReadOnly() {
        try {
            Boolean retVal = port.iHardDiskGetReadOnly(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IHardDisk::logicalSize of type unsigned long long
    public BigInteger getLogicalSize() {
        try {
            BigInteger retVal = port.iHardDiskGetLogicalSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IHardDisk::autoReset of type boolean
    public Boolean getAutoReset() {
        try {
            Boolean retVal = port.iHardDiskGetAutoReset(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setAutoReset(Boolean value) {
        try {
            port.iHardDiskSetAutoReset(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::getProperty(
            [in] wstring name,
            [return] wstring value)
     */
    public String getProperty(String name) {
        try {
            String retVal = port.iHardDiskGetProperty(_this, name);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::setProperty(
            [in] wstring name,
            [in] wstring value)
     */
    public void setProperty(String name, String value) {
        try {
            port.iHardDiskSetProperty(_this, name, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::getProperties(
            [in] wstring names,
            [out] wstring returnNames[],
            [return] wstring returnValues[])
     */
    public List<String> getProperties(String names, Holder<List<String>> returnNames) {
        try {
            Holder<List<String>> retVal = new Holder<List<String>>();
            port.iHardDiskGetProperties(_this, names, returnNames, retVal);
            return retVal.value;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::setProperties(
            [in] wstring names[],
            [in] wstring values[])
     */
    public void setProperties(List<String> names, List<String> values) {
        try {
            port.iHardDiskSetProperties(_this, names, values);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::createBaseStorage(
            [in] unsigned long long logicalSize,
            [in] HardDiskVariant variant,
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress createBaseStorage(BigInteger logicalSize, org.virtualbox_2_2.HardDiskVariant variant) {
        try {
            String retVal = port.iHardDiskCreateBaseStorage(_this, logicalSize, variant);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::deleteStorage(
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress deleteStorage() {
        try {
            String retVal = port.iHardDiskDeleteStorage(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::createDiffStorage(
            [in] IHardDisk target,
            [in] HardDiskVariant variant,
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress createDiffStorage(com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk target, org.virtualbox_2_2.HardDiskVariant variant) {
        try {
            String retVal = port.iHardDiskCreateDiffStorage(_this, ((target == null)?null:target.getRef()), variant);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::mergeTo(
            [in] uuid targetId,
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress mergeTo(UUID targetId) {
        try {
            String retVal = port.iHardDiskMergeTo(_this, targetId.toString());
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::cloneTo(
            [in] IHardDisk target,
            [in] HardDiskVariant variant,
            [in] IHardDisk parent,
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress cloneTo(com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk target, org.virtualbox_2_2.HardDiskVariant variant, com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk parent) {
        try {
            String retVal = port.iHardDiskCloneTo(_this, ((target == null)?null:target.getRef()), variant, ((parent == null)?null:parent.getRef()));
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::compact(
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress compact() {
        try {
            String retVal = port.iHardDiskCompact(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IHardDisk::reset(
            [return] IProgress progress)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IProgress reset() {
        try {
            String retVal = port.iHardDiskReset(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IProgress(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
