/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox_2_2;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.virtualbox_2_2.VboxPortType;
import org.virtualbox_2_2.VboxService;

class PortPool {
    private Map<VboxPortType, Integer> known = new HashMap<VboxPortType, Integer>();
    private boolean initStarted;
    private VboxService svc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PortPool(boolean bl) {
        if (bl) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = PortPool.this.known;
                    synchronized (map) {
                        PortPool.this.initStarted = true;
                        PortPool.this.known.notify();
                    }
                    PortPool.this.preinit();
                }
            }).start();
            Map<VboxPortType, Integer> map = this.known;
            synchronized (map) {
                while (!this.initStarted) {
                    try {
                        this.known.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    private synchronized void preinit() {
        VboxPortType vboxPortType = this.getPort();
        this.releasePort(vboxPortType);
    }

    synchronized VboxPortType getPort() {
        VboxPortType vboxPortType = null;
        for (VboxPortType vboxPortType2 : this.known.keySet()) {
            if (this.known.get(vboxPortType2) != 0) continue;
            vboxPortType = vboxPortType2;
            break;
        }
        if (vboxPortType == null) {
            if (this.svc == null) {
                URL uRL = PortPool.class.getClassLoader().getResource("vboxwebService.wsdl");
                if (uRL == null) {
                    throw new LinkageError("vboxwebService.wsdl not found, but it should have been in the jar");
                }
                this.svc = new VboxService(uRL, new QName("http://www.virtualbox.org/Service", "vboxService"));
            }
            vboxPortType = this.svc.getVboxServicePort();
        }
        this.known.put(vboxPortType, new Integer(1));
        return vboxPortType;
    }

    synchronized void releasePort(VboxPortType vboxPortType) {
        Integer n = this.known.get(vboxPortType);
        if (n == null || n == 0) {
            return;
        }
        this.known.put(vboxPortType, n - 1);
    }
}

