
/**
 * Copyright (C) 2008-2009 Sun Microsystems, Inc.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Sun LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Sun elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
 * Clara, CA 95054 USA or visit http://www.sun.com if you need
 * additional information or have any questions.
 *
 * IMachine.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/webservice/glue-jaxws.xsl
 */


package com.sun.xml.ws.commons.virtualbox_2_2;

import org.virtualbox_2_2.VboxPortType;
import org.virtualbox_2_2.VboxService;
import org.virtualbox_2_2.InvalidObjectFaultMsg;
import org.virtualbox_2_2.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
public class IMachine extends IUnknown {

    public static IMachine cast(IUnknown other) {
        return new IMachine(other.getRef(), other.getRemoteWSPort());
    }

    public IMachine(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IMachine::parent of type IVirtualBox
    public com.sun.xml.ws.commons.virtualbox_2_2.IVirtualBox getParent() {
        try {
            String retVal = port.iMachineGetParent(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IVirtualBox(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::accessible of type boolean
    public Boolean getAccessible() {
        try {
            Boolean retVal = port.iMachineGetAccessible(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // Skipping attribute IVirtualBoxErrorInfo for it is of suppressed type IVirtualBoxErrorInfo

    // read/write attribute IMachine::name of type wstring
    public String getName() {
        try {
            String retVal = port.iMachineGetName(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setName(String value) {
        try {
            port.iMachineSetName(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::description of type wstring
    public String getDescription() {
        try {
            String retVal = port.iMachineGetDescription(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setDescription(String value) {
        try {
            port.iMachineSetDescription(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::id of type uuid
    public UUID getId() {
        try {
            String retVal = port.iMachineGetId(_this);
            return UUID.fromString(retVal);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::OSTypeId of type wstring
    public String getOSTypeId() {
        try {
            String retVal = port.iMachineGetOSTypeId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setOSTypeId(String value) {
        try {
            port.iMachineSetOSTypeId(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::HardwareVersion of type wstring
    public String getHardwareVersion() {
        try {
            String retVal = port.iMachineGetHardwareVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setHardwareVersion(String value) {
        try {
            port.iMachineSetHardwareVersion(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::CPUCount of type unsigned long
    public Long getCPUCount() {
        try {
            Long retVal = port.iMachineGetCPUCount(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setCPUCount(Long value) {
        try {
            port.iMachineSetCPUCount(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::memorySize of type unsigned long
    public Long getMemorySize() {
        try {
            Long retVal = port.iMachineGetMemorySize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMemorySize(Long value) {
        try {
            port.iMachineSetMemorySize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::memoryBalloonSize of type unsigned long
    public Long getMemoryBalloonSize() {
        try {
            Long retVal = port.iMachineGetMemoryBalloonSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMemoryBalloonSize(Long value) {
        try {
            port.iMachineSetMemoryBalloonSize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::statisticsUpdateInterval of type unsigned long
    public Long getStatisticsUpdateInterval() {
        try {
            Long retVal = port.iMachineGetStatisticsUpdateInterval(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setStatisticsUpdateInterval(Long value) {
        try {
            port.iMachineSetStatisticsUpdateInterval(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::VRAMSize of type unsigned long
    public Long getVRAMSize() {
        try {
            Long retVal = port.iMachineGetVRAMSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setVRAMSize(Long value) {
        try {
            port.iMachineSetVRAMSize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::accelerate3DEnabled of type boolean
    public Boolean getAccelerate3DEnabled() {
        try {
            Boolean retVal = port.iMachineGetAccelerate3DEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setAccelerate3DEnabled(Boolean value) {
        try {
            port.iMachineSetAccelerate3DEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::monitorCount of type unsigned long
    public Long getMonitorCount() {
        try {
            Long retVal = port.iMachineGetMonitorCount(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMonitorCount(Long value) {
        try {
            port.iMachineSetMonitorCount(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::BIOSSettings of type IBIOSSettings
    public com.sun.xml.ws.commons.virtualbox_2_2.IBIOSSettings getBIOSSettings() {
        try {
            String retVal = port.iMachineGetBIOSSettings(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IBIOSSettings(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::HWVirtExEnabled of type TSBool
    public org.virtualbox_2_2.TSBool getHWVirtExEnabled() {
        try {
            org.virtualbox_2_2.TSBool retVal = port.iMachineGetHWVirtExEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setHWVirtExEnabled(org.virtualbox_2_2.TSBool value) {
        try {
            port.iMachineSetHWVirtExEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::HWVirtExNestedPagingEnabled of type boolean
    public Boolean getHWVirtExNestedPagingEnabled() {
        try {
            Boolean retVal = port.iMachineGetHWVirtExNestedPagingEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setHWVirtExNestedPagingEnabled(Boolean value) {
        try {
            port.iMachineSetHWVirtExNestedPagingEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::HWVirtExVPIDEnabled of type boolean
    public Boolean getHWVirtExVPIDEnabled() {
        try {
            Boolean retVal = port.iMachineGetHWVirtExVPIDEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setHWVirtExVPIDEnabled(Boolean value) {
        try {
            port.iMachineSetHWVirtExVPIDEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::PAEEnabled of type boolean
    public Boolean getPAEEnabled() {
        try {
            Boolean retVal = port.iMachineGetPAEEnabled(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setPAEEnabled(Boolean value) {
        try {
            port.iMachineSetPAEEnabled(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::snapshotFolder of type wstring
    public String getSnapshotFolder() {
        try {
            String retVal = port.iMachineGetSnapshotFolder(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setSnapshotFolder(String value) {
        try {
            port.iMachineSetSnapshotFolder(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::VRDPServer of type IVRDPServer
    public com.sun.xml.ws.commons.virtualbox_2_2.IVRDPServer getVRDPServer() {
        try {
            String retVal = port.iMachineGetVRDPServer(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IVRDPServer(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::hardDiskAttachments of type IHardDiskAttachment
    public List<org.virtualbox_2_2.IHardDiskAttachment> getHardDiskAttachments() {
        try {
            List<org.virtualbox_2_2.IHardDiskAttachment> retVal = port.iMachineGetHardDiskAttachments(_this);
            return /* 2 */retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::DVDDrive of type IDVDDrive
    public com.sun.xml.ws.commons.virtualbox_2_2.IDVDDrive getDVDDrive() {
        try {
            String retVal = port.iMachineGetDVDDrive(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IDVDDrive(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::floppyDrive of type IFloppyDrive
    public com.sun.xml.ws.commons.virtualbox_2_2.IFloppyDrive getFloppyDrive() {
        try {
            String retVal = port.iMachineGetFloppyDrive(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IFloppyDrive(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::USBController of type IUSBController
    public com.sun.xml.ws.commons.virtualbox_2_2.IUSBController getUSBController() {
        try {
            String retVal = port.iMachineGetUSBController(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IUSBController(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::audioAdapter of type IAudioAdapter
    public com.sun.xml.ws.commons.virtualbox_2_2.IAudioAdapter getAudioAdapter() {
        try {
            String retVal = port.iMachineGetAudioAdapter(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IAudioAdapter(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::storageControllers of type IStorageController
    public List<com.sun.xml.ws.commons.virtualbox_2_2.IStorageController> getStorageControllers() {
        try {
            List<String> retVal = port.iMachineGetStorageControllers(_this);
            return Helper.wrap(com.sun.xml.ws.commons.virtualbox_2_2.IStorageController.class, port, retVal);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::settingsFilePath of type wstring
    public String getSettingsFilePath() {
        try {
            String retVal = port.iMachineGetSettingsFilePath(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::settingsFileVersion of type wstring
    public String getSettingsFileVersion() {
        try {
            String retVal = port.iMachineGetSettingsFileVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::settingsModified of type boolean
    public Boolean getSettingsModified() {
        try {
            Boolean retVal = port.iMachineGetSettingsModified(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sessionState of type SessionState
    public org.virtualbox_2_2.SessionState getSessionState() {
        try {
            org.virtualbox_2_2.SessionState retVal = port.iMachineGetSessionState(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sessionType of type wstring
    public String getSessionType() {
        try {
            String retVal = port.iMachineGetSessionType(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sessionPid of type unsigned long
    public Long getSessionPid() {
        try {
            Long retVal = port.iMachineGetSessionPid(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::state of type MachineState
    public org.virtualbox_2_2.MachineState getState() {
        try {
            org.virtualbox_2_2.MachineState retVal = port.iMachineGetState(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::lastStateChange of type long long
    public Long getLastStateChange() {
        try {
            Long retVal = port.iMachineGetLastStateChange(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::stateFilePath of type wstring
    public String getStateFilePath() {
        try {
            String retVal = port.iMachineGetStateFilePath(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::logFolder of type wstring
    public String getLogFolder() {
        try {
            String retVal = port.iMachineGetLogFolder(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::currentSnapshot of type ISnapshot
    public com.sun.xml.ws.commons.virtualbox_2_2.ISnapshot getCurrentSnapshot() {
        try {
            String retVal = port.iMachineGetCurrentSnapshot(_this);
            return new com.sun.xml.ws.commons.virtualbox_2_2.ISnapshot(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::snapshotCount of type unsigned long
    public Long getSnapshotCount() {
        try {
            Long retVal = port.iMachineGetSnapshotCount(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::currentStateModified of type boolean
    public Boolean getCurrentStateModified() {
        try {
            Boolean retVal = port.iMachineGetCurrentStateModified(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMachine::sharedFolders of type ISharedFolder
    public List<org.virtualbox_2_2.ISharedFolder> getSharedFolders() {
        try {
            List<org.virtualbox_2_2.ISharedFolder> retVal = port.iMachineGetSharedFolders(_this);
            return /* 2 */retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::clipboardMode of type ClipboardMode
    public org.virtualbox_2_2.ClipboardMode getClipboardMode() {
        try {
            org.virtualbox_2_2.ClipboardMode retVal = port.iMachineGetClipboardMode(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setClipboardMode(org.virtualbox_2_2.ClipboardMode value) {
        try {
            port.iMachineSetClipboardMode(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMachine::guestPropertyNotificationPatterns of type wstring
    public String getGuestPropertyNotificationPatterns() {
        try {
            String retVal = port.iMachineGetGuestPropertyNotificationPatterns(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setGuestPropertyNotificationPatterns(String value) {
        try {
            port.iMachineSetGuestPropertyNotificationPatterns(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setBootOrder(
            [in] unsigned long position,
            [in] DeviceType device)
     */
    public void setBootOrder(Long position, org.virtualbox_2_2.DeviceType device) {
        try {
            port.iMachineSetBootOrder(_this, position, device);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getBootOrder(
            [in] unsigned long position,
            [return] DeviceType device)
     */
    public org.virtualbox_2_2.DeviceType getBootOrder(Long position) {
        try {
            org.virtualbox_2_2.DeviceType retVal = port.iMachineGetBootOrder(_this, position);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::attachHardDisk(
            [in] uuid id,
            [in] wstring name,
            [in] long controllerPort,
            [in] long device)
     */
    public void attachHardDisk(UUID id, String name, Integer controllerPort, Integer device) {
        try {
            port.iMachineAttachHardDisk(_this, id.toString(), name, controllerPort, device);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getHardDisk(
            [in] wstring name,
            [in] long controllerPort,
            [in] long device,
            [return] IHardDisk hardDisk)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk getHardDisk(String name, Integer controllerPort, Integer device) {
        try {
            String retVal = port.iMachineGetHardDisk(_this, name, controllerPort, device);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IHardDisk(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::detachHardDisk(
            [in] wstring name,
            [in] long controllerPort,
            [in] long device)
     */
    public void detachHardDisk(String name, Integer controllerPort, Integer device) {
        try {
            port.iMachineDetachHardDisk(_this, name, controllerPort, device);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getHardDiskAttachmentsOfController(
            [in] wstring name,
            [return] IHardDiskAttachment hardDiskAttachments[])
     */
    public List<org.virtualbox_2_2.IHardDiskAttachment> getHardDiskAttachmentsOfController(String name) {
        try {
            List<org.virtualbox_2_2.IHardDiskAttachment> retVal = port.iMachineGetHardDiskAttachmentsOfController(_this, name);
            return /* 2 */retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getNetworkAdapter(
            [in] unsigned long slot,
            [return] INetworkAdapter adapter)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.INetworkAdapter getNetworkAdapter(Long slot) {
        try {
            String retVal = port.iMachineGetNetworkAdapter(_this, slot);
            return new com.sun.xml.ws.commons.virtualbox_2_2.INetworkAdapter(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::addStorageController(
            [in] wstring name,
            [in] StorageBus connectionType,
            [return] IStorageController controller)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IStorageController addStorageController(String name, org.virtualbox_2_2.StorageBus connectionType) {
        try {
            String retVal = port.iMachineAddStorageController(_this, name, connectionType);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IStorageController(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getStorageControllerByName(
            [in] wstring name,
            [return] IStorageController storageController)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IStorageController getStorageControllerByName(String name) {
        try {
            String retVal = port.iMachineGetStorageControllerByName(_this, name);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IStorageController(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::removeStorageController(
            [in] wstring name)
     */
    public void removeStorageController(String name) {
        try {
            port.iMachineRemoveStorageController(_this, name);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getSerialPort(
            [in] unsigned long slot,
            [return] ISerialPort port)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.ISerialPort getSerialPort(Long slot) {
        try {
            String retVal = port.iMachineGetSerialPort(_this, slot);
            return new com.sun.xml.ws.commons.virtualbox_2_2.ISerialPort(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getParallelPort(
            [in] unsigned long slot,
            [return] IParallelPort port)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IParallelPort getParallelPort(Long slot) {
        try {
            String retVal = port.iMachineGetParallelPort(_this, slot);
            return new com.sun.xml.ws.commons.virtualbox_2_2.IParallelPort(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getNextExtraDataKey(
            [in] wstring key,
            [out] wstring nextKey,
            [out] wstring nextValue)
     */
    public void getNextExtraDataKey(String key, Holder<String> nextKey, Holder<String> nextValue) {
        try {
            port.iMachineGetNextExtraDataKey(_this, key, nextKey, nextValue);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getExtraData(
            [in] wstring key,
            [return] wstring value)
     */
    public String getExtraData(String key) {
        try {
            String retVal = port.iMachineGetExtraData(_this, key);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setExtraData(
            [in] wstring key,
            [in] wstring value)
     */
    public void setExtraData(String key, String value) {
        try {
            port.iMachineSetExtraData(_this, key, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::saveSettings()
     */
    public void saveSettings() {
        try {
            port.iMachineSaveSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::saveSettingsWithBackup(
            [return] wstring bakFileName)
     */
    public String saveSettingsWithBackup() {
        try {
            String retVal = port.iMachineSaveSettingsWithBackup(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::discardSettings()
     */
    public void discardSettings() {
        try {
            port.iMachineDiscardSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::deleteSettings()
     */
    public void deleteSettings() {
        try {
            port.iMachineDeleteSettings(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::export(
            [in] IAppliance aAppliance,
            [return] IVirtualSystemDescription aDescription)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.IVirtualSystemDescription export(com.sun.xml.ws.commons.virtualbox_2_2.IAppliance aAppliance) {
        try {
            String retVal = port.iMachineExport(_this, ((aAppliance == null)?null:aAppliance.getRef()));
            return new com.sun.xml.ws.commons.virtualbox_2_2.IVirtualSystemDescription(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getSnapshot(
            [in] uuid id,
            [return] ISnapshot snapshot)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.ISnapshot getSnapshot(UUID id) {
        try {
            String retVal = port.iMachineGetSnapshot(_this, id.toString());
            return new com.sun.xml.ws.commons.virtualbox_2_2.ISnapshot(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::findSnapshot(
            [in] wstring name,
            [return] ISnapshot snapshot)
     */
    public com.sun.xml.ws.commons.virtualbox_2_2.ISnapshot findSnapshot(String name) {
        try {
            String retVal = port.iMachineFindSnapshot(_this, name);
            return new com.sun.xml.ws.commons.virtualbox_2_2.ISnapshot(retVal, port);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setCurrentSnapshot(
            [in] uuid id)
     */
    public void setCurrentSnapshot(UUID id) {
        try {
            port.iMachineSetCurrentSnapshot(_this, id.toString());
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::createSharedFolder(
            [in] wstring name,
            [in] wstring hostPath,
            [in] boolean writable)
     */
    public void createSharedFolder(String name, String hostPath, Boolean writable) {
        try {
            port.iMachineCreateSharedFolder(_this, name, hostPath, writable);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::removeSharedFolder(
            [in] wstring name)
     */
    public void removeSharedFolder(String name) {
        try {
            port.iMachineRemoveSharedFolder(_this, name);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::canShowConsoleWindow(
            [return] boolean canShow)
     */
    public Boolean canShowConsoleWindow() {
        try {
            Boolean retVal = port.iMachineCanShowConsoleWindow(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::showConsoleWindow(
            [return] unsigned long long winId)
     */
    public BigInteger showConsoleWindow() {
        try {
            BigInteger retVal = port.iMachineShowConsoleWindow(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getGuestProperty(
            [in] wstring name,
            [out] wstring value,
            [out] unsigned long long timestamp,
            [out] wstring flags)
     */
    public void getGuestProperty(String name, Holder<String> value, Holder<BigInteger> timestamp, Holder<String> flags) {
        try {
            port.iMachineGetGuestProperty(_this, name, value, timestamp, flags);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getGuestPropertyValue(
            [in] wstring property,
            [return] wstring value)
     */
    public String getGuestPropertyValue(String property) {
        try {
            String retVal = port.iMachineGetGuestPropertyValue(_this, property);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::getGuestPropertyTimestamp(
            [in] wstring property,
            [return] unsigned long long value)
     */
    public BigInteger getGuestPropertyTimestamp(String property) {
        try {
            BigInteger retVal = port.iMachineGetGuestPropertyTimestamp(_this, property);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setGuestProperty(
            [in] wstring property,
            [in] wstring value,
            [in] wstring flags)
     */
    public void setGuestProperty(String property, String value, String flags) {
        try {
            port.iMachineSetGuestProperty(_this, property, value, flags);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::setGuestPropertyValue(
            [in] wstring property,
            [in] wstring value)
     */
    public void setGuestPropertyValue(String property, String value) {
        try {
            port.iMachineSetGuestPropertyValue(_this, property, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMachine::enumerateGuestProperties(
            [in] wstring patterns,
            [out] wstring name[],
            [out] wstring value[],
            [out] unsigned long long timestamp[],
            [out] wstring flags[])
     */
    public void enumerateGuestProperties(String patterns, Holder<List<String>> name, Holder<List<String>> value, Holder<List<BigInteger>> timestamp, Holder<List<String>> flags) {
        try {
            port.iMachineEnumerateGuestProperties(_this, patterns, name, value, timestamp, flags);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
