
/**
 * Copyright (C) 2008-2009 Sun Microsystems, Inc.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Sun LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Sun elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
 * Clara, CA 95054 USA or visit http://www.sun.com if you need
 * additional information or have any questions.
 *
 * IVirtualSystemDescription.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/webservice/glue-jaxws.xsl
 */


package com.sun.xml.ws.commons.virtualbox_2_2;

import org.virtualbox_2_2.VboxPortType;
import org.virtualbox_2_2.VboxService;
import org.virtualbox_2_2.InvalidObjectFaultMsg;
import org.virtualbox_2_2.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
public class IVirtualSystemDescription extends IUnknown {

    public static IVirtualSystemDescription cast(IUnknown other) {
        return new IVirtualSystemDescription(other.getRef(), other.getRemoteWSPort());
    }

    public IVirtualSystemDescription(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IVirtualSystemDescription::count of type unsigned long
    public Long getCount() {
        try {
            Long retVal = port.iVirtualSystemDescriptionGetCount(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualSystemDescription::getDescription(
            [out] VirtualSystemDescriptionType aTypes[],
            [out] wstring aRefs[],
            [out] wstring aOvfValues[],
            [out] wstring aVboxValues[],
            [out] wstring aExtraConfigValues[])
     */
    public void getDescription(Holder<List<org.virtualbox_2_2.VirtualSystemDescriptionType>> aTypes, Holder<List<String>> aRefs, Holder<List<String>> aOvfValues, Holder<List<String>> aVboxValues, Holder<List<String>> aExtraConfigValues) {
        try {
            port.iVirtualSystemDescriptionGetDescription(_this, aTypes, aRefs, aOvfValues, aVboxValues, aExtraConfigValues);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualSystemDescription::getDescriptionByType(
            [in] VirtualSystemDescriptionType aType,
            [out] VirtualSystemDescriptionType aTypes[],
            [out] wstring aRefs[],
            [out] wstring aOvfValues[],
            [out] wstring aVboxValues[],
            [out] wstring aExtraConfigValues[])
     */
    public void getDescriptionByType(org.virtualbox_2_2.VirtualSystemDescriptionType aType, Holder<List<org.virtualbox_2_2.VirtualSystemDescriptionType>> aTypes, Holder<List<String>> aRefs, Holder<List<String>> aOvfValues, Holder<List<String>> aVboxValues, Holder<List<String>> aExtraConfigValues) {
        try {
            port.iVirtualSystemDescriptionGetDescriptionByType(_this, aType, aTypes, aRefs, aOvfValues, aVboxValues, aExtraConfigValues);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualSystemDescription::getValuesByType(
            [in] VirtualSystemDescriptionType aType,
            [in] VirtualSystemDescriptionValueType aWhich,
            [return] wstring aValues[])
     */
    public List<String> getValuesByType(org.virtualbox_2_2.VirtualSystemDescriptionType aType, org.virtualbox_2_2.VirtualSystemDescriptionValueType aWhich) {
        try {
            List<String> retVal = port.iVirtualSystemDescriptionGetValuesByType(_this, aType, aWhich);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualSystemDescription::setFinalValues(
            [in] boolean aEnabled[],
            [in] wstring aVboxValues[],
            [in] wstring aExtraConfigValues[])
     */
    public void setFinalValues(List<Boolean> aEnabled, List<String> aVboxValues, List<String> aExtraConfigValues) {
        try {
            port.iVirtualSystemDescriptionSetFinalValues(_this, aEnabled, aVboxValues, aExtraConfigValues);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IVirtualSystemDescription::addDescription(
            [in] VirtualSystemDescriptionType aType,
            [in] wstring aVboxValue,
            [in] wstring aExtraConfigValue)
     */
    public void addDescription(org.virtualbox_2_2.VirtualSystemDescriptionType aType, String aVboxValue, String aExtraConfigValue) {
        try {
            port.iVirtualSystemDescriptionAddDescription(_this, aType, aVboxValue, aExtraConfigValue);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
