# Copyright (C) 2008 Sun Microsystems, Inc.
#
# This file is part of VirtualBox Open Source Edition (OSE), as
# available from http://www.virtualbox.org. This file is free software;
# you can redistribute it and/or modify it under the terms of the GNU
# General Public License (GPL) as published by the Free Software
# Foundation, in version 2 as it comes in the "COPYING" file of the
# VirtualBox OSE distribution. VirtualBox OSE is distributed in the
# hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
#
# Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
# Clara, CA 95054 USA or visit http://www.sun.com if you need
# additional information or have any questions.
#
# This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
#
from VirtualBox_services import *

g_port = vboxServiceLocator().getvboxPortType()

class ManagedManager:
  def __init__(self):
     self.map = {}

  def register(self,handle):
     if handle == None:
        return
     c = self.map.get(handle,0)
     c = c + 1
     self.map[handle]=c

  def unregister(self,handle):
     if handle == None:
        return
     c = self.map.get(handle,-1)
     if c == -1:
        raise Error, 'wrong refcount'
     c = c - 1
     if c == 0:
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass
        finally:
            self.map[handle] = -1
     else:
        self.map[handle] = c

g_manMgr = ManagedManager()

class String:
  def __init__(self, handle = None, isarray = False):
      self.handle = handle
      self.isarray = isarray
 
  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return String(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

  def __str__(self):
      return self.handle

  def __eq__(self,other):
      if self.isarray:
         return isinstance(other,String) and self.handle == other.handle
      if isinstance(other,String):
         return self.handle == other.handle
      if isinstance(other,basestring):
         return self.handle == other
      return False

  def __ne__(self,other):
      if self.isarray:
         return not isinstance(other,String) or self.handle == other.handle     
      if isinstance(other,String):
         return self.handle != other.handle
      if isinstance(other,basestring):
         return self.handle != other
      return True


class UUID:
  def __init__(self, handle = None, isarray = False):
      self.handle = handle
      self.isarray = isarray
 
  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return UUID(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

  def __str__(self):
      return self.handle

  def __eq__(self,other):
      if self.isarray:
         return isinstance(other,UUID) and self.handle == other.handle
      if isinstance(other,UUID):
         return self.handle == other.handle
      if isinstance(other,basestring):
         return self.handle == other
      return False

  def __ne__(self,other):
      if self.isarray:
         return not isinstance(other,UUID) or self.handle == other.handle     
      if isinstance(other,UUID):
         return self.handle != other.handle
      if isinstance(other,basestring):
         return self.handle != other
      return True

class Boolean:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
       self.isarray = isarray
 
  def __str__(self):
       return "true" if self.handle else "false"

  def __eq__(self,other):
      if isinstance(other,Bool):
         return self.handle == other.value
      if isinstance(other,bool):
         return self.handle == other
      return False

  def __ne__(self,other):
      if isinstance(other,Bool):
         return self.handle != other.handle
      if isinstance(other,bool):
         return self.handle != other
      return True

class UnsignedInt:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
       self.isarray = isarray
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return UnsignedInt(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

    
class Int:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
       self.isarray = isarray

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return Int(self.handle[index])
      raise TypeError, "iteration over non-sequence"       
 
  def __str__(self):
       return str(self.handle)
  
  def __int__(self):
       return int(self.handle)

class UnsignedShort:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
       self.isarray = isarray
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Short:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)
  
  def __int__(self):
       return int(self.handle)

class UnsignedLong:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Long:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Double:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)

class Float:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
 
  def __str__(self):
       return str(self.handle)

  def __int__(self):
       return int(self.handle)


class IUnknown:
  def __init__(self, handle = None, isarray = False):
       self.handle = handle
       self.isarray = isarray

  def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

  def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

  def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

  def __getitem__(self, index):
      if self.isarray:
          return IUnknown(self.handle[index])
      raise TypeError, "iteration over non-sequence"       
  
  def __str__(self):
       return str(self.handle)


class IDHCPServer:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IDHCPServer(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDHCPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IDHCPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def setConfiguration(self, _arg_IPAddress, _arg_networkMask, _arg_FromIPAddress, _arg_ToIPAddress):
       req=IDHCPServer_setConfigurationRequestMsg()
       req._this=self.handle
       
       req._IPAddress=_arg_IPAddress
       req._networkMask=_arg_networkMask
       req._FromIPAddress=_arg_FromIPAddress
       req._ToIPAddress=_arg_ToIPAddress
       val=g_port.IDHCPServer_setConfiguration(req)
             
       return 

 
   def start(self, _arg_networkName, _arg_trunkName, _arg_trunkType):
       req=IDHCPServer_startRequestMsg()
       req._this=self.handle
       
       req._networkName=_arg_networkName
       req._trunkName=_arg_trunkName
       req._trunkType=_arg_trunkType
       val=g_port.IDHCPServer_start(req)
             
       return 

 
   def stop(self):
       req=IDHCPServer_stopRequestMsg()
       req._this=self.handle
       
       val=g_port.IDHCPServer_stop(req)
             
       return 


   def getEnabled(self):
       req=IDHCPServer_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IDHCPServer_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IDHCPServer_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IDHCPServer_setEnabled(req)      

   def getIPAddress(self):
       req=IDHCPServer_getIPAddressRequestMsg()
       req._this=self.handle
       val=g_port.IDHCPServer_getIPAddress(req)
       return  String(val._returnval)
   def getNetworkMask(self):
       req=IDHCPServer_getNetworkMaskRequestMsg()
       req._this=self.handle
       val=g_port.IDHCPServer_getNetworkMask(req)
       return  String(val._returnval)
   def getNetworkName(self):
       req=IDHCPServer_getNetworkNameRequestMsg()
       req._this=self.handle
       val=g_port.IDHCPServer_getNetworkName(req)
       return  String(val._returnval)
   def getLowerIP(self):
       req=IDHCPServer_getLowerIPRequestMsg()
       req._this=self.handle
       val=g_port.IDHCPServer_getLowerIP(req)
       return  String(val._returnval)
   def getUpperIP(self):
       req=IDHCPServer_getUpperIPRequestMsg()
       req._this=self.handle
       val=g_port.IDHCPServer_getUpperIP(req)
       return  String(val._returnval)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'IPAddress':[getIPAddress,None],
         'networkMask':[getNetworkMask,None],
         'networkName':[getNetworkName,None],
         'lowerIP':[getLowerIP,None],
         'upperIP':[getUpperIP,None]}
class IVirtualBox:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualBox(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualBox._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVirtualBox._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createMachine(self, _arg_name, _arg_osTypeId, _arg_baseFolder, _arg_id):
       req=IVirtualBox_createMachineRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._osTypeId=_arg_osTypeId
       req._baseFolder=_arg_baseFolder
       req._id=_arg_id
       val=g_port.IVirtualBox_createMachine(req)
             
       return IMachine(val._returnval)

 
   def createLegacyMachine(self, _arg_name, _arg_osTypeId, _arg_settingsFile, _arg_id):
       req=IVirtualBox_createLegacyMachineRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._osTypeId=_arg_osTypeId
       req._settingsFile=_arg_settingsFile
       req._id=_arg_id
       val=g_port.IVirtualBox_createLegacyMachine(req)
             
       return IMachine(val._returnval)

 
   def openMachine(self, _arg_settingsFile):
       req=IVirtualBox_openMachineRequestMsg()
       req._this=self.handle
       
       req._settingsFile=_arg_settingsFile
       val=g_port.IVirtualBox_openMachine(req)
             
       return IMachine(val._returnval)

 
   def registerMachine(self, _arg_machine):
       req=IVirtualBox_registerMachineRequestMsg()
       req._this=self.handle
       
       req._machine=_arg_machine
       val=g_port.IVirtualBox_registerMachine(req)
             
       return 

 
   def getMachine(self, _arg_id):
       req=IVirtualBox_getMachineRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getMachine(req)
             
       return IMachine(val._returnval)

 
   def findMachine(self, _arg_name):
       req=IVirtualBox_findMachineRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IVirtualBox_findMachine(req)
             
       return IMachine(val._returnval)

 
   def unregisterMachine(self, _arg_id):
       req=IVirtualBox_unregisterMachineRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_unregisterMachine(req)
             
       return IMachine(val._returnval)

 
   def createAppliance(self):
       req=IVirtualBox_createApplianceRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualBox_createAppliance(req)
             
       return IAppliance(val._returnval)

 
   def createHardDisk(self, _arg_format, _arg_location):
       req=IVirtualBox_createHardDiskRequestMsg()
       req._this=self.handle
       
       req._format=_arg_format
       req._location=_arg_location
       val=g_port.IVirtualBox_createHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def openHardDisk(self, _arg_location, _arg_accessMode):
       req=IVirtualBox_openHardDiskRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       req._accessMode=_arg_accessMode
       val=g_port.IVirtualBox_openHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def getHardDisk(self, _arg_id):
       req=IVirtualBox_getHardDiskRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def findHardDisk(self, _arg_location):
       req=IVirtualBox_findHardDiskRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       val=g_port.IVirtualBox_findHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def openDVDImage(self, _arg_location, _arg_id):
       req=IVirtualBox_openDVDImageRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       req._id=_arg_id
       val=g_port.IVirtualBox_openDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def getDVDImage(self, _arg_id):
       req=IVirtualBox_getDVDImageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def findDVDImage(self, _arg_location):
       req=IVirtualBox_findDVDImageRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       val=g_port.IVirtualBox_findDVDImage(req)
             
       return IDVDImage(val._returnval)

 
   def openFloppyImage(self, _arg_location, _arg_id):
       req=IVirtualBox_openFloppyImageRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       req._id=_arg_id
       val=g_port.IVirtualBox_openFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def getFloppyImage(self, _arg_id):
       req=IVirtualBox_getFloppyImageRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def findFloppyImage(self, _arg_location):
       req=IVirtualBox_findFloppyImageRequestMsg()
       req._this=self.handle
       
       req._location=_arg_location
       val=g_port.IVirtualBox_findFloppyImage(req)
             
       return IFloppyImage(val._returnval)

 
   def getGuestOSType(self, _arg_id):
       req=IVirtualBox_getGuestOSTypeRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IVirtualBox_getGuestOSType(req)
             
       return IGuestOSType(val._returnval)

 
   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable):
       req=IVirtualBox_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       val=g_port.IVirtualBox_createSharedFolder(req)
             
       return 

 
   def removeSharedFolder(self, _arg_name):
       req=IVirtualBox_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IVirtualBox_removeSharedFolder(req)
             
       return 

 
   def getNextExtraDataKey(self, _arg_key):
       req=IVirtualBox_getNextExtraDataKeyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IVirtualBox_getNextExtraDataKey(req)
             
       return String(val._nextKey), String(val._nextValue)

 
   def getExtraData(self, _arg_key):
       req=IVirtualBox_getExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IVirtualBox_getExtraData(req)
             
       return String(val._returnval)

 
   def setExtraData(self, _arg_key, _arg_value):
       req=IVirtualBox_setExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=g_port.IVirtualBox_setExtraData(req)
             
       return 

 
   def openSession(self, _arg_session, _arg_machineId):
       req=IVirtualBox_openSessionRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._machineId=_arg_machineId
       val=g_port.IVirtualBox_openSession(req)
             
       return 

 
   def openRemoteSession(self, _arg_session, _arg_machineId, _arg_type, _arg_environment):
       req=IVirtualBox_openRemoteSessionRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._machineId=_arg_machineId
       req._type=_arg_type
       req._environment=_arg_environment
       val=g_port.IVirtualBox_openRemoteSession(req)
             
       return IProgress(val._returnval)

 
   def openExistingSession(self, _arg_session, _arg_machineId):
       req=IVirtualBox_openExistingSessionRequestMsg()
       req._this=self.handle
       
       req._session=_arg_session
       req._machineId=_arg_machineId
       val=g_port.IVirtualBox_openExistingSession(req)
             
       return 

 
   def registerCallback(self, _arg_callback):
       req=IVirtualBox_registerCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IVirtualBox_registerCallback(req)
             
       return 

 
   def unregisterCallback(self, _arg_callback):
       req=IVirtualBox_unregisterCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IVirtualBox_unregisterCallback(req)
             
       return 

 
   def waitForPropertyChange(self, _arg_what, _arg_timeout):
       req=IVirtualBox_waitForPropertyChangeRequestMsg()
       req._this=self.handle
       
       req._what=_arg_what
       req._timeout=_arg_timeout
       val=g_port.IVirtualBox_waitForPropertyChange(req)
             
       return String(val._changed), String(val._values)

 
   def saveSettings(self):
       req=IVirtualBox_saveSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualBox_saveSettings(req)
             
       return 

 
   def saveSettingsWithBackup(self):
       req=IVirtualBox_saveSettingsWithBackupRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualBox_saveSettingsWithBackup(req)
             
       return String(val._returnval)

 
   def createDHCPServer(self, _arg_name):
       req=IVirtualBox_createDHCPServerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IVirtualBox_createDHCPServer(req)
             
       return IDHCPServer(val._returnval)

 
   def findDHCPServerByNetworkName(self, _arg_name):
       req=IVirtualBox_findDHCPServerByNetworkNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IVirtualBox_findDHCPServerByNetworkName(req)
             
       return IDHCPServer(val._returnval)

 
   def removeDHCPServer(self, _arg_server):
       req=IVirtualBox_removeDHCPServerRequestMsg()
       req._this=self.handle
       
       req._server=_arg_server
       val=g_port.IVirtualBox_removeDHCPServer(req)
             
       return 


   def getVersion(self):
       req=IVirtualBox_getVersionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getVersion(req)
       return  String(val._returnval)
   def getRevision(self):
       req=IVirtualBox_getRevisionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getRevision(req)
       return  UnsignedInt(val._returnval)
   def getPackageType(self):
       req=IVirtualBox_getPackageTypeRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getPackageType(req)
       return  String(val._returnval)
   def getHomeFolder(self):
       req=IVirtualBox_getHomeFolderRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getHomeFolder(req)
       return  String(val._returnval)
   def getSettingsFilePath(self):
       req=IVirtualBox_getSettingsFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSettingsFilePath(req)
       return  String(val._returnval)
   def getSettingsFileVersion(self):
       req=IVirtualBox_getSettingsFileVersionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSettingsFileVersion(req)
       return  String(val._returnval)
   def getSettingsFormatVersion(self):
       req=IVirtualBox_getSettingsFormatVersionRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSettingsFormatVersion(req)
       return  String(val._returnval)
   def getHost(self):
       req=IVirtualBox_getHostRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getHost(req)
       return  IHost(val._returnval)
   def getSystemProperties(self):
       req=IVirtualBox_getSystemPropertiesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSystemProperties(req)
       return  ISystemProperties(val._returnval)
   def getMachines(self):
       req=IVirtualBox_getMachinesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getMachines(req)
       return  IMachine(val._returnval, True)
   def getHardDisks(self):
       req=IVirtualBox_getHardDisksRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getHardDisks(req)
       return  IHardDisk(val._returnval, True)
   def getDVDImages(self):
       req=IVirtualBox_getDVDImagesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getDVDImages(req)
       return  IDVDImage(val._returnval, True)
   def getFloppyImages(self):
       req=IVirtualBox_getFloppyImagesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getFloppyImages(req)
       return  IFloppyImage(val._returnval, True)
   def getProgressOperations(self):
       req=IVirtualBox_getProgressOperationsRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getProgressOperations(req)
       return  IProgress(val._returnval, True)
   def getGuestOSTypes(self):
       req=IVirtualBox_getGuestOSTypesRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getGuestOSTypes(req)
       return  IGuestOSType(val._returnval, True)
   def getSharedFolders(self):
       req=IVirtualBox_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getSharedFolders(req)
       return  ISharedFolder(val._returnval, True)
   def getPerformanceCollector(self):
       req=IVirtualBox_getPerformanceCollectorRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getPerformanceCollector(req)
       return  IPerformanceCollector(val._returnval)
   def getDHCPServers(self):
       req=IVirtualBox_getDHCPServersRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualBox_getDHCPServers(req)
       return  IDHCPServer(val._returnval, True)


   _Attrs_={         'version':[getVersion,None],
         'revision':[getRevision,None],
         'packageType':[getPackageType,None],
         'homeFolder':[getHomeFolder,None],
         'settingsFilePath':[getSettingsFilePath,None],
         'settingsFileVersion':[getSettingsFileVersion,None],
         'settingsFormatVersion':[getSettingsFormatVersion,None],
         'host':[getHost,None],
         'systemProperties':[getSystemProperties,None],
         'machines':[getMachines,None],
         'hardDisks':[getHardDisks,None],
         'DVDImages':[getDVDImages,None],
         'floppyImages':[getFloppyImages,None],
         'progressOperations':[getProgressOperations,None],
         'guestOSTypes':[getGuestOSTypes,None],
         'sharedFolders':[getSharedFolders,None],
         'performanceCollector':[getPerformanceCollector,None],
         'DHCPServers':[getDHCPServers,None]}
class IAppliance:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IAppliance(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IAppliance._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IAppliance._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def read(self, _arg_file):
       req=IAppliance_readRequestMsg()
       req._this=self.handle
       
       req._file=_arg_file
       val=g_port.IAppliance_read(req)
             
       return 

 
   def interpret(self):
       req=IAppliance_interpretRequestMsg()
       req._this=self.handle
       
       val=g_port.IAppliance_interpret(req)
             
       return 

 
   def importMachines(self):
       req=IAppliance_importMachinesRequestMsg()
       req._this=self.handle
       
       val=g_port.IAppliance_importMachines(req)
             
       return IProgress(val._returnval)

 
   def write(self, _arg_format, _arg_path):
       req=IAppliance_writeRequestMsg()
       req._this=self.handle
       
       req._format=_arg_format
       req._path=_arg_path
       val=g_port.IAppliance_write(req)
             
       return IProgress(val._returnval)

 
   def getWarnings(self):
       req=IAppliance_getWarningsRequestMsg()
       req._this=self.handle
       
       val=g_port.IAppliance_getWarnings(req)
             
       return String(val._returnval, True)


   def getPath(self):
       req=IAppliance_getPathRequestMsg()
       req._this=self.handle
       val=g_port.IAppliance_getPath(req)
       return  String(val._returnval)
   def getDisks(self):
       req=IAppliance_getDisksRequestMsg()
       req._this=self.handle
       val=g_port.IAppliance_getDisks(req)
       return  String(val._returnval, True)
   def getVirtualSystemDescriptions(self):
       req=IAppliance_getVirtualSystemDescriptionsRequestMsg()
       req._this=self.handle
       val=g_port.IAppliance_getVirtualSystemDescriptions(req)
       return  IVirtualSystemDescription(val._returnval, True)


   _Attrs_={         'path':[getPath,None],
         'disks':[getDisks,None],
         'virtualSystemDescriptions':[getVirtualSystemDescriptions,None]}
class IVirtualSystemDescription:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVirtualSystemDescription(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVirtualSystemDescription._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVirtualSystemDescription._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getDescription(self):
       req=IVirtualSystemDescription_getDescriptionRequestMsg()
       req._this=self.handle
       
       val=g_port.IVirtualSystemDescription_getDescription(req)
             
       return VirtualSystemDescriptionType(val._aTypes, True), String(val._aRefs, True), String(val._aOvfValues, True), String(val._aVboxValues, True), String(val._aExtraConfigValues, True)

 
   def getDescriptionByType(self, _arg_aType):
       req=IVirtualSystemDescription_getDescriptionByTypeRequestMsg()
       req._this=self.handle
       
       req._aType=_arg_aType
       val=g_port.IVirtualSystemDescription_getDescriptionByType(req)
             
       return VirtualSystemDescriptionType(val._aTypes, True), String(val._aRefs, True), String(val._aOvfValues, True), String(val._aVboxValues, True), String(val._aExtraConfigValues, True)

 
   def getValuesByType(self, _arg_aType, _arg_aWhich):
       req=IVirtualSystemDescription_getValuesByTypeRequestMsg()
       req._this=self.handle
       
       req._aType=_arg_aType
       req._aWhich=_arg_aWhich
       val=g_port.IVirtualSystemDescription_getValuesByType(req)
             
       return String(val._returnval, True)

 
   def setFinalValues(self, _arg_aEnabled, _arg_aVboxValues, _arg_aExtraConfigValues):
       req=IVirtualSystemDescription_setFinalValuesRequestMsg()
       req._this=self.handle
       
       req._aEnabled=_arg_aEnabled
       req._aVboxValues=_arg_aVboxValues
       req._aExtraConfigValues=_arg_aExtraConfigValues
       val=g_port.IVirtualSystemDescription_setFinalValues(req)
             
       return 

 
   def addDescription(self, _arg_aType, _arg_aVboxValue, _arg_aExtraConfigValue):
       req=IVirtualSystemDescription_addDescriptionRequestMsg()
       req._this=self.handle
       
       req._aType=_arg_aType
       req._aVboxValue=_arg_aVboxValue
       req._aExtraConfigValue=_arg_aExtraConfigValue
       val=g_port.IVirtualSystemDescription_addDescription(req)
             
       return 


   def getCount(self):
       req=IVirtualSystemDescription_getCountRequestMsg()
       req._this=self.handle
       val=g_port.IVirtualSystemDescription_getCount(req)
       return  UnsignedInt(val._returnval)


   _Attrs_={         'count':[getCount,None]}
class IBIOSSettings:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IBIOSSettings(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IBIOSSettings._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IBIOSSettings._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getLogoFadeIn(self):
       req=IBIOSSettings_getLogoFadeInRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoFadeIn(req)
       return  Boolean(val._returnval)
   def setLogoFadeIn(self, value):
       req=IBIOSSettings_setLogoFadeInRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoFadeIn = value
       else:
            req._logoFadeIn = value.handle
       g_port.IBIOSSettings_setLogoFadeIn(req)      

   def getLogoFadeOut(self):
       req=IBIOSSettings_getLogoFadeOutRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoFadeOut(req)
       return  Boolean(val._returnval)
   def setLogoFadeOut(self, value):
       req=IBIOSSettings_setLogoFadeOutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoFadeOut = value
       else:
            req._logoFadeOut = value.handle
       g_port.IBIOSSettings_setLogoFadeOut(req)      

   def getLogoDisplayTime(self):
       req=IBIOSSettings_getLogoDisplayTimeRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoDisplayTime(req)
       return  UnsignedInt(val._returnval)
   def setLogoDisplayTime(self, value):
       req=IBIOSSettings_setLogoDisplayTimeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoDisplayTime = value
       else:
            req._logoDisplayTime = value.handle
       g_port.IBIOSSettings_setLogoDisplayTime(req)      

   def getLogoImagePath(self):
       req=IBIOSSettings_getLogoImagePathRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getLogoImagePath(req)
       return  String(val._returnval)
   def setLogoImagePath(self, value):
       req=IBIOSSettings_setLogoImagePathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._logoImagePath = value
       else:
            req._logoImagePath = value.handle
       g_port.IBIOSSettings_setLogoImagePath(req)      

   def getBootMenuMode(self):
       req=IBIOSSettings_getBootMenuModeRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getBootMenuMode(req)
       return  BIOSBootMenuMode(val._returnval)
   def setBootMenuMode(self, value):
       req=IBIOSSettings_setBootMenuModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._bootMenuMode = value
       else:
            req._bootMenuMode = value.handle
       g_port.IBIOSSettings_setBootMenuMode(req)      

   def getACPIEnabled(self):
       req=IBIOSSettings_getACPIEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getACPIEnabled(req)
       return  Boolean(val._returnval)
   def setACPIEnabled(self, value):
       req=IBIOSSettings_setACPIEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._ACPIEnabled = value
       else:
            req._ACPIEnabled = value.handle
       g_port.IBIOSSettings_setACPIEnabled(req)      

   def getIOAPICEnabled(self):
       req=IBIOSSettings_getIOAPICEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getIOAPICEnabled(req)
       return  Boolean(val._returnval)
   def setIOAPICEnabled(self, value):
       req=IBIOSSettings_setIOAPICEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IOAPICEnabled = value
       else:
            req._IOAPICEnabled = value.handle
       g_port.IBIOSSettings_setIOAPICEnabled(req)      

   def getTimeOffset(self):
       req=IBIOSSettings_getTimeOffsetRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getTimeOffset(req)
       return  Long(val._returnval)
   def setTimeOffset(self, value):
       req=IBIOSSettings_setTimeOffsetRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._timeOffset = value
       else:
            req._timeOffset = value.handle
       g_port.IBIOSSettings_setTimeOffset(req)      

   def getPXEDebugEnabled(self):
       req=IBIOSSettings_getPXEDebugEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IBIOSSettings_getPXEDebugEnabled(req)
       return  Boolean(val._returnval)
   def setPXEDebugEnabled(self, value):
       req=IBIOSSettings_setPXEDebugEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._PXEDebugEnabled = value
       else:
            req._PXEDebugEnabled = value.handle
       g_port.IBIOSSettings_setPXEDebugEnabled(req)      



   _Attrs_={         'logoFadeIn':[getLogoFadeIn,setLogoFadeIn,
        ],
         'logoFadeOut':[getLogoFadeOut,setLogoFadeOut,
        ],
         'logoDisplayTime':[getLogoDisplayTime,setLogoDisplayTime,
        ],
         'logoImagePath':[getLogoImagePath,setLogoImagePath,
        ],
         'bootMenuMode':[getBootMenuMode,setBootMenuMode,
        ],
         'ACPIEnabled':[getACPIEnabled,setACPIEnabled,
        ],
         'IOAPICEnabled':[getIOAPICEnabled,setIOAPICEnabled,
        ],
         'timeOffset':[getTimeOffset,setTimeOffset,
        ],
         'PXEDebugEnabled':[getPXEDebugEnabled,setPXEDebugEnabled,
        ]}
class IMachine:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IMachine(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMachine._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IMachine._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def setBootOrder(self, _arg_position, _arg_device):
       req=IMachine_setBootOrderRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._device=_arg_device
       val=g_port.IMachine_setBootOrder(req)
             
       return 

 
   def getBootOrder(self, _arg_position):
       req=IMachine_getBootOrderRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=g_port.IMachine_getBootOrder(req)
             
       return DeviceType(val._returnval)

 
   def attachHardDisk(self, _arg_id, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_attachHardDiskRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=g_port.IMachine_attachHardDisk(req)
             
       return 

 
   def getHardDisk(self, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_getHardDiskRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=g_port.IMachine_getHardDisk(req)
             
       return IHardDisk(val._returnval)

 
   def detachHardDisk(self, _arg_name, _arg_controllerPort, _arg_device):
       req=IMachine_detachHardDiskRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._controllerPort=_arg_controllerPort
       req._device=_arg_device
       val=g_port.IMachine_detachHardDisk(req)
             
       return 

 
   def getHardDiskAttachmentsOfController(self, _arg_name):
       req=IMachine_getHardDiskAttachmentsOfControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_getHardDiskAttachmentsOfController(req)
             
       return IHardDiskAttachment(val._returnval, True)

 
   def getNetworkAdapter(self, _arg_slot):
       req=IMachine_getNetworkAdapterRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=g_port.IMachine_getNetworkAdapter(req)
             
       return INetworkAdapter(val._returnval)

 
   def addStorageController(self, _arg_name, _arg_connectionType):
       req=IMachine_addStorageControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._connectionType=_arg_connectionType
       val=g_port.IMachine_addStorageController(req)
             
       return IStorageController(val._returnval)

 
   def getStorageControllerByName(self, _arg_name):
       req=IMachine_getStorageControllerByNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_getStorageControllerByName(req)
             
       return IStorageController(val._returnval)

 
   def removeStorageController(self, _arg_name):
       req=IMachine_removeStorageControllerRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_removeStorageController(req)
             
       return 

 
   def getSerialPort(self, _arg_slot):
       req=IMachine_getSerialPortRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=g_port.IMachine_getSerialPort(req)
             
       return ISerialPort(val._returnval)

 
   def getParallelPort(self, _arg_slot):
       req=IMachine_getParallelPortRequestMsg()
       req._this=self.handle
       
       req._slot=_arg_slot
       val=g_port.IMachine_getParallelPort(req)
             
       return IParallelPort(val._returnval)

 
   def getNextExtraDataKey(self, _arg_key):
       req=IMachine_getNextExtraDataKeyRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IMachine_getNextExtraDataKey(req)
             
       return String(val._nextKey), String(val._nextValue)

 
   def getExtraData(self, _arg_key):
       req=IMachine_getExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       val=g_port.IMachine_getExtraData(req)
             
       return String(val._returnval)

 
   def setExtraData(self, _arg_key, _arg_value):
       req=IMachine_setExtraDataRequestMsg()
       req._this=self.handle
       
       req._key=_arg_key
       req._value=_arg_value
       val=g_port.IMachine_setExtraData(req)
             
       return 

 
   def saveSettings(self):
       req=IMachine_saveSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_saveSettings(req)
             
       return 

 
   def saveSettingsWithBackup(self):
       req=IMachine_saveSettingsWithBackupRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_saveSettingsWithBackup(req)
             
       return String(val._returnval)

 
   def discardSettings(self):
       req=IMachine_discardSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_discardSettings(req)
             
       return 

 
   def deleteSettings(self):
       req=IMachine_deleteSettingsRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_deleteSettings(req)
             
       return 

 
   def export(self, _arg_aAppliance):
       req=IMachine_exportRequestMsg()
       req._this=self.handle
       
       req._aAppliance=_arg_aAppliance
       val=g_port.IMachine_export(req)
             
       return IVirtualSystemDescription(val._returnval)

 
   def getSnapshot(self, _arg_id):
       req=IMachine_getSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IMachine_getSnapshot(req)
             
       return ISnapshot(val._returnval)

 
   def findSnapshot(self, _arg_name):
       req=IMachine_findSnapshotRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_findSnapshot(req)
             
       return ISnapshot(val._returnval)

 
   def setCurrentSnapshot(self, _arg_id):
       req=IMachine_setCurrentSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IMachine_setCurrentSnapshot(req)
             
       return 

 
   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable):
       req=IMachine_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       val=g_port.IMachine_createSharedFolder(req)
             
       return 

 
   def removeSharedFolder(self, _arg_name):
       req=IMachine_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_removeSharedFolder(req)
             
       return 

 
   def canShowConsoleWindow(self):
       req=IMachine_canShowConsoleWindowRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_canShowConsoleWindow(req)
             
       return Boolean(val._returnval)

 
   def showConsoleWindow(self):
       req=IMachine_showConsoleWindowRequestMsg()
       req._this=self.handle
       
       val=g_port.IMachine_showConsoleWindow(req)
             
       return UnsignedLong(val._returnval)

 
   def getGuestProperty(self, _arg_name):
       req=IMachine_getGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IMachine_getGuestProperty(req)
             
       return String(val._value), UnsignedLong(val._timestamp), String(val._flags)

 
   def getGuestPropertyValue(self, _arg_property):
       req=IMachine_getGuestPropertyValueRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=g_port.IMachine_getGuestPropertyValue(req)
             
       return String(val._returnval)

 
   def getGuestPropertyTimestamp(self, _arg_property):
       req=IMachine_getGuestPropertyTimestampRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       val=g_port.IMachine_getGuestPropertyTimestamp(req)
             
       return UnsignedLong(val._returnval)

 
   def setGuestProperty(self, _arg_property, _arg_value, _arg_flags):
       req=IMachine_setGuestPropertyRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       req._flags=_arg_flags
       val=g_port.IMachine_setGuestProperty(req)
             
       return 

 
   def setGuestPropertyValue(self, _arg_property, _arg_value):
       req=IMachine_setGuestPropertyValueRequestMsg()
       req._this=self.handle
       
       req._property=_arg_property
       req._value=_arg_value
       val=g_port.IMachine_setGuestPropertyValue(req)
             
       return 

 
   def enumerateGuestProperties(self, _arg_patterns):
       req=IMachine_enumerateGuestPropertiesRequestMsg()
       req._this=self.handle
       
       req._patterns=_arg_patterns
       val=g_port.IMachine_enumerateGuestProperties(req)
             
       return String(val._name, True), String(val._value, True), UnsignedLong(val._timestamp, True), String(val._flags, True)


   def getParent(self):
       req=IMachine_getParentRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getParent(req)
       return  IVirtualBox(val._returnval)
   def getAccessible(self):
       req=IMachine_getAccessibleRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getAccessible(req)
       return  Boolean(val._returnval)
   def getName(self):
       req=IMachine_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getName(req)
       return  String(val._returnval)
   def setName(self, value):
       req=IMachine_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._name = value
       else:
            req._name = value.handle
       g_port.IMachine_setName(req)      

   def getDescription(self):
       req=IMachine_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getDescription(req)
       return  String(val._returnval)
   def setDescription(self, value):
       req=IMachine_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._description = value
       else:
            req._description = value.handle
       g_port.IMachine_setDescription(req)      

   def getId(self):
       req=IMachine_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getId(req)
       return  UUID(val._returnval)
   def getOSTypeId(self):
       req=IMachine_getOSTypeIdRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getOSTypeId(req)
       return  String(val._returnval)
   def setOSTypeId(self, value):
       req=IMachine_setOSTypeIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._OSTypeId = value
       else:
            req._OSTypeId = value.handle
       g_port.IMachine_setOSTypeId(req)      

   def getHardwareVersion(self):
       req=IMachine_getHardwareVersionRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHardwareVersion(req)
       return  String(val._returnval)
   def setHardwareVersion(self, value):
       req=IMachine_setHardwareVersionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HardwareVersion = value
       else:
            req._HardwareVersion = value.handle
       g_port.IMachine_setHardwareVersion(req)      

   def getCPUCount(self):
       req=IMachine_getCPUCountRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getCPUCount(req)
       return  UnsignedInt(val._returnval)
   def setCPUCount(self, value):
       req=IMachine_setCPUCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._CPUCount = value
       else:
            req._CPUCount = value.handle
       g_port.IMachine_setCPUCount(req)      

   def getMemorySize(self):
       req=IMachine_getMemorySizeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getMemorySize(req)
       return  UnsignedInt(val._returnval)
   def setMemorySize(self, value):
       req=IMachine_setMemorySizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._memorySize = value
       else:
            req._memorySize = value.handle
       g_port.IMachine_setMemorySize(req)      

   def getMemoryBalloonSize(self):
       req=IMachine_getMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getMemoryBalloonSize(req)
       return  UnsignedInt(val._returnval)
   def setMemoryBalloonSize(self, value):
       req=IMachine_setMemoryBalloonSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._memoryBalloonSize = value
       else:
            req._memoryBalloonSize = value.handle
       g_port.IMachine_setMemoryBalloonSize(req)      

   def getStatisticsUpdateInterval(self):
       req=IMachine_getStatisticsUpdateIntervalRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getStatisticsUpdateInterval(req)
       return  UnsignedInt(val._returnval)
   def setStatisticsUpdateInterval(self, value):
       req=IMachine_setStatisticsUpdateIntervalRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._statisticsUpdateInterval = value
       else:
            req._statisticsUpdateInterval = value.handle
       g_port.IMachine_setStatisticsUpdateInterval(req)      

   def getVRAMSize(self):
       req=IMachine_getVRAMSizeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getVRAMSize(req)
       return  UnsignedInt(val._returnval)
   def setVRAMSize(self, value):
       req=IMachine_setVRAMSizeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._VRAMSize = value
       else:
            req._VRAMSize = value.handle
       g_port.IMachine_setVRAMSize(req)      

   def getAccelerate3DEnabled(self):
       req=IMachine_getAccelerate3DEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getAccelerate3DEnabled(req)
       return  Boolean(val._returnval)
   def setAccelerate3DEnabled(self, value):
       req=IMachine_setAccelerate3DEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._accelerate3DEnabled = value
       else:
            req._accelerate3DEnabled = value.handle
       g_port.IMachine_setAccelerate3DEnabled(req)      

   def getMonitorCount(self):
       req=IMachine_getMonitorCountRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getMonitorCount(req)
       return  UnsignedInt(val._returnval)
   def setMonitorCount(self, value):
       req=IMachine_setMonitorCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._monitorCount = value
       else:
            req._monitorCount = value.handle
       g_port.IMachine_setMonitorCount(req)      

   def getBIOSSettings(self):
       req=IMachine_getBIOSSettingsRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getBIOSSettings(req)
       return  IBIOSSettings(val._returnval)
   def getHWVirtExEnabled(self):
       req=IMachine_getHWVirtExEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHWVirtExEnabled(req)
       return  TSBool(val._returnval)
   def setHWVirtExEnabled(self, value):
       req=IMachine_setHWVirtExEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExEnabled = value
       else:
            req._HWVirtExEnabled = value.handle
       g_port.IMachine_setHWVirtExEnabled(req)      

   def getHWVirtExNestedPagingEnabled(self):
       req=IMachine_getHWVirtExNestedPagingEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHWVirtExNestedPagingEnabled(req)
       return  Boolean(val._returnval)
   def setHWVirtExNestedPagingEnabled(self, value):
       req=IMachine_setHWVirtExNestedPagingEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExNestedPagingEnabled = value
       else:
            req._HWVirtExNestedPagingEnabled = value.handle
       g_port.IMachine_setHWVirtExNestedPagingEnabled(req)      

   def getHWVirtExVPIDEnabled(self):
       req=IMachine_getHWVirtExVPIDEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHWVirtExVPIDEnabled(req)
       return  Boolean(val._returnval)
   def setHWVirtExVPIDEnabled(self, value):
       req=IMachine_setHWVirtExVPIDEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExVPIDEnabled = value
       else:
            req._HWVirtExVPIDEnabled = value.handle
       g_port.IMachine_setHWVirtExVPIDEnabled(req)      

   def getPAEEnabled(self):
       req=IMachine_getPAEEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getPAEEnabled(req)
       return  Boolean(val._returnval)
   def setPAEEnabled(self, value):
       req=IMachine_setPAEEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._PAEEnabled = value
       else:
            req._PAEEnabled = value.handle
       g_port.IMachine_setPAEEnabled(req)      

   def getSnapshotFolder(self):
       req=IMachine_getSnapshotFolderRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSnapshotFolder(req)
       return  String(val._returnval)
   def setSnapshotFolder(self, value):
       req=IMachine_setSnapshotFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._snapshotFolder = value
       else:
            req._snapshotFolder = value.handle
       g_port.IMachine_setSnapshotFolder(req)      

   def getVRDPServer(self):
       req=IMachine_getVRDPServerRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getVRDPServer(req)
       return  IVRDPServer(val._returnval)
   def getHardDiskAttachments(self):
       req=IMachine_getHardDiskAttachmentsRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getHardDiskAttachments(req)
       return  IHardDiskAttachment(val._returnval, True)
   def getDVDDrive(self):
       req=IMachine_getDVDDriveRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getDVDDrive(req)
       return  IDVDDrive(val._returnval)
   def getFloppyDrive(self):
       req=IMachine_getFloppyDriveRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getFloppyDrive(req)
       return  IFloppyDrive(val._returnval)
   def getUSBController(self):
       req=IMachine_getUSBControllerRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getUSBController(req)
       return  IUSBController(val._returnval)
   def getAudioAdapter(self):
       req=IMachine_getAudioAdapterRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getAudioAdapter(req)
       return  IAudioAdapter(val._returnval)
   def getStorageControllers(self):
       req=IMachine_getStorageControllersRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getStorageControllers(req)
       return  IStorageController(val._returnval, True)
   def getSettingsFilePath(self):
       req=IMachine_getSettingsFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSettingsFilePath(req)
       return  String(val._returnval)
   def getSettingsFileVersion(self):
       req=IMachine_getSettingsFileVersionRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSettingsFileVersion(req)
       return  String(val._returnval)
   def getSettingsModified(self):
       req=IMachine_getSettingsModifiedRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSettingsModified(req)
       return  Boolean(val._returnval)
   def getSessionState(self):
       req=IMachine_getSessionStateRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSessionState(req)
       return  SessionState(val._returnval)
   def getSessionType(self):
       req=IMachine_getSessionTypeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSessionType(req)
       return  String(val._returnval)
   def getSessionPid(self):
       req=IMachine_getSessionPidRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSessionPid(req)
       return  UnsignedInt(val._returnval)
   def getState(self):
       req=IMachine_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getState(req)
       return  MachineState(val._returnval)
   def getLastStateChange(self):
       req=IMachine_getLastStateChangeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getLastStateChange(req)
       return  Long(val._returnval)
   def getStateFilePath(self):
       req=IMachine_getStateFilePathRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getStateFilePath(req)
       return  String(val._returnval)
   def getLogFolder(self):
       req=IMachine_getLogFolderRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getLogFolder(req)
       return  String(val._returnval)
   def getCurrentSnapshot(self):
       req=IMachine_getCurrentSnapshotRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getCurrentSnapshot(req)
       return  ISnapshot(val._returnval)
   def getSnapshotCount(self):
       req=IMachine_getSnapshotCountRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSnapshotCount(req)
       return  UnsignedInt(val._returnval)
   def getCurrentStateModified(self):
       req=IMachine_getCurrentStateModifiedRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getCurrentStateModified(req)
       return  Boolean(val._returnval)
   def getSharedFolders(self):
       req=IMachine_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getSharedFolders(req)
       return  ISharedFolder(val._returnval, True)
   def getClipboardMode(self):
       req=IMachine_getClipboardModeRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getClipboardMode(req)
       return  ClipboardMode(val._returnval)
   def setClipboardMode(self, value):
       req=IMachine_setClipboardModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._clipboardMode = value
       else:
            req._clipboardMode = value.handle
       g_port.IMachine_setClipboardMode(req)      

   def getGuestPropertyNotificationPatterns(self):
       req=IMachine_getGuestPropertyNotificationPatternsRequestMsg()
       req._this=self.handle
       val=g_port.IMachine_getGuestPropertyNotificationPatterns(req)
       return  String(val._returnval)
   def setGuestPropertyNotificationPatterns(self, value):
       req=IMachine_setGuestPropertyNotificationPatternsRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._guestPropertyNotificationPatterns = value
       else:
            req._guestPropertyNotificationPatterns = value.handle
       g_port.IMachine_setGuestPropertyNotificationPatterns(req)      



   _Attrs_={         'parent':[getParent,None],
         'accessible':[getAccessible,None],
         'name':[getName,setName,
        ],
         'description':[getDescription,setDescription,
        ],
         'id':[getId,None],
         'OSTypeId':[getOSTypeId,setOSTypeId,
        ],
         'HardwareVersion':[getHardwareVersion,setHardwareVersion,
        ],
         'CPUCount':[getCPUCount,setCPUCount,
        ],
         'memorySize':[getMemorySize,setMemorySize,
        ],
         'memoryBalloonSize':[getMemoryBalloonSize,setMemoryBalloonSize,
        ],
         'statisticsUpdateInterval':[getStatisticsUpdateInterval,setStatisticsUpdateInterval,
        ],
         'VRAMSize':[getVRAMSize,setVRAMSize,
        ],
         'accelerate3DEnabled':[getAccelerate3DEnabled,setAccelerate3DEnabled,
        ],
         'monitorCount':[getMonitorCount,setMonitorCount,
        ],
         'BIOSSettings':[getBIOSSettings,None],
         'HWVirtExEnabled':[getHWVirtExEnabled,setHWVirtExEnabled,
        ],
         'HWVirtExNestedPagingEnabled':[getHWVirtExNestedPagingEnabled,setHWVirtExNestedPagingEnabled,
        ],
         'HWVirtExVPIDEnabled':[getHWVirtExVPIDEnabled,setHWVirtExVPIDEnabled,
        ],
         'PAEEnabled':[getPAEEnabled,setPAEEnabled,
        ],
         'snapshotFolder':[getSnapshotFolder,setSnapshotFolder,
        ],
         'VRDPServer':[getVRDPServer,None],
         'hardDiskAttachments':[getHardDiskAttachments,None],
         'DVDDrive':[getDVDDrive,None],
         'floppyDrive':[getFloppyDrive,None],
         'USBController':[getUSBController,None],
         'audioAdapter':[getAudioAdapter,None],
         'storageControllers':[getStorageControllers,None],
         'settingsFilePath':[getSettingsFilePath,None],
         'settingsFileVersion':[getSettingsFileVersion,None],
         'settingsModified':[getSettingsModified,None],
         'sessionState':[getSessionState,None],
         'sessionType':[getSessionType,None],
         'sessionPid':[getSessionPid,None],
         'state':[getState,None],
         'lastStateChange':[getLastStateChange,None],
         'stateFilePath':[getStateFilePath,None],
         'logFolder':[getLogFolder,None],
         'currentSnapshot':[getCurrentSnapshot,None],
         'snapshotCount':[getSnapshotCount,None],
         'currentStateModified':[getCurrentStateModified,None],
         'sharedFolders':[getSharedFolders,None],
         'clipboardMode':[getClipboardMode,setClipboardMode,
        ],
         'guestPropertyNotificationPatterns':[getGuestPropertyNotificationPatterns,setGuestPropertyNotificationPatterns,
        ]}
class IConsole:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IConsole(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IConsole._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IConsole._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def powerUp(self):
       req=IConsole_powerUpRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerUp(req)
             
       return IProgress(val._returnval)

 
   def powerUpPaused(self):
       req=IConsole_powerUpPausedRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerUpPaused(req)
             
       return IProgress(val._returnval)

 
   def powerDown(self):
       req=IConsole_powerDownRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerDown(req)
             
       return 

 
   def powerDownAsync(self):
       req=IConsole_powerDownAsyncRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerDownAsync(req)
             
       return IProgress(val._returnval)

 
   def reset(self):
       req=IConsole_resetRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_reset(req)
             
       return 

 
   def pause(self):
       req=IConsole_pauseRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_pause(req)
             
       return 

 
   def resume(self):
       req=IConsole_resumeRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_resume(req)
             
       return 

 
   def powerButton(self):
       req=IConsole_powerButtonRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_powerButton(req)
             
       return 

 
   def sleepButton(self):
       req=IConsole_sleepButtonRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_sleepButton(req)
             
       return 

 
   def getPowerButtonHandled(self):
       req=IConsole_getPowerButtonHandledRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_getPowerButtonHandled(req)
             
       return Boolean(val._returnval)

 
   def getGuestEnteredACPIMode(self):
       req=IConsole_getGuestEnteredACPIModeRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_getGuestEnteredACPIMode(req)
             
       return Boolean(val._returnval)

 
   def saveState(self):
       req=IConsole_saveStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_saveState(req)
             
       return IProgress(val._returnval)

 
   def adoptSavedState(self, _arg_savedStateFile):
       req=IConsole_adoptSavedStateRequestMsg()
       req._this=self.handle
       
       req._savedStateFile=_arg_savedStateFile
       val=g_port.IConsole_adoptSavedState(req)
             
       return 

 
   def discardSavedState(self):
       req=IConsole_discardSavedStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_discardSavedState(req)
             
       return 

 
   def getDeviceActivity(self, _arg_type):
       req=IConsole_getDeviceActivityRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=g_port.IConsole_getDeviceActivity(req)
             
       return DeviceActivity(val._returnval)

 
   def attachUSBDevice(self, _arg_id):
       req=IConsole_attachUSBDeviceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_attachUSBDevice(req)
             
       return 

 
   def detachUSBDevice(self, _arg_id):
       req=IConsole_detachUSBDeviceRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_detachUSBDevice(req)
             
       return IUSBDevice(val._returnval)

 
   def findUSBDeviceByAddress(self, _arg_name):
       req=IConsole_findUSBDeviceByAddressRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IConsole_findUSBDeviceByAddress(req)
             
       return IUSBDevice(val._returnval)

 
   def findUSBDeviceById(self, _arg_id):
       req=IConsole_findUSBDeviceByIdRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_findUSBDeviceById(req)
             
       return IUSBDevice(val._returnval)

 
   def createSharedFolder(self, _arg_name, _arg_hostPath, _arg_writable):
       req=IConsole_createSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._hostPath=_arg_hostPath
       req._writable=_arg_writable
       val=g_port.IConsole_createSharedFolder(req)
             
       return 

 
   def removeSharedFolder(self, _arg_name):
       req=IConsole_removeSharedFolderRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IConsole_removeSharedFolder(req)
             
       return 

 
   def takeSnapshot(self, _arg_name, _arg_description):
       req=IConsole_takeSnapshotRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._description=_arg_description
       val=g_port.IConsole_takeSnapshot(req)
             
       return IProgress(val._returnval)

 
   def discardSnapshot(self, _arg_id):
       req=IConsole_discardSnapshotRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IConsole_discardSnapshot(req)
             
       return IProgress(val._returnval)

 
   def discardCurrentState(self):
       req=IConsole_discardCurrentStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_discardCurrentState(req)
             
       return IProgress(val._returnval)

 
   def discardCurrentSnapshotAndState(self):
       req=IConsole_discardCurrentSnapshotAndStateRequestMsg()
       req._this=self.handle
       
       val=g_port.IConsole_discardCurrentSnapshotAndState(req)
             
       return IProgress(val._returnval)

 
   def registerCallback(self, _arg_callback):
       req=IConsole_registerCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IConsole_registerCallback(req)
             
       return 

 
   def unregisterCallback(self, _arg_callback):
       req=IConsole_unregisterCallbackRequestMsg()
       req._this=self.handle
       
       req._callback=_arg_callback
       val=g_port.IConsole_unregisterCallback(req)
             
       return 


   def getMachine(self):
       req=IConsole_getMachineRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getMachine(req)
       return  IMachine(val._returnval)
   def getState(self):
       req=IConsole_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getState(req)
       return  MachineState(val._returnval)
   def getKeyboard(self):
       req=IConsole_getKeyboardRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getKeyboard(req)
       return  IKeyboard(val._returnval)
   def getMouse(self):
       req=IConsole_getMouseRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getMouse(req)
       return  IMouse(val._returnval)
   def getUSBDevices(self):
       req=IConsole_getUSBDevicesRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getUSBDevices(req)
       return  IUSBDevice(val._returnval, True)
   def getRemoteUSBDevices(self):
       req=IConsole_getRemoteUSBDevicesRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getRemoteUSBDevices(req)
       return  IHostUSBDevice(val._returnval, True)
   def getSharedFolders(self):
       req=IConsole_getSharedFoldersRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getSharedFolders(req)
       return  ISharedFolder(val._returnval, True)
   def getRemoteDisplayInfo(self):
       req=IConsole_getRemoteDisplayInfoRequestMsg()
       req._this=self.handle
       val=g_port.IConsole_getRemoteDisplayInfo(req)
       return  IRemoteDisplayInfo(val._returnval)


   _Attrs_={         'machine':[getMachine,None],
         'state':[getState,None],
         'keyboard':[getKeyboard,None],
         'mouse':[getMouse,None],
         'USBDevices':[getUSBDevices,None],
         'remoteUSBDevices':[getRemoteUSBDevices,None],
         'sharedFolders':[getSharedFolders,None],
         'remoteDisplayInfo':[getRemoteDisplayInfo,None]}
class IHostDVDDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostDVDDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IHostDVDDrive_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostDVDDrive_getName(req)
       return  String(val._returnval)
   def getDescription(self):
       req=IHostDVDDrive_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IHostDVDDrive_getDescription(req)
       return  String(val._returnval)
   def getUdi(self):
       req=IHostDVDDrive_getUdiRequestMsg()
       req._this=self.handle
       val=g_port.IHostDVDDrive_getUdi(req)
       return  String(val._returnval)


   _Attrs_={         'name':[getName,None],
         'description':[getDescription,None],
         'udi':[getUdi,None]}
class IHostFloppyDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostFloppyDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IHostFloppyDrive_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostFloppyDrive_getName(req)
       return  String(val._returnval)
   def getDescription(self):
       req=IHostFloppyDrive_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IHostFloppyDrive_getDescription(req)
       return  String(val._returnval)
   def getUdi(self):
       req=IHostFloppyDrive_getUdiRequestMsg()
       req._this=self.handle
       val=g_port.IHostFloppyDrive_getUdi(req)
       return  String(val._returnval)


   _Attrs_={         'name':[getName,None],
         'description':[getDescription,None],
         'udi':[getUdi,None]}
class IHostNetworkInterface:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostNetworkInterface(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostNetworkInterface._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostNetworkInterface._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def enableStaticIpConfig(self, _arg_IPAddress, _arg_networkMask):
       req=IHostNetworkInterface_enableStaticIpConfigRequestMsg()
       req._this=self.handle
       
       req._IPAddress=_arg_IPAddress
       req._networkMask=_arg_networkMask
       val=g_port.IHostNetworkInterface_enableStaticIpConfig(req)
             
       return 

 
   def enableStaticIpConfigV6(self, _arg_IPV6Address, _arg_IPV6NetworkMaskPrefixLength):
       req=IHostNetworkInterface_enableStaticIpConfigV6RequestMsg()
       req._this=self.handle
       
       req._IPV6Address=_arg_IPV6Address
       req._IPV6NetworkMaskPrefixLength=_arg_IPV6NetworkMaskPrefixLength
       val=g_port.IHostNetworkInterface_enableStaticIpConfigV6(req)
             
       return 

 
   def enableDynamicIpConfig(self):
       req=IHostNetworkInterface_enableDynamicIpConfigRequestMsg()
       req._this=self.handle
       
       val=g_port.IHostNetworkInterface_enableDynamicIpConfig(req)
             
       return 

 
   def dhcpRediscover(self):
       req=IHostNetworkInterface_dhcpRediscoverRequestMsg()
       req._this=self.handle
       
       val=g_port.IHostNetworkInterface_dhcpRediscover(req)
             
       return 


   def getName(self):
       req=IHostNetworkInterface_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getName(req)
       return  String(val._returnval)
   def getId(self):
       req=IHostNetworkInterface_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getId(req)
       return  UUID(val._returnval)
   def getNetworkName(self):
       req=IHostNetworkInterface_getNetworkNameRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getNetworkName(req)
       return  String(val._returnval)
   def getDhcpEnabled(self):
       req=IHostNetworkInterface_getDhcpEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getDhcpEnabled(req)
       return  Boolean(val._returnval)
   def getIPAddress(self):
       req=IHostNetworkInterface_getIPAddressRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getIPAddress(req)
       return  String(val._returnval)
   def getNetworkMask(self):
       req=IHostNetworkInterface_getNetworkMaskRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getNetworkMask(req)
       return  String(val._returnval)
   def getIPV6Supported(self):
       req=IHostNetworkInterface_getIPV6SupportedRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getIPV6Supported(req)
       return  Boolean(val._returnval)
   def getIPV6Address(self):
       req=IHostNetworkInterface_getIPV6AddressRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getIPV6Address(req)
       return  String(val._returnval)
   def getIPV6NetworkMaskPrefixLength(self):
       req=IHostNetworkInterface_getIPV6NetworkMaskPrefixLengthRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getIPV6NetworkMaskPrefixLength(req)
       return  UnsignedInt(val._returnval)
   def getHardwareAddress(self):
       req=IHostNetworkInterface_getHardwareAddressRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getHardwareAddress(req)
       return  String(val._returnval)
   def getMediumType(self):
       req=IHostNetworkInterface_getMediumTypeRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getMediumType(req)
       return  HostNetworkInterfaceMediumType(val._returnval)
   def getStatus(self):
       req=IHostNetworkInterface_getStatusRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getStatus(req)
       return  HostNetworkInterfaceStatus(val._returnval)
   def getInterfaceType(self):
       req=IHostNetworkInterface_getInterfaceTypeRequestMsg()
       req._this=self.handle
       val=g_port.IHostNetworkInterface_getInterfaceType(req)
       return  HostNetworkInterfaceType(val._returnval)


   _Attrs_={         'name':[getName,None],
         'id':[getId,None],
         'networkName':[getNetworkName,None],
         'dhcpEnabled':[getDhcpEnabled,None],
         'IPAddress':[getIPAddress,None],
         'networkMask':[getNetworkMask,None],
         'IPV6Supported':[getIPV6Supported,None],
         'IPV6Address':[getIPV6Address,None],
         'IPV6NetworkMaskPrefixLength':[getIPV6NetworkMaskPrefixLength,None],
         'hardwareAddress':[getHardwareAddress,None],
         'mediumType':[getMediumType,None],
         'status':[getStatus,None],
         'interfaceType':[getInterfaceType,None]}
class IHost:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHost(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHost._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHost._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getProcessorSpeed(self, _arg_cpuId):
       req=IHost_getProcessorSpeedRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=g_port.IHost_getProcessorSpeed(req)
             
       return UnsignedInt(val._returnval)

 
   def getProcessorFeature(self, _arg_feature):
       req=IHost_getProcessorFeatureRequestMsg()
       req._this=self.handle
       
       req._feature=_arg_feature
       val=g_port.IHost_getProcessorFeature(req)
             
       return Boolean(val._returnval)

 
   def getProcessorDescription(self, _arg_cpuId):
       req=IHost_getProcessorDescriptionRequestMsg()
       req._this=self.handle
       
       req._cpuId=_arg_cpuId
       val=g_port.IHost_getProcessorDescription(req)
             
       return String(val._returnval)

 
   def createUSBDeviceFilter(self, _arg_name):
       req=IHost_createUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHost_createUSBDeviceFilter(req)
             
       return IHostUSBDeviceFilter(val._returnval)

 
   def insertUSBDeviceFilter(self, _arg_position, _arg_filter):
       req=IHost_insertUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._filter=_arg_filter
       val=g_port.IHost_insertUSBDeviceFilter(req)
             
       return 

 
   def removeUSBDeviceFilter(self, _arg_position):
       req=IHost_removeUSBDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=g_port.IHost_removeUSBDeviceFilter(req)
             
       return IHostUSBDeviceFilter(val._returnval)

 
   def findHostDVDDrive(self, _arg_name):
       req=IHost_findHostDVDDriveRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHost_findHostDVDDrive(req)
             
       return IHostDVDDrive(val._returnval)

 
   def findHostFloppyDrive(self, _arg_name):
       req=IHost_findHostFloppyDriveRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHost_findHostFloppyDrive(req)
             
       return IHostFloppyDrive(val._returnval)

 
   def findHostNetworkInterfaceByName(self, _arg_name):
       req=IHost_findHostNetworkInterfaceByNameRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHost_findHostNetworkInterfaceByName(req)
             
       return IHostNetworkInterface(val._returnval)

 
   def findHostNetworkInterfaceById(self, _arg_id):
       req=IHost_findHostNetworkInterfaceByIdRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IHost_findHostNetworkInterfaceById(req)
             
       return IHostNetworkInterface(val._returnval)

 
   def findHostNetworkInterfacesOfType(self, _arg_type):
       req=IHost_findHostNetworkInterfacesOfTypeRequestMsg()
       req._this=self.handle
       
       req._type=_arg_type
       val=g_port.IHost_findHostNetworkInterfacesOfType(req)
             
       return IHostNetworkInterface(val._returnval, True)

 
   def findUSBDeviceById(self, _arg_id):
       req=IHost_findUSBDeviceByIdRequestMsg()
       req._this=self.handle
       
       req._id=_arg_id
       val=g_port.IHost_findUSBDeviceById(req)
             
       return IHostUSBDevice(val._returnval)

 
   def findUSBDeviceByAddress(self, _arg_name):
       req=IHost_findUSBDeviceByAddressRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHost_findUSBDeviceByAddress(req)
             
       return IHostUSBDevice(val._returnval)


   def getDVDDrives(self):
       req=IHost_getDVDDrivesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getDVDDrives(req)
       return  IHostDVDDrive(val._returnval, True)
   def getFloppyDrives(self):
       req=IHost_getFloppyDrivesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getFloppyDrives(req)
       return  IHostFloppyDrive(val._returnval, True)
   def getUSBDevices(self):
       req=IHost_getUSBDevicesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getUSBDevices(req)
       return  IHostUSBDevice(val._returnval, True)
   def getUSBDeviceFilters(self):
       req=IHost_getUSBDeviceFiltersRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getUSBDeviceFilters(req)
       return  IHostUSBDeviceFilter(val._returnval, True)
   def getNetworkInterfaces(self):
       req=IHost_getNetworkInterfacesRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getNetworkInterfaces(req)
       return  IHostNetworkInterface(val._returnval, True)
   def getProcessorCount(self):
       req=IHost_getProcessorCountRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getProcessorCount(req)
       return  UnsignedInt(val._returnval)
   def getProcessorOnlineCount(self):
       req=IHost_getProcessorOnlineCountRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getProcessorOnlineCount(req)
       return  UnsignedInt(val._returnval)
   def getMemorySize(self):
       req=IHost_getMemorySizeRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getMemorySize(req)
       return  UnsignedInt(val._returnval)
   def getMemoryAvailable(self):
       req=IHost_getMemoryAvailableRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getMemoryAvailable(req)
       return  UnsignedInt(val._returnval)
   def getOperatingSystem(self):
       req=IHost_getOperatingSystemRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getOperatingSystem(req)
       return  String(val._returnval)
   def getOSVersion(self):
       req=IHost_getOSVersionRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getOSVersion(req)
       return  String(val._returnval)
   def getUTCTime(self):
       req=IHost_getUTCTimeRequestMsg()
       req._this=self.handle
       val=g_port.IHost_getUTCTime(req)
       return  Long(val._returnval)


   _Attrs_={         'DVDDrives':[getDVDDrives,None],
         'floppyDrives':[getFloppyDrives,None],
         'USBDevices':[getUSBDevices,None],
         'USBDeviceFilters':[getUSBDeviceFilters,None],
         'networkInterfaces':[getNetworkInterfaces,None],
         'processorCount':[getProcessorCount,None],
         'processorOnlineCount':[getProcessorOnlineCount,None],
         'memorySize':[getMemorySize,None],
         'memoryAvailable':[getMemoryAvailable,None],
         'operatingSystem':[getOperatingSystem,None],
         'OSVersion':[getOSVersion,None],
         'UTCTime':[getUTCTime,None]}
class ISystemProperties:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISystemProperties(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISystemProperties._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISystemProperties._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMinGuestRAM(self):
       req=ISystemProperties_getMinGuestRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMinGuestRAM(req)
       return  UnsignedInt(val._returnval)
   def getMaxGuestRAM(self):
       req=ISystemProperties_getMaxGuestRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxGuestRAM(req)
       return  UnsignedInt(val._returnval)
   def getMinGuestVRAM(self):
       req=ISystemProperties_getMinGuestVRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMinGuestVRAM(req)
       return  UnsignedInt(val._returnval)
   def getMaxGuestVRAM(self):
       req=ISystemProperties_getMaxGuestVRAMRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxGuestVRAM(req)
       return  UnsignedInt(val._returnval)
   def getMinGuestCPUCount(self):
       req=ISystemProperties_getMinGuestCPUCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMinGuestCPUCount(req)
       return  UnsignedInt(val._returnval)
   def getMaxGuestCPUCount(self):
       req=ISystemProperties_getMaxGuestCPUCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxGuestCPUCount(req)
       return  UnsignedInt(val._returnval)
   def getMaxVDISize(self):
       req=ISystemProperties_getMaxVDISizeRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxVDISize(req)
       return  UnsignedLong(val._returnval)
   def getNetworkAdapterCount(self):
       req=ISystemProperties_getNetworkAdapterCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getNetworkAdapterCount(req)
       return  UnsignedInt(val._returnval)
   def getSerialPortCount(self):
       req=ISystemProperties_getSerialPortCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getSerialPortCount(req)
       return  UnsignedInt(val._returnval)
   def getParallelPortCount(self):
       req=ISystemProperties_getParallelPortCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getParallelPortCount(req)
       return  UnsignedInt(val._returnval)
   def getMaxBootPosition(self):
       req=ISystemProperties_getMaxBootPositionRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getMaxBootPosition(req)
       return  UnsignedInt(val._returnval)
   def getDefaultMachineFolder(self):
       req=ISystemProperties_getDefaultMachineFolderRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getDefaultMachineFolder(req)
       return  String(val._returnval)
   def setDefaultMachineFolder(self, value):
       req=ISystemProperties_setDefaultMachineFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._defaultMachineFolder = value
       else:
            req._defaultMachineFolder = value.handle
       g_port.ISystemProperties_setDefaultMachineFolder(req)      

   def getDefaultHardDiskFolder(self):
       req=ISystemProperties_getDefaultHardDiskFolderRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getDefaultHardDiskFolder(req)
       return  String(val._returnval)
   def setDefaultHardDiskFolder(self, value):
       req=ISystemProperties_setDefaultHardDiskFolderRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._defaultHardDiskFolder = value
       else:
            req._defaultHardDiskFolder = value.handle
       g_port.ISystemProperties_setDefaultHardDiskFolder(req)      

   def getHardDiskFormats(self):
       req=ISystemProperties_getHardDiskFormatsRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getHardDiskFormats(req)
       return  IHardDiskFormat(val._returnval, True)
   def getDefaultHardDiskFormat(self):
       req=ISystemProperties_getDefaultHardDiskFormatRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getDefaultHardDiskFormat(req)
       return  String(val._returnval)
   def setDefaultHardDiskFormat(self, value):
       req=ISystemProperties_setDefaultHardDiskFormatRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._defaultHardDiskFormat = value
       else:
            req._defaultHardDiskFormat = value.handle
       g_port.ISystemProperties_setDefaultHardDiskFormat(req)      

   def getRemoteDisplayAuthLibrary(self):
       req=ISystemProperties_getRemoteDisplayAuthLibraryRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getRemoteDisplayAuthLibrary(req)
       return  String(val._returnval)
   def setRemoteDisplayAuthLibrary(self, value):
       req=ISystemProperties_setRemoteDisplayAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._remoteDisplayAuthLibrary = value
       else:
            req._remoteDisplayAuthLibrary = value.handle
       g_port.ISystemProperties_setRemoteDisplayAuthLibrary(req)      

   def getWebServiceAuthLibrary(self):
       req=ISystemProperties_getWebServiceAuthLibraryRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getWebServiceAuthLibrary(req)
       return  String(val._returnval)
   def setWebServiceAuthLibrary(self, value):
       req=ISystemProperties_setWebServiceAuthLibraryRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._webServiceAuthLibrary = value
       else:
            req._webServiceAuthLibrary = value.handle
       g_port.ISystemProperties_setWebServiceAuthLibrary(req)      

   def getHWVirtExEnabled(self):
       req=ISystemProperties_getHWVirtExEnabledRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getHWVirtExEnabled(req)
       return  Boolean(val._returnval)
   def setHWVirtExEnabled(self, value):
       req=ISystemProperties_setHWVirtExEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._HWVirtExEnabled = value
       else:
            req._HWVirtExEnabled = value.handle
       g_port.ISystemProperties_setHWVirtExEnabled(req)      

   def getLogHistoryCount(self):
       req=ISystemProperties_getLogHistoryCountRequestMsg()
       req._this=self.handle
       val=g_port.ISystemProperties_getLogHistoryCount(req)
       return  UnsignedInt(val._returnval)
   def setLogHistoryCount(self, value):
       req=ISystemProperties_setLogHistoryCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._LogHistoryCount = value
       else:
            req._LogHistoryCount = value.handle
       g_port.ISystemProperties_setLogHistoryCount(req)      



   _Attrs_={         'minGuestRAM':[getMinGuestRAM,None],
         'maxGuestRAM':[getMaxGuestRAM,None],
         'minGuestVRAM':[getMinGuestVRAM,None],
         'maxGuestVRAM':[getMaxGuestVRAM,None],
         'minGuestCPUCount':[getMinGuestCPUCount,None],
         'maxGuestCPUCount':[getMaxGuestCPUCount,None],
         'maxVDISize':[getMaxVDISize,None],
         'networkAdapterCount':[getNetworkAdapterCount,None],
         'serialPortCount':[getSerialPortCount,None],
         'parallelPortCount':[getParallelPortCount,None],
         'maxBootPosition':[getMaxBootPosition,None],
         'defaultMachineFolder':[getDefaultMachineFolder,setDefaultMachineFolder,
        ],
         'defaultHardDiskFolder':[getDefaultHardDiskFolder,setDefaultHardDiskFolder,
        ],
         'hardDiskFormats':[getHardDiskFormats,None],
         'defaultHardDiskFormat':[getDefaultHardDiskFormat,setDefaultHardDiskFormat,
        ],
         'remoteDisplayAuthLibrary':[getRemoteDisplayAuthLibrary,setRemoteDisplayAuthLibrary,
        ],
         'webServiceAuthLibrary':[getWebServiceAuthLibrary,setWebServiceAuthLibrary,
        ],
         'HWVirtExEnabled':[getHWVirtExEnabled,setHWVirtExEnabled,
        ],
         'LogHistoryCount':[getLogHistoryCount,setLogHistoryCount,
        ]}
class IProgress:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IProgress(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IProgress._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IProgress._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def waitForCompletion(self, _arg_timeout):
       req=IProgress_waitForCompletionRequestMsg()
       req._this=self.handle
       
       req._timeout=_arg_timeout
       val=g_port.IProgress_waitForCompletion(req)
             
       return 

 
   def waitForOperationCompletion(self, _arg_operation, _arg_timeout):
       req=IProgress_waitForOperationCompletionRequestMsg()
       req._this=self.handle
       
       req._operation=_arg_operation
       req._timeout=_arg_timeout
       val=g_port.IProgress_waitForOperationCompletion(req)
             
       return 

 
   def cancel(self):
       req=IProgress_cancelRequestMsg()
       req._this=self.handle
       
       val=g_port.IProgress_cancel(req)
             
       return 


   def getId(self):
       req=IProgress_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getId(req)
       return  UUID(val._returnval)
   def getDescription(self):
       req=IProgress_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getDescription(req)
       return  String(val._returnval)
   def getInitiator(self):
       req=IProgress_getInitiatorRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getInitiator(req)
       return  IUnknown(val._returnval)
   def getCancelable(self):
       req=IProgress_getCancelableRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getCancelable(req)
       return  Boolean(val._returnval)
   def getPercent(self):
       req=IProgress_getPercentRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getPercent(req)
       return  UnsignedInt(val._returnval)
   def getTimeRemaining(self):
       req=IProgress_getTimeRemainingRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getTimeRemaining(req)
       return  Int(val._returnval)
   def getCompleted(self):
       req=IProgress_getCompletedRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getCompleted(req)
       return  Boolean(val._returnval)
   def getCanceled(self):
       req=IProgress_getCanceledRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getCanceled(req)
       return  Boolean(val._returnval)
   def getResultCode(self):
       req=IProgress_getResultCodeRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getResultCode(req)
       return  UnsignedInt(val._returnval)
   def getOperationCount(self):
       req=IProgress_getOperationCountRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperationCount(req)
       return  UnsignedInt(val._returnval)
   def getOperation(self):
       req=IProgress_getOperationRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperation(req)
       return  UnsignedInt(val._returnval)
   def getOperationDescription(self):
       req=IProgress_getOperationDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperationDescription(req)
       return  String(val._returnval)
   def getOperationPercent(self):
       req=IProgress_getOperationPercentRequestMsg()
       req._this=self.handle
       val=g_port.IProgress_getOperationPercent(req)
       return  UnsignedInt(val._returnval)


   _Attrs_={         'id':[getId,None],
         'description':[getDescription,None],
         'initiator':[getInitiator,None],
         'cancelable':[getCancelable,None],
         'percent':[getPercent,None],
         'timeRemaining':[getTimeRemaining,None],
         'completed':[getCompleted,None],
         'canceled':[getCanceled,None],
         'resultCode':[getResultCode,None],
         'operationCount':[getOperationCount,None],
         'operation':[getOperation,None],
         'operationDescription':[getOperationDescription,None],
         'operationPercent':[getOperationPercent,None]}
class ISnapshot:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISnapshot(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISnapshot._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISnapshot._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=ISnapshot_getIdRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getId(req)
       return  UUID(val._returnval)
   def getName(self):
       req=ISnapshot_getNameRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getName(req)
       return  String(val._returnval)
   def setName(self, value):
       req=ISnapshot_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._name = value
       else:
            req._name = value.handle
       g_port.ISnapshot_setName(req)      

   def getDescription(self):
       req=ISnapshot_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getDescription(req)
       return  String(val._returnval)
   def setDescription(self, value):
       req=ISnapshot_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._description = value
       else:
            req._description = value.handle
       g_port.ISnapshot_setDescription(req)      

   def getTimeStamp(self):
       req=ISnapshot_getTimeStampRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getTimeStamp(req)
       return  Long(val._returnval)
   def getOnline(self):
       req=ISnapshot_getOnlineRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getOnline(req)
       return  Boolean(val._returnval)
   def getMachine(self):
       req=ISnapshot_getMachineRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getMachine(req)
       return  IMachine(val._returnval)
   def getParent(self):
       req=ISnapshot_getParentRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getParent(req)
       return  ISnapshot(val._returnval)
   def getChildren(self):
       req=ISnapshot_getChildrenRequestMsg()
       req._this=self.handle
       val=g_port.ISnapshot_getChildren(req)
       return  ISnapshot(val._returnval, True)


   _Attrs_={         'id':[getId,None],
         'name':[getName,setName,
        ],
         'description':[getDescription,setDescription,
        ],
         'timeStamp':[getTimeStamp,None],
         'online':[getOnline,None],
         'machine':[getMachine,None],
         'parent':[getParent,None],
         'children':[getChildren,None]}
class IMedium:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IMedium(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMedium._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IMedium._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getSnapshotIds(self, _arg_machineId):
       req=IMedium_getSnapshotIdsRequestMsg()
       req._this=self.handle
       
       req._machineId=_arg_machineId
       val=g_port.IMedium_getSnapshotIds(req)
             
       return UUID(val._returnval, True)

 
   def lockRead(self):
       req=IMedium_lockReadRequestMsg()
       req._this=self.handle
       
       val=g_port.IMedium_lockRead(req)
             
       return MediaState(val._returnval)

 
   def unlockRead(self):
       req=IMedium_unlockReadRequestMsg()
       req._this=self.handle
       
       val=g_port.IMedium_unlockRead(req)
             
       return MediaState(val._returnval)

 
   def lockWrite(self):
       req=IMedium_lockWriteRequestMsg()
       req._this=self.handle
       
       val=g_port.IMedium_lockWrite(req)
             
       return MediaState(val._returnval)

 
   def unlockWrite(self):
       req=IMedium_unlockWriteRequestMsg()
       req._this=self.handle
       
       val=g_port.IMedium_unlockWrite(req)
             
       return MediaState(val._returnval)

 
   def close(self):
       req=IMedium_closeRequestMsg()
       req._this=self.handle
       
       val=g_port.IMedium_close(req)
             
       return 


   def getId(self):
       req=IMedium_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getId(req)
       return  UUID(val._returnval)
   def getDescription(self):
       req=IMedium_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getDescription(req)
       return  String(val._returnval)
   def setDescription(self, value):
       req=IMedium_setDescriptionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._description = value
       else:
            req._description = value.handle
       g_port.IMedium_setDescription(req)      

   def getState(self):
       req=IMedium_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getState(req)
       return  MediaState(val._returnval)
   def getLocation(self):
       req=IMedium_getLocationRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getLocation(req)
       return  String(val._returnval)
   def setLocation(self, value):
       req=IMedium_setLocationRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._location = value
       else:
            req._location = value.handle
       g_port.IMedium_setLocation(req)      

   def getName(self):
       req=IMedium_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getName(req)
       return  String(val._returnval)
   def getSize(self):
       req=IMedium_getSizeRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getSize(req)
       return  UnsignedLong(val._returnval)
   def getLastAccessError(self):
       req=IMedium_getLastAccessErrorRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getLastAccessError(req)
       return  String(val._returnval)
   def getMachineIds(self):
       req=IMedium_getMachineIdsRequestMsg()
       req._this=self.handle
       val=g_port.IMedium_getMachineIds(req)
       return  UUID(val._returnval, True)


   _Attrs_={         'id':[getId,None],
         'description':[getDescription,setDescription,
        ],
         'state':[getState,None],
         'location':[getLocation,setLocation,
        ],
         'name':[getName,None],
         'size':[getSize,None],
         'lastAccessError':[getLastAccessError,None],
         'machineIds':[getMachineIds,None]}
class IHardDisk:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHardDisk(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHardDisk._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getProperty(self, _arg_name):
       req=IHardDisk_getPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IHardDisk_getProperty(req)
             
       return String(val._returnval)

 
   def setProperty(self, _arg_name, _arg_value):
       req=IHardDisk_setPropertyRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       req._value=_arg_value
       val=g_port.IHardDisk_setProperty(req)
             
       return 

 
   def getProperties(self, _arg_names):
       req=IHardDisk_getPropertiesRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       val=g_port.IHardDisk_getProperties(req)
             
       return String(val._returnval, True), String(val._returnNames, True)

 
   def setProperties(self, _arg_names, _arg_values):
       req=IHardDisk_setPropertiesRequestMsg()
       req._this=self.handle
       
       req._names=_arg_names
       req._values=_arg_values
       val=g_port.IHardDisk_setProperties(req)
             
       return 

 
   def createBaseStorage(self, _arg_logicalSize, _arg_variant):
       req=IHardDisk_createBaseStorageRequestMsg()
       req._this=self.handle
       
       req._logicalSize=_arg_logicalSize
       req._variant=_arg_variant
       val=g_port.IHardDisk_createBaseStorage(req)
             
       return IProgress(val._returnval)

 
   def deleteStorage(self):
       req=IHardDisk_deleteStorageRequestMsg()
       req._this=self.handle
       
       val=g_port.IHardDisk_deleteStorage(req)
             
       return IProgress(val._returnval)

 
   def createDiffStorage(self, _arg_target, _arg_variant):
       req=IHardDisk_createDiffStorageRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       req._variant=_arg_variant
       val=g_port.IHardDisk_createDiffStorage(req)
             
       return IProgress(val._returnval)

 
   def mergeTo(self, _arg_targetId):
       req=IHardDisk_mergeToRequestMsg()
       req._this=self.handle
       
       req._targetId=_arg_targetId
       val=g_port.IHardDisk_mergeTo(req)
             
       return IProgress(val._returnval)

 
   def cloneTo(self, _arg_target, _arg_variant, _arg_parent):
       req=IHardDisk_cloneToRequestMsg()
       req._this=self.handle
       
       req._target=_arg_target
       req._variant=_arg_variant
       req._parent=_arg_parent
       val=g_port.IHardDisk_cloneTo(req)
             
       return IProgress(val._returnval)

 
   def compact(self):
       req=IHardDisk_compactRequestMsg()
       req._this=self.handle
       
       val=g_port.IHardDisk_compact(req)
             
       return IProgress(val._returnval)

 
   def reset(self):
       req=IHardDisk_resetRequestMsg()
       req._this=self.handle
       
       val=g_port.IHardDisk_reset(req)
             
       return IProgress(val._returnval)


   def getFormat(self):
       req=IHardDisk_getFormatRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getFormat(req)
       return  String(val._returnval)
   def getType(self):
       req=IHardDisk_getTypeRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getType(req)
       return  HardDiskType(val._returnval)
   def setType(self, value):
       req=IHardDisk_setTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._type = value
       else:
            req._type = value.handle
       g_port.IHardDisk_setType(req)      

   def getParent(self):
       req=IHardDisk_getParentRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getParent(req)
       return  IHardDisk(val._returnval)
   def getChildren(self):
       req=IHardDisk_getChildrenRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getChildren(req)
       return  IHardDisk(val._returnval, True)
   def getRoot(self):
       req=IHardDisk_getRootRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getRoot(req)
       return  IHardDisk(val._returnval)
   def getReadOnly(self):
       req=IHardDisk_getReadOnlyRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getReadOnly(req)
       return  Boolean(val._returnval)
   def getLogicalSize(self):
       req=IHardDisk_getLogicalSizeRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getLogicalSize(req)
       return  UnsignedLong(val._returnval)
   def getAutoReset(self):
       req=IHardDisk_getAutoResetRequestMsg()
       req._this=self.handle
       val=g_port.IHardDisk_getAutoReset(req)
       return  Boolean(val._returnval)
   def setAutoReset(self, value):
       req=IHardDisk_setAutoResetRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._autoReset = value
       else:
            req._autoReset = value.handle
       g_port.IHardDisk_setAutoReset(req)      



   _Attrs_={         'format':[getFormat,None],
         'type':[getType,setType,
        ],
         'parent':[getParent,None],
         'children':[getChildren,None],
         'root':[getRoot,None],
         'readOnly':[getReadOnly,None],
         'logicalSize':[getLogicalSize,None],
         'autoReset':[getAutoReset,setAutoReset,
        ]}
class IHardDiskFormat:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHardDiskFormat(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHardDiskFormat._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHardDiskFormat._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def describeProperties(self):
       req=IHardDiskFormat_describePropertiesRequestMsg()
       req._this=self.handle
       
       val=g_port.IHardDiskFormat_describeProperties(req)
             
       return String(val._names, True), String(val._description, True), DataType(val._types, True), UnsignedInt(val._flags, True), String(val._defaults, True)


   def getId(self):
       req=IHardDiskFormat_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IHardDiskFormat_getId(req)
       return  String(val._returnval)
   def getName(self):
       req=IHardDiskFormat_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IHardDiskFormat_getName(req)
       return  String(val._returnval)
   def getFileExtensions(self):
       req=IHardDiskFormat_getFileExtensionsRequestMsg()
       req._this=self.handle
       val=g_port.IHardDiskFormat_getFileExtensions(req)
       return  String(val._returnval, True)
   def getCapabilities(self):
       req=IHardDiskFormat_getCapabilitiesRequestMsg()
       req._this=self.handle
       val=g_port.IHardDiskFormat_getCapabilities(req)
       return  UnsignedInt(val._returnval)


   _Attrs_={         'id':[getId,None],
         'name':[getName,None],
         'fileExtensions':[getFileExtensions,None],
         'capabilities':[getCapabilities,None]}
class IFloppyImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IFloppyImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFloppyImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IFloppyImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   


   _Attrs_={}
class IDVDImage:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IDVDImage(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDVDImage._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IDVDImage._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   


   _Attrs_={}
class IDVDDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IDVDDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IDVDDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def mountImage(self, _arg_imageId):
       req=IDVDDrive_mountImageRequestMsg()
       req._this=self.handle
       
       req._imageId=_arg_imageId
       val=g_port.IDVDDrive_mountImage(req)
             
       return 

 
   def captureHostDrive(self, _arg_drive):
       req=IDVDDrive_captureHostDriveRequestMsg()
       req._this=self.handle
       
       req._drive=_arg_drive
       val=g_port.IDVDDrive_captureHostDrive(req)
             
       return 

 
   def unmount(self):
       req=IDVDDrive_unmountRequestMsg()
       req._this=self.handle
       
       val=g_port.IDVDDrive_unmount(req)
             
       return 

 
   def getImage(self):
       req=IDVDDrive_getImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IDVDDrive_getImage(req)
             
       return IDVDImage(val._returnval)

 
   def getHostDrive(self):
       req=IDVDDrive_getHostDriveRequestMsg()
       req._this=self.handle
       
       val=g_port.IDVDDrive_getHostDrive(req)
             
       return IHostDVDDrive(val._returnval)


   def getState(self):
       req=IDVDDrive_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IDVDDrive_getState(req)
       return  DriveState(val._returnval)
   def getPassthrough(self):
       req=IDVDDrive_getPassthroughRequestMsg()
       req._this=self.handle
       val=g_port.IDVDDrive_getPassthrough(req)
       return  Boolean(val._returnval)
   def setPassthrough(self, value):
       req=IDVDDrive_setPassthroughRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._passthrough = value
       else:
            req._passthrough = value.handle
       g_port.IDVDDrive_setPassthrough(req)      



   _Attrs_={         'state':[getState,None],
         'passthrough':[getPassthrough,setPassthrough,
        ]}
class IFloppyDrive:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IFloppyDrive(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IFloppyDrive._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def mountImage(self, _arg_imageId):
       req=IFloppyDrive_mountImageRequestMsg()
       req._this=self.handle
       
       req._imageId=_arg_imageId
       val=g_port.IFloppyDrive_mountImage(req)
             
       return 

 
   def captureHostDrive(self, _arg_drive):
       req=IFloppyDrive_captureHostDriveRequestMsg()
       req._this=self.handle
       
       req._drive=_arg_drive
       val=g_port.IFloppyDrive_captureHostDrive(req)
             
       return 

 
   def unmount(self):
       req=IFloppyDrive_unmountRequestMsg()
       req._this=self.handle
       
       val=g_port.IFloppyDrive_unmount(req)
             
       return 

 
   def getImage(self):
       req=IFloppyDrive_getImageRequestMsg()
       req._this=self.handle
       
       val=g_port.IFloppyDrive_getImage(req)
             
       return IFloppyImage(val._returnval)

 
   def getHostDrive(self):
       req=IFloppyDrive_getHostDriveRequestMsg()
       req._this=self.handle
       
       val=g_port.IFloppyDrive_getHostDrive(req)
             
       return IHostFloppyDrive(val._returnval)


   def getEnabled(self):
       req=IFloppyDrive_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyDrive_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IFloppyDrive_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IFloppyDrive_setEnabled(req)      

   def getState(self):
       req=IFloppyDrive_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IFloppyDrive_getState(req)
       return  DriveState(val._returnval)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'state':[getState,None]}
class IKeyboard:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IKeyboard(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IKeyboard._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IKeyboard._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def putScancode(self, _arg_scancode):
       req=IKeyboard_putScancodeRequestMsg()
       req._this=self.handle
       
       req._scancode=_arg_scancode
       val=g_port.IKeyboard_putScancode(req)
             
       return 

 
   def putScancodes(self, _arg_scancodes):
       req=IKeyboard_putScancodesRequestMsg()
       req._this=self.handle
       
       req._scancodes=_arg_scancodes
       val=g_port.IKeyboard_putScancodes(req)
             
       return UnsignedInt(val._returnval)

 
   def putCAD(self):
       req=IKeyboard_putCADRequestMsg()
       req._this=self.handle
       
       val=g_port.IKeyboard_putCAD(req)
             
       return 




   _Attrs_={}
class IMouse:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IMouse(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IMouse._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IMouse._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def putMouseEvent(self, _arg_dx, _arg_dy, _arg_dz, _arg_buttonState):
       req=IMouse_putMouseEventRequestMsg()
       req._this=self.handle
       
       req._dx=_arg_dx
       req._dy=_arg_dy
       req._dz=_arg_dz
       req._buttonState=_arg_buttonState
       val=g_port.IMouse_putMouseEvent(req)
             
       return 

 
   def putMouseEventAbsolute(self, _arg_x, _arg_y, _arg_dz, _arg_buttonState):
       req=IMouse_putMouseEventAbsoluteRequestMsg()
       req._this=self.handle
       
       req._x=_arg_x
       req._y=_arg_y
       req._dz=_arg_dz
       req._buttonState=_arg_buttonState
       val=g_port.IMouse_putMouseEventAbsolute(req)
             
       return 


   def getAbsoluteSupported(self):
       req=IMouse_getAbsoluteSupportedRequestMsg()
       req._this=self.handle
       val=g_port.IMouse_getAbsoluteSupported(req)
       return  Boolean(val._returnval)


   _Attrs_={         'absoluteSupported':[getAbsoluteSupported,None]}
class INetworkAdapter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return INetworkAdapter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = INetworkAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = INetworkAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def attachToNAT(self):
       req=INetworkAdapter_attachToNATRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToNAT(req)
             
       return 

 
   def attachToBridgedInterface(self):
       req=INetworkAdapter_attachToBridgedInterfaceRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToBridgedInterface(req)
             
       return 

 
   def attachToInternalNetwork(self):
       req=INetworkAdapter_attachToInternalNetworkRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToInternalNetwork(req)
             
       return 

 
   def attachToHostOnlyInterface(self):
       req=INetworkAdapter_attachToHostOnlyInterfaceRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_attachToHostOnlyInterface(req)
             
       return 

 
   def detach(self):
       req=INetworkAdapter_detachRequestMsg()
       req._this=self.handle
       
       val=g_port.INetworkAdapter_detach(req)
             
       return 


   def getAdapterType(self):
       req=INetworkAdapter_getAdapterTypeRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getAdapterType(req)
       return  NetworkAdapterType(val._returnval)
   def setAdapterType(self, value):
       req=INetworkAdapter_setAdapterTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._adapterType = value
       else:
            req._adapterType = value.handle
       g_port.INetworkAdapter_setAdapterType(req)      

   def getSlot(self):
       req=INetworkAdapter_getSlotRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getSlot(req)
       return  UnsignedInt(val._returnval)
   def getEnabled(self):
       req=INetworkAdapter_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=INetworkAdapter_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.INetworkAdapter_setEnabled(req)      

   def getMACAddress(self):
       req=INetworkAdapter_getMACAddressRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getMACAddress(req)
       return  String(val._returnval)
   def setMACAddress(self, value):
       req=INetworkAdapter_setMACAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._MACAddress = value
       else:
            req._MACAddress = value.handle
       g_port.INetworkAdapter_setMACAddress(req)      

   def getAttachmentType(self):
       req=INetworkAdapter_getAttachmentTypeRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getAttachmentType(req)
       return  NetworkAttachmentType(val._returnval)
   def getHostInterface(self):
       req=INetworkAdapter_getHostInterfaceRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getHostInterface(req)
       return  String(val._returnval)
   def setHostInterface(self, value):
       req=INetworkAdapter_setHostInterfaceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._hostInterface = value
       else:
            req._hostInterface = value.handle
       g_port.INetworkAdapter_setHostInterface(req)      

   def getInternalNetwork(self):
       req=INetworkAdapter_getInternalNetworkRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getInternalNetwork(req)
       return  String(val._returnval)
   def setInternalNetwork(self, value):
       req=INetworkAdapter_setInternalNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._internalNetwork = value
       else:
            req._internalNetwork = value.handle
       g_port.INetworkAdapter_setInternalNetwork(req)      

   def getNATNetwork(self):
       req=INetworkAdapter_getNATNetworkRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getNATNetwork(req)
       return  String(val._returnval)
   def setNATNetwork(self, value):
       req=INetworkAdapter_setNATNetworkRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._NATNetwork = value
       else:
            req._NATNetwork = value.handle
       g_port.INetworkAdapter_setNATNetwork(req)      

   def getCableConnected(self):
       req=INetworkAdapter_getCableConnectedRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getCableConnected(req)
       return  Boolean(val._returnval)
   def setCableConnected(self, value):
       req=INetworkAdapter_setCableConnectedRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._cableConnected = value
       else:
            req._cableConnected = value.handle
       g_port.INetworkAdapter_setCableConnected(req)      

   def getLineSpeed(self):
       req=INetworkAdapter_getLineSpeedRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getLineSpeed(req)
       return  UnsignedInt(val._returnval)
   def setLineSpeed(self, value):
       req=INetworkAdapter_setLineSpeedRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._lineSpeed = value
       else:
            req._lineSpeed = value.handle
       g_port.INetworkAdapter_setLineSpeed(req)      

   def getTraceEnabled(self):
       req=INetworkAdapter_getTraceEnabledRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getTraceEnabled(req)
       return  Boolean(val._returnval)
   def setTraceEnabled(self, value):
       req=INetworkAdapter_setTraceEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._traceEnabled = value
       else:
            req._traceEnabled = value.handle
       g_port.INetworkAdapter_setTraceEnabled(req)      

   def getTraceFile(self):
       req=INetworkAdapter_getTraceFileRequestMsg()
       req._this=self.handle
       val=g_port.INetworkAdapter_getTraceFile(req)
       return  String(val._returnval)
   def setTraceFile(self, value):
       req=INetworkAdapter_setTraceFileRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._traceFile = value
       else:
            req._traceFile = value.handle
       g_port.INetworkAdapter_setTraceFile(req)      



   _Attrs_={         'adapterType':[getAdapterType,setAdapterType,
        ],
         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'MACAddress':[getMACAddress,setMACAddress,
        ],
         'attachmentType':[getAttachmentType,None],
         'hostInterface':[getHostInterface,setHostInterface,
        ],
         'internalNetwork':[getInternalNetwork,setInternalNetwork,
        ],
         'NATNetwork':[getNATNetwork,setNATNetwork,
        ],
         'cableConnected':[getCableConnected,setCableConnected,
        ],
         'lineSpeed':[getLineSpeed,setLineSpeed,
        ],
         'traceEnabled':[getTraceEnabled,setTraceEnabled,
        ],
         'traceFile':[getTraceFile,setTraceFile,
        ]}
class ISerialPort:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISerialPort(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISerialPort._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISerialPort._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=ISerialPort_getSlotRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getSlot(req)
       return  UnsignedInt(val._returnval)
   def getEnabled(self):
       req=ISerialPort_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=ISerialPort_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.ISerialPort_setEnabled(req)      

   def getIOBase(self):
       req=ISerialPort_getIOBaseRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getIOBase(req)
       return  UnsignedInt(val._returnval)
   def setIOBase(self, value):
       req=ISerialPort_setIOBaseRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IOBase = value
       else:
            req._IOBase = value.handle
       g_port.ISerialPort_setIOBase(req)      

   def getIRQ(self):
       req=ISerialPort_getIRQRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getIRQ(req)
       return  UnsignedInt(val._returnval)
   def setIRQ(self, value):
       req=ISerialPort_setIRQRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IRQ = value
       else:
            req._IRQ = value.handle
       g_port.ISerialPort_setIRQ(req)      

   def getHostMode(self):
       req=ISerialPort_getHostModeRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getHostMode(req)
       return  PortMode(val._returnval)
   def setHostMode(self, value):
       req=ISerialPort_setHostModeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._hostMode = value
       else:
            req._hostMode = value.handle
       g_port.ISerialPort_setHostMode(req)      

   def getServer(self):
       req=ISerialPort_getServerRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getServer(req)
       return  Boolean(val._returnval)
   def setServer(self, value):
       req=ISerialPort_setServerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._server = value
       else:
            req._server = value.handle
       g_port.ISerialPort_setServer(req)      

   def getPath(self):
       req=ISerialPort_getPathRequestMsg()
       req._this=self.handle
       val=g_port.ISerialPort_getPath(req)
       return  String(val._returnval)
   def setPath(self, value):
       req=ISerialPort_setPathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._path = value
       else:
            req._path = value.handle
       g_port.ISerialPort_setPath(req)      



   _Attrs_={         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IOBase':[getIOBase,setIOBase,
        ],
         'IRQ':[getIRQ,setIRQ,
        ],
         'hostMode':[getHostMode,setHostMode,
        ],
         'server':[getServer,setServer,
        ],
         'path':[getPath,setPath,
        ]}
class IParallelPort:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IParallelPort(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IParallelPort._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IParallelPort._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getSlot(self):
       req=IParallelPort_getSlotRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getSlot(req)
       return  UnsignedInt(val._returnval)
   def getEnabled(self):
       req=IParallelPort_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IParallelPort_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IParallelPort_setEnabled(req)      

   def getIOBase(self):
       req=IParallelPort_getIOBaseRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getIOBase(req)
       return  UnsignedInt(val._returnval)
   def setIOBase(self, value):
       req=IParallelPort_setIOBaseRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IOBase = value
       else:
            req._IOBase = value.handle
       g_port.IParallelPort_setIOBase(req)      

   def getIRQ(self):
       req=IParallelPort_getIRQRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getIRQ(req)
       return  UnsignedInt(val._returnval)
   def setIRQ(self, value):
       req=IParallelPort_setIRQRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._IRQ = value
       else:
            req._IRQ = value.handle
       g_port.IParallelPort_setIRQ(req)      

   def getPath(self):
       req=IParallelPort_getPathRequestMsg()
       req._this=self.handle
       val=g_port.IParallelPort_getPath(req)
       return  String(val._returnval)
   def setPath(self, value):
       req=IParallelPort_setPathRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._path = value
       else:
            req._path = value.handle
       g_port.IParallelPort_setPath(req)      



   _Attrs_={         'slot':[getSlot,None],
         'enabled':[getEnabled,setEnabled,
        ],
         'IOBase':[getIOBase,setIOBase,
        ],
         'IRQ':[getIRQ,setIRQ,
        ],
         'path':[getPath,setPath,
        ]}
class IUSBController:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IUSBController(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBController._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IUSBController._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def createDeviceFilter(self, _arg_name):
       req=IUSBController_createDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._name=_arg_name
       val=g_port.IUSBController_createDeviceFilter(req)
             
       return IUSBDeviceFilter(val._returnval)

 
   def insertDeviceFilter(self, _arg_position, _arg_filter):
       req=IUSBController_insertDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       req._filter=_arg_filter
       val=g_port.IUSBController_insertDeviceFilter(req)
             
       return 

 
   def removeDeviceFilter(self, _arg_position):
       req=IUSBController_removeDeviceFilterRequestMsg()
       req._this=self.handle
       
       req._position=_arg_position
       val=g_port.IUSBController_removeDeviceFilter(req)
             
       return IUSBDeviceFilter(val._returnval)


   def getEnabled(self):
       req=IUSBController_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IUSBController_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IUSBController_setEnabled(req)      

   def getEnabledEhci(self):
       req=IUSBController_getEnabledEhciRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getEnabledEhci(req)
       return  Boolean(val._returnval)
   def setEnabledEhci(self, value):
       req=IUSBController_setEnabledEhciRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabledEhci = value
       else:
            req._enabledEhci = value.handle
       g_port.IUSBController_setEnabledEhci(req)      

   def getUSBStandard(self):
       req=IUSBController_getUSBStandardRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getUSBStandard(req)
       return  UnsignedShort(val._returnval)
   def getDeviceFilters(self):
       req=IUSBController_getDeviceFiltersRequestMsg()
       req._this=self.handle
       val=g_port.IUSBController_getDeviceFilters(req)
       return  IUSBDeviceFilter(val._returnval, True)


   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'enabledEhci':[getEnabledEhci,setEnabledEhci,
        ],
         'USBStandard':[getUSBStandard,None],
         'deviceFilters':[getDeviceFilters,None]}
class IUSBDevice:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDevice(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getId(self):
       req=IUSBDevice_getIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getId(req)
       return  UUID(val._returnval)
   def getVendorId(self):
       req=IUSBDevice_getVendorIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getVendorId(req)
       return  UnsignedShort(val._returnval)
   def getProductId(self):
       req=IUSBDevice_getProductIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getProductId(req)
       return  UnsignedShort(val._returnval)
   def getRevision(self):
       req=IUSBDevice_getRevisionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getRevision(req)
       return  UnsignedShort(val._returnval)
   def getManufacturer(self):
       req=IUSBDevice_getManufacturerRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getManufacturer(req)
       return  String(val._returnval)
   def getProduct(self):
       req=IUSBDevice_getProductRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getProduct(req)
       return  String(val._returnval)
   def getSerialNumber(self):
       req=IUSBDevice_getSerialNumberRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getSerialNumber(req)
       return  String(val._returnval)
   def getAddress(self):
       req=IUSBDevice_getAddressRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getAddress(req)
       return  String(val._returnval)
   def getPort(self):
       req=IUSBDevice_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getPort(req)
       return  UnsignedShort(val._returnval)
   def getVersion(self):
       req=IUSBDevice_getVersionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getVersion(req)
       return  UnsignedShort(val._returnval)
   def getPortVersion(self):
       req=IUSBDevice_getPortVersionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getPortVersion(req)
       return  UnsignedShort(val._returnval)
   def getRemote(self):
       req=IUSBDevice_getRemoteRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDevice_getRemote(req)
       return  Boolean(val._returnval)


   _Attrs_={         'id':[getId,None],
         'vendorId':[getVendorId,None],
         'productId':[getProductId,None],
         'revision':[getRevision,None],
         'manufacturer':[getManufacturer,None],
         'product':[getProduct,None],
         'serialNumber':[getSerialNumber,None],
         'address':[getAddress,None],
         'port':[getPort,None],
         'version':[getVersion,None],
         'portVersion':[getPortVersion,None],
         'remote':[getRemote,None]}
class IUSBDeviceFilter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IUSBDeviceFilter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getName(self):
       req=IUSBDeviceFilter_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getName(req)
       return  String(val._returnval)
   def setName(self, value):
       req=IUSBDeviceFilter_setNameRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._name = value
       else:
            req._name = value.handle
       g_port.IUSBDeviceFilter_setName(req)      

   def getActive(self):
       req=IUSBDeviceFilter_getActiveRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getActive(req)
       return  Boolean(val._returnval)
   def setActive(self, value):
       req=IUSBDeviceFilter_setActiveRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._active = value
       else:
            req._active = value.handle
       g_port.IUSBDeviceFilter_setActive(req)      

   def getVendorId(self):
       req=IUSBDeviceFilter_getVendorIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getVendorId(req)
       return  String(val._returnval)
   def setVendorId(self, value):
       req=IUSBDeviceFilter_setVendorIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._vendorId = value
       else:
            req._vendorId = value.handle
       g_port.IUSBDeviceFilter_setVendorId(req)      

   def getProductId(self):
       req=IUSBDeviceFilter_getProductIdRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getProductId(req)
       return  String(val._returnval)
   def setProductId(self, value):
       req=IUSBDeviceFilter_setProductIdRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._productId = value
       else:
            req._productId = value.handle
       g_port.IUSBDeviceFilter_setProductId(req)      

   def getRevision(self):
       req=IUSBDeviceFilter_getRevisionRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getRevision(req)
       return  String(val._returnval)
   def setRevision(self, value):
       req=IUSBDeviceFilter_setRevisionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._revision = value
       else:
            req._revision = value.handle
       g_port.IUSBDeviceFilter_setRevision(req)      

   def getManufacturer(self):
       req=IUSBDeviceFilter_getManufacturerRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getManufacturer(req)
       return  String(val._returnval)
   def setManufacturer(self, value):
       req=IUSBDeviceFilter_setManufacturerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._manufacturer = value
       else:
            req._manufacturer = value.handle
       g_port.IUSBDeviceFilter_setManufacturer(req)      

   def getProduct(self):
       req=IUSBDeviceFilter_getProductRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getProduct(req)
       return  String(val._returnval)
   def setProduct(self, value):
       req=IUSBDeviceFilter_setProductRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._product = value
       else:
            req._product = value.handle
       g_port.IUSBDeviceFilter_setProduct(req)      

   def getSerialNumber(self):
       req=IUSBDeviceFilter_getSerialNumberRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getSerialNumber(req)
       return  String(val._returnval)
   def setSerialNumber(self, value):
       req=IUSBDeviceFilter_setSerialNumberRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._serialNumber = value
       else:
            req._serialNumber = value.handle
       g_port.IUSBDeviceFilter_setSerialNumber(req)      

   def getPort(self):
       req=IUSBDeviceFilter_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getPort(req)
       return  String(val._returnval)
   def setPort(self, value):
       req=IUSBDeviceFilter_setPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._port = value
       else:
            req._port = value.handle
       g_port.IUSBDeviceFilter_setPort(req)      

   def getRemote(self):
       req=IUSBDeviceFilter_getRemoteRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getRemote(req)
       return  String(val._returnval)
   def setRemote(self, value):
       req=IUSBDeviceFilter_setRemoteRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._remote = value
       else:
            req._remote = value.handle
       g_port.IUSBDeviceFilter_setRemote(req)      

   def getMaskedInterfaces(self):
       req=IUSBDeviceFilter_getMaskedInterfacesRequestMsg()
       req._this=self.handle
       val=g_port.IUSBDeviceFilter_getMaskedInterfaces(req)
       return  UnsignedInt(val._returnval)
   def setMaskedInterfaces(self, value):
       req=IUSBDeviceFilter_setMaskedInterfacesRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._maskedInterfaces = value
       else:
            req._maskedInterfaces = value.handle
       g_port.IUSBDeviceFilter_setMaskedInterfaces(req)      



   _Attrs_={         'name':[getName,setName,
        ],
         'active':[getActive,setActive,
        ],
         'vendorId':[getVendorId,setVendorId,
        ],
         'productId':[getProductId,setProductId,
        ],
         'revision':[getRevision,setRevision,
        ],
         'manufacturer':[getManufacturer,setManufacturer,
        ],
         'product':[getProduct,setProduct,
        ],
         'serialNumber':[getSerialNumber,setSerialNumber,
        ],
         'port':[getPort,setPort,
        ],
         'remote':[getRemote,setRemote,
        ],
         'maskedInterfaces':[getMaskedInterfaces,setMaskedInterfaces,
        ]}
class IHostUSBDevice:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostUSBDevice(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostUSBDevice._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getState(self):
       req=IHostUSBDevice_getStateRequestMsg()
       req._this=self.handle
       val=g_port.IHostUSBDevice_getState(req)
       return  USBDeviceState(val._returnval)


   _Attrs_={         'state':[getState,None]}
class IHostUSBDeviceFilter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IHostUSBDeviceFilter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IHostUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IHostUSBDeviceFilter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getAction(self):
       req=IHostUSBDeviceFilter_getActionRequestMsg()
       req._this=self.handle
       val=g_port.IHostUSBDeviceFilter_getAction(req)
       return  USBDeviceFilterAction(val._returnval)
   def setAction(self, value):
       req=IHostUSBDeviceFilter_setActionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._action = value
       else:
            req._action = value.handle
       g_port.IHostUSBDeviceFilter_setAction(req)      



   _Attrs_={         'action':[getAction,setAction,
        ]}
class IAudioAdapter:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IAudioAdapter(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IAudioAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IAudioAdapter._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getEnabled(self):
       req=IAudioAdapter_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IAudioAdapter_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IAudioAdapter_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IAudioAdapter_setEnabled(req)      

   def getAudioController(self):
       req=IAudioAdapter_getAudioControllerRequestMsg()
       req._this=self.handle
       val=g_port.IAudioAdapter_getAudioController(req)
       return  AudioControllerType(val._returnval)
   def setAudioController(self, value):
       req=IAudioAdapter_setAudioControllerRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._audioController = value
       else:
            req._audioController = value.handle
       g_port.IAudioAdapter_setAudioController(req)      

   def getAudioDriver(self):
       req=IAudioAdapter_getAudioDriverRequestMsg()
       req._this=self.handle
       val=g_port.IAudioAdapter_getAudioDriver(req)
       return  AudioDriverType(val._returnval)
   def setAudioDriver(self, value):
       req=IAudioAdapter_setAudioDriverRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._audioDriver = value
       else:
            req._audioDriver = value.handle
       g_port.IAudioAdapter_setAudioDriver(req)      



   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'audioController':[getAudioController,setAudioController,
        ],
         'audioDriver':[getAudioDriver,setAudioDriver,
        ]}
class IVRDPServer:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IVRDPServer(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IVRDPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IVRDPServer._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getEnabled(self):
       req=IVRDPServer_getEnabledRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getEnabled(req)
       return  Boolean(val._returnval)
   def setEnabled(self, value):
       req=IVRDPServer_setEnabledRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._enabled = value
       else:
            req._enabled = value.handle
       g_port.IVRDPServer_setEnabled(req)      

   def getPort(self):
       req=IVRDPServer_getPortRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getPort(req)
       return  UnsignedInt(val._returnval)
   def setPort(self, value):
       req=IVRDPServer_setPortRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._port = value
       else:
            req._port = value.handle
       g_port.IVRDPServer_setPort(req)      

   def getNetAddress(self):
       req=IVRDPServer_getNetAddressRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getNetAddress(req)
       return  String(val._returnval)
   def setNetAddress(self, value):
       req=IVRDPServer_setNetAddressRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._netAddress = value
       else:
            req._netAddress = value.handle
       g_port.IVRDPServer_setNetAddress(req)      

   def getAuthType(self):
       req=IVRDPServer_getAuthTypeRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getAuthType(req)
       return  VRDPAuthType(val._returnval)
   def setAuthType(self, value):
       req=IVRDPServer_setAuthTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._authType = value
       else:
            req._authType = value.handle
       g_port.IVRDPServer_setAuthType(req)      

   def getAuthTimeout(self):
       req=IVRDPServer_getAuthTimeoutRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getAuthTimeout(req)
       return  UnsignedInt(val._returnval)
   def setAuthTimeout(self, value):
       req=IVRDPServer_setAuthTimeoutRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._authTimeout = value
       else:
            req._authTimeout = value.handle
       g_port.IVRDPServer_setAuthTimeout(req)      

   def getAllowMultiConnection(self):
       req=IVRDPServer_getAllowMultiConnectionRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getAllowMultiConnection(req)
       return  Boolean(val._returnval)
   def setAllowMultiConnection(self, value):
       req=IVRDPServer_setAllowMultiConnectionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._allowMultiConnection = value
       else:
            req._allowMultiConnection = value.handle
       g_port.IVRDPServer_setAllowMultiConnection(req)      

   def getReuseSingleConnection(self):
       req=IVRDPServer_getReuseSingleConnectionRequestMsg()
       req._this=self.handle
       val=g_port.IVRDPServer_getReuseSingleConnection(req)
       return  Boolean(val._returnval)
   def setReuseSingleConnection(self, value):
       req=IVRDPServer_setReuseSingleConnectionRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._reuseSingleConnection = value
       else:
            req._reuseSingleConnection = value.handle
       g_port.IVRDPServer_setReuseSingleConnection(req)      



   _Attrs_={         'enabled':[getEnabled,setEnabled,
        ],
         'port':[getPort,setPort,
        ],
         'netAddress':[getNetAddress,setNetAddress,
        ],
         'authType':[getAuthType,setAuthType,
        ],
         'authTimeout':[getAuthTimeout,setAuthTimeout,
        ],
         'allowMultiConnection':[getAllowMultiConnection,setAllowMultiConnection,
        ],
         'reuseSingleConnection':[getReuseSingleConnection,setReuseSingleConnection,
        ]}
class ISession:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return ISession(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = ISession._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = ISession._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def close(self):
       req=ISession_closeRequestMsg()
       req._this=self.handle
       
       val=g_port.ISession_close(req)
             
       return 


   def getState(self):
       req=ISession_getStateRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getState(req)
       return  SessionState(val._returnval)
   def getType(self):
       req=ISession_getTypeRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getType(req)
       return  SessionType(val._returnval)
   def getMachine(self):
       req=ISession_getMachineRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getMachine(req)
       return  IMachine(val._returnval)
   def getConsole(self):
       req=ISession_getConsoleRequestMsg()
       req._this=self.handle
       val=g_port.ISession_getConsole(req)
       return  IConsole(val._returnval)


   _Attrs_={         'state':[getState,None],
         'type':[getType,None],
         'machine':[getMachine,None],
         'console':[getConsole,None]}
class IStorageController:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IStorageController(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IStorageController._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IStorageController._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def GetIDEEmulationPort(self, _arg_devicePosition):
       req=IStorageController_GetIDEEmulationPortRequestMsg()
       req._this=self.handle
       
       req._devicePosition=_arg_devicePosition
       val=g_port.IStorageController_GetIDEEmulationPort(req)
             
       return Int(val._returnval)

 
   def SetIDEEmulationPort(self, _arg_devicePosition, _arg_portNumber):
       req=IStorageController_SetIDEEmulationPortRequestMsg()
       req._this=self.handle
       
       req._devicePosition=_arg_devicePosition
       req._portNumber=_arg_portNumber
       val=g_port.IStorageController_SetIDEEmulationPort(req)
             
       return 


   def getName(self):
       req=IStorageController_getNameRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getName(req)
       return  String(val._returnval)
   def getMaxDevicesPerPortCount(self):
       req=IStorageController_getMaxDevicesPerPortCountRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getMaxDevicesPerPortCount(req)
       return  UnsignedInt(val._returnval)
   def getMinPortCount(self):
       req=IStorageController_getMinPortCountRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getMinPortCount(req)
       return  UnsignedInt(val._returnval)
   def getMaxPortCount(self):
       req=IStorageController_getMaxPortCountRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getMaxPortCount(req)
       return  UnsignedInt(val._returnval)
   def getInstance(self):
       req=IStorageController_getInstanceRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getInstance(req)
       return  UnsignedInt(val._returnval)
   def setInstance(self, value):
       req=IStorageController_setInstanceRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._instance = value
       else:
            req._instance = value.handle
       g_port.IStorageController_setInstance(req)      

   def getPortCount(self):
       req=IStorageController_getPortCountRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getPortCount(req)
       return  UnsignedInt(val._returnval)
   def setPortCount(self, value):
       req=IStorageController_setPortCountRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._portCount = value
       else:
            req._portCount = value.handle
       g_port.IStorageController_setPortCount(req)      

   def getBus(self):
       req=IStorageController_getBusRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getBus(req)
       return  StorageBus(val._returnval)
   def getControllerType(self):
       req=IStorageController_getControllerTypeRequestMsg()
       req._this=self.handle
       val=g_port.IStorageController_getControllerType(req)
       return  StorageControllerType(val._returnval)
   def setControllerType(self, value):
       req=IStorageController_setControllerTypeRequestMsg()
       req._this=self.handle
       if type(value) in [int, bool, basestring]:
            req._controllerType = value
       else:
            req._controllerType = value.handle
       g_port.IStorageController_setControllerType(req)      



   _Attrs_={         'name':[getName,None],
         'maxDevicesPerPortCount':[getMaxDevicesPerPortCount,None],
         'minPortCount':[getMinPortCount,None],
         'maxPortCount':[getMaxPortCount,None],
         'instance':[getInstance,setInstance,
        ],
         'portCount':[getPortCount,setPortCount,
        ],
         'bus':[getBus,None],
         'controllerType':[getControllerType,setControllerType,
        ]}
class IManagedObjectRef:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IManagedObjectRef(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IManagedObjectRef._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IManagedObjectRef._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getInterfaceName(self):
       req=IManagedObjectRef_getInterfaceNameRequestMsg()
       req._this=self.handle
       
       val=g_port.IManagedObjectRef_getInterfaceName(req)
             
       return String(val._returnval)

 
   def release(self):
       req=IManagedObjectRef_releaseRequestMsg()
       req._this=self.handle
       
       val=g_port.IManagedObjectRef_release(req)
             
       return 




   _Attrs_={}
class IWebsessionManager:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IWebsessionManager(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IWebsessionManager._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IWebsessionManager._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def logon(self, _arg_username, _arg_password):
       req=IWebsessionManager_logonRequestMsg()
       req._this=self.handle
       
       req._username=_arg_username
       req._password=_arg_password
       val=g_port.IWebsessionManager_logon(req)
             
       return IVirtualBox(val._returnval)

 
   def getSessionObject(self, _arg_refIVirtualBox):
       req=IWebsessionManager_getSessionObjectRequestMsg()
       req._this=self.handle
       
       req._refIVirtualBox=_arg_refIVirtualBox
       val=g_port.IWebsessionManager_getSessionObject(req)
             
       return ISession(val._returnval)

 
   def logoff(self, _arg_refIVirtualBox):
       req=IWebsessionManager_logoffRequestMsg()
       req._this=self.handle
       
       req._refIVirtualBox=_arg_refIVirtualBox
       val=g_port.IWebsessionManager_logoff(req)
             
       return 




   _Attrs_={}
class IPerformanceMetric:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IPerformanceMetric(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPerformanceMetric._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IPerformanceMetric._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

   
   def getMetricName(self):
       req=IPerformanceMetric_getMetricNameRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getMetricName(req)
       return  String(val._returnval)
   def getObject(self):
       req=IPerformanceMetric_getObjectRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getObject(req)
       return  IUnknown(val._returnval)
   def getDescription(self):
       req=IPerformanceMetric_getDescriptionRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getDescription(req)
       return  String(val._returnval)
   def getPeriod(self):
       req=IPerformanceMetric_getPeriodRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getPeriod(req)
       return  UnsignedInt(val._returnval)
   def getCount(self):
       req=IPerformanceMetric_getCountRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getCount(req)
       return  UnsignedInt(val._returnval)
   def getUnit(self):
       req=IPerformanceMetric_getUnitRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getUnit(req)
       return  String(val._returnval)
   def getMinimumValue(self):
       req=IPerformanceMetric_getMinimumValueRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getMinimumValue(req)
       return  Int(val._returnval)
   def getMaximumValue(self):
       req=IPerformanceMetric_getMaximumValueRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceMetric_getMaximumValue(req)
       return  Int(val._returnval)


   _Attrs_={         'metricName':[getMetricName,None],
         'object':[getObject,None],
         'description':[getDescription,None],
         'period':[getPeriod,None],
         'count':[getCount,None],
         'unit':[getUnit,None],
         'minimumValue':[getMinimumValue,None],
         'maximumValue':[getMaximumValue,None]}
class IPerformanceCollector:
   def __init__(self, handle = None,isarray = False):
       self.handle = handle
       self.isarray = isarray

   def releaseRemote(self):
        try:
            req=IManagedObjectRef_releaseRequestMsg() 
            req._this=handle
            g_port.IManagedObjectRef_release(req)
        except:
            pass

   def __next(self):
      if self.isarray:
          return self.handle.__next()
      raise TypeError, "iteration over non-sequence"

   def __size(self):
      if self.isarray:         
          return self.handle.__size()
      raise TypeError, "iteration over non-sequence"

   def __len__(self):
      if self.isarray:
          return self.handle.__len__()
      raise TypeError, "iteration over non-sequence"

   def __getitem__(self, index):
      if self.isarray:
          return IPerformanceCollector(self.handle[index])
      raise TypeError, "iteration over non-sequence"       

   def __str__(self):
        return self.handle
   
   def isValid(self):
        return self.handle != None and self.handle != ''

   def __getattr__(self,name):
      hndl = IPerformanceCollector._Attrs_.get(name, None)
      if (hndl != None and hndl[0] != None):
         return hndl[0](self)
      else:
         raise AttributeError

   def __setattr__(self, name, val):
      hndl = IPerformanceCollector._Attrs_.get(name, None)
      if (hndl != None and hndl[1] != None):
         hndl[1](self,val)
      else:
         self.__dict__[name] = val

    
   def getMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_getMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_getMetrics(req)
             
       return IPerformanceMetric(val._returnval, True)

 
   def setupMetrics(self, _arg_metricNames, _arg_objects, _arg_period, _arg_count):
       req=IPerformanceCollector_setupMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       req._period=_arg_period
       req._count=_arg_count
       val=g_port.IPerformanceCollector_setupMetrics(req)
             
       return IPerformanceMetric(val._returnval, True)

 
   def enableMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_enableMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_enableMetrics(req)
             
       return IPerformanceMetric(val._returnval, True)

 
   def disableMetrics(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_disableMetricsRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_disableMetrics(req)
             
       return IPerformanceMetric(val._returnval, True)

 
   def queryMetricsData(self, _arg_metricNames, _arg_objects):
       req=IPerformanceCollector_queryMetricsDataRequestMsg()
       req._this=self.handle
       
       req._metricNames=_arg_metricNames
       req._objects=_arg_objects
       val=g_port.IPerformanceCollector_queryMetricsData(req)
             
       return Int(val._returnval, True), String(val._returnMetricNames, True), IUnknown(val._returnObjects, True), String(val._returnUnits, True), UnsignedInt(val._returnScales, True), UnsignedInt(val._returnSequenceNumbers, True), UnsignedInt(val._returnDataIndices, True), UnsignedInt(val._returnDataLengths, True)


   def getMetricNames(self):
       req=IPerformanceCollector_getMetricNamesRequestMsg()
       req._this=self.handle
       val=g_port.IPerformanceCollector_getMetricNames(req)
       return  String(val._returnval, True)


   _Attrs_={         'metricNames':[getMetricNames,None]}
class IRemoteDisplayInfo:
    def __init__(self, handle):
       self.active = handle._active
       self.numberOfClients = handle._numberOfClients
       self.beginTime = handle._beginTime
       self.endTime = handle._endTime
       self.bytesSent = handle._bytesSent
       self.bytesSentTotal = handle._bytesSentTotal
       self.bytesReceived = handle._bytesReceived
       self.bytesReceivedTotal = handle._bytesReceivedTotal
       self.user = handle._user
       self.domain = handle._domain
       self.clientName = handle._clientName
       self.clientIP = handle._clientIP
       self.clientVersion = handle._clientVersion
       self.encryptionStyle = handle._encryptionStyle
    def getActive(self):
       return self.active
 
    def setActive(self):
       raise Error, 'setters not supported'
    
    def getNumberOfClients(self):
       return self.numberOfClients
 
    def setNumberOfClients(self):
       raise Error, 'setters not supported'
    
    def getBeginTime(self):
       return self.beginTime
 
    def setBeginTime(self):
       raise Error, 'setters not supported'
    
    def getEndTime(self):
       return self.endTime
 
    def setEndTime(self):
       raise Error, 'setters not supported'
    
    def getBytesSent(self):
       return self.bytesSent
 
    def setBytesSent(self):
       raise Error, 'setters not supported'
    
    def getBytesSentTotal(self):
       return self.bytesSentTotal
 
    def setBytesSentTotal(self):
       raise Error, 'setters not supported'
    
    def getBytesReceived(self):
       return self.bytesReceived
 
    def setBytesReceived(self):
       raise Error, 'setters not supported'
    
    def getBytesReceivedTotal(self):
       return self.bytesReceivedTotal
 
    def setBytesReceivedTotal(self):
       raise Error, 'setters not supported'
    
    def getUser(self):
       return self.user
 
    def setUser(self):
       raise Error, 'setters not supported'
    
    def getDomain(self):
       return self.domain
 
    def setDomain(self):
       raise Error, 'setters not supported'
    
    def getClientName(self):
       return self.clientName
 
    def setClientName(self):
       raise Error, 'setters not supported'
    
    def getClientIP(self):
       return self.clientIP
 
    def setClientIP(self):
       raise Error, 'setters not supported'
    
    def getClientVersion(self):
       return self.clientVersion
 
    def setClientVersion(self):
       raise Error, 'setters not supported'
    
    def getEncryptionStyle(self):
       return self.encryptionStyle
 
    def setEncryptionStyle(self):
       raise Error, 'setters not supported'
    
class IGuestOSType:
    def __init__(self, handle):
       self.familyId = handle._familyId
       self.familyDescription = handle._familyDescription
       self.id = handle._id
       self.description = handle._description
       self.is64Bit = handle._is64Bit
       self.recommendedIOAPIC = handle._recommendedIOAPIC
       self.recommendedVirtEx = handle._recommendedVirtEx
       self.recommendedRAM = handle._recommendedRAM
       self.recommendedVRAM = handle._recommendedVRAM
       self.recommendedHDD = handle._recommendedHDD
       self.adapterType = handle._adapterType
    def getFamilyId(self):
       return self.familyId
 
    def setFamilyId(self):
       raise Error, 'setters not supported'
    
    def getFamilyDescription(self):
       return self.familyDescription
 
    def setFamilyDescription(self):
       raise Error, 'setters not supported'
    
    def getId(self):
       return self.id
 
    def setId(self):
       raise Error, 'setters not supported'
    
    def getDescription(self):
       return self.description
 
    def setDescription(self):
       raise Error, 'setters not supported'
    
    def getIs64Bit(self):
       return self.is64Bit
 
    def setIs64Bit(self):
       raise Error, 'setters not supported'
    
    def getRecommendedIOAPIC(self):
       return self.recommendedIOAPIC
 
    def setRecommendedIOAPIC(self):
       raise Error, 'setters not supported'
    
    def getRecommendedVirtEx(self):
       return self.recommendedVirtEx
 
    def setRecommendedVirtEx(self):
       raise Error, 'setters not supported'
    
    def getRecommendedRAM(self):
       return self.recommendedRAM
 
    def setRecommendedRAM(self):
       raise Error, 'setters not supported'
    
    def getRecommendedVRAM(self):
       return self.recommendedVRAM
 
    def setRecommendedVRAM(self):
       raise Error, 'setters not supported'
    
    def getRecommendedHDD(self):
       return self.recommendedHDD
 
    def setRecommendedHDD(self):
       raise Error, 'setters not supported'
    
    def getAdapterType(self):
       return self.adapterType
 
    def setAdapterType(self):
       raise Error, 'setters not supported'
    
class IHardDiskAttachment:
    def __init__(self, handle):
       self.hardDisk = handle._hardDisk
       self.controller = handle._controller
       self.port = handle._port
       self.device = handle._device
    def getHardDisk(self):
       return self.hardDisk
 
    def setHardDisk(self):
       raise Error, 'setters not supported'
    
    def getController(self):
       return self.controller
 
    def setController(self):
       raise Error, 'setters not supported'
    
    def getPort(self):
       return self.port
 
    def setPort(self):
       raise Error, 'setters not supported'
    
    def getDevice(self):
       return self.device
 
    def setDevice(self):
       raise Error, 'setters not supported'
    
class ISharedFolder:
    def __init__(self, handle):
       self.name = handle._name
       self.hostPath = handle._hostPath
       self.accessible = handle._accessible
       self.writable = handle._writable
       self.lastAccessError = handle._lastAccessError
    def getName(self):
       return self.name
 
    def setName(self):
       raise Error, 'setters not supported'
    
    def getHostPath(self):
       return self.hostPath
 
    def setHostPath(self):
       raise Error, 'setters not supported'
    
    def getAccessible(self):
       return self.accessible
 
    def setAccessible(self):
       raise Error, 'setters not supported'
    
    def getWritable(self):
       return self.writable
 
    def setWritable(self):
       raise Error, 'setters not supported'
    
    def getLastAccessError(self):
       return self.lastAccessError
 
    def setLastAccessError(self):
       raise Error, 'setters not supported'
    
class TSBool:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=TSBool._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,TSBool):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,TSBool):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return TSBool._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'False',1:'True',2:'Default'}
   _ValueMap={
              'False':0,
              'True':1,
              'Default':2}

   False=0
   True=1
   Default=2

class AccessMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=AccessMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AccessMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,AccessMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return AccessMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'ReadOnly',2:'ReadWrite'}
   _ValueMap={
              'ReadOnly':1,
              'ReadWrite':2}

   ReadOnly=1
   ReadWrite=2

class MachineState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=MachineState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MachineState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,MachineState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return MachineState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'PoweredOff',2:'Saved',3:'Aborted',4:'Running',5:'Paused',6:'Stuck',7:'Starting',8:'Stopping',9:'Saving',10:'Restoring',11:'Discarding',12:'SettingUp',4:'FirstOnline',10:'LastOnline',7:'FirstTransient',12:'LastTransient'}
   _ValueMap={
              'Null':0,
              'PoweredOff':1,
              'Saved':2,
              'Aborted':3,
              'Running':4,
              'Paused':5,
              'Stuck':6,
              'Starting':7,
              'Stopping':8,
              'Saving':9,
              'Restoring':10,
              'Discarding':11,
              'SettingUp':12,
              'FirstOnline':4,
              'LastOnline':10,
              'FirstTransient':7,
              'LastTransient':12}

   Null=0
   PoweredOff=1
   Saved=2
   Aborted=3
   Running=4
   Paused=5
   Stuck=6
   Starting=7
   Stopping=8
   Saving=9
   Restoring=10
   Discarding=11
   SettingUp=12
   FirstOnline=4
   LastOnline=10
   FirstTransient=7
   LastTransient=12

class SessionState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=SessionState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SessionState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,SessionState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return SessionState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Closed',2:'Open',3:'Spawning',4:'Closing'}
   _ValueMap={
              'Null':0,
              'Closed':1,
              'Open':2,
              'Spawning':3,
              'Closing':4}

   Null=0
   Closed=1
   Open=2
   Spawning=3
   Closing=4

class SessionType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=SessionType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,SessionType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,SessionType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return SessionType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Direct',2:'Remote',3:'Existing'}
   _ValueMap={
              'Null':0,
              'Direct':1,
              'Remote':2,
              'Existing':3}

   Null=0
   Direct=1
   Remote=2
   Existing=3

class DeviceType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DeviceType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DeviceType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DeviceType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DeviceType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Floppy',2:'DVD',3:'HardDisk',4:'Network',5:'USB',6:'SharedFolder'}
   _ValueMap={
              'Null':0,
              'Floppy':1,
              'DVD':2,
              'HardDisk':3,
              'Network':4,
              'USB':5,
              'SharedFolder':6}

   Null=0
   Floppy=1
   DVD=2
   HardDisk=3
   Network=4
   USB=5
   SharedFolder=6

class DeviceActivity:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DeviceActivity._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DeviceActivity):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DeviceActivity):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DeviceActivity._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Idle',2:'Reading',3:'Writing'}
   _ValueMap={
              'Null':0,
              'Idle':1,
              'Reading':2,
              'Writing':3}

   Null=0
   Idle=1
   Reading=2
   Writing=3

class ClipboardMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=ClipboardMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ClipboardMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,ClipboardMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return ClipboardMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'HostToGuest',2:'GuestToHost',3:'Bidirectional'}
   _ValueMap={
              'Disabled':0,
              'HostToGuest':1,
              'GuestToHost':2,
              'Bidirectional':3}

   Disabled=0
   HostToGuest=1
   GuestToHost=2
   Bidirectional=3

class Scope:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=Scope._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,Scope):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,Scope):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return Scope._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Global',1:'Machine',2:'Session'}
   _ValueMap={
              'Global':0,
              'Machine':1,
              'Session':2}

   Global=0
   Machine=1
   Session=2

class GuestStatisticType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=GuestStatisticType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,GuestStatisticType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,GuestStatisticType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return GuestStatisticType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'CPULoad_Idle',1:'CPULoad_Kernel',2:'CPULoad_User',3:'Threads',4:'Processes',5:'Handles',6:'MemoryLoad',7:'PhysMemTotal',8:'PhysMemAvailable',9:'PhysMemBalloon',10:'MemCommitTotal',11:'MemKernelTotal',12:'MemKernelPaged',13:'MemKernelNonpaged',14:'MemSystemCache',15:'PageFileSize',16:'SampleNumber',17:'MaxVal'}
   _ValueMap={
              'CPULoad_Idle':0,
              'CPULoad_Kernel':1,
              'CPULoad_User':2,
              'Threads':3,
              'Processes':4,
              'Handles':5,
              'MemoryLoad':6,
              'PhysMemTotal':7,
              'PhysMemAvailable':8,
              'PhysMemBalloon':9,
              'MemCommitTotal':10,
              'MemKernelTotal':11,
              'MemKernelPaged':12,
              'MemKernelNonpaged':13,
              'MemSystemCache':14,
              'PageFileSize':15,
              'SampleNumber':16,
              'MaxVal':17}

   CPULoad_Idle=0
   CPULoad_Kernel=1
   CPULoad_User=2
   Threads=3
   Processes=4
   Handles=5
   MemoryLoad=6
   PhysMemTotal=7
   PhysMemAvailable=8
   PhysMemBalloon=9
   MemCommitTotal=10
   MemKernelTotal=11
   MemKernelPaged=12
   MemKernelNonpaged=13
   MemSystemCache=14
   PageFileSize=15
   SampleNumber=16
   MaxVal=17

class BIOSBootMenuMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=BIOSBootMenuMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,BIOSBootMenuMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,BIOSBootMenuMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return BIOSBootMenuMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disabled',1:'MenuOnly',2:'MessageAndMenu'}
   _ValueMap={
              'Disabled':0,
              'MenuOnly':1,
              'MessageAndMenu':2}

   Disabled=0
   MenuOnly=1
   MessageAndMenu=2

class DriveState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DriveState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DriveState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DriveState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DriveState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'NotMounted',2:'ImageMounted',3:'HostDriveCaptured'}
   _ValueMap={
              'Null':0,
              'NotMounted':1,
              'ImageMounted':2,
              'HostDriveCaptured':3}

   Null=0
   NotMounted=1
   ImageMounted=2
   HostDriveCaptured=3

class ProcessorFeature:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=ProcessorFeature._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,ProcessorFeature):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,ProcessorFeature):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return ProcessorFeature._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'HWVirtEx',1:'PAE',2:'LongMode'}
   _ValueMap={
              'HWVirtEx':0,
              'PAE':1,
              'LongMode':2}

   HWVirtEx=0
   PAE=1
   LongMode=2

class CIMOSType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=CIMOSType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,CIMOSType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,CIMOSType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return CIMOSType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'CIMOS_Unknown',1:'CIMOS_Other',2:'CIMOS_MACOS',3:'CIMOS_ATTUNIX',4:'CIMOS_DGUX',5:'CIMOS_DECNT',6:'CIMOS_Tru64UNIX',7:'CIMOS_OpenVMS',8:'CIMOS_HPUX',9:'CIMOS_AIX',10:'CIMOS_MVS',11:'CIMOS_OS400',12:'CIMOS_OS2',13:'CIMOS_JavaVM',14:'CIMOS_MSDOS',15:'CIMOS_WIN3x',16:'CIMOS_WIN95',17:'CIMOS_WIN98',18:'CIMOS_WINNT',19:'CIMOS_WINCE',20:'CIMOS_NCR3000',21:'CIMOS_NetWare',22:'CIMOS_OSF',23:'CIMOS_DCOS',24:'CIMOS_ReliantUNIX',25:'CIMOS_SCOUnixWare',26:'CIMOS_SCOOpenServer',27:'CIMOS_Sequent',28:'CIMOS_IRIX',29:'CIMOS_Solaris',30:'CIMOS_SunOS',31:'CIMOS_U6000',32:'CIMOS_ASERIES',33:'CIMOS_HPNonStopOS',34:'CIMOS_HPNonStopOSS',35:'CIMOS_BS2000',36:'CIMOS_LINUX',37:'CIMOS_Lynx',38:'CIMOS_XENIX',39:'CIMOS_VM',40:'CIMOS_InteractiveUNIX',41:'CIMOS_BSDUNIX',42:'CIMOS_FreeBSD',43:'CIMOS_NetBSD',44:'CIMOS_GNUHurd',45:'CIMOS_OS9',46:'CIMOS_MACHKernel',47:'CIMOS_Inferno',48:'CIMOS_QNX',49:'CIMOS_EPOC',50:'CIMOS_IxWorks',51:'CIMOS_VxWorks',52:'CIMOS_MiNT',53:'CIMOS_BeOS',54:'CIMOS_HPMPE',55:'CIMOS_NextStep',56:'CIMOS_PalmPilot',57:'CIMOS_Rhapsody',58:'CIMOS_Windows2000',59:'CIMOS_Dedicated',60:'CIMOS_OS390',61:'CIMOS_VSE',62:'CIMOS_TPF',63:'CIMOS_WindowsMe',64:'CIMOS_CalderaOpenUNIX',65:'CIMOS_OpenBSD',66:'CIMOS_NotApplicable',67:'CIMOS_WindowsXP',68:'CIMOS_zOS',69:'CIMOS_MicrosoftWindowsServer2003',70:'CIMOS_MicrosoftWindowsServer2003_64',71:'CIMOS_WindowsXP_64',72:'CIMOS_WindowsXPEmbedded',73:'CIMOS_WindowsVista',74:'CIMOS_WindowsVista_64',75:'CIMOS_WindowsEmbeddedforPointofService',76:'CIMOS_MicrosoftWindowsServer2008',77:'CIMOS_MicrosoftWindowsServer2008_64',78:'CIMOS_FreeBSD_64',79:'CIMOS_RedHatEnterpriseLinux',80:'CIMOS_RedHatEnterpriseLinux_64',81:'CIMOS_Solaris_64',82:'CIMOS_SUSE',83:'CIMOS_SUSE_64',84:'CIMOS_SLES',85:'CIMOS_SLES_64',86:'CIMOS_NovellOES',87:'CIMOS_NovellLinuxDesktop',88:'CIMOS_SunJavaDesktopSystem',89:'CIMOS_Mandriva',90:'CIMOS_Mandriva_64',91:'CIMOS_TurboLinux',92:'CIMOS_TurboLinux_64',93:'CIMOS_Ubuntu',94:'CIMOS_Ubuntu_64',95:'CIMOS_Debian',96:'CIMOS_Debian_64',97:'CIMOS_Linux_2_4_x',98:'CIMOS_Linux_2_4_x_64',99:'CIMOS_Linux_2_6_x',100:'CIMOS_Linux_2_6_x_64',101:'CIMOS_Linux_64',102:'CIMOS_Other_64'}
   _ValueMap={
              'CIMOS_Unknown':0,
              'CIMOS_Other':1,
              'CIMOS_MACOS':2,
              'CIMOS_ATTUNIX':3,
              'CIMOS_DGUX':4,
              'CIMOS_DECNT':5,
              'CIMOS_Tru64UNIX':6,
              'CIMOS_OpenVMS':7,
              'CIMOS_HPUX':8,
              'CIMOS_AIX':9,
              'CIMOS_MVS':10,
              'CIMOS_OS400':11,
              'CIMOS_OS2':12,
              'CIMOS_JavaVM':13,
              'CIMOS_MSDOS':14,
              'CIMOS_WIN3x':15,
              'CIMOS_WIN95':16,
              'CIMOS_WIN98':17,
              'CIMOS_WINNT':18,
              'CIMOS_WINCE':19,
              'CIMOS_NCR3000':20,
              'CIMOS_NetWare':21,
              'CIMOS_OSF':22,
              'CIMOS_DCOS':23,
              'CIMOS_ReliantUNIX':24,
              'CIMOS_SCOUnixWare':25,
              'CIMOS_SCOOpenServer':26,
              'CIMOS_Sequent':27,
              'CIMOS_IRIX':28,
              'CIMOS_Solaris':29,
              'CIMOS_SunOS':30,
              'CIMOS_U6000':31,
              'CIMOS_ASERIES':32,
              'CIMOS_HPNonStopOS':33,
              'CIMOS_HPNonStopOSS':34,
              'CIMOS_BS2000':35,
              'CIMOS_LINUX':36,
              'CIMOS_Lynx':37,
              'CIMOS_XENIX':38,
              'CIMOS_VM':39,
              'CIMOS_InteractiveUNIX':40,
              'CIMOS_BSDUNIX':41,
              'CIMOS_FreeBSD':42,
              'CIMOS_NetBSD':43,
              'CIMOS_GNUHurd':44,
              'CIMOS_OS9':45,
              'CIMOS_MACHKernel':46,
              'CIMOS_Inferno':47,
              'CIMOS_QNX':48,
              'CIMOS_EPOC':49,
              'CIMOS_IxWorks':50,
              'CIMOS_VxWorks':51,
              'CIMOS_MiNT':52,
              'CIMOS_BeOS':53,
              'CIMOS_HPMPE':54,
              'CIMOS_NextStep':55,
              'CIMOS_PalmPilot':56,
              'CIMOS_Rhapsody':57,
              'CIMOS_Windows2000':58,
              'CIMOS_Dedicated':59,
              'CIMOS_OS390':60,
              'CIMOS_VSE':61,
              'CIMOS_TPF':62,
              'CIMOS_WindowsMe':63,
              'CIMOS_CalderaOpenUNIX':64,
              'CIMOS_OpenBSD':65,
              'CIMOS_NotApplicable':66,
              'CIMOS_WindowsXP':67,
              'CIMOS_zOS':68,
              'CIMOS_MicrosoftWindowsServer2003':69,
              'CIMOS_MicrosoftWindowsServer2003_64':70,
              'CIMOS_WindowsXP_64':71,
              'CIMOS_WindowsXPEmbedded':72,
              'CIMOS_WindowsVista':73,
              'CIMOS_WindowsVista_64':74,
              'CIMOS_WindowsEmbeddedforPointofService':75,
              'CIMOS_MicrosoftWindowsServer2008':76,
              'CIMOS_MicrosoftWindowsServer2008_64':77,
              'CIMOS_FreeBSD_64':78,
              'CIMOS_RedHatEnterpriseLinux':79,
              'CIMOS_RedHatEnterpriseLinux_64':80,
              'CIMOS_Solaris_64':81,
              'CIMOS_SUSE':82,
              'CIMOS_SUSE_64':83,
              'CIMOS_SLES':84,
              'CIMOS_SLES_64':85,
              'CIMOS_NovellOES':86,
              'CIMOS_NovellLinuxDesktop':87,
              'CIMOS_SunJavaDesktopSystem':88,
              'CIMOS_Mandriva':89,
              'CIMOS_Mandriva_64':90,
              'CIMOS_TurboLinux':91,
              'CIMOS_TurboLinux_64':92,
              'CIMOS_Ubuntu':93,
              'CIMOS_Ubuntu_64':94,
              'CIMOS_Debian':95,
              'CIMOS_Debian_64':96,
              'CIMOS_Linux_2_4_x':97,
              'CIMOS_Linux_2_4_x_64':98,
              'CIMOS_Linux_2_6_x':99,
              'CIMOS_Linux_2_6_x_64':100,
              'CIMOS_Linux_64':101,
              'CIMOS_Other_64':102}

   CIMOS_Unknown=0
   CIMOS_Other=1
   CIMOS_MACOS=2
   CIMOS_ATTUNIX=3
   CIMOS_DGUX=4
   CIMOS_DECNT=5
   CIMOS_Tru64UNIX=6
   CIMOS_OpenVMS=7
   CIMOS_HPUX=8
   CIMOS_AIX=9
   CIMOS_MVS=10
   CIMOS_OS400=11
   CIMOS_OS2=12
   CIMOS_JavaVM=13
   CIMOS_MSDOS=14
   CIMOS_WIN3x=15
   CIMOS_WIN95=16
   CIMOS_WIN98=17
   CIMOS_WINNT=18
   CIMOS_WINCE=19
   CIMOS_NCR3000=20
   CIMOS_NetWare=21
   CIMOS_OSF=22
   CIMOS_DCOS=23
   CIMOS_ReliantUNIX=24
   CIMOS_SCOUnixWare=25
   CIMOS_SCOOpenServer=26
   CIMOS_Sequent=27
   CIMOS_IRIX=28
   CIMOS_Solaris=29
   CIMOS_SunOS=30
   CIMOS_U6000=31
   CIMOS_ASERIES=32
   CIMOS_HPNonStopOS=33
   CIMOS_HPNonStopOSS=34
   CIMOS_BS2000=35
   CIMOS_LINUX=36
   CIMOS_Lynx=37
   CIMOS_XENIX=38
   CIMOS_VM=39
   CIMOS_InteractiveUNIX=40
   CIMOS_BSDUNIX=41
   CIMOS_FreeBSD=42
   CIMOS_NetBSD=43
   CIMOS_GNUHurd=44
   CIMOS_OS9=45
   CIMOS_MACHKernel=46
   CIMOS_Inferno=47
   CIMOS_QNX=48
   CIMOS_EPOC=49
   CIMOS_IxWorks=50
   CIMOS_VxWorks=51
   CIMOS_MiNT=52
   CIMOS_BeOS=53
   CIMOS_HPMPE=54
   CIMOS_NextStep=55
   CIMOS_PalmPilot=56
   CIMOS_Rhapsody=57
   CIMOS_Windows2000=58
   CIMOS_Dedicated=59
   CIMOS_OS390=60
   CIMOS_VSE=61
   CIMOS_TPF=62
   CIMOS_WindowsMe=63
   CIMOS_CalderaOpenUNIX=64
   CIMOS_OpenBSD=65
   CIMOS_NotApplicable=66
   CIMOS_WindowsXP=67
   CIMOS_zOS=68
   CIMOS_MicrosoftWindowsServer2003=69
   CIMOS_MicrosoftWindowsServer2003_64=70
   CIMOS_WindowsXP_64=71
   CIMOS_WindowsXPEmbedded=72
   CIMOS_WindowsVista=73
   CIMOS_WindowsVista_64=74
   CIMOS_WindowsEmbeddedforPointofService=75
   CIMOS_MicrosoftWindowsServer2008=76
   CIMOS_MicrosoftWindowsServer2008_64=77
   CIMOS_FreeBSD_64=78
   CIMOS_RedHatEnterpriseLinux=79
   CIMOS_RedHatEnterpriseLinux_64=80
   CIMOS_Solaris_64=81
   CIMOS_SUSE=82
   CIMOS_SUSE_64=83
   CIMOS_SLES=84
   CIMOS_SLES_64=85
   CIMOS_NovellOES=86
   CIMOS_NovellLinuxDesktop=87
   CIMOS_SunJavaDesktopSystem=88
   CIMOS_Mandriva=89
   CIMOS_Mandriva_64=90
   CIMOS_TurboLinux=91
   CIMOS_TurboLinux_64=92
   CIMOS_Ubuntu=93
   CIMOS_Ubuntu_64=94
   CIMOS_Debian=95
   CIMOS_Debian_64=96
   CIMOS_Linux_2_4_x=97
   CIMOS_Linux_2_4_x_64=98
   CIMOS_Linux_2_6_x=99
   CIMOS_Linux_2_6_x_64=100
   CIMOS_Linux_64=101
   CIMOS_Other_64=102

class OVFResourceType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=OVFResourceType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,OVFResourceType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,OVFResourceType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return OVFResourceType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Other',2:'ComputerSystem',3:'Processor',4:'Memory',5:'IDEController',6:'ParallelSCSIHBA',7:'FCHBA',8:'iSCSIHBA',9:'IBHCA',10:'EthernetAdapter',11:'OtherNetworkAdapter',12:'IOSlot',13:'IODevice',14:'FloppyDrive',15:'CDDrive',16:'DVDDrive',17:'HardDisk',20:'OtherStorageDevice',23:'USBController',35:'SoundCard'}
   _ValueMap={
              'Other':1,
              'ComputerSystem':2,
              'Processor':3,
              'Memory':4,
              'IDEController':5,
              'ParallelSCSIHBA':6,
              'FCHBA':7,
              'iSCSIHBA':8,
              'IBHCA':9,
              'EthernetAdapter':10,
              'OtherNetworkAdapter':11,
              'IOSlot':12,
              'IODevice':13,
              'FloppyDrive':14,
              'CDDrive':15,
              'DVDDrive':16,
              'HardDisk':17,
              'OtherStorageDevice':20,
              'USBController':23,
              'SoundCard':35}

   Other=1
   ComputerSystem=2
   Processor=3
   Memory=4
   IDEController=5
   ParallelSCSIHBA=6
   FCHBA=7
   iSCSIHBA=8
   IBHCA=9
   EthernetAdapter=10
   OtherNetworkAdapter=11
   IOSlot=12
   IODevice=13
   FloppyDrive=14
   CDDrive=15
   DVDDrive=16
   HardDisk=17
   OtherStorageDevice=20
   USBController=23
   SoundCard=35

class VirtualSystemDescriptionType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=VirtualSystemDescriptionType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VirtualSystemDescriptionType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,VirtualSystemDescriptionType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return VirtualSystemDescriptionType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Ignore',2:'OS',3:'Name',4:'Product',5:'Vendor',6:'Version',7:'ProductUrl',8:'VendorUrl',9:'Description',10:'License',11:'Miscellaneous',12:'CPU',13:'Memory',14:'HardDiskControllerIDE',15:'HardDiskControllerSATA',16:'HardDiskControllerSCSI',17:'HardDiskImage',18:'Floppy',19:'CDROM',20:'NetworkAdapter',21:'USBController',22:'SoundCard'}
   _ValueMap={
              'Ignore':1,
              'OS':2,
              'Name':3,
              'Product':4,
              'Vendor':5,
              'Version':6,
              'ProductUrl':7,
              'VendorUrl':8,
              'Description':9,
              'License':10,
              'Miscellaneous':11,
              'CPU':12,
              'Memory':13,
              'HardDiskControllerIDE':14,
              'HardDiskControllerSATA':15,
              'HardDiskControllerSCSI':16,
              'HardDiskImage':17,
              'Floppy':18,
              'CDROM':19,
              'NetworkAdapter':20,
              'USBController':21,
              'SoundCard':22}

   Ignore=1
   OS=2
   Name=3
   Product=4
   Vendor=5
   Version=6
   ProductUrl=7
   VendorUrl=8
   Description=9
   License=10
   Miscellaneous=11
   CPU=12
   Memory=13
   HardDiskControllerIDE=14
   HardDiskControllerSATA=15
   HardDiskControllerSCSI=16
   HardDiskImage=17
   Floppy=18
   CDROM=19
   NetworkAdapter=20
   USBController=21
   SoundCard=22

class VirtualSystemDescriptionValueType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=VirtualSystemDescriptionValueType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VirtualSystemDescriptionValueType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,VirtualSystemDescriptionValueType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return VirtualSystemDescriptionValueType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Reference',2:'Original',3:'Auto',4:'ExtraConfig'}
   _ValueMap={
              'Reference':1,
              'Original':2,
              'Auto':3,
              'ExtraConfig':4}

   Reference=1
   Original=2
   Auto=3
   ExtraConfig=4

class HostNetworkInterfaceMediumType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HostNetworkInterfaceMediumType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HostNetworkInterfaceMediumType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HostNetworkInterfaceMediumType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HostNetworkInterfaceMediumType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unknown',1:'Ethernet',2:'PPP',3:'SLIP'}
   _ValueMap={
              'Unknown':0,
              'Ethernet':1,
              'PPP':2,
              'SLIP':3}

   Unknown=0
   Ethernet=1
   PPP=2
   SLIP=3

class HostNetworkInterfaceStatus:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HostNetworkInterfaceStatus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HostNetworkInterfaceStatus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HostNetworkInterfaceStatus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HostNetworkInterfaceStatus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Unknown',1:'Up',2:'Down'}
   _ValueMap={
              'Unknown':0,
              'Up':1,
              'Down':2}

   Unknown=0
   Up=1
   Down=2

class HostNetworkInterfaceType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HostNetworkInterfaceType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HostNetworkInterfaceType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HostNetworkInterfaceType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HostNetworkInterfaceType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'Bridged',2:'HostOnly'}
   _ValueMap={
              'Bridged':1,
              'HostOnly':2}

   Bridged=1
   HostOnly=2

class MediaState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=MediaState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MediaState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,MediaState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return MediaState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'NotCreated',1:'Created',2:'LockedRead',3:'LockedWrite',4:'Inaccessible',5:'Creating',6:'Deleting'}
   _ValueMap={
              'NotCreated':0,
              'Created':1,
              'LockedRead':2,
              'LockedWrite':3,
              'Inaccessible':4,
              'Creating':5,
              'Deleting':6}

   NotCreated=0
   Created=1
   LockedRead=2
   LockedWrite=3
   Inaccessible=4
   Creating=5
   Deleting=6

class HardDiskType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HardDiskType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HardDiskType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HardDiskType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HardDiskType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Normal',1:'Immutable',2:'Writethrough'}
   _ValueMap={
              'Normal':0,
              'Immutable':1,
              'Writethrough':2}

   Normal=0
   Immutable=1
   Writethrough=2

class HardDiskVariant:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HardDiskVariant._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HardDiskVariant):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HardDiskVariant):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HardDiskVariant._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Standard',0x01:'VmdkSplit2G',0x04:'VmdkStreamOptimized',0x08:'VmdkESX',0x10000:'Fixed',0x20000:'Diff'}
   _ValueMap={
              'Standard':0,
              'VmdkSplit2G':0x01,
              'VmdkStreamOptimized':0x04,
              'VmdkESX':0x08,
              'Fixed':0x10000,
              'Diff':0x20000}

   Standard=0
   VmdkSplit2G=0x01
   VmdkStreamOptimized=0x04
   VmdkESX=0x08
   Fixed=0x10000
   Diff=0x20000

class DataType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DataType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DataType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DataType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DataType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Int32',1:'Int8',2:'String'}
   _ValueMap={
              'Int32':0,
              'Int8':1,
              'String':2}

   Int32=0
   Int8=1
   String=2

class DataFlags:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=DataFlags._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,DataFlags):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,DataFlags):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return DataFlags._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x00:'None',0x01:'Mandatory',0x02:'Expert',0x04:'Array',0x07:'FlagMask'}
   _ValueMap={
              'None':0x00,
              'Mandatory':0x01,
              'Expert':0x02,
              'Array':0x04,
              'FlagMask':0x07}

   _None=0x00
   Mandatory=0x01
   Expert=0x02
   Array=0x04
   FlagMask=0x07

class HardDiskFormatCapabilities:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=HardDiskFormatCapabilities._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,HardDiskFormatCapabilities):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,HardDiskFormatCapabilities):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return HardDiskFormatCapabilities._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'Uuid',0x02:'CreateFixed',0x04:'CreateDynamic',0x08:'CreateSplit2G',0x10:'Differencing',0x20:'Asynchronous',0x40:'File',0x80:'Properties',0xFF:'CapabilityMask'}
   _ValueMap={
              'Uuid':0x01,
              'CreateFixed':0x02,
              'CreateDynamic':0x04,
              'CreateSplit2G':0x08,
              'Differencing':0x10,
              'Asynchronous':0x20,
              'File':0x40,
              'Properties':0x80,
              'CapabilityMask':0xFF}

   Uuid=0x01
   CreateFixed=0x02
   CreateDynamic=0x04
   CreateSplit2G=0x08
   Differencing=0x10
   Asynchronous=0x20
   File=0x40
   Properties=0x80
   CapabilityMask=0xFF

class MouseButtonState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=MouseButtonState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,MouseButtonState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,MouseButtonState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return MouseButtonState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0x01:'LeftButton',0x02:'RightButton',0x04:'MiddleButton',0x08:'WheelUp',0x10:'WheelDown',0x1F:'MouseStateMask'}
   _ValueMap={
              'LeftButton':0x01,
              'RightButton':0x02,
              'MiddleButton':0x04,
              'WheelUp':0x08,
              'WheelDown':0x10,
              'MouseStateMask':0x1F}

   LeftButton=0x01
   RightButton=0x02
   MiddleButton=0x04
   WheelUp=0x08
   WheelDown=0x10
   MouseStateMask=0x1F

class FramebufferAccelerationOperation:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=FramebufferAccelerationOperation._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FramebufferAccelerationOperation):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,FramebufferAccelerationOperation):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return FramebufferAccelerationOperation._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={1:'SolidFillAcceleration',2:'ScreenCopyAcceleration'}
   _ValueMap={
              'SolidFillAcceleration':1,
              'ScreenCopyAcceleration':2}

   SolidFillAcceleration=1
   ScreenCopyAcceleration=2

class FramebufferPixelFormat:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=FramebufferPixelFormat._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,FramebufferPixelFormat):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,FramebufferPixelFormat):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return FramebufferPixelFormat._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Opaque',0x32424752:'FOURCC_RGB'}
   _ValueMap={
              'Opaque':0,
              'FOURCC_RGB':0x32424752}

   Opaque=0
   FOURCC_RGB=0x32424752

class NetworkAttachmentType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=NetworkAttachmentType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAttachmentType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAttachmentType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return NetworkAttachmentType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'NAT',2:'Bridged',3:'Internal',4:'HostOnly'}
   _ValueMap={
              'Null':0,
              'NAT':1,
              'Bridged':2,
              'Internal':3,
              'HostOnly':4}

   Null=0
   NAT=1
   Bridged=2
   Internal=3
   HostOnly=4

class NetworkAdapterType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=NetworkAdapterType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,NetworkAdapterType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,NetworkAdapterType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return NetworkAdapterType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Am79C970A',2:'Am79C973',3:'I82540EM',4:'I82543GC',5:'I82545EM'}
   _ValueMap={
              'Null':0,
              'Am79C970A':1,
              'Am79C973':2,
              'I82540EM':3,
              'I82543GC':4,
              'I82545EM':5}

   Null=0
   Am79C970A=1
   Am79C973=2
   I82540EM=3
   I82543GC=4
   I82545EM=5

class PortMode:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=PortMode._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,PortMode):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,PortMode):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return PortMode._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Disconnected',1:'HostPipe',2:'HostDevice',3:'RawFile'}
   _ValueMap={
              'Disconnected':0,
              'HostPipe':1,
              'HostDevice':2,
              'RawFile':3}

   Disconnected=0
   HostPipe=1
   HostDevice=2
   RawFile=3

class USBDeviceState:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=USBDeviceState._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBDeviceState):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBDeviceState):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return USBDeviceState._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'NotSupported',1:'Unavailable',2:'Busy',3:'Available',4:'Held',5:'Captured'}
   _ValueMap={
              'NotSupported':0,
              'Unavailable':1,
              'Busy':2,
              'Available':3,
              'Held':4,
              'Captured':5}

   NotSupported=0
   Unavailable=1
   Busy=2
   Available=3
   Held=4
   Captured=5

class USBDeviceFilterAction:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=USBDeviceFilterAction._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,USBDeviceFilterAction):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,USBDeviceFilterAction):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return USBDeviceFilterAction._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'Ignore',2:'Hold'}
   _ValueMap={
              'Null':0,
              'Ignore':1,
              'Hold':2}

   Null=0
   Ignore=1
   Hold=2

class AudioDriverType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=AudioDriverType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioDriverType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioDriverType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return AudioDriverType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'WinMM',2:'OSS',3:'ALSA',4:'DirectSound',5:'CoreAudio',6:'MMPM',7:'Pulse',8:'SolAudio'}
   _ValueMap={
              'Null':0,
              'WinMM':1,
              'OSS':2,
              'ALSA':3,
              'DirectSound':4,
              'CoreAudio':5,
              'MMPM':6,
              'Pulse':7,
              'SolAudio':8}

   Null=0
   WinMM=1
   OSS=2
   ALSA=3
   DirectSound=4
   CoreAudio=5
   MMPM=6
   Pulse=7
   SolAudio=8

class AudioControllerType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=AudioControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,AudioControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,AudioControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return AudioControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'AC97',1:'SB16'}
   _ValueMap={
              'AC97':0,
              'SB16':1}

   AC97=0
   SB16=1

class VRDPAuthType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=VRDPAuthType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,VRDPAuthType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,VRDPAuthType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return VRDPAuthType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'External',2:'Guest'}
   _ValueMap={
              'Null':0,
              'External':1,
              'Guest':2}

   Null=0
   External=1
   Guest=2

class StorageBus:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=StorageBus._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,StorageBus):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,StorageBus):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return StorageBus._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'IDE',2:'SATA',3:'SCSI'}
   _ValueMap={
              'Null':0,
              'IDE':1,
              'SATA':2,
              'SCSI':3}

   Null=0
   IDE=1
   SATA=2
   SCSI=3

class StorageControllerType:
   def __init__(self,handle):
       if isinstance(handle,basestring):
           self.handle=StorageControllerType._ValueMap[handle]
       else:
           self.handle=handle

   def __eq__(self,other):
      if isinstance(other,StorageControllerType):
         return self.handle == other.handle
      if isinstance(other,int):
         return self.handle == other
      return False

   def __ne__(self,other):
      if isinstance(other,StorageControllerType):
         return self.handle != other.handle
      if isinstance(other,int):
         return self.handle != other
      return True

   def __str__(self):
        return StorageControllerType._NameMap[self.handle]

   def __int__(self):
        return self.handle

   _NameMap={0:'Null',1:'LsiLogic',2:'BusLogic',3:'IntelAhci',4:'PIIX3',5:'PIIX4',6:'ICH6'}
   _ValueMap={
              'Null':0,
              'LsiLogic':1,
              'BusLogic':2,
              'IntelAhci':3,
              'PIIX3':4,
              'PIIX4':5,
              'ICH6':6}

   Null=0
   LsiLogic=1
   BusLogic=2
   IntelAhci=3
   PIIX3=4
   PIIX4=5
   ICH6=6


class VirtualBoxReflectionInfo:
   def __init__(self):
      self.map = {}
  
   def add(self,name,ref):
      self.map[name] = ref

   def __getattr__(self,name):
      ref = self.map.get(name,None)
      if ref == None:
          return self.__dict__[name]
      return ref

g_reflectionInfo = VirtualBoxReflectionInfo()
g_reflectionInfo.add("TSBool",TSBool)
g_reflectionInfo.add("AccessMode",AccessMode)
g_reflectionInfo.add("MachineState",MachineState)
g_reflectionInfo.add("SessionState",SessionState)
g_reflectionInfo.add("SessionType",SessionType)
g_reflectionInfo.add("DeviceType",DeviceType)
g_reflectionInfo.add("DeviceActivity",DeviceActivity)
g_reflectionInfo.add("ClipboardMode",ClipboardMode)
g_reflectionInfo.add("Scope",Scope)
g_reflectionInfo.add("GuestStatisticType",GuestStatisticType)
g_reflectionInfo.add("BIOSBootMenuMode",BIOSBootMenuMode)
g_reflectionInfo.add("DriveState",DriveState)
g_reflectionInfo.add("ProcessorFeature",ProcessorFeature)
g_reflectionInfo.add("CIMOSType",CIMOSType)
g_reflectionInfo.add("OVFResourceType",OVFResourceType)
g_reflectionInfo.add("VirtualSystemDescriptionType",VirtualSystemDescriptionType)
g_reflectionInfo.add("VirtualSystemDescriptionValueType",VirtualSystemDescriptionValueType)
g_reflectionInfo.add("HostNetworkInterfaceMediumType",HostNetworkInterfaceMediumType)
g_reflectionInfo.add("HostNetworkInterfaceStatus",HostNetworkInterfaceStatus)
g_reflectionInfo.add("HostNetworkInterfaceType",HostNetworkInterfaceType)
g_reflectionInfo.add("MediaState",MediaState)
g_reflectionInfo.add("HardDiskType",HardDiskType)
g_reflectionInfo.add("HardDiskVariant",HardDiskVariant)
g_reflectionInfo.add("DataType",DataType)
g_reflectionInfo.add("DataFlags",DataFlags)
g_reflectionInfo.add("HardDiskFormatCapabilities",HardDiskFormatCapabilities)
g_reflectionInfo.add("MouseButtonState",MouseButtonState)
g_reflectionInfo.add("FramebufferAccelerationOperation",FramebufferAccelerationOperation)
g_reflectionInfo.add("FramebufferPixelFormat",FramebufferPixelFormat)
g_reflectionInfo.add("NetworkAttachmentType",NetworkAttachmentType)
g_reflectionInfo.add("NetworkAdapterType",NetworkAdapterType)
g_reflectionInfo.add("PortMode",PortMode)
g_reflectionInfo.add("USBDeviceState",USBDeviceState)
g_reflectionInfo.add("USBDeviceFilterAction",USBDeviceFilterAction)
g_reflectionInfo.add("AudioDriverType",AudioDriverType)
g_reflectionInfo.add("AudioControllerType",AudioControllerType)
g_reflectionInfo.add("VRDPAuthType",VRDPAuthType)
g_reflectionInfo.add("StorageBus",StorageBus)
g_reflectionInfo.add("StorageControllerType",StorageControllerType)
