/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox_3_0;

import com.sun.xml.ws.commons.virtualbox_3_0.Helper;
import com.sun.xml.ws.commons.virtualbox_3_0.IAppliance;
import com.sun.xml.ws.commons.virtualbox_3_0.IDHCPServer;
import com.sun.xml.ws.commons.virtualbox_3_0.IDVDImage;
import com.sun.xml.ws.commons.virtualbox_3_0.IFloppyImage;
import com.sun.xml.ws.commons.virtualbox_3_0.IHardDisk;
import com.sun.xml.ws.commons.virtualbox_3_0.IHost;
import com.sun.xml.ws.commons.virtualbox_3_0.IMachine;
import com.sun.xml.ws.commons.virtualbox_3_0.IPerformanceCollector;
import com.sun.xml.ws.commons.virtualbox_3_0.IProgress;
import com.sun.xml.ws.commons.virtualbox_3_0.ISession;
import com.sun.xml.ws.commons.virtualbox_3_0.ISystemProperties;
import com.sun.xml.ws.commons.virtualbox_3_0.IUnknown;
import java.util.List;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.virtualbox_3_0.AccessMode;
import org.virtualbox_3_0.IGuestOSType;
import org.virtualbox_3_0.ISharedFolder;
import org.virtualbox_3_0.InvalidObjectFaultMsg;
import org.virtualbox_3_0.RuntimeFaultMsg;
import org.virtualbox_3_0.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IVirtualBox
extends IUnknown {
    public static IVirtualBox cast(IUnknown iUnknown) {
        return new IVirtualBox(iUnknown.getRef(), iUnknown.getRemoteWSPort());
    }

    public IVirtualBox(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public String getVersion() {
        try {
            String string = this.port.iVirtualBoxGetVersion(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Long getRevision() {
        try {
            Long l = this.port.iVirtualBoxGetRevision(this._this);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getPackageType() {
        try {
            String string = this.port.iVirtualBoxGetPackageType(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getHomeFolder() {
        try {
            String string = this.port.iVirtualBoxGetHomeFolder(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getSettingsFilePath() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFilePath(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getSettingsFileVersion() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFileVersion(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getSettingsFormatVersion() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFormatVersion(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHost getHost() {
        try {
            String string = this.port.iVirtualBoxGetHost(this._this);
            return string.length() > 0 ? new IHost(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public ISystemProperties getSystemProperties() {
        try {
            String string = this.port.iVirtualBoxGetSystemProperties(this._this);
            return string.length() > 0 ? new ISystemProperties(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IMachine> getMachines() {
        try {
            List<String> list = this.port.iVirtualBoxGetMachines(this._this);
            return Helper.wrap(IMachine.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IHardDisk> getHardDisks() {
        try {
            List<String> list = this.port.iVirtualBoxGetHardDisks(this._this);
            return Helper.wrap(IHardDisk.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IDVDImage> getDVDImages() {
        try {
            List<String> list = this.port.iVirtualBoxGetDVDImages(this._this);
            return Helper.wrap(IDVDImage.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IFloppyImage> getFloppyImages() {
        try {
            List<String> list = this.port.iVirtualBoxGetFloppyImages(this._this);
            return Helper.wrap(IFloppyImage.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IProgress> getProgressOperations() {
        try {
            List<String> list = this.port.iVirtualBoxGetProgressOperations(this._this);
            return Helper.wrap(IProgress.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IGuestOSType> getGuestOSTypes() {
        try {
            List<IGuestOSType> list = this.port.iVirtualBoxGetGuestOSTypes(this._this);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<ISharedFolder> getSharedFolders() {
        try {
            List<ISharedFolder> list = this.port.iVirtualBoxGetSharedFolders(this._this);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IPerformanceCollector getPerformanceCollector() {
        try {
            String string = this.port.iVirtualBoxGetPerformanceCollector(this._this);
            return string.length() > 0 ? new IPerformanceCollector(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IDHCPServer> getDHCPServers() {
        try {
            List<String> list = this.port.iVirtualBoxGetDHCPServers(this._this);
            return Helper.wrap(IDHCPServer.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine createMachine(String string, String string2, String string3, String string4) {
        try {
            String string5 = this.port.iVirtualBoxCreateMachine(this._this, string, string2, string3, string4);
            return string5.length() > 0 ? new IMachine(string5, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine createLegacyMachine(String string, String string2, String string3, String string4) {
        try {
            String string5 = this.port.iVirtualBoxCreateLegacyMachine(this._this, string, string2, string3, string4);
            return string5.length() > 0 ? new IMachine(string5, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine openMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxOpenMachine(this._this, string);
            return string2.length() > 0 ? new IMachine(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void registerMachine(IMachine iMachine) {
        try {
            this.port.iVirtualBoxRegisterMachine(this._this, iMachine == null ? null : iMachine.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine getMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetMachine(this._this, string);
            return string2.length() > 0 ? new IMachine(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine findMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindMachine(this._this, string);
            return string2.length() > 0 ? new IMachine(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IMachine unregisterMachine(String string) {
        try {
            String string2 = this.port.iVirtualBoxUnregisterMachine(this._this, string);
            return string2.length() > 0 ? new IMachine(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IAppliance createAppliance() {
        try {
            String string = this.port.iVirtualBoxCreateAppliance(this._this);
            return string.length() > 0 ? new IAppliance(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk createHardDisk(String string, String string2) {
        try {
            String string3 = this.port.iVirtualBoxCreateHardDisk(this._this, string, string2);
            return string3.length() > 0 ? new IHardDisk(string3, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk openHardDisk(String string, AccessMode accessMode, Boolean bl, String string2, Boolean bl2, String string3) {
        try {
            String string4 = this.port.iVirtualBoxOpenHardDisk(this._this, string, accessMode, bl, string2, bl2, string3);
            return string4.length() > 0 ? new IHardDisk(string4, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk getHardDisk(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetHardDisk(this._this, string);
            return string2.length() > 0 ? new IHardDisk(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IHardDisk findHardDisk(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindHardDisk(this._this, string);
            return string2.length() > 0 ? new IHardDisk(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage openDVDImage(String string, String string2) {
        try {
            String string3 = this.port.iVirtualBoxOpenDVDImage(this._this, string, string2);
            return string3.length() > 0 ? new IDVDImage(string3, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage getDVDImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetDVDImage(this._this, string);
            return string2.length() > 0 ? new IDVDImage(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDVDImage findDVDImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindDVDImage(this._this, string);
            return string2.length() > 0 ? new IDVDImage(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage openFloppyImage(String string, String string2) {
        try {
            String string3 = this.port.iVirtualBoxOpenFloppyImage(this._this, string, string2);
            return string3.length() > 0 ? new IFloppyImage(string3, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage getFloppyImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetFloppyImage(this._this, string);
            return string2.length() > 0 ? new IFloppyImage(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IFloppyImage findFloppyImage(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindFloppyImage(this._this, string);
            return string2.length() > 0 ? new IFloppyImage(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IGuestOSType getGuestOSType(String string) {
        try {
            IGuestOSType iGuestOSType = this.port.iVirtualBoxGetGuestOSType(this._this, string);
            return iGuestOSType;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void createSharedFolder(String string, String string2, Boolean bl) {
        try {
            this.port.iVirtualBoxCreateSharedFolder(this._this, string, string2, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void removeSharedFolder(String string) {
        try {
            this.port.iVirtualBoxRemoveSharedFolder(this._this, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void getNextExtraDataKey(String string, Holder<String> holder, Holder<String> holder2) {
        try {
            this.port.iVirtualBoxGetNextExtraDataKey(this._this, string, holder, holder2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String getExtraData(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetExtraData(this._this, string);
            return string2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setExtraData(String string, String string2) {
        try {
            this.port.iVirtualBoxSetExtraData(this._this, string, string2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void openSession(ISession iSession, String string) {
        try {
            this.port.iVirtualBoxOpenSession(this._this, iSession == null ? null : iSession.getRef(), string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IProgress openRemoteSession(ISession iSession, String string, String string2, String string3) {
        try {
            String string4 = this.port.iVirtualBoxOpenRemoteSession(this._this, iSession == null ? null : iSession.getRef(), string, string2, string3);
            return string4.length() > 0 ? new IProgress(string4, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void openExistingSession(ISession iSession, String string) {
        try {
            this.port.iVirtualBoxOpenExistingSession(this._this, iSession == null ? null : iSession.getRef(), string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void waitForPropertyChange(String string, Long l, Holder<String> holder, Holder<String> holder2) {
        try {
            this.port.iVirtualBoxWaitForPropertyChange(this._this, string, l, holder, holder2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void saveSettings() {
        try {
            this.port.iVirtualBoxSaveSettings(this._this);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public String saveSettingsWithBackup() {
        try {
            String string = this.port.iVirtualBoxSaveSettingsWithBackup(this._this);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDHCPServer createDHCPServer(String string) {
        try {
            String string2 = this.port.iVirtualBoxCreateDHCPServer(this._this, string);
            return string2.length() > 0 ? new IDHCPServer(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IDHCPServer findDHCPServerByNetworkName(String string) {
        try {
            String string2 = this.port.iVirtualBoxFindDHCPServerByNetworkName(this._this, string);
            return string2.length() > 0 ? new IDHCPServer(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void removeDHCPServer(IDHCPServer iDHCPServer) {
        try {
            this.port.iVirtualBoxRemoveDHCPServer(this._this, iDHCPServer == null ? null : iDHCPServer.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }
}

