
/**
 * Copyright (C) 2008-2009 Sun Microsystems, Inc.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Sun LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Sun elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
 * Clara, CA 95054 USA or visit http://www.sun.com if you need
 * additional information or have any questions.
 *
 * IMedium.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/webservice/glue-jaxws.xsl
 */


package com.sun.xml.ws.commons.virtualbox_3_0;

import org.virtualbox_3_0.VboxPortType;
import org.virtualbox_3_0.VboxService;
import org.virtualbox_3_0.InvalidObjectFaultMsg;
import org.virtualbox_3_0.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
public class IMedium extends IUnknown {

    public static IMedium cast(IUnknown other) {
        return new IMedium(other.getRef(), other.getRemoteWSPort());
    }

    public IMedium(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IMedium::id of type wstring
    public String getId() {
        try {
            String retVal = port.iMediumGetId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMedium::description of type wstring
    public String getDescription() {
        try {
            String retVal = port.iMediumGetDescription(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setDescription(String value) {
        try {
            port.iMediumSetDescription(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMedium::state of type MediaState
    public org.virtualbox_3_0.MediaState getState() {
        try {
            org.virtualbox_3_0.MediaState retVal = port.iMediumGetState(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IMedium::location of type wstring
    public String getLocation() {
        try {
            String retVal = port.iMediumGetLocation(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setLocation(String value) {
        try {
            port.iMediumSetLocation(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMedium::name of type wstring
    public String getName() {
        try {
            String retVal = port.iMediumGetName(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMedium::size of type unsigned long long
    public BigInteger getSize() {
        try {
            BigInteger retVal = port.iMediumGetSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMedium::lastAccessError of type wstring
    public String getLastAccessError() {
        try {
            String retVal = port.iMediumGetLastAccessError(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IMedium::machineIds of type wstring
    public List<String> getMachineIds() {
        try {
            List<String> retVal = port.iMediumGetMachineIds(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMedium::getSnapshotIds(
            [in] wstring machineId,
            [return] wstring snapshotIds[])
     */
    public List<String> getSnapshotIds(String machineId) {
        try {
            List<String> retVal = port.iMediumGetSnapshotIds(_this, machineId);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMedium::lockRead(
            [return] MediaState state)
     */
    public org.virtualbox_3_0.MediaState lockRead() {
        try {
            org.virtualbox_3_0.MediaState retVal = port.iMediumLockRead(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMedium::unlockRead(
            [return] MediaState state)
     */
    public org.virtualbox_3_0.MediaState unlockRead() {
        try {
            org.virtualbox_3_0.MediaState retVal = port.iMediumUnlockRead(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMedium::lockWrite(
            [return] MediaState state)
     */
    public org.virtualbox_3_0.MediaState lockWrite() {
        try {
            org.virtualbox_3_0.MediaState retVal = port.iMediumLockWrite(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMedium::unlockWrite(
            [return] MediaState state)
     */
    public org.virtualbox_3_0.MediaState unlockWrite() {
        try {
            org.virtualbox_3_0.MediaState retVal = port.iMediumUnlockWrite(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IMedium::close()
     */
    public void close() {
        try {
            port.iMediumClose(_this);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
