
/**
 * Copyright (C) 2008-2009 Sun Microsystems, Inc.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Sun LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Sun elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
 * Clara, CA 95054 USA or visit http://www.sun.com if you need
 * additional information or have any questions.
 *
 * IUSBDevice.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/webservice/glue-jaxws.xsl
 */


package com.sun.xml.ws.commons.virtualbox_3_0;

import org.virtualbox_3_0.VboxPortType;
import org.virtualbox_3_0.VboxService;
import org.virtualbox_3_0.InvalidObjectFaultMsg;
import org.virtualbox_3_0.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
public class IUSBDevice extends IUnknown {

    public static IUSBDevice cast(IUnknown other) {
        return new IUSBDevice(other.getRef(), other.getRemoteWSPort());
    }

    public IUSBDevice(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IUSBDevice::id of type wstring
    public String getId() {
        try {
            String retVal = port.iusbDeviceGetId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::vendorId of type unsigned short
    public Integer getVendorId() {
        try {
            Integer retVal = port.iusbDeviceGetVendorId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::productId of type unsigned short
    public Integer getProductId() {
        try {
            Integer retVal = port.iusbDeviceGetProductId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::revision of type unsigned short
    public Integer getRevision() {
        try {
            Integer retVal = port.iusbDeviceGetRevision(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::manufacturer of type wstring
    public String getManufacturer() {
        try {
            String retVal = port.iusbDeviceGetManufacturer(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::product of type wstring
    public String getProduct() {
        try {
            String retVal = port.iusbDeviceGetProduct(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::serialNumber of type wstring
    public String getSerialNumber() {
        try {
            String retVal = port.iusbDeviceGetSerialNumber(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::address of type wstring
    public String getAddress() {
        try {
            String retVal = port.iusbDeviceGetAddress(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::port of type unsigned short
    public Integer getPort() {
        try {
            Integer retVal = port.iusbDeviceGetPort(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::version of type unsigned short
    public Integer getVersion() {
        try {
            Integer retVal = port.iusbDeviceGetVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::portVersion of type unsigned short
    public Integer getPortVersion() {
        try {
            Integer retVal = port.iusbDeviceGetPortVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IUSBDevice::remote of type boolean
    public Boolean getRemote() {
        try {
            Boolean retVal = port.iusbDeviceGetRemote(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
