# Copyright (C) 2009 Sun Microsystems, Inc.
#
# This file is part of VirtualBox Open Source Edition (OSE), as
# available from http://www.virtualbox.org. This file is free software;
# you can redistribute it and/or modify it under the terms of the GNU
# General Public License (GPL) as published by the Free Software
# Foundation, in version 2 as it comes in the "COPYING" file of the
# VirtualBox OSE distribution. VirtualBox OSE is distributed in the
# hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
#
# Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
# Clara, CA 95054 USA or visit http://www.sun.com if you need
# additional information or have any questions.
#
# This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
#

class VirtualBoxReflectionInfo:
   def __init__(self, isSym):
      self.isSym = isSym

   _Values = {
                'AccessMode':{
                  'ReadOnly':1,'ReadWrite':2},
                'MachineState':{
                  'Null':0,'PoweredOff':1,'Saved':2,'Aborted':3,'Running':4,'Paused':5,'Stuck':6,'Starting':7,'Stopping':8,'Saving':9,'Restoring':10,'Discarding':11,'SettingUp':12,'FirstOnline':4,'LastOnline':10,'FirstTransient':7,'LastTransient':12},
                'SessionState':{
                  'Null':0,'Closed':1,'Open':2,'Spawning':3,'Closing':4},
                'SessionType':{
                  'Null':0,'Direct':1,'Remote':2,'Existing':3},
                'DeviceType':{
                  'Null':0,'Floppy':1,'DVD':2,'HardDisk':3,'Network':4,'USB':5,'SharedFolder':6},
                'DeviceActivity':{
                  'Null':0,'Idle':1,'Reading':2,'Writing':3},
                'ClipboardMode':{
                  'Disabled':0,'HostToGuest':1,'GuestToHost':2,'Bidirectional':3},
                'Scope':{
                  'Global':0,'Machine':1,'Session':2},
                'GuestStatisticType':{
                  'CPULoad_Idle':0,'CPULoad_Kernel':1,'CPULoad_User':2,'Threads':3,'Processes':4,'Handles':5,'MemoryLoad':6,'PhysMemTotal':7,'PhysMemAvailable':8,'PhysMemBalloon':9,'MemCommitTotal':10,'MemKernelTotal':11,'MemKernelPaged':12,'MemKernelNonpaged':13,'MemSystemCache':14,'PageFileSize':15,'SampleNumber':16,'MaxVal':17},
                'BIOSBootMenuMode':{
                  'Disabled':0,'MenuOnly':1,'MessageAndMenu':2},
                'DriveState':{
                  'Null':0,'NotMounted':1,'ImageMounted':2,'HostDriveCaptured':3},
                'ProcessorFeature':{
                  'HWVirtEx':0,'PAE':1,'LongMode':2},
                'VFSType':{
                  'File':1,'Cloud':2,'S3':3,'WebDav':4},
                'VFSFileType':{
                  'Unknown':1,'Fifo':2,'DevChar':3,'Directory':4,'DevBlock':5,'File':6,'SymLink':7,'Socket':8,'WhiteOut':9},
                'CIMOSType':{
                  'CIMOS_Unknown':0,'CIMOS_Other':1,'CIMOS_MACOS':2,'CIMOS_ATTUNIX':3,'CIMOS_DGUX':4,'CIMOS_DECNT':5,'CIMOS_Tru64UNIX':6,'CIMOS_OpenVMS':7,'CIMOS_HPUX':8,'CIMOS_AIX':9,'CIMOS_MVS':10,'CIMOS_OS400':11,'CIMOS_OS2':12,'CIMOS_JavaVM':13,'CIMOS_MSDOS':14,'CIMOS_WIN3x':15,'CIMOS_WIN95':16,'CIMOS_WIN98':17,'CIMOS_WINNT':18,'CIMOS_WINCE':19,'CIMOS_NCR3000':20,'CIMOS_NetWare':21,'CIMOS_OSF':22,'CIMOS_DCOS':23,'CIMOS_ReliantUNIX':24,'CIMOS_SCOUnixWare':25,'CIMOS_SCOOpenServer':26,'CIMOS_Sequent':27,'CIMOS_IRIX':28,'CIMOS_Solaris':29,'CIMOS_SunOS':30,'CIMOS_U6000':31,'CIMOS_ASERIES':32,'CIMOS_HPNonStopOS':33,'CIMOS_HPNonStopOSS':34,'CIMOS_BS2000':35,'CIMOS_LINUX':36,'CIMOS_Lynx':37,'CIMOS_XENIX':38,'CIMOS_VM':39,'CIMOS_InteractiveUNIX':40,'CIMOS_BSDUNIX':41,'CIMOS_FreeBSD':42,'CIMOS_NetBSD':43,'CIMOS_GNUHurd':44,'CIMOS_OS9':45,'CIMOS_MACHKernel':46,'CIMOS_Inferno':47,'CIMOS_QNX':48,'CIMOS_EPOC':49,'CIMOS_IxWorks':50,'CIMOS_VxWorks':51,'CIMOS_MiNT':52,'CIMOS_BeOS':53,'CIMOS_HPMPE':54,'CIMOS_NextStep':55,'CIMOS_PalmPilot':56,'CIMOS_Rhapsody':57,'CIMOS_Windows2000':58,'CIMOS_Dedicated':59,'CIMOS_OS390':60,'CIMOS_VSE':61,'CIMOS_TPF':62,'CIMOS_WindowsMe':63,'CIMOS_CalderaOpenUNIX':64,'CIMOS_OpenBSD':65,'CIMOS_NotApplicable':66,'CIMOS_WindowsXP':67,'CIMOS_zOS':68,'CIMOS_MicrosoftWindowsServer2003':69,'CIMOS_MicrosoftWindowsServer2003_64':70,'CIMOS_WindowsXP_64':71,'CIMOS_WindowsXPEmbedded':72,'CIMOS_WindowsVista':73,'CIMOS_WindowsVista_64':74,'CIMOS_WindowsEmbeddedforPointofService':75,'CIMOS_MicrosoftWindowsServer2008':76,'CIMOS_MicrosoftWindowsServer2008_64':77,'CIMOS_FreeBSD_64':78,'CIMOS_RedHatEnterpriseLinux':79,'CIMOS_RedHatEnterpriseLinux_64':80,'CIMOS_Solaris_64':81,'CIMOS_SUSE':82,'CIMOS_SUSE_64':83,'CIMOS_SLES':84,'CIMOS_SLES_64':85,'CIMOS_NovellOES':86,'CIMOS_NovellLinuxDesktop':87,'CIMOS_SunJavaDesktopSystem':88,'CIMOS_Mandriva':89,'CIMOS_Mandriva_64':90,'CIMOS_TurboLinux':91,'CIMOS_TurboLinux_64':92,'CIMOS_Ubuntu':93,'CIMOS_Ubuntu_64':94,'CIMOS_Debian':95,'CIMOS_Debian_64':96,'CIMOS_Linux_2_4_x':97,'CIMOS_Linux_2_4_x_64':98,'CIMOS_Linux_2_6_x':99,'CIMOS_Linux_2_6_x_64':100,'CIMOS_Linux_64':101,'CIMOS_Other_64':102},
                'OVFResourceType':{
                  'Other':1,'ComputerSystem':2,'Processor':3,'Memory':4,'IDEController':5,'ParallelSCSIHBA':6,'FCHBA':7,'iSCSIHBA':8,'IBHCA':9,'EthernetAdapter':10,'OtherNetworkAdapter':11,'IOSlot':12,'IODevice':13,'FloppyDrive':14,'CDDrive':15,'DVDDrive':16,'HardDisk':17,'OtherStorageDevice':20,'USBController':23,'SoundCard':35},
                'VirtualSystemDescriptionType':{
                  'Ignore':1,'OS':2,'Name':3,'Product':4,'Vendor':5,'Version':6,'ProductUrl':7,'VendorUrl':8,'Description':9,'License':10,'Miscellaneous':11,'CPU':12,'Memory':13,'HardDiskControllerIDE':14,'HardDiskControllerSATA':15,'HardDiskControllerSCSI':16,'HardDiskImage':17,'Floppy':18,'CDROM':19,'NetworkAdapter':20,'USBController':21,'SoundCard':22},
                'VirtualSystemDescriptionValueType':{
                  'Reference':1,'Original':2,'Auto':3,'ExtraConfig':4},
                'HostNetworkInterfaceMediumType':{
                  'Unknown':0,'Ethernet':1,'PPP':2,'SLIP':3},
                'HostNetworkInterfaceStatus':{
                  'Unknown':0,'Up':1,'Down':2},
                'HostNetworkInterfaceType':{
                  'Bridged':1,'HostOnly':2},
                'MediaState':{
                  'NotCreated':0,'Created':1,'LockedRead':2,'LockedWrite':3,'Inaccessible':4,'Creating':5,'Deleting':6},
                'HardDiskType':{
                  'Normal':0,'Immutable':1,'Writethrough':2},
                'HardDiskVariant':{
                  'Standard':0,'VmdkSplit2G':0x01,'VmdkStreamOptimized':0x04,'VmdkESX':0x08,'Fixed':0x10000,'Diff':0x20000},
                'DataType':{
                  'Int32':0,'Int8':1,'String':2},
                'DataFlags':{
                  'None':0x00,'Mandatory':0x01,'Expert':0x02,'Array':0x04,'FlagMask':0x07},
                'HardDiskFormatCapabilities':{
                  'Uuid':0x01,'CreateFixed':0x02,'CreateDynamic':0x04,'CreateSplit2G':0x08,'Differencing':0x10,'Asynchronous':0x20,'File':0x40,'Properties':0x80,'CapabilityMask':0xFF},
                'MouseButtonState':{
                  'LeftButton':0x01,'RightButton':0x02,'MiddleButton':0x04,'WheelUp':0x08,'WheelDown':0x10,'MouseStateMask':0x1F},
                'FramebufferPixelFormat':{
                  'Opaque':0,'FOURCC_RGB':0x32424752},
                'NetworkAttachmentType':{
                  'Null':0,'NAT':1,'Bridged':2,'Internal':3,'HostOnly':4},
                'NetworkAdapterType':{
                  'Null':0,'Am79C970A':1,'Am79C973':2,'I82540EM':3,'I82543GC':4,'I82545EM':5},
                'PortMode':{
                  'Disconnected':0,'HostPipe':1,'HostDevice':2,'RawFile':3},
                'USBDeviceState':{
                  'NotSupported':0,'Unavailable':1,'Busy':2,'Available':3,'Held':4,'Captured':5},
                'USBDeviceFilterAction':{
                  'Null':0,'Ignore':1,'Hold':2},
                'AudioDriverType':{
                  'Null':0,'WinMM':1,'OSS':2,'ALSA':3,'DirectSound':4,'CoreAudio':5,'MMPM':6,'Pulse':7,'SolAudio':8},
                'AudioControllerType':{
                  'AC97':0,'SB16':1},
                'VRDPAuthType':{
                  'Null':0,'External':1,'Guest':2},
                'StorageBus':{
                  'Null':0,'IDE':1,'SATA':2,'SCSI':3},
                'StorageControllerType':{
                  'Null':0,'LsiLogic':1,'BusLogic':2,'IntelAhci':3,'PIIX3':4,'PIIX4':5,'ICH6':6}}

   _ValuesFlat = {
                        'AccessMode_ReadOnly':1,
                        'AccessMode_ReadWrite':2,
                        'MachineState_Null':0,
                        'MachineState_PoweredOff':1,
                        'MachineState_Saved':2,
                        'MachineState_Aborted':3,
                        'MachineState_Running':4,
                        'MachineState_Paused':5,
                        'MachineState_Stuck':6,
                        'MachineState_Starting':7,
                        'MachineState_Stopping':8,
                        'MachineState_Saving':9,
                        'MachineState_Restoring':10,
                        'MachineState_Discarding':11,
                        'MachineState_SettingUp':12,
                        'MachineState_FirstOnline':4,
                        'MachineState_LastOnline':10,
                        'MachineState_FirstTransient':7,
                        'MachineState_LastTransient':12,
                        'SessionState_Null':0,
                        'SessionState_Closed':1,
                        'SessionState_Open':2,
                        'SessionState_Spawning':3,
                        'SessionState_Closing':4,
                        'SessionType_Null':0,
                        'SessionType_Direct':1,
                        'SessionType_Remote':2,
                        'SessionType_Existing':3,
                        'DeviceType_Null':0,
                        'DeviceType_Floppy':1,
                        'DeviceType_DVD':2,
                        'DeviceType_HardDisk':3,
                        'DeviceType_Network':4,
                        'DeviceType_USB':5,
                        'DeviceType_SharedFolder':6,
                        'DeviceActivity_Null':0,
                        'DeviceActivity_Idle':1,
                        'DeviceActivity_Reading':2,
                        'DeviceActivity_Writing':3,
                        'ClipboardMode_Disabled':0,
                        'ClipboardMode_HostToGuest':1,
                        'ClipboardMode_GuestToHost':2,
                        'ClipboardMode_Bidirectional':3,
                        'Scope_Global':0,
                        'Scope_Machine':1,
                        'Scope_Session':2,
                        'GuestStatisticType_CPULoad_Idle':0,
                        'GuestStatisticType_CPULoad_Kernel':1,
                        'GuestStatisticType_CPULoad_User':2,
                        'GuestStatisticType_Threads':3,
                        'GuestStatisticType_Processes':4,
                        'GuestStatisticType_Handles':5,
                        'GuestStatisticType_MemoryLoad':6,
                        'GuestStatisticType_PhysMemTotal':7,
                        'GuestStatisticType_PhysMemAvailable':8,
                        'GuestStatisticType_PhysMemBalloon':9,
                        'GuestStatisticType_MemCommitTotal':10,
                        'GuestStatisticType_MemKernelTotal':11,
                        'GuestStatisticType_MemKernelPaged':12,
                        'GuestStatisticType_MemKernelNonpaged':13,
                        'GuestStatisticType_MemSystemCache':14,
                        'GuestStatisticType_PageFileSize':15,
                        'GuestStatisticType_SampleNumber':16,
                        'GuestStatisticType_MaxVal':17,
                        'BIOSBootMenuMode_Disabled':0,
                        'BIOSBootMenuMode_MenuOnly':1,
                        'BIOSBootMenuMode_MessageAndMenu':2,
                        'DriveState_Null':0,
                        'DriveState_NotMounted':1,
                        'DriveState_ImageMounted':2,
                        'DriveState_HostDriveCaptured':3,
                        'ProcessorFeature_HWVirtEx':0,
                        'ProcessorFeature_PAE':1,
                        'ProcessorFeature_LongMode':2,
                        'VFSType_File':1,
                        'VFSType_Cloud':2,
                        'VFSType_S3':3,
                        'VFSType_WebDav':4,
                        'VFSFileType_Unknown':1,
                        'VFSFileType_Fifo':2,
                        'VFSFileType_DevChar':3,
                        'VFSFileType_Directory':4,
                        'VFSFileType_DevBlock':5,
                        'VFSFileType_File':6,
                        'VFSFileType_SymLink':7,
                        'VFSFileType_Socket':8,
                        'VFSFileType_WhiteOut':9,
                        'CIMOSType_CIMOS_Unknown':0,
                        'CIMOSType_CIMOS_Other':1,
                        'CIMOSType_CIMOS_MACOS':2,
                        'CIMOSType_CIMOS_ATTUNIX':3,
                        'CIMOSType_CIMOS_DGUX':4,
                        'CIMOSType_CIMOS_DECNT':5,
                        'CIMOSType_CIMOS_Tru64UNIX':6,
                        'CIMOSType_CIMOS_OpenVMS':7,
                        'CIMOSType_CIMOS_HPUX':8,
                        'CIMOSType_CIMOS_AIX':9,
                        'CIMOSType_CIMOS_MVS':10,
                        'CIMOSType_CIMOS_OS400':11,
                        'CIMOSType_CIMOS_OS2':12,
                        'CIMOSType_CIMOS_JavaVM':13,
                        'CIMOSType_CIMOS_MSDOS':14,
                        'CIMOSType_CIMOS_WIN3x':15,
                        'CIMOSType_CIMOS_WIN95':16,
                        'CIMOSType_CIMOS_WIN98':17,
                        'CIMOSType_CIMOS_WINNT':18,
                        'CIMOSType_CIMOS_WINCE':19,
                        'CIMOSType_CIMOS_NCR3000':20,
                        'CIMOSType_CIMOS_NetWare':21,
                        'CIMOSType_CIMOS_OSF':22,
                        'CIMOSType_CIMOS_DCOS':23,
                        'CIMOSType_CIMOS_ReliantUNIX':24,
                        'CIMOSType_CIMOS_SCOUnixWare':25,
                        'CIMOSType_CIMOS_SCOOpenServer':26,
                        'CIMOSType_CIMOS_Sequent':27,
                        'CIMOSType_CIMOS_IRIX':28,
                        'CIMOSType_CIMOS_Solaris':29,
                        'CIMOSType_CIMOS_SunOS':30,
                        'CIMOSType_CIMOS_U6000':31,
                        'CIMOSType_CIMOS_ASERIES':32,
                        'CIMOSType_CIMOS_HPNonStopOS':33,
                        'CIMOSType_CIMOS_HPNonStopOSS':34,
                        'CIMOSType_CIMOS_BS2000':35,
                        'CIMOSType_CIMOS_LINUX':36,
                        'CIMOSType_CIMOS_Lynx':37,
                        'CIMOSType_CIMOS_XENIX':38,
                        'CIMOSType_CIMOS_VM':39,
                        'CIMOSType_CIMOS_InteractiveUNIX':40,
                        'CIMOSType_CIMOS_BSDUNIX':41,
                        'CIMOSType_CIMOS_FreeBSD':42,
                        'CIMOSType_CIMOS_NetBSD':43,
                        'CIMOSType_CIMOS_GNUHurd':44,
                        'CIMOSType_CIMOS_OS9':45,
                        'CIMOSType_CIMOS_MACHKernel':46,
                        'CIMOSType_CIMOS_Inferno':47,
                        'CIMOSType_CIMOS_QNX':48,
                        'CIMOSType_CIMOS_EPOC':49,
                        'CIMOSType_CIMOS_IxWorks':50,
                        'CIMOSType_CIMOS_VxWorks':51,
                        'CIMOSType_CIMOS_MiNT':52,
                        'CIMOSType_CIMOS_BeOS':53,
                        'CIMOSType_CIMOS_HPMPE':54,
                        'CIMOSType_CIMOS_NextStep':55,
                        'CIMOSType_CIMOS_PalmPilot':56,
                        'CIMOSType_CIMOS_Rhapsody':57,
                        'CIMOSType_CIMOS_Windows2000':58,
                        'CIMOSType_CIMOS_Dedicated':59,
                        'CIMOSType_CIMOS_OS390':60,
                        'CIMOSType_CIMOS_VSE':61,
                        'CIMOSType_CIMOS_TPF':62,
                        'CIMOSType_CIMOS_WindowsMe':63,
                        'CIMOSType_CIMOS_CalderaOpenUNIX':64,
                        'CIMOSType_CIMOS_OpenBSD':65,
                        'CIMOSType_CIMOS_NotApplicable':66,
                        'CIMOSType_CIMOS_WindowsXP':67,
                        'CIMOSType_CIMOS_zOS':68,
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2003':69,
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2003_64':70,
                        'CIMOSType_CIMOS_WindowsXP_64':71,
                        'CIMOSType_CIMOS_WindowsXPEmbedded':72,
                        'CIMOSType_CIMOS_WindowsVista':73,
                        'CIMOSType_CIMOS_WindowsVista_64':74,
                        'CIMOSType_CIMOS_WindowsEmbeddedforPointofService':75,
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2008':76,
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2008_64':77,
                        'CIMOSType_CIMOS_FreeBSD_64':78,
                        'CIMOSType_CIMOS_RedHatEnterpriseLinux':79,
                        'CIMOSType_CIMOS_RedHatEnterpriseLinux_64':80,
                        'CIMOSType_CIMOS_Solaris_64':81,
                        'CIMOSType_CIMOS_SUSE':82,
                        'CIMOSType_CIMOS_SUSE_64':83,
                        'CIMOSType_CIMOS_SLES':84,
                        'CIMOSType_CIMOS_SLES_64':85,
                        'CIMOSType_CIMOS_NovellOES':86,
                        'CIMOSType_CIMOS_NovellLinuxDesktop':87,
                        'CIMOSType_CIMOS_SunJavaDesktopSystem':88,
                        'CIMOSType_CIMOS_Mandriva':89,
                        'CIMOSType_CIMOS_Mandriva_64':90,
                        'CIMOSType_CIMOS_TurboLinux':91,
                        'CIMOSType_CIMOS_TurboLinux_64':92,
                        'CIMOSType_CIMOS_Ubuntu':93,
                        'CIMOSType_CIMOS_Ubuntu_64':94,
                        'CIMOSType_CIMOS_Debian':95,
                        'CIMOSType_CIMOS_Debian_64':96,
                        'CIMOSType_CIMOS_Linux_2_4_x':97,
                        'CIMOSType_CIMOS_Linux_2_4_x_64':98,
                        'CIMOSType_CIMOS_Linux_2_6_x':99,
                        'CIMOSType_CIMOS_Linux_2_6_x_64':100,
                        'CIMOSType_CIMOS_Linux_64':101,
                        'CIMOSType_CIMOS_Other_64':102,
                        'OVFResourceType_Other':1,
                        'OVFResourceType_ComputerSystem':2,
                        'OVFResourceType_Processor':3,
                        'OVFResourceType_Memory':4,
                        'OVFResourceType_IDEController':5,
                        'OVFResourceType_ParallelSCSIHBA':6,
                        'OVFResourceType_FCHBA':7,
                        'OVFResourceType_iSCSIHBA':8,
                        'OVFResourceType_IBHCA':9,
                        'OVFResourceType_EthernetAdapter':10,
                        'OVFResourceType_OtherNetworkAdapter':11,
                        'OVFResourceType_IOSlot':12,
                        'OVFResourceType_IODevice':13,
                        'OVFResourceType_FloppyDrive':14,
                        'OVFResourceType_CDDrive':15,
                        'OVFResourceType_DVDDrive':16,
                        'OVFResourceType_HardDisk':17,
                        'OVFResourceType_OtherStorageDevice':20,
                        'OVFResourceType_USBController':23,
                        'OVFResourceType_SoundCard':35,
                        'VirtualSystemDescriptionType_Ignore':1,
                        'VirtualSystemDescriptionType_OS':2,
                        'VirtualSystemDescriptionType_Name':3,
                        'VirtualSystemDescriptionType_Product':4,
                        'VirtualSystemDescriptionType_Vendor':5,
                        'VirtualSystemDescriptionType_Version':6,
                        'VirtualSystemDescriptionType_ProductUrl':7,
                        'VirtualSystemDescriptionType_VendorUrl':8,
                        'VirtualSystemDescriptionType_Description':9,
                        'VirtualSystemDescriptionType_License':10,
                        'VirtualSystemDescriptionType_Miscellaneous':11,
                        'VirtualSystemDescriptionType_CPU':12,
                        'VirtualSystemDescriptionType_Memory':13,
                        'VirtualSystemDescriptionType_HardDiskControllerIDE':14,
                        'VirtualSystemDescriptionType_HardDiskControllerSATA':15,
                        'VirtualSystemDescriptionType_HardDiskControllerSCSI':16,
                        'VirtualSystemDescriptionType_HardDiskImage':17,
                        'VirtualSystemDescriptionType_Floppy':18,
                        'VirtualSystemDescriptionType_CDROM':19,
                        'VirtualSystemDescriptionType_NetworkAdapter':20,
                        'VirtualSystemDescriptionType_USBController':21,
                        'VirtualSystemDescriptionType_SoundCard':22,
                        'VirtualSystemDescriptionValueType_Reference':1,
                        'VirtualSystemDescriptionValueType_Original':2,
                        'VirtualSystemDescriptionValueType_Auto':3,
                        'VirtualSystemDescriptionValueType_ExtraConfig':4,
                        'HostNetworkInterfaceMediumType_Unknown':0,
                        'HostNetworkInterfaceMediumType_Ethernet':1,
                        'HostNetworkInterfaceMediumType_PPP':2,
                        'HostNetworkInterfaceMediumType_SLIP':3,
                        'HostNetworkInterfaceStatus_Unknown':0,
                        'HostNetworkInterfaceStatus_Up':1,
                        'HostNetworkInterfaceStatus_Down':2,
                        'HostNetworkInterfaceType_Bridged':1,
                        'HostNetworkInterfaceType_HostOnly':2,
                        'MediaState_NotCreated':0,
                        'MediaState_Created':1,
                        'MediaState_LockedRead':2,
                        'MediaState_LockedWrite':3,
                        'MediaState_Inaccessible':4,
                        'MediaState_Creating':5,
                        'MediaState_Deleting':6,
                        'HardDiskType_Normal':0,
                        'HardDiskType_Immutable':1,
                        'HardDiskType_Writethrough':2,
                        'HardDiskVariant_Standard':0,
                        'HardDiskVariant_VmdkSplit2G':0x01,
                        'HardDiskVariant_VmdkStreamOptimized':0x04,
                        'HardDiskVariant_VmdkESX':0x08,
                        'HardDiskVariant_Fixed':0x10000,
                        'HardDiskVariant_Diff':0x20000,
                        'DataType_Int32':0,
                        'DataType_Int8':1,
                        'DataType_String':2,
                        'DataFlags_None':0x00,
                        'DataFlags_Mandatory':0x01,
                        'DataFlags_Expert':0x02,
                        'DataFlags_Array':0x04,
                        'DataFlags_FlagMask':0x07,
                        'HardDiskFormatCapabilities_Uuid':0x01,
                        'HardDiskFormatCapabilities_CreateFixed':0x02,
                        'HardDiskFormatCapabilities_CreateDynamic':0x04,
                        'HardDiskFormatCapabilities_CreateSplit2G':0x08,
                        'HardDiskFormatCapabilities_Differencing':0x10,
                        'HardDiskFormatCapabilities_Asynchronous':0x20,
                        'HardDiskFormatCapabilities_File':0x40,
                        'HardDiskFormatCapabilities_Properties':0x80,
                        'HardDiskFormatCapabilities_CapabilityMask':0xFF,
                        'MouseButtonState_LeftButton':0x01,
                        'MouseButtonState_RightButton':0x02,
                        'MouseButtonState_MiddleButton':0x04,
                        'MouseButtonState_WheelUp':0x08,
                        'MouseButtonState_WheelDown':0x10,
                        'MouseButtonState_MouseStateMask':0x1F,
                        'FramebufferPixelFormat_Opaque':0,
                        'FramebufferPixelFormat_FOURCC_RGB':0x32424752,
                        'NetworkAttachmentType_Null':0,
                        'NetworkAttachmentType_NAT':1,
                        'NetworkAttachmentType_Bridged':2,
                        'NetworkAttachmentType_Internal':3,
                        'NetworkAttachmentType_HostOnly':4,
                        'NetworkAdapterType_Null':0,
                        'NetworkAdapterType_Am79C970A':1,
                        'NetworkAdapterType_Am79C973':2,
                        'NetworkAdapterType_I82540EM':3,
                        'NetworkAdapterType_I82543GC':4,
                        'NetworkAdapterType_I82545EM':5,
                        'PortMode_Disconnected':0,
                        'PortMode_HostPipe':1,
                        'PortMode_HostDevice':2,
                        'PortMode_RawFile':3,
                        'USBDeviceState_NotSupported':0,
                        'USBDeviceState_Unavailable':1,
                        'USBDeviceState_Busy':2,
                        'USBDeviceState_Available':3,
                        'USBDeviceState_Held':4,
                        'USBDeviceState_Captured':5,
                        'USBDeviceFilterAction_Null':0,
                        'USBDeviceFilterAction_Ignore':1,
                        'USBDeviceFilterAction_Hold':2,
                        'AudioDriverType_Null':0,
                        'AudioDriverType_WinMM':1,
                        'AudioDriverType_OSS':2,
                        'AudioDriverType_ALSA':3,
                        'AudioDriverType_DirectSound':4,
                        'AudioDriverType_CoreAudio':5,
                        'AudioDriverType_MMPM':6,
                        'AudioDriverType_Pulse':7,
                        'AudioDriverType_SolAudio':8,
                        'AudioControllerType_AC97':0,
                        'AudioControllerType_SB16':1,
                        'VRDPAuthType_Null':0,
                        'VRDPAuthType_External':1,
                        'VRDPAuthType_Guest':2,
                        'StorageBus_Null':0,
                        'StorageBus_IDE':1,
                        'StorageBus_SATA':2,
                        'StorageBus_SCSI':3,
                        'StorageControllerType_Null':0,
                        'StorageControllerType_LsiLogic':1,
                        'StorageControllerType_BusLogic':2,
                        'StorageControllerType_IntelAhci':3,
                        'StorageControllerType_PIIX3':4,
                        'StorageControllerType_PIIX4':5,
                        'StorageControllerType_ICH6':6}

   _ValuesFlatSym = {
                        'AccessMode_ReadOnly': 'ReadOnly',
                        'AccessMode_ReadWrite': 'ReadWrite',
                        'MachineState_Null': 'Null',
                        'MachineState_PoweredOff': 'PoweredOff',
                        'MachineState_Saved': 'Saved',
                        'MachineState_Aborted': 'Aborted',
                        'MachineState_Running': 'Running',
                        'MachineState_Paused': 'Paused',
                        'MachineState_Stuck': 'Stuck',
                        'MachineState_Starting': 'Starting',
                        'MachineState_Stopping': 'Stopping',
                        'MachineState_Saving': 'Saving',
                        'MachineState_Restoring': 'Restoring',
                        'MachineState_Discarding': 'Discarding',
                        'MachineState_SettingUp': 'SettingUp',
                        'MachineState_FirstOnline': 'FirstOnline',
                        'MachineState_LastOnline': 'LastOnline',
                        'MachineState_FirstTransient': 'FirstTransient',
                        'MachineState_LastTransient': 'LastTransient',
                        'SessionState_Null': 'Null',
                        'SessionState_Closed': 'Closed',
                        'SessionState_Open': 'Open',
                        'SessionState_Spawning': 'Spawning',
                        'SessionState_Closing': 'Closing',
                        'SessionType_Null': 'Null',
                        'SessionType_Direct': 'Direct',
                        'SessionType_Remote': 'Remote',
                        'SessionType_Existing': 'Existing',
                        'DeviceType_Null': 'Null',
                        'DeviceType_Floppy': 'Floppy',
                        'DeviceType_DVD': 'DVD',
                        'DeviceType_HardDisk': 'HardDisk',
                        'DeviceType_Network': 'Network',
                        'DeviceType_USB': 'USB',
                        'DeviceType_SharedFolder': 'SharedFolder',
                        'DeviceActivity_Null': 'Null',
                        'DeviceActivity_Idle': 'Idle',
                        'DeviceActivity_Reading': 'Reading',
                        'DeviceActivity_Writing': 'Writing',
                        'ClipboardMode_Disabled': 'Disabled',
                        'ClipboardMode_HostToGuest': 'HostToGuest',
                        'ClipboardMode_GuestToHost': 'GuestToHost',
                        'ClipboardMode_Bidirectional': 'Bidirectional',
                        'Scope_Global': 'Global',
                        'Scope_Machine': 'Machine',
                        'Scope_Session': 'Session',
                        'GuestStatisticType_CPULoad_Idle': 'CPULoad_Idle',
                        'GuestStatisticType_CPULoad_Kernel': 'CPULoad_Kernel',
                        'GuestStatisticType_CPULoad_User': 'CPULoad_User',
                        'GuestStatisticType_Threads': 'Threads',
                        'GuestStatisticType_Processes': 'Processes',
                        'GuestStatisticType_Handles': 'Handles',
                        'GuestStatisticType_MemoryLoad': 'MemoryLoad',
                        'GuestStatisticType_PhysMemTotal': 'PhysMemTotal',
                        'GuestStatisticType_PhysMemAvailable': 'PhysMemAvailable',
                        'GuestStatisticType_PhysMemBalloon': 'PhysMemBalloon',
                        'GuestStatisticType_MemCommitTotal': 'MemCommitTotal',
                        'GuestStatisticType_MemKernelTotal': 'MemKernelTotal',
                        'GuestStatisticType_MemKernelPaged': 'MemKernelPaged',
                        'GuestStatisticType_MemKernelNonpaged': 'MemKernelNonpaged',
                        'GuestStatisticType_MemSystemCache': 'MemSystemCache',
                        'GuestStatisticType_PageFileSize': 'PageFileSize',
                        'GuestStatisticType_SampleNumber': 'SampleNumber',
                        'GuestStatisticType_MaxVal': 'MaxVal',
                        'BIOSBootMenuMode_Disabled': 'Disabled',
                        'BIOSBootMenuMode_MenuOnly': 'MenuOnly',
                        'BIOSBootMenuMode_MessageAndMenu': 'MessageAndMenu',
                        'DriveState_Null': 'Null',
                        'DriveState_NotMounted': 'NotMounted',
                        'DriveState_ImageMounted': 'ImageMounted',
                        'DriveState_HostDriveCaptured': 'HostDriveCaptured',
                        'ProcessorFeature_HWVirtEx': 'HWVirtEx',
                        'ProcessorFeature_PAE': 'PAE',
                        'ProcessorFeature_LongMode': 'LongMode',
                        'VFSType_File': 'File',
                        'VFSType_Cloud': 'Cloud',
                        'VFSType_S3': 'S3',
                        'VFSType_WebDav': 'WebDav',
                        'VFSFileType_Unknown': 'Unknown',
                        'VFSFileType_Fifo': 'Fifo',
                        'VFSFileType_DevChar': 'DevChar',
                        'VFSFileType_Directory': 'Directory',
                        'VFSFileType_DevBlock': 'DevBlock',
                        'VFSFileType_File': 'File',
                        'VFSFileType_SymLink': 'SymLink',
                        'VFSFileType_Socket': 'Socket',
                        'VFSFileType_WhiteOut': 'WhiteOut',
                        'CIMOSType_CIMOS_Unknown': 'CIMOS_Unknown',
                        'CIMOSType_CIMOS_Other': 'CIMOS_Other',
                        'CIMOSType_CIMOS_MACOS': 'CIMOS_MACOS',
                        'CIMOSType_CIMOS_ATTUNIX': 'CIMOS_ATTUNIX',
                        'CIMOSType_CIMOS_DGUX': 'CIMOS_DGUX',
                        'CIMOSType_CIMOS_DECNT': 'CIMOS_DECNT',
                        'CIMOSType_CIMOS_Tru64UNIX': 'CIMOS_Tru64UNIX',
                        'CIMOSType_CIMOS_OpenVMS': 'CIMOS_OpenVMS',
                        'CIMOSType_CIMOS_HPUX': 'CIMOS_HPUX',
                        'CIMOSType_CIMOS_AIX': 'CIMOS_AIX',
                        'CIMOSType_CIMOS_MVS': 'CIMOS_MVS',
                        'CIMOSType_CIMOS_OS400': 'CIMOS_OS400',
                        'CIMOSType_CIMOS_OS2': 'CIMOS_OS2',
                        'CIMOSType_CIMOS_JavaVM': 'CIMOS_JavaVM',
                        'CIMOSType_CIMOS_MSDOS': 'CIMOS_MSDOS',
                        'CIMOSType_CIMOS_WIN3x': 'CIMOS_WIN3x',
                        'CIMOSType_CIMOS_WIN95': 'CIMOS_WIN95',
                        'CIMOSType_CIMOS_WIN98': 'CIMOS_WIN98',
                        'CIMOSType_CIMOS_WINNT': 'CIMOS_WINNT',
                        'CIMOSType_CIMOS_WINCE': 'CIMOS_WINCE',
                        'CIMOSType_CIMOS_NCR3000': 'CIMOS_NCR3000',
                        'CIMOSType_CIMOS_NetWare': 'CIMOS_NetWare',
                        'CIMOSType_CIMOS_OSF': 'CIMOS_OSF',
                        'CIMOSType_CIMOS_DCOS': 'CIMOS_DCOS',
                        'CIMOSType_CIMOS_ReliantUNIX': 'CIMOS_ReliantUNIX',
                        'CIMOSType_CIMOS_SCOUnixWare': 'CIMOS_SCOUnixWare',
                        'CIMOSType_CIMOS_SCOOpenServer': 'CIMOS_SCOOpenServer',
                        'CIMOSType_CIMOS_Sequent': 'CIMOS_Sequent',
                        'CIMOSType_CIMOS_IRIX': 'CIMOS_IRIX',
                        'CIMOSType_CIMOS_Solaris': 'CIMOS_Solaris',
                        'CIMOSType_CIMOS_SunOS': 'CIMOS_SunOS',
                        'CIMOSType_CIMOS_U6000': 'CIMOS_U6000',
                        'CIMOSType_CIMOS_ASERIES': 'CIMOS_ASERIES',
                        'CIMOSType_CIMOS_HPNonStopOS': 'CIMOS_HPNonStopOS',
                        'CIMOSType_CIMOS_HPNonStopOSS': 'CIMOS_HPNonStopOSS',
                        'CIMOSType_CIMOS_BS2000': 'CIMOS_BS2000',
                        'CIMOSType_CIMOS_LINUX': 'CIMOS_LINUX',
                        'CIMOSType_CIMOS_Lynx': 'CIMOS_Lynx',
                        'CIMOSType_CIMOS_XENIX': 'CIMOS_XENIX',
                        'CIMOSType_CIMOS_VM': 'CIMOS_VM',
                        'CIMOSType_CIMOS_InteractiveUNIX': 'CIMOS_InteractiveUNIX',
                        'CIMOSType_CIMOS_BSDUNIX': 'CIMOS_BSDUNIX',
                        'CIMOSType_CIMOS_FreeBSD': 'CIMOS_FreeBSD',
                        'CIMOSType_CIMOS_NetBSD': 'CIMOS_NetBSD',
                        'CIMOSType_CIMOS_GNUHurd': 'CIMOS_GNUHurd',
                        'CIMOSType_CIMOS_OS9': 'CIMOS_OS9',
                        'CIMOSType_CIMOS_MACHKernel': 'CIMOS_MACHKernel',
                        'CIMOSType_CIMOS_Inferno': 'CIMOS_Inferno',
                        'CIMOSType_CIMOS_QNX': 'CIMOS_QNX',
                        'CIMOSType_CIMOS_EPOC': 'CIMOS_EPOC',
                        'CIMOSType_CIMOS_IxWorks': 'CIMOS_IxWorks',
                        'CIMOSType_CIMOS_VxWorks': 'CIMOS_VxWorks',
                        'CIMOSType_CIMOS_MiNT': 'CIMOS_MiNT',
                        'CIMOSType_CIMOS_BeOS': 'CIMOS_BeOS',
                        'CIMOSType_CIMOS_HPMPE': 'CIMOS_HPMPE',
                        'CIMOSType_CIMOS_NextStep': 'CIMOS_NextStep',
                        'CIMOSType_CIMOS_PalmPilot': 'CIMOS_PalmPilot',
                        'CIMOSType_CIMOS_Rhapsody': 'CIMOS_Rhapsody',
                        'CIMOSType_CIMOS_Windows2000': 'CIMOS_Windows2000',
                        'CIMOSType_CIMOS_Dedicated': 'CIMOS_Dedicated',
                        'CIMOSType_CIMOS_OS390': 'CIMOS_OS390',
                        'CIMOSType_CIMOS_VSE': 'CIMOS_VSE',
                        'CIMOSType_CIMOS_TPF': 'CIMOS_TPF',
                        'CIMOSType_CIMOS_WindowsMe': 'CIMOS_WindowsMe',
                        'CIMOSType_CIMOS_CalderaOpenUNIX': 'CIMOS_CalderaOpenUNIX',
                        'CIMOSType_CIMOS_OpenBSD': 'CIMOS_OpenBSD',
                        'CIMOSType_CIMOS_NotApplicable': 'CIMOS_NotApplicable',
                        'CIMOSType_CIMOS_WindowsXP': 'CIMOS_WindowsXP',
                        'CIMOSType_CIMOS_zOS': 'CIMOS_zOS',
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2003': 'CIMOS_MicrosoftWindowsServer2003',
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2003_64': 'CIMOS_MicrosoftWindowsServer2003_64',
                        'CIMOSType_CIMOS_WindowsXP_64': 'CIMOS_WindowsXP_64',
                        'CIMOSType_CIMOS_WindowsXPEmbedded': 'CIMOS_WindowsXPEmbedded',
                        'CIMOSType_CIMOS_WindowsVista': 'CIMOS_WindowsVista',
                        'CIMOSType_CIMOS_WindowsVista_64': 'CIMOS_WindowsVista_64',
                        'CIMOSType_CIMOS_WindowsEmbeddedforPointofService': 'CIMOS_WindowsEmbeddedforPointofService',
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2008': 'CIMOS_MicrosoftWindowsServer2008',
                        'CIMOSType_CIMOS_MicrosoftWindowsServer2008_64': 'CIMOS_MicrosoftWindowsServer2008_64',
                        'CIMOSType_CIMOS_FreeBSD_64': 'CIMOS_FreeBSD_64',
                        'CIMOSType_CIMOS_RedHatEnterpriseLinux': 'CIMOS_RedHatEnterpriseLinux',
                        'CIMOSType_CIMOS_RedHatEnterpriseLinux_64': 'CIMOS_RedHatEnterpriseLinux_64',
                        'CIMOSType_CIMOS_Solaris_64': 'CIMOS_Solaris_64',
                        'CIMOSType_CIMOS_SUSE': 'CIMOS_SUSE',
                        'CIMOSType_CIMOS_SUSE_64': 'CIMOS_SUSE_64',
                        'CIMOSType_CIMOS_SLES': 'CIMOS_SLES',
                        'CIMOSType_CIMOS_SLES_64': 'CIMOS_SLES_64',
                        'CIMOSType_CIMOS_NovellOES': 'CIMOS_NovellOES',
                        'CIMOSType_CIMOS_NovellLinuxDesktop': 'CIMOS_NovellLinuxDesktop',
                        'CIMOSType_CIMOS_SunJavaDesktopSystem': 'CIMOS_SunJavaDesktopSystem',
                        'CIMOSType_CIMOS_Mandriva': 'CIMOS_Mandriva',
                        'CIMOSType_CIMOS_Mandriva_64': 'CIMOS_Mandriva_64',
                        'CIMOSType_CIMOS_TurboLinux': 'CIMOS_TurboLinux',
                        'CIMOSType_CIMOS_TurboLinux_64': 'CIMOS_TurboLinux_64',
                        'CIMOSType_CIMOS_Ubuntu': 'CIMOS_Ubuntu',
                        'CIMOSType_CIMOS_Ubuntu_64': 'CIMOS_Ubuntu_64',
                        'CIMOSType_CIMOS_Debian': 'CIMOS_Debian',
                        'CIMOSType_CIMOS_Debian_64': 'CIMOS_Debian_64',
                        'CIMOSType_CIMOS_Linux_2_4_x': 'CIMOS_Linux_2_4_x',
                        'CIMOSType_CIMOS_Linux_2_4_x_64': 'CIMOS_Linux_2_4_x_64',
                        'CIMOSType_CIMOS_Linux_2_6_x': 'CIMOS_Linux_2_6_x',
                        'CIMOSType_CIMOS_Linux_2_6_x_64': 'CIMOS_Linux_2_6_x_64',
                        'CIMOSType_CIMOS_Linux_64': 'CIMOS_Linux_64',
                        'CIMOSType_CIMOS_Other_64': 'CIMOS_Other_64',
                        'OVFResourceType_Other': 'Other',
                        'OVFResourceType_ComputerSystem': 'ComputerSystem',
                        'OVFResourceType_Processor': 'Processor',
                        'OVFResourceType_Memory': 'Memory',
                        'OVFResourceType_IDEController': 'IDEController',
                        'OVFResourceType_ParallelSCSIHBA': 'ParallelSCSIHBA',
                        'OVFResourceType_FCHBA': 'FCHBA',
                        'OVFResourceType_iSCSIHBA': 'iSCSIHBA',
                        'OVFResourceType_IBHCA': 'IBHCA',
                        'OVFResourceType_EthernetAdapter': 'EthernetAdapter',
                        'OVFResourceType_OtherNetworkAdapter': 'OtherNetworkAdapter',
                        'OVFResourceType_IOSlot': 'IOSlot',
                        'OVFResourceType_IODevice': 'IODevice',
                        'OVFResourceType_FloppyDrive': 'FloppyDrive',
                        'OVFResourceType_CDDrive': 'CDDrive',
                        'OVFResourceType_DVDDrive': 'DVDDrive',
                        'OVFResourceType_HardDisk': 'HardDisk',
                        'OVFResourceType_OtherStorageDevice': 'OtherStorageDevice',
                        'OVFResourceType_USBController': 'USBController',
                        'OVFResourceType_SoundCard': 'SoundCard',
                        'VirtualSystemDescriptionType_Ignore': 'Ignore',
                        'VirtualSystemDescriptionType_OS': 'OS',
                        'VirtualSystemDescriptionType_Name': 'Name',
                        'VirtualSystemDescriptionType_Product': 'Product',
                        'VirtualSystemDescriptionType_Vendor': 'Vendor',
                        'VirtualSystemDescriptionType_Version': 'Version',
                        'VirtualSystemDescriptionType_ProductUrl': 'ProductUrl',
                        'VirtualSystemDescriptionType_VendorUrl': 'VendorUrl',
                        'VirtualSystemDescriptionType_Description': 'Description',
                        'VirtualSystemDescriptionType_License': 'License',
                        'VirtualSystemDescriptionType_Miscellaneous': 'Miscellaneous',
                        'VirtualSystemDescriptionType_CPU': 'CPU',
                        'VirtualSystemDescriptionType_Memory': 'Memory',
                        'VirtualSystemDescriptionType_HardDiskControllerIDE': 'HardDiskControllerIDE',
                        'VirtualSystemDescriptionType_HardDiskControllerSATA': 'HardDiskControllerSATA',
                        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 'HardDiskControllerSCSI',
                        'VirtualSystemDescriptionType_HardDiskImage': 'HardDiskImage',
                        'VirtualSystemDescriptionType_Floppy': 'Floppy',
                        'VirtualSystemDescriptionType_CDROM': 'CDROM',
                        'VirtualSystemDescriptionType_NetworkAdapter': 'NetworkAdapter',
                        'VirtualSystemDescriptionType_USBController': 'USBController',
                        'VirtualSystemDescriptionType_SoundCard': 'SoundCard',
                        'VirtualSystemDescriptionValueType_Reference': 'Reference',
                        'VirtualSystemDescriptionValueType_Original': 'Original',
                        'VirtualSystemDescriptionValueType_Auto': 'Auto',
                        'VirtualSystemDescriptionValueType_ExtraConfig': 'ExtraConfig',
                        'HostNetworkInterfaceMediumType_Unknown': 'Unknown',
                        'HostNetworkInterfaceMediumType_Ethernet': 'Ethernet',
                        'HostNetworkInterfaceMediumType_PPP': 'PPP',
                        'HostNetworkInterfaceMediumType_SLIP': 'SLIP',
                        'HostNetworkInterfaceStatus_Unknown': 'Unknown',
                        'HostNetworkInterfaceStatus_Up': 'Up',
                        'HostNetworkInterfaceStatus_Down': 'Down',
                        'HostNetworkInterfaceType_Bridged': 'Bridged',
                        'HostNetworkInterfaceType_HostOnly': 'HostOnly',
                        'MediaState_NotCreated': 'NotCreated',
                        'MediaState_Created': 'Created',
                        'MediaState_LockedRead': 'LockedRead',
                        'MediaState_LockedWrite': 'LockedWrite',
                        'MediaState_Inaccessible': 'Inaccessible',
                        'MediaState_Creating': 'Creating',
                        'MediaState_Deleting': 'Deleting',
                        'HardDiskType_Normal': 'Normal',
                        'HardDiskType_Immutable': 'Immutable',
                        'HardDiskType_Writethrough': 'Writethrough',
                        'HardDiskVariant_Standard': 'Standard',
                        'HardDiskVariant_VmdkSplit2G': 'VmdkSplit2G',
                        'HardDiskVariant_VmdkStreamOptimized': 'VmdkStreamOptimized',
                        'HardDiskVariant_VmdkESX': 'VmdkESX',
                        'HardDiskVariant_Fixed': 'Fixed',
                        'HardDiskVariant_Diff': 'Diff',
                        'DataType_Int32': 'Int32',
                        'DataType_Int8': 'Int8',
                        'DataType_String': 'String',
                        'DataFlags_None': 'None',
                        'DataFlags_Mandatory': 'Mandatory',
                        'DataFlags_Expert': 'Expert',
                        'DataFlags_Array': 'Array',
                        'DataFlags_FlagMask': 'FlagMask',
                        'HardDiskFormatCapabilities_Uuid': 'Uuid',
                        'HardDiskFormatCapabilities_CreateFixed': 'CreateFixed',
                        'HardDiskFormatCapabilities_CreateDynamic': 'CreateDynamic',
                        'HardDiskFormatCapabilities_CreateSplit2G': 'CreateSplit2G',
                        'HardDiskFormatCapabilities_Differencing': 'Differencing',
                        'HardDiskFormatCapabilities_Asynchronous': 'Asynchronous',
                        'HardDiskFormatCapabilities_File': 'File',
                        'HardDiskFormatCapabilities_Properties': 'Properties',
                        'HardDiskFormatCapabilities_CapabilityMask': 'CapabilityMask',
                        'MouseButtonState_LeftButton': 'LeftButton',
                        'MouseButtonState_RightButton': 'RightButton',
                        'MouseButtonState_MiddleButton': 'MiddleButton',
                        'MouseButtonState_WheelUp': 'WheelUp',
                        'MouseButtonState_WheelDown': 'WheelDown',
                        'MouseButtonState_MouseStateMask': 'MouseStateMask',
                        'FramebufferPixelFormat_Opaque': 'Opaque',
                        'FramebufferPixelFormat_FOURCC_RGB': 'FOURCC_RGB',
                        'NetworkAttachmentType_Null': 'Null',
                        'NetworkAttachmentType_NAT': 'NAT',
                        'NetworkAttachmentType_Bridged': 'Bridged',
                        'NetworkAttachmentType_Internal': 'Internal',
                        'NetworkAttachmentType_HostOnly': 'HostOnly',
                        'NetworkAdapterType_Null': 'Null',
                        'NetworkAdapterType_Am79C970A': 'Am79C970A',
                        'NetworkAdapterType_Am79C973': 'Am79C973',
                        'NetworkAdapterType_I82540EM': 'I82540EM',
                        'NetworkAdapterType_I82543GC': 'I82543GC',
                        'NetworkAdapterType_I82545EM': 'I82545EM',
                        'PortMode_Disconnected': 'Disconnected',
                        'PortMode_HostPipe': 'HostPipe',
                        'PortMode_HostDevice': 'HostDevice',
                        'PortMode_RawFile': 'RawFile',
                        'USBDeviceState_NotSupported': 'NotSupported',
                        'USBDeviceState_Unavailable': 'Unavailable',
                        'USBDeviceState_Busy': 'Busy',
                        'USBDeviceState_Available': 'Available',
                        'USBDeviceState_Held': 'Held',
                        'USBDeviceState_Captured': 'Captured',
                        'USBDeviceFilterAction_Null': 'Null',
                        'USBDeviceFilterAction_Ignore': 'Ignore',
                        'USBDeviceFilterAction_Hold': 'Hold',
                        'AudioDriverType_Null': 'Null',
                        'AudioDriverType_WinMM': 'WinMM',
                        'AudioDriverType_OSS': 'OSS',
                        'AudioDriverType_ALSA': 'ALSA',
                        'AudioDriverType_DirectSound': 'DirectSound',
                        'AudioDriverType_CoreAudio': 'CoreAudio',
                        'AudioDriverType_MMPM': 'MMPM',
                        'AudioDriverType_Pulse': 'Pulse',
                        'AudioDriverType_SolAudio': 'SolAudio',
                        'AudioControllerType_AC97': 'AC97',
                        'AudioControllerType_SB16': 'SB16',
                        'VRDPAuthType_Null': 'Null',
                        'VRDPAuthType_External': 'External',
                        'VRDPAuthType_Guest': 'Guest',
                        'StorageBus_Null': 'Null',
                        'StorageBus_IDE': 'IDE',
                        'StorageBus_SATA': 'SATA',
                        'StorageBus_SCSI': 'SCSI',
                        'StorageControllerType_Null': 'Null',
                        'StorageControllerType_LsiLogic': 'LsiLogic',
                        'StorageControllerType_BusLogic': 'BusLogic',
                        'StorageControllerType_IntelAhci': 'IntelAhci',
                        'StorageControllerType_PIIX3': 'PIIX3',
                        'StorageControllerType_PIIX4': 'PIIX4',
                        'StorageControllerType_ICH6': 'ICH6'}

   def __getattr__(self,attr):
      if self.isSym:
        v = self._ValuesFlatSym.get(attr)
      else:
        v = self._ValuesFlat.get(attr)
      if v is not None:
         return v
      else:
         raise AttributeError

