/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.virtualbox_3_1;

import com.sun.xml.ws.commons.virtualbox_3_1.Helper;
import com.sun.xml.ws.commons.virtualbox_3_1.IUSBDeviceFilter;
import com.sun.xml.ws.commons.virtualbox_3_1.IUnknown;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.virtualbox_3_1.InvalidObjectFaultMsg;
import org.virtualbox_3_1.RuntimeFaultMsg;
import org.virtualbox_3_1.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IUSBController
extends IUnknown {
    public static IUSBController cast(IUnknown iUnknown) {
        return new IUSBController(iUnknown.getRef(), iUnknown.getRemoteWSPort());
    }

    public IUSBController(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public Boolean getEnabled() {
        try {
            Boolean bl = this.port.iusbControllerGetEnabled(this._this);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setEnabled(Boolean bl) {
        try {
            this.port.iusbControllerSetEnabled(this._this, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Boolean getEnabledEhci() {
        try {
            Boolean bl = this.port.iusbControllerGetEnabledEhci(this._this);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void setEnabledEhci(Boolean bl) {
        try {
            this.port.iusbControllerSetEnabledEhci(this._this, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public Integer getUSBStandard() {
        try {
            Integer n = this.port.iusbControllerGetUSBStandard(this._this);
            return n;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public List<IUSBDeviceFilter> getDeviceFilters() {
        try {
            List<String> list = this.port.iusbControllerGetDeviceFilters(this._this);
            return Helper.wrap(IUSBDeviceFilter.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IUSBDeviceFilter createDeviceFilter(String string) {
        try {
            String string2 = this.port.iusbControllerCreateDeviceFilter(this._this, string);
            return string2.length() > 0 ? new IUSBDeviceFilter(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public void insertDeviceFilter(Long l, IUSBDeviceFilter iUSBDeviceFilter) {
        try {
            this.port.iusbControllerInsertDeviceFilter(this._this, l, iUSBDeviceFilter == null ? null : iUSBDeviceFilter.getRef());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }

    public IUSBDeviceFilter removeDeviceFilter(Long l) {
        try {
            String string = this.port.iusbControllerRemoveDeviceFilter(this._this, l);
            return string.length() > 0 ? new IUSBDeviceFilter(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new WebServiceException((Throwable)invalidObjectFaultMsg);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new WebServiceException((Throwable)runtimeFaultMsg);
        }
    }
}

