
/**
 * Copyright (C) 2008-2009 Sun Microsystems, Inc.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the "COPYING.LIB" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Sun LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Sun elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
 * Clara, CA 95054 USA or visit http://www.sun.com if you need
 * additional information or have any questions.
 *
 * IGuest.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/webservice/glue-jaxws.xsl
 */


package com.sun.xml.ws.commons.virtualbox_3_1;

import org.virtualbox_3_1.VboxPortType;
import org.virtualbox_3_1.VboxService;
import org.virtualbox_3_1.InvalidObjectFaultMsg;
import org.virtualbox_3_1.RuntimeFaultMsg;
import javax.xml.ws.WebServiceException;
import java.math.BigInteger;
import java.util.List;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
public class IGuest extends IUnknown {

    public static IGuest cast(IUnknown other) {
        return new IGuest(other.getRef(), other.getRemoteWSPort());
    }

    public IGuest(String _this, VboxPortType port) {
        super(_this,port);
    }

    // read-only attribute IGuest::OSTypeId of type wstring
    public String getOSTypeId() {
        try {
            String retVal = port.iGuestGetOSTypeId(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IGuest::additionsActive of type boolean
    public Boolean getAdditionsActive() {
        try {
            Boolean retVal = port.iGuestGetAdditionsActive(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IGuest::additionsVersion of type wstring
    public String getAdditionsVersion() {
        try {
            String retVal = port.iGuestGetAdditionsVersion(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IGuest::supportsSeamless of type boolean
    public Boolean getSupportsSeamless() {
        try {
            Boolean retVal = port.iGuestGetSupportsSeamless(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read-only attribute IGuest::supportsGraphics of type boolean
    public Boolean getSupportsGraphics() {
        try {
            Boolean retVal = port.iGuestGetSupportsGraphics(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IGuest::memoryBalloonSize of type unsigned long
    public Long getMemoryBalloonSize() {
        try {
            Long retVal = port.iGuestGetMemoryBalloonSize(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setMemoryBalloonSize(Long value) {
        try {
            port.iGuestSetMemoryBalloonSize(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    // read/write attribute IGuest::statisticsUpdateInterval of type unsigned long
    public Long getStatisticsUpdateInterval() {
        try {
            Long retVal = port.iGuestGetStatisticsUpdateInterval(_this);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
    public void setStatisticsUpdateInterval(Long value) {
        try {
            port.iGuestSetStatisticsUpdateInterval(_this, value);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IGuest::setCredentials(
            [in] wstring userName,
            [in] wstring password,
            [in] wstring domain,
            [in] boolean allowInteractiveLogon)
     */
    public void setCredentials(String userName, String password, String domain, Boolean allowInteractiveLogon) {
        try {
            port.iGuestSetCredentials(_this, userName, password, domain, allowInteractiveLogon);
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }

    /* method IGuest::getStatistic(
            [in] unsigned long cpuId,
            [in] GuestStatisticType statistic,
            [return] unsigned long statVal)
     */
    public Long getStatistic(Long cpuId, org.virtualbox_3_1.GuestStatisticType statistic) {
        try {
            Long retVal = port.iGuestGetStatistic(_this, cpuId, statistic);
            return retVal;
        } catch (InvalidObjectFaultMsg e) {
            throw new WebServiceException(e);
        } catch (RuntimeFaultMsg e) {
            throw new WebServiceException(e);
        }
    }
}
