# Copyright (C) 2009 Sun Microsystems, Inc.
#
# This file is part of VirtualBox Open Source Edition (OSE), as
# available from http://www.virtualbox.org. This file is free software;
# you can redistribute it and/or modify it under the terms of the GNU
# General Public License (GPL) as published by the Free Software
# Foundation, in version 2 as it comes in the "COPYING" file of the
# VirtualBox OSE distribution. VirtualBox OSE is distributed in the
# hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
#
# Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa
# Clara, CA 95054 USA or visit http://www.sun.com if you need
# additional information or have any questions.
#
# This file is autogenerated from VirtualBox.xidl, DO NOT EDIT!
#

class VirtualBoxReflectionInfo:
   def __init__(self, isSym):
      self.isSym = isSym

   _Values = {
                'SettingsVersion':{
                  'Null':0,'v1_0':1,'v1_1':2,'v1_2':3,'v1_3pre':4,'v1_3':5,'v1_4':6,'v1_5':7,'v1_6':8,'v1_7':9,'v1_8':10,'v1_9':11,'Future':12},
                'AccessMode':{
                  'ReadOnly':1,'ReadWrite':2},
                'MachineState':{
                  'Null':0,'PoweredOff':1,'Saved':2,'Teleported':3,'Aborted':4,'Running':5,'Paused':6,'Stuck':7,'Teleporting':8,'LiveSnapshotting':9,'Starting':10,'Stopping':11,'Saving':12,'Restoring':13,'TeleportingPausedVM':14,'TeleportingIn':15,'RestoringSnapshot':16,'DeletingSnapshot':17,'SettingUp':18,'FirstOnline':5,'LastOnline':13,'FirstTransient':8,'LastTransient':18},
                'SessionState':{
                  'Null':0,'Closed':1,'Open':2,'Spawning':3,'Closing':4},
                'CpuPropertyType':{
                  'Null':0,'PAE':1,'Synthetic':2},
                'HWVirtExPropertyType':{
                  'Null':0,'Enabled':1,'Exclusive':2,'VPID':3,'NestedPaging':4},
                'SessionType':{
                  'Null':0,'Direct':1,'Remote':2,'Existing':3},
                'DeviceType':{
                  'Null':0,'Floppy':1,'DVD':2,'HardDisk':3,'Network':4,'USB':5,'SharedFolder':6},
                'DeviceActivity':{
                  'Null':0,'Idle':1,'Reading':2,'Writing':3},
                'ClipboardMode':{
                  'Disabled':0,'HostToGuest':1,'GuestToHost':2,'Bidirectional':3},
                'Scope':{
                  'Global':0,'Machine':1,'Session':2},
                'GuestStatisticType':{
                  'CPULoad_Idle':0,'CPULoad_Kernel':1,'CPULoad_User':2,'Threads':3,'Processes':4,'Handles':5,'MemoryLoad':6,'PhysMemTotal':7,'PhysMemAvailable':8,'PhysMemBalloon':9,'MemCommitTotal':10,'MemKernelTotal':11,'MemKernelPaged':12,'MemKernelNonpaged':13,'MemSystemCache':14,'PageFileSize':15,'SampleNumber':16,'MaxVal':17},
                'BIOSBootMenuMode':{
                  'Disabled':0,'MenuOnly':1,'MessageAndMenu':2},
                'ProcessorFeature':{
                  'HWVirtEx':0,'PAE':1,'LongMode':2,'NestedPaging':3},
                'FirmwareType':{
                  'BIOS':1,'EFI':2,'EFI32':3,'EFI64':4,'EFIDUAL':5},
                'VFSType':{
                  'File':1,'Cloud':2,'S3':3,'WebDav':4},
                'VFSFileType':{
                  'Unknown':1,'Fifo':2,'DevChar':3,'Directory':4,'DevBlock':5,'File':6,'SymLink':7,'Socket':8,'WhiteOut':9},
                'VirtualSystemDescriptionType':{
                  'Ignore':1,'OS':2,'Name':3,'Product':4,'Vendor':5,'Version':6,'ProductUrl':7,'VendorUrl':8,'Description':9,'License':10,'Miscellaneous':11,'CPU':12,'Memory':13,'HardDiskControllerIDE':14,'HardDiskControllerSATA':15,'HardDiskControllerSCSI':16,'HardDiskImage':17,'Floppy':18,'CDROM':19,'NetworkAdapter':20,'USBController':21,'SoundCard':22},
                'VirtualSystemDescriptionValueType':{
                  'Reference':1,'Original':2,'Auto':3,'ExtraConfig':4},
                'HostNetworkInterfaceMediumType':{
                  'Unknown':0,'Ethernet':1,'PPP':2,'SLIP':3},
                'HostNetworkInterfaceStatus':{
                  'Unknown':0,'Up':1,'Down':2},
                'HostNetworkInterfaceType':{
                  'Bridged':1,'HostOnly':2},
                'MediumState':{
                  'NotCreated':0,'Created':1,'LockedRead':2,'LockedWrite':3,'Inaccessible':4,'Creating':5,'Deleting':6},
                'MediumType':{
                  'Normal':0,'Immutable':1,'Writethrough':2},
                'MediumVariant':{
                  'Standard':0,'VmdkSplit2G':0x01,'VmdkStreamOptimized':0x04,'VmdkESX':0x08,'Fixed':0x10000,'Diff':0x20000},
                'DataType':{
                  'Int32':0,'Int8':1,'String':2},
                'DataFlags':{
                  'None':0x00,'Mandatory':0x01,'Expert':0x02,'Array':0x04,'FlagMask':0x07},
                'MediumFormatCapabilities':{
                  'Uuid':0x01,'CreateFixed':0x02,'CreateDynamic':0x04,'CreateSplit2G':0x08,'Differencing':0x10,'Asynchronous':0x20,'File':0x40,'Properties':0x80,'CapabilityMask':0xFF},
                'MouseButtonState':{
                  'LeftButton':0x01,'RightButton':0x02,'MiddleButton':0x04,'WheelUp':0x08,'WheelDown':0x10,'XButton1':0x20,'XButton2':0x40,'MouseStateMask':0x7F},
                'FramebufferPixelFormat':{
                  'Opaque':0,'FOURCC_RGB':0x32424752},
                'NetworkAttachmentType':{
                  'Null':0,'NAT':1,'Bridged':2,'Internal':3,'HostOnly':4},
                'NetworkAdapterType':{
                  'Null':0,'Am79C970A':1,'Am79C973':2,'I82540EM':3,'I82543GC':4,'I82545EM':5,'Virtio':6},
                'PortMode':{
                  'Disconnected':0,'HostPipe':1,'HostDevice':2,'RawFile':3},
                'USBDeviceState':{
                  'NotSupported':0,'Unavailable':1,'Busy':2,'Available':3,'Held':4,'Captured':5},
                'USBDeviceFilterAction':{
                  'Null':0,'Ignore':1,'Hold':2},
                'AudioDriverType':{
                  'Null':0,'WinMM':1,'OSS':2,'ALSA':3,'DirectSound':4,'CoreAudio':5,'MMPM':6,'Pulse':7,'SolAudio':8},
                'AudioControllerType':{
                  'AC97':0,'SB16':1},
                'VRDPAuthType':{
                  'Null':0,'External':1,'Guest':2},
                'StorageBus':{
                  'Null':0,'IDE':1,'SATA':2,'SCSI':3,'Floppy':4},
                'StorageControllerType':{
                  'Null':0,'LsiLogic':1,'BusLogic':2,'IntelAhci':3,'PIIX3':4,'PIIX4':5,'ICH6':6,'I82078':7}}

   _ValuesFlat = {
                        'SettingsVersion_Null':0,
                        'SettingsVersion_v1_0':1,
                        'SettingsVersion_v1_1':2,
                        'SettingsVersion_v1_2':3,
                        'SettingsVersion_v1_3pre':4,
                        'SettingsVersion_v1_3':5,
                        'SettingsVersion_v1_4':6,
                        'SettingsVersion_v1_5':7,
                        'SettingsVersion_v1_6':8,
                        'SettingsVersion_v1_7':9,
                        'SettingsVersion_v1_8':10,
                        'SettingsVersion_v1_9':11,
                        'SettingsVersion_Future':12,
                        'AccessMode_ReadOnly':1,
                        'AccessMode_ReadWrite':2,
                        'MachineState_Null':0,
                        'MachineState_PoweredOff':1,
                        'MachineState_Saved':2,
                        'MachineState_Teleported':3,
                        'MachineState_Aborted':4,
                        'MachineState_Running':5,
                        'MachineState_Paused':6,
                        'MachineState_Stuck':7,
                        'MachineState_Teleporting':8,
                        'MachineState_LiveSnapshotting':9,
                        'MachineState_Starting':10,
                        'MachineState_Stopping':11,
                        'MachineState_Saving':12,
                        'MachineState_Restoring':13,
                        'MachineState_TeleportingPausedVM':14,
                        'MachineState_TeleportingIn':15,
                        'MachineState_RestoringSnapshot':16,
                        'MachineState_DeletingSnapshot':17,
                        'MachineState_SettingUp':18,
                        'MachineState_FirstOnline':5,
                        'MachineState_LastOnline':13,
                        'MachineState_FirstTransient':8,
                        'MachineState_LastTransient':18,
                        'SessionState_Null':0,
                        'SessionState_Closed':1,
                        'SessionState_Open':2,
                        'SessionState_Spawning':3,
                        'SessionState_Closing':4,
                        'CpuPropertyType_Null':0,
                        'CpuPropertyType_PAE':1,
                        'CpuPropertyType_Synthetic':2,
                        'HWVirtExPropertyType_Null':0,
                        'HWVirtExPropertyType_Enabled':1,
                        'HWVirtExPropertyType_Exclusive':2,
                        'HWVirtExPropertyType_VPID':3,
                        'HWVirtExPropertyType_NestedPaging':4,
                        'SessionType_Null':0,
                        'SessionType_Direct':1,
                        'SessionType_Remote':2,
                        'SessionType_Existing':3,
                        'DeviceType_Null':0,
                        'DeviceType_Floppy':1,
                        'DeviceType_DVD':2,
                        'DeviceType_HardDisk':3,
                        'DeviceType_Network':4,
                        'DeviceType_USB':5,
                        'DeviceType_SharedFolder':6,
                        'DeviceActivity_Null':0,
                        'DeviceActivity_Idle':1,
                        'DeviceActivity_Reading':2,
                        'DeviceActivity_Writing':3,
                        'ClipboardMode_Disabled':0,
                        'ClipboardMode_HostToGuest':1,
                        'ClipboardMode_GuestToHost':2,
                        'ClipboardMode_Bidirectional':3,
                        'Scope_Global':0,
                        'Scope_Machine':1,
                        'Scope_Session':2,
                        'GuestStatisticType_CPULoad_Idle':0,
                        'GuestStatisticType_CPULoad_Kernel':1,
                        'GuestStatisticType_CPULoad_User':2,
                        'GuestStatisticType_Threads':3,
                        'GuestStatisticType_Processes':4,
                        'GuestStatisticType_Handles':5,
                        'GuestStatisticType_MemoryLoad':6,
                        'GuestStatisticType_PhysMemTotal':7,
                        'GuestStatisticType_PhysMemAvailable':8,
                        'GuestStatisticType_PhysMemBalloon':9,
                        'GuestStatisticType_MemCommitTotal':10,
                        'GuestStatisticType_MemKernelTotal':11,
                        'GuestStatisticType_MemKernelPaged':12,
                        'GuestStatisticType_MemKernelNonpaged':13,
                        'GuestStatisticType_MemSystemCache':14,
                        'GuestStatisticType_PageFileSize':15,
                        'GuestStatisticType_SampleNumber':16,
                        'GuestStatisticType_MaxVal':17,
                        'BIOSBootMenuMode_Disabled':0,
                        'BIOSBootMenuMode_MenuOnly':1,
                        'BIOSBootMenuMode_MessageAndMenu':2,
                        'ProcessorFeature_HWVirtEx':0,
                        'ProcessorFeature_PAE':1,
                        'ProcessorFeature_LongMode':2,
                        'ProcessorFeature_NestedPaging':3,
                        'FirmwareType_BIOS':1,
                        'FirmwareType_EFI':2,
                        'FirmwareType_EFI32':3,
                        'FirmwareType_EFI64':4,
                        'FirmwareType_EFIDUAL':5,
                        'VFSType_File':1,
                        'VFSType_Cloud':2,
                        'VFSType_S3':3,
                        'VFSType_WebDav':4,
                        'VFSFileType_Unknown':1,
                        'VFSFileType_Fifo':2,
                        'VFSFileType_DevChar':3,
                        'VFSFileType_Directory':4,
                        'VFSFileType_DevBlock':5,
                        'VFSFileType_File':6,
                        'VFSFileType_SymLink':7,
                        'VFSFileType_Socket':8,
                        'VFSFileType_WhiteOut':9,
                        'VirtualSystemDescriptionType_Ignore':1,
                        'VirtualSystemDescriptionType_OS':2,
                        'VirtualSystemDescriptionType_Name':3,
                        'VirtualSystemDescriptionType_Product':4,
                        'VirtualSystemDescriptionType_Vendor':5,
                        'VirtualSystemDescriptionType_Version':6,
                        'VirtualSystemDescriptionType_ProductUrl':7,
                        'VirtualSystemDescriptionType_VendorUrl':8,
                        'VirtualSystemDescriptionType_Description':9,
                        'VirtualSystemDescriptionType_License':10,
                        'VirtualSystemDescriptionType_Miscellaneous':11,
                        'VirtualSystemDescriptionType_CPU':12,
                        'VirtualSystemDescriptionType_Memory':13,
                        'VirtualSystemDescriptionType_HardDiskControllerIDE':14,
                        'VirtualSystemDescriptionType_HardDiskControllerSATA':15,
                        'VirtualSystemDescriptionType_HardDiskControllerSCSI':16,
                        'VirtualSystemDescriptionType_HardDiskImage':17,
                        'VirtualSystemDescriptionType_Floppy':18,
                        'VirtualSystemDescriptionType_CDROM':19,
                        'VirtualSystemDescriptionType_NetworkAdapter':20,
                        'VirtualSystemDescriptionType_USBController':21,
                        'VirtualSystemDescriptionType_SoundCard':22,
                        'VirtualSystemDescriptionValueType_Reference':1,
                        'VirtualSystemDescriptionValueType_Original':2,
                        'VirtualSystemDescriptionValueType_Auto':3,
                        'VirtualSystemDescriptionValueType_ExtraConfig':4,
                        'HostNetworkInterfaceMediumType_Unknown':0,
                        'HostNetworkInterfaceMediumType_Ethernet':1,
                        'HostNetworkInterfaceMediumType_PPP':2,
                        'HostNetworkInterfaceMediumType_SLIP':3,
                        'HostNetworkInterfaceStatus_Unknown':0,
                        'HostNetworkInterfaceStatus_Up':1,
                        'HostNetworkInterfaceStatus_Down':2,
                        'HostNetworkInterfaceType_Bridged':1,
                        'HostNetworkInterfaceType_HostOnly':2,
                        'MediumState_NotCreated':0,
                        'MediumState_Created':1,
                        'MediumState_LockedRead':2,
                        'MediumState_LockedWrite':3,
                        'MediumState_Inaccessible':4,
                        'MediumState_Creating':5,
                        'MediumState_Deleting':6,
                        'MediumType_Normal':0,
                        'MediumType_Immutable':1,
                        'MediumType_Writethrough':2,
                        'MediumVariant_Standard':0,
                        'MediumVariant_VmdkSplit2G':0x01,
                        'MediumVariant_VmdkStreamOptimized':0x04,
                        'MediumVariant_VmdkESX':0x08,
                        'MediumVariant_Fixed':0x10000,
                        'MediumVariant_Diff':0x20000,
                        'DataType_Int32':0,
                        'DataType_Int8':1,
                        'DataType_String':2,
                        'DataFlags_None':0x00,
                        'DataFlags_Mandatory':0x01,
                        'DataFlags_Expert':0x02,
                        'DataFlags_Array':0x04,
                        'DataFlags_FlagMask':0x07,
                        'MediumFormatCapabilities_Uuid':0x01,
                        'MediumFormatCapabilities_CreateFixed':0x02,
                        'MediumFormatCapabilities_CreateDynamic':0x04,
                        'MediumFormatCapabilities_CreateSplit2G':0x08,
                        'MediumFormatCapabilities_Differencing':0x10,
                        'MediumFormatCapabilities_Asynchronous':0x20,
                        'MediumFormatCapabilities_File':0x40,
                        'MediumFormatCapabilities_Properties':0x80,
                        'MediumFormatCapabilities_CapabilityMask':0xFF,
                        'MouseButtonState_LeftButton':0x01,
                        'MouseButtonState_RightButton':0x02,
                        'MouseButtonState_MiddleButton':0x04,
                        'MouseButtonState_WheelUp':0x08,
                        'MouseButtonState_WheelDown':0x10,
                        'MouseButtonState_XButton1':0x20,
                        'MouseButtonState_XButton2':0x40,
                        'MouseButtonState_MouseStateMask':0x7F,
                        'FramebufferPixelFormat_Opaque':0,
                        'FramebufferPixelFormat_FOURCC_RGB':0x32424752,
                        'NetworkAttachmentType_Null':0,
                        'NetworkAttachmentType_NAT':1,
                        'NetworkAttachmentType_Bridged':2,
                        'NetworkAttachmentType_Internal':3,
                        'NetworkAttachmentType_HostOnly':4,
                        'NetworkAdapterType_Null':0,
                        'NetworkAdapterType_Am79C970A':1,
                        'NetworkAdapterType_Am79C973':2,
                        'NetworkAdapterType_I82540EM':3,
                        'NetworkAdapterType_I82543GC':4,
                        'NetworkAdapterType_I82545EM':5,
                        'NetworkAdapterType_Virtio':6,
                        'PortMode_Disconnected':0,
                        'PortMode_HostPipe':1,
                        'PortMode_HostDevice':2,
                        'PortMode_RawFile':3,
                        'USBDeviceState_NotSupported':0,
                        'USBDeviceState_Unavailable':1,
                        'USBDeviceState_Busy':2,
                        'USBDeviceState_Available':3,
                        'USBDeviceState_Held':4,
                        'USBDeviceState_Captured':5,
                        'USBDeviceFilterAction_Null':0,
                        'USBDeviceFilterAction_Ignore':1,
                        'USBDeviceFilterAction_Hold':2,
                        'AudioDriverType_Null':0,
                        'AudioDriverType_WinMM':1,
                        'AudioDriverType_OSS':2,
                        'AudioDriverType_ALSA':3,
                        'AudioDriverType_DirectSound':4,
                        'AudioDriverType_CoreAudio':5,
                        'AudioDriverType_MMPM':6,
                        'AudioDriverType_Pulse':7,
                        'AudioDriverType_SolAudio':8,
                        'AudioControllerType_AC97':0,
                        'AudioControllerType_SB16':1,
                        'VRDPAuthType_Null':0,
                        'VRDPAuthType_External':1,
                        'VRDPAuthType_Guest':2,
                        'StorageBus_Null':0,
                        'StorageBus_IDE':1,
                        'StorageBus_SATA':2,
                        'StorageBus_SCSI':3,
                        'StorageBus_Floppy':4,
                        'StorageControllerType_Null':0,
                        'StorageControllerType_LsiLogic':1,
                        'StorageControllerType_BusLogic':2,
                        'StorageControllerType_IntelAhci':3,
                        'StorageControllerType_PIIX3':4,
                        'StorageControllerType_PIIX4':5,
                        'StorageControllerType_ICH6':6,
                        'StorageControllerType_I82078':7}

   _ValuesFlatSym = {
                        'SettingsVersion_Null': 'Null',
                        'SettingsVersion_v1_0': 'v1_0',
                        'SettingsVersion_v1_1': 'v1_1',
                        'SettingsVersion_v1_2': 'v1_2',
                        'SettingsVersion_v1_3pre': 'v1_3pre',
                        'SettingsVersion_v1_3': 'v1_3',
                        'SettingsVersion_v1_4': 'v1_4',
                        'SettingsVersion_v1_5': 'v1_5',
                        'SettingsVersion_v1_6': 'v1_6',
                        'SettingsVersion_v1_7': 'v1_7',
                        'SettingsVersion_v1_8': 'v1_8',
                        'SettingsVersion_v1_9': 'v1_9',
                        'SettingsVersion_Future': 'Future',
                        'AccessMode_ReadOnly': 'ReadOnly',
                        'AccessMode_ReadWrite': 'ReadWrite',
                        'MachineState_Null': 'Null',
                        'MachineState_PoweredOff': 'PoweredOff',
                        'MachineState_Saved': 'Saved',
                        'MachineState_Teleported': 'Teleported',
                        'MachineState_Aborted': 'Aborted',
                        'MachineState_Running': 'Running',
                        'MachineState_Paused': 'Paused',
                        'MachineState_Stuck': 'Stuck',
                        'MachineState_Teleporting': 'Teleporting',
                        'MachineState_LiveSnapshotting': 'LiveSnapshotting',
                        'MachineState_Starting': 'Starting',
                        'MachineState_Stopping': 'Stopping',
                        'MachineState_Saving': 'Saving',
                        'MachineState_Restoring': 'Restoring',
                        'MachineState_TeleportingPausedVM': 'TeleportingPausedVM',
                        'MachineState_TeleportingIn': 'TeleportingIn',
                        'MachineState_RestoringSnapshot': 'RestoringSnapshot',
                        'MachineState_DeletingSnapshot': 'DeletingSnapshot',
                        'MachineState_SettingUp': 'SettingUp',
                        'MachineState_FirstOnline': 'FirstOnline',
                        'MachineState_LastOnline': 'LastOnline',
                        'MachineState_FirstTransient': 'FirstTransient',
                        'MachineState_LastTransient': 'LastTransient',
                        'SessionState_Null': 'Null',
                        'SessionState_Closed': 'Closed',
                        'SessionState_Open': 'Open',
                        'SessionState_Spawning': 'Spawning',
                        'SessionState_Closing': 'Closing',
                        'CpuPropertyType_Null': 'Null',
                        'CpuPropertyType_PAE': 'PAE',
                        'CpuPropertyType_Synthetic': 'Synthetic',
                        'HWVirtExPropertyType_Null': 'Null',
                        'HWVirtExPropertyType_Enabled': 'Enabled',
                        'HWVirtExPropertyType_Exclusive': 'Exclusive',
                        'HWVirtExPropertyType_VPID': 'VPID',
                        'HWVirtExPropertyType_NestedPaging': 'NestedPaging',
                        'SessionType_Null': 'Null',
                        'SessionType_Direct': 'Direct',
                        'SessionType_Remote': 'Remote',
                        'SessionType_Existing': 'Existing',
                        'DeviceType_Null': 'Null',
                        'DeviceType_Floppy': 'Floppy',
                        'DeviceType_DVD': 'DVD',
                        'DeviceType_HardDisk': 'HardDisk',
                        'DeviceType_Network': 'Network',
                        'DeviceType_USB': 'USB',
                        'DeviceType_SharedFolder': 'SharedFolder',
                        'DeviceActivity_Null': 'Null',
                        'DeviceActivity_Idle': 'Idle',
                        'DeviceActivity_Reading': 'Reading',
                        'DeviceActivity_Writing': 'Writing',
                        'ClipboardMode_Disabled': 'Disabled',
                        'ClipboardMode_HostToGuest': 'HostToGuest',
                        'ClipboardMode_GuestToHost': 'GuestToHost',
                        'ClipboardMode_Bidirectional': 'Bidirectional',
                        'Scope_Global': 'Global',
                        'Scope_Machine': 'Machine',
                        'Scope_Session': 'Session',
                        'GuestStatisticType_CPULoad_Idle': 'CPULoad_Idle',
                        'GuestStatisticType_CPULoad_Kernel': 'CPULoad_Kernel',
                        'GuestStatisticType_CPULoad_User': 'CPULoad_User',
                        'GuestStatisticType_Threads': 'Threads',
                        'GuestStatisticType_Processes': 'Processes',
                        'GuestStatisticType_Handles': 'Handles',
                        'GuestStatisticType_MemoryLoad': 'MemoryLoad',
                        'GuestStatisticType_PhysMemTotal': 'PhysMemTotal',
                        'GuestStatisticType_PhysMemAvailable': 'PhysMemAvailable',
                        'GuestStatisticType_PhysMemBalloon': 'PhysMemBalloon',
                        'GuestStatisticType_MemCommitTotal': 'MemCommitTotal',
                        'GuestStatisticType_MemKernelTotal': 'MemKernelTotal',
                        'GuestStatisticType_MemKernelPaged': 'MemKernelPaged',
                        'GuestStatisticType_MemKernelNonpaged': 'MemKernelNonpaged',
                        'GuestStatisticType_MemSystemCache': 'MemSystemCache',
                        'GuestStatisticType_PageFileSize': 'PageFileSize',
                        'GuestStatisticType_SampleNumber': 'SampleNumber',
                        'GuestStatisticType_MaxVal': 'MaxVal',
                        'BIOSBootMenuMode_Disabled': 'Disabled',
                        'BIOSBootMenuMode_MenuOnly': 'MenuOnly',
                        'BIOSBootMenuMode_MessageAndMenu': 'MessageAndMenu',
                        'ProcessorFeature_HWVirtEx': 'HWVirtEx',
                        'ProcessorFeature_PAE': 'PAE',
                        'ProcessorFeature_LongMode': 'LongMode',
                        'ProcessorFeature_NestedPaging': 'NestedPaging',
                        'FirmwareType_BIOS': 'BIOS',
                        'FirmwareType_EFI': 'EFI',
                        'FirmwareType_EFI32': 'EFI32',
                        'FirmwareType_EFI64': 'EFI64',
                        'FirmwareType_EFIDUAL': 'EFIDUAL',
                        'VFSType_File': 'File',
                        'VFSType_Cloud': 'Cloud',
                        'VFSType_S3': 'S3',
                        'VFSType_WebDav': 'WebDav',
                        'VFSFileType_Unknown': 'Unknown',
                        'VFSFileType_Fifo': 'Fifo',
                        'VFSFileType_DevChar': 'DevChar',
                        'VFSFileType_Directory': 'Directory',
                        'VFSFileType_DevBlock': 'DevBlock',
                        'VFSFileType_File': 'File',
                        'VFSFileType_SymLink': 'SymLink',
                        'VFSFileType_Socket': 'Socket',
                        'VFSFileType_WhiteOut': 'WhiteOut',
                        'VirtualSystemDescriptionType_Ignore': 'Ignore',
                        'VirtualSystemDescriptionType_OS': 'OS',
                        'VirtualSystemDescriptionType_Name': 'Name',
                        'VirtualSystemDescriptionType_Product': 'Product',
                        'VirtualSystemDescriptionType_Vendor': 'Vendor',
                        'VirtualSystemDescriptionType_Version': 'Version',
                        'VirtualSystemDescriptionType_ProductUrl': 'ProductUrl',
                        'VirtualSystemDescriptionType_VendorUrl': 'VendorUrl',
                        'VirtualSystemDescriptionType_Description': 'Description',
                        'VirtualSystemDescriptionType_License': 'License',
                        'VirtualSystemDescriptionType_Miscellaneous': 'Miscellaneous',
                        'VirtualSystemDescriptionType_CPU': 'CPU',
                        'VirtualSystemDescriptionType_Memory': 'Memory',
                        'VirtualSystemDescriptionType_HardDiskControllerIDE': 'HardDiskControllerIDE',
                        'VirtualSystemDescriptionType_HardDiskControllerSATA': 'HardDiskControllerSATA',
                        'VirtualSystemDescriptionType_HardDiskControllerSCSI': 'HardDiskControllerSCSI',
                        'VirtualSystemDescriptionType_HardDiskImage': 'HardDiskImage',
                        'VirtualSystemDescriptionType_Floppy': 'Floppy',
                        'VirtualSystemDescriptionType_CDROM': 'CDROM',
                        'VirtualSystemDescriptionType_NetworkAdapter': 'NetworkAdapter',
                        'VirtualSystemDescriptionType_USBController': 'USBController',
                        'VirtualSystemDescriptionType_SoundCard': 'SoundCard',
                        'VirtualSystemDescriptionValueType_Reference': 'Reference',
                        'VirtualSystemDescriptionValueType_Original': 'Original',
                        'VirtualSystemDescriptionValueType_Auto': 'Auto',
                        'VirtualSystemDescriptionValueType_ExtraConfig': 'ExtraConfig',
                        'HostNetworkInterfaceMediumType_Unknown': 'Unknown',
                        'HostNetworkInterfaceMediumType_Ethernet': 'Ethernet',
                        'HostNetworkInterfaceMediumType_PPP': 'PPP',
                        'HostNetworkInterfaceMediumType_SLIP': 'SLIP',
                        'HostNetworkInterfaceStatus_Unknown': 'Unknown',
                        'HostNetworkInterfaceStatus_Up': 'Up',
                        'HostNetworkInterfaceStatus_Down': 'Down',
                        'HostNetworkInterfaceType_Bridged': 'Bridged',
                        'HostNetworkInterfaceType_HostOnly': 'HostOnly',
                        'MediumState_NotCreated': 'NotCreated',
                        'MediumState_Created': 'Created',
                        'MediumState_LockedRead': 'LockedRead',
                        'MediumState_LockedWrite': 'LockedWrite',
                        'MediumState_Inaccessible': 'Inaccessible',
                        'MediumState_Creating': 'Creating',
                        'MediumState_Deleting': 'Deleting',
                        'MediumType_Normal': 'Normal',
                        'MediumType_Immutable': 'Immutable',
                        'MediumType_Writethrough': 'Writethrough',
                        'MediumVariant_Standard': 'Standard',
                        'MediumVariant_VmdkSplit2G': 'VmdkSplit2G',
                        'MediumVariant_VmdkStreamOptimized': 'VmdkStreamOptimized',
                        'MediumVariant_VmdkESX': 'VmdkESX',
                        'MediumVariant_Fixed': 'Fixed',
                        'MediumVariant_Diff': 'Diff',
                        'DataType_Int32': 'Int32',
                        'DataType_Int8': 'Int8',
                        'DataType_String': 'String',
                        'DataFlags_None': 'None',
                        'DataFlags_Mandatory': 'Mandatory',
                        'DataFlags_Expert': 'Expert',
                        'DataFlags_Array': 'Array',
                        'DataFlags_FlagMask': 'FlagMask',
                        'MediumFormatCapabilities_Uuid': 'Uuid',
                        'MediumFormatCapabilities_CreateFixed': 'CreateFixed',
                        'MediumFormatCapabilities_CreateDynamic': 'CreateDynamic',
                        'MediumFormatCapabilities_CreateSplit2G': 'CreateSplit2G',
                        'MediumFormatCapabilities_Differencing': 'Differencing',
                        'MediumFormatCapabilities_Asynchronous': 'Asynchronous',
                        'MediumFormatCapabilities_File': 'File',
                        'MediumFormatCapabilities_Properties': 'Properties',
                        'MediumFormatCapabilities_CapabilityMask': 'CapabilityMask',
                        'MouseButtonState_LeftButton': 'LeftButton',
                        'MouseButtonState_RightButton': 'RightButton',
                        'MouseButtonState_MiddleButton': 'MiddleButton',
                        'MouseButtonState_WheelUp': 'WheelUp',
                        'MouseButtonState_WheelDown': 'WheelDown',
                        'MouseButtonState_XButton1': 'XButton1',
                        'MouseButtonState_XButton2': 'XButton2',
                        'MouseButtonState_MouseStateMask': 'MouseStateMask',
                        'FramebufferPixelFormat_Opaque': 'Opaque',
                        'FramebufferPixelFormat_FOURCC_RGB': 'FOURCC_RGB',
                        'NetworkAttachmentType_Null': 'Null',
                        'NetworkAttachmentType_NAT': 'NAT',
                        'NetworkAttachmentType_Bridged': 'Bridged',
                        'NetworkAttachmentType_Internal': 'Internal',
                        'NetworkAttachmentType_HostOnly': 'HostOnly',
                        'NetworkAdapterType_Null': 'Null',
                        'NetworkAdapterType_Am79C970A': 'Am79C970A',
                        'NetworkAdapterType_Am79C973': 'Am79C973',
                        'NetworkAdapterType_I82540EM': 'I82540EM',
                        'NetworkAdapterType_I82543GC': 'I82543GC',
                        'NetworkAdapterType_I82545EM': 'I82545EM',
                        'NetworkAdapterType_Virtio': 'Virtio',
                        'PortMode_Disconnected': 'Disconnected',
                        'PortMode_HostPipe': 'HostPipe',
                        'PortMode_HostDevice': 'HostDevice',
                        'PortMode_RawFile': 'RawFile',
                        'USBDeviceState_NotSupported': 'NotSupported',
                        'USBDeviceState_Unavailable': 'Unavailable',
                        'USBDeviceState_Busy': 'Busy',
                        'USBDeviceState_Available': 'Available',
                        'USBDeviceState_Held': 'Held',
                        'USBDeviceState_Captured': 'Captured',
                        'USBDeviceFilterAction_Null': 'Null',
                        'USBDeviceFilterAction_Ignore': 'Ignore',
                        'USBDeviceFilterAction_Hold': 'Hold',
                        'AudioDriverType_Null': 'Null',
                        'AudioDriverType_WinMM': 'WinMM',
                        'AudioDriverType_OSS': 'OSS',
                        'AudioDriverType_ALSA': 'ALSA',
                        'AudioDriverType_DirectSound': 'DirectSound',
                        'AudioDriverType_CoreAudio': 'CoreAudio',
                        'AudioDriverType_MMPM': 'MMPM',
                        'AudioDriverType_Pulse': 'Pulse',
                        'AudioDriverType_SolAudio': 'SolAudio',
                        'AudioControllerType_AC97': 'AC97',
                        'AudioControllerType_SB16': 'SB16',
                        'VRDPAuthType_Null': 'Null',
                        'VRDPAuthType_External': 'External',
                        'VRDPAuthType_Guest': 'Guest',
                        'StorageBus_Null': 'Null',
                        'StorageBus_IDE': 'IDE',
                        'StorageBus_SATA': 'SATA',
                        'StorageBus_SCSI': 'SCSI',
                        'StorageBus_Floppy': 'Floppy',
                        'StorageControllerType_Null': 'Null',
                        'StorageControllerType_LsiLogic': 'LsiLogic',
                        'StorageControllerType_BusLogic': 'BusLogic',
                        'StorageControllerType_IntelAhci': 'IntelAhci',
                        'StorageControllerType_PIIX3': 'PIIX3',
                        'StorageControllerType_PIIX4': 'PIIX4',
                        'StorageControllerType_ICH6': 'ICH6',
                        'StorageControllerType_I82078': 'I82078'}

   def __getattr__(self,attr):
      if self.isSym:
        v = self._ValuesFlatSym.get(attr)
      else:
        v = self._ValuesFlat.get(attr)
      if v is not None:
         return v
      else:
         raise AttributeError

